/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.llvm.LLVMOrcCSymbolsList;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class LLVMOrcCDependenceMapPair
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int JD;
    public static final int NAMES;

    public LLVMOrcCDependenceMapPair(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), LLVMOrcCDependenceMapPair.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="LLVMOrcJITDylibRef")
    public long JD() {
        return LLVMOrcCDependenceMapPair.nJD(this.address());
    }

    public LLVMOrcCSymbolsList Names() {
        return LLVMOrcCDependenceMapPair.nNames(this.address());
    }

    public LLVMOrcCDependenceMapPair JD(@NativeType(value="LLVMOrcJITDylibRef") long value) {
        LLVMOrcCDependenceMapPair.nJD(this.address(), value);
        return this;
    }

    public LLVMOrcCDependenceMapPair Names(LLVMOrcCSymbolsList value) {
        LLVMOrcCDependenceMapPair.nNames(this.address(), value);
        return this;
    }

    public LLVMOrcCDependenceMapPair Names(Consumer<LLVMOrcCSymbolsList> consumer) {
        consumer.accept(this.Names());
        return this;
    }

    public LLVMOrcCDependenceMapPair set(long JD, LLVMOrcCSymbolsList Names) {
        this.JD(JD);
        this.Names(Names);
        return this;
    }

    public LLVMOrcCDependenceMapPair set(LLVMOrcCDependenceMapPair src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static LLVMOrcCDependenceMapPair malloc() {
        return LLVMOrcCDependenceMapPair.wrap(LLVMOrcCDependenceMapPair.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static LLVMOrcCDependenceMapPair calloc() {
        return LLVMOrcCDependenceMapPair.wrap(LLVMOrcCDependenceMapPair.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static LLVMOrcCDependenceMapPair create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return LLVMOrcCDependenceMapPair.wrap(LLVMOrcCDependenceMapPair.class, MemoryUtil.memAddress(container), container);
    }

    public static LLVMOrcCDependenceMapPair create(long address) {
        return LLVMOrcCDependenceMapPair.wrap(LLVMOrcCDependenceMapPair.class, address);
    }

    @Nullable
    public static LLVMOrcCDependenceMapPair createSafe(long address) {
        return address == 0L ? null : LLVMOrcCDependenceMapPair.wrap(LLVMOrcCDependenceMapPair.class, address);
    }

    public static Buffer malloc(int capacity) {
        return LLVMOrcCDependenceMapPair.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(LLVMOrcCDependenceMapPair.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return LLVMOrcCDependenceMapPair.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = LLVMOrcCDependenceMapPair.__create(capacity, SIZEOF);
        return LLVMOrcCDependenceMapPair.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return LLVMOrcCDependenceMapPair.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : LLVMOrcCDependenceMapPair.wrap(Buffer.class, address, capacity);
    }

    public static LLVMOrcCDependenceMapPair malloc(MemoryStack stack) {
        return LLVMOrcCDependenceMapPair.wrap(LLVMOrcCDependenceMapPair.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static LLVMOrcCDependenceMapPair calloc(MemoryStack stack) {
        return LLVMOrcCDependenceMapPair.wrap(LLVMOrcCDependenceMapPair.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return LLVMOrcCDependenceMapPair.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return LLVMOrcCDependenceMapPair.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nJD(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)JD);
    }

    public static LLVMOrcCSymbolsList nNames(long struct) {
        return LLVMOrcCSymbolsList.create(struct + (long)NAMES);
    }

    public static void nJD(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)JD, Checks.check(value));
    }

    public static void nNames(long struct, LLVMOrcCSymbolsList value) {
        MemoryUtil.memCopy(value.address(), struct + (long)NAMES, LLVMOrcCSymbolsList.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)JD));
        LLVMOrcCSymbolsList.validate(struct + (long)NAMES);
    }

    static {
        Struct.Layout layout = LLVMOrcCDependenceMapPair.__struct(LLVMOrcCDependenceMapPair.__member(POINTER_SIZE), LLVMOrcCDependenceMapPair.__member(LLVMOrcCSymbolsList.SIZEOF, LLVMOrcCSymbolsList.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        JD = layout.offsetof(0);
        NAMES = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<LLVMOrcCDependenceMapPair, Buffer>
    implements NativeResource {
        private static final LLVMOrcCDependenceMapPair ELEMENT_FACTORY = LLVMOrcCDependenceMapPair.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected LLVMOrcCDependenceMapPair getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="LLVMOrcJITDylibRef")
        public long JD() {
            return LLVMOrcCDependenceMapPair.nJD(this.address());
        }

        public LLVMOrcCSymbolsList Names() {
            return LLVMOrcCDependenceMapPair.nNames(this.address());
        }

        public Buffer JD(@NativeType(value="LLVMOrcJITDylibRef") long value) {
            LLVMOrcCDependenceMapPair.nJD(this.address(), value);
            return this;
        }

        public Buffer Names(LLVMOrcCSymbolsList value) {
            LLVMOrcCDependenceMapPair.nNames(this.address(), value);
            return this;
        }

        public Buffer Names(Consumer<LLVMOrcCSymbolsList> consumer) {
            consumer.accept(this.Names());
            return this;
        }
    }
}

