/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.llvm.LLVMCore;
import org.lwjgl.llvm.LLVMJITCSymbolMapPair;
import org.lwjgl.llvm.LLVMOrcCAPIDefinitionGeneratorTryToGenerateFunctionI;
import org.lwjgl.llvm.LLVMOrcCDependenceMapPair;
import org.lwjgl.llvm.LLVMOrcCSymbolAliasMapPair;
import org.lwjgl.llvm.LLVMOrcCSymbolFlagsMapPair;
import org.lwjgl.llvm.LLVMOrcErrorReporterFunctionI;
import org.lwjgl.llvm.LLVMOrcGenericIRModuleOperationFunctionI;
import org.lwjgl.llvm.LLVMOrcIRTransformLayerTransformFunctionI;
import org.lwjgl.llvm.LLVMOrcMaterializationUnitDestroyFunctionI;
import org.lwjgl.llvm.LLVMOrcMaterializationUnitDiscardFunctionI;
import org.lwjgl.llvm.LLVMOrcMaterializationUnitMaterializeFunctionI;
import org.lwjgl.llvm.LLVMOrcObjectTransformLayerTransformFunctionI;
import org.lwjgl.llvm.LLVMOrcSymbolPredicateI;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class LLVMOrc {
    public static final int LLVMJITSymbolGenericFlagsExported = 1;
    public static final int LLVMJITSymbolGenericFlagsWeak = 2;
    public static final int LLVMJITSymbolGenericFlagsCallable = 4;
    public static final int LLVMJITSymbolGenericFlagsMaterializationSideEffectsOnly = 8;
    public static final int LLVMOrcLookupKindStatic = 0;
    public static final int LLVMOrcLookupKindDLSym = 1;
    public static final int LLVMOrcJITDylibLookupFlagsMatchExportedSymbolsOnly = 0;
    public static final int LLVMOrcJITDylibLookupFlagsMatchAllSymbols = 1;
    public static final int LLVMOrcSymbolLookupFlagsRequiredSymbol = 0;
    public static final int LLVMOrcSymbolLookupFlagsWeaklyReferencedSymbol = 1;

    protected LLVMOrc() {
        throw new UnsupportedOperationException();
    }

    public static void nLLVMOrcExecutionSessionSetErrorReporter(long ES, long ReportError, long Ctx) {
        long __functionAddress = Functions.OrcExecutionSessionSetErrorReporter;
        if (Checks.CHECKS) {
            Checks.check(ES);
            Checks.check(Ctx);
        }
        JNI.invokePPPV(ES, ReportError, Ctx, __functionAddress);
    }

    public static void LLVMOrcExecutionSessionSetErrorReporter(@NativeType(value="LLVMOrcExecutionSessionRef") long ES, @NativeType(value="LLVMOrcErrorReporterFunction") LLVMOrcErrorReporterFunctionI ReportError, @NativeType(value="void *") long Ctx) {
        LLVMOrc.nLLVMOrcExecutionSessionSetErrorReporter(ES, ReportError.address(), Ctx);
    }

    @NativeType(value="LLVMOrcSymbolStringPoolRef")
    public static long LLVMOrcExecutionSessionGetSymbolStringPool(@NativeType(value="LLVMOrcExecutionSessionRef") long ES) {
        long __functionAddress = Functions.OrcExecutionSessionGetSymbolStringPool;
        if (Checks.CHECKS) {
            Checks.check(ES);
        }
        return JNI.invokePP(ES, __functionAddress);
    }

    public static void LLVMOrcSymbolStringPoolClearDeadEntries(@NativeType(value="LLVMOrcSymbolStringPoolRef") long SSP) {
        long __functionAddress = Functions.OrcSymbolStringPoolClearDeadEntries;
        if (Checks.CHECKS) {
            Checks.check(SSP);
        }
        JNI.invokePV(SSP, __functionAddress);
    }

    public static long nLLVMOrcExecutionSessionIntern(long ES, long Name2) {
        long __functionAddress = Functions.OrcExecutionSessionIntern;
        if (Checks.CHECKS) {
            Checks.check(ES);
        }
        return JNI.invokePPP(ES, Name2, __functionAddress);
    }

    @NativeType(value="LLVMOrcSymbolStringPoolEntryRef")
    public static long LLVMOrcExecutionSessionIntern(@NativeType(value="LLVMOrcExecutionSessionRef") long ES, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMOrc.nLLVMOrcExecutionSessionIntern(ES, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMOrcSymbolStringPoolEntryRef")
    public static long LLVMOrcExecutionSessionIntern(@NativeType(value="LLVMOrcExecutionSessionRef") long ES, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMOrc.nLLVMOrcExecutionSessionIntern(ES, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void LLVMOrcRetainSymbolStringPoolEntry(@NativeType(value="LLVMOrcSymbolStringPoolEntryRef") long S) {
        long __functionAddress = Functions.OrcRetainSymbolStringPoolEntry;
        if (Checks.CHECKS) {
            Checks.check(S);
        }
        JNI.invokePV(S, __functionAddress);
    }

    public static void LLVMOrcReleaseSymbolStringPoolEntry(@NativeType(value="LLVMOrcSymbolStringPoolEntryRef") long S) {
        long __functionAddress = Functions.OrcReleaseSymbolStringPoolEntry;
        if (Checks.CHECKS) {
            Checks.check(S);
        }
        JNI.invokePV(S, __functionAddress);
    }

    public static long nLLVMOrcSymbolStringPoolEntryStr(long S) {
        long __functionAddress = Functions.OrcSymbolStringPoolEntryStr;
        if (Checks.CHECKS) {
            Checks.check(S);
        }
        return JNI.invokePP(S, __functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String LLVMOrcSymbolStringPoolEntryStr(@NativeType(value="LLVMOrcSymbolStringPoolEntryRef") long S) {
        long __result = LLVMOrc.nLLVMOrcSymbolStringPoolEntryStr(S);
        return MemoryUtil.memUTF8Safe(__result);
    }

    public static void LLVMOrcReleaseResourceTracker(@NativeType(value="LLVMOrcResourceTrackerRef") long RT) {
        long __functionAddress = Functions.OrcReleaseResourceTracker;
        if (Checks.CHECKS) {
            Checks.check(RT);
        }
        JNI.invokePV(RT, __functionAddress);
    }

    public static void LLVMOrcResourceTrackerTransferTo(@NativeType(value="LLVMOrcResourceTrackerRef") long SrcRT, @NativeType(value="LLVMOrcResourceTrackerRef") long DstRT) {
        long __functionAddress = Functions.OrcResourceTrackerTransferTo;
        if (Checks.CHECKS) {
            Checks.check(SrcRT);
            Checks.check(DstRT);
        }
        JNI.invokePPV(SrcRT, DstRT, __functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcResourceTrackerRemove(@NativeType(value="LLVMOrcResourceTrackerRef") long RT) {
        long __functionAddress = Functions.OrcResourceTrackerRemove;
        if (Checks.CHECKS) {
            Checks.check(RT);
        }
        return JNI.invokePP(RT, __functionAddress);
    }

    public static void LLVMOrcDisposeDefinitionGenerator(@NativeType(value="LLVMOrcDefinitionGeneratorRef") long DG) {
        long __functionAddress = Functions.OrcDisposeDefinitionGenerator;
        if (Checks.CHECKS) {
            Checks.check(DG);
        }
        JNI.invokePV(DG, __functionAddress);
    }

    public static void LLVMOrcDisposeMaterializationUnit(@NativeType(value="LLVMOrcMaterializationUnitRef") long MU) {
        long __functionAddress = Functions.OrcDisposeMaterializationUnit;
        if (Checks.CHECKS) {
            Checks.check(MU);
        }
        JNI.invokePV(MU, __functionAddress);
    }

    public static long nLLVMOrcCreateCustomMaterializationUnit(long Name2, long Ctx, long Syms, long NumSyms, long InitSym, long Materialize, long Discard, long Destroy) {
        long __functionAddress = Functions.OrcCreateCustomMaterializationUnit;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Ctx);
        }
        return JNI.invokePPPPPPPPP(Name2, Ctx, Syms, NumSyms, InitSym, Materialize, Discard, Destroy, __functionAddress);
    }

    @NativeType(value="LLVMOrcMaterializationUnitRef")
    public static long LLVMOrcCreateCustomMaterializationUnit(@NativeType(value="char const *") ByteBuffer Name2, @NativeType(value="void *") long Ctx, @NativeType(value="LLVMOrcCSymbolFlagsMapPairs") LLVMOrcCSymbolFlagsMapPair.Buffer Syms, @NativeType(value="LLVMOrcSymbolStringPoolEntryRef") long InitSym, @NativeType(value="LLVMOrcMaterializationUnitMaterializeFunction") LLVMOrcMaterializationUnitMaterializeFunctionI Materialize, @NativeType(value="LLVMOrcMaterializationUnitDiscardFunction") LLVMOrcMaterializationUnitDiscardFunctionI Discard, @NativeType(value="LLVMOrcMaterializationUnitDestroyFunction") LLVMOrcMaterializationUnitDestroyFunctionI Destroy) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMOrc.nLLVMOrcCreateCustomMaterializationUnit(MemoryUtil.memAddress(Name2), Ctx, Syms.address(), Syms.remaining(), InitSym, Materialize.address(), Discard.address(), Destroy.address());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMOrcMaterializationUnitRef")
    public static long LLVMOrcCreateCustomMaterializationUnit(@NativeType(value="char const *") CharSequence Name2, @NativeType(value="void *") long Ctx, @NativeType(value="LLVMOrcCSymbolFlagsMapPairs") LLVMOrcCSymbolFlagsMapPair.Buffer Syms, @NativeType(value="LLVMOrcSymbolStringPoolEntryRef") long InitSym, @NativeType(value="LLVMOrcMaterializationUnitMaterializeFunction") LLVMOrcMaterializationUnitMaterializeFunctionI Materialize, @NativeType(value="LLVMOrcMaterializationUnitDiscardFunction") LLVMOrcMaterializationUnitDiscardFunctionI Discard, @NativeType(value="LLVMOrcMaterializationUnitDestroyFunction") LLVMOrcMaterializationUnitDestroyFunctionI Destroy) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMOrc.nLLVMOrcCreateCustomMaterializationUnit(NameEncoded, Ctx, Syms.address(), Syms.remaining(), InitSym, Materialize.address(), Discard.address(), Destroy.address());
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMOrcAbsoluteSymbols(long Syms, long NumPairs) {
        long __functionAddress = Functions.OrcAbsoluteSymbols;
        return JNI.invokePPP(Syms, NumPairs, __functionAddress);
    }

    @NativeType(value="LLVMOrcMaterializationUnitRef")
    public static long LLVMOrcAbsoluteSymbols(@NativeType(value="LLVMOrcCSymbolMapPairs") LLVMJITCSymbolMapPair.Buffer Syms) {
        return LLVMOrc.nLLVMOrcAbsoluteSymbols(Syms.address(), Syms.remaining());
    }

    public static long nLLVMOrcLazyReexports(long LCTM, long ISM, long SourceRef, long CallableAliases, long NumPairs) {
        long __functionAddress = Functions.OrcLazyReexports;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(LCTM);
            Checks.check(ISM);
            Checks.check(SourceRef);
        }
        return JNI.invokePPPPPP(LCTM, ISM, SourceRef, CallableAliases, NumPairs, __functionAddress);
    }

    @NativeType(value="LLVMOrcMaterializationUnitRef")
    public static long LLVMOrcLazyReexports(@NativeType(value="LLVMOrcLazyCallThroughManagerRef") long LCTM, @NativeType(value="LLVMOrcIndirectStubsManagerRef") long ISM, @NativeType(value="LLVMOrcJITDylibRef") long SourceRef, @NativeType(value="LLVMOrcCSymbolAliasMapPairs") LLVMOrcCSymbolAliasMapPair.Buffer CallableAliases) {
        return LLVMOrc.nLLVMOrcLazyReexports(LCTM, ISM, SourceRef, CallableAliases.address(), CallableAliases.remaining());
    }

    public static void LLVMOrcDisposeMaterializationResponsibility(@NativeType(value="LLVMOrcMaterializationResponsibilityRef") long MR) {
        long __functionAddress = Functions.OrcDisposeMaterializationResponsibility;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(MR);
        }
        JNI.invokePV(MR, __functionAddress);
    }

    @NativeType(value="LLVMOrcJITDylibRef")
    public static long LLVMOrcMaterializationResponsibilityGetTargetDylib(@NativeType(value="LLVMOrcMaterializationResponsibilityRef") long MR) {
        long __functionAddress = Functions.OrcMaterializationResponsibilityGetTargetDylib;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(MR);
        }
        return JNI.invokePP(MR, __functionAddress);
    }

    @NativeType(value="LLVMOrcExecutionSessionRef")
    public static long LLVMOrcMaterializationResponsibilityGetExecutionSession(@NativeType(value="LLVMOrcMaterializationResponsibilityRef") long MR) {
        long __functionAddress = Functions.OrcMaterializationResponsibilityGetExecutionSession;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(MR);
        }
        return JNI.invokePP(MR, __functionAddress);
    }

    public static long nLLVMOrcMaterializationResponsibilityGetSymbols(long MR, long NumPairs) {
        long __functionAddress = Functions.OrcMaterializationResponsibilityGetSymbols;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(MR);
        }
        return JNI.invokePPP(MR, NumPairs, __functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="LLVMOrcCSymbolFlagsMapPairs")
    public static LLVMOrcCSymbolFlagsMapPair.Buffer LLVMOrcMaterializationResponsibilityGetSymbols(@NativeType(value="LLVMOrcMaterializationResponsibilityRef") long MR) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        PointerBuffer NumPairs = stack.callocPointer(1);
        try {
            long __result = LLVMOrc.nLLVMOrcMaterializationResponsibilityGetSymbols(MR, MemoryUtil.memAddress(NumPairs));
            LLVMOrcCSymbolFlagsMapPair.Buffer buffer = LLVMOrcCSymbolFlagsMapPair.createSafe(__result, (int)NumPairs.get(0));
            return buffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nLLVMOrcDisposeCSymbolFlagsMap(long Pairs) {
        long __functionAddress = Functions.OrcDisposeCSymbolFlagsMap;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.invokePV(Pairs, __functionAddress);
    }

    public static void LLVMOrcDisposeCSymbolFlagsMap(@NativeType(value="LLVMOrcCSymbolFlagsMapPairs") LLVMOrcCSymbolFlagsMapPair Pairs) {
        LLVMOrc.nLLVMOrcDisposeCSymbolFlagsMap(Pairs.address());
    }

    @NativeType(value="LLVMOrcSymbolStringPoolEntryRef")
    public static long LLVMOrcMaterializationResponsibilityGetInitializerSymbol(@NativeType(value="LLVMOrcMaterializationResponsibilityRef") long MR) {
        long __functionAddress = Functions.OrcMaterializationResponsibilityGetInitializerSymbol;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(MR);
        }
        return JNI.invokePP(MR, __functionAddress);
    }

    public static long nLLVMOrcMaterializationResponsibilityGetRequestedSymbols(long MR, long NumSymbols) {
        long __functionAddress = Functions.OrcMaterializationResponsibilityGetRequestedSymbols;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(MR);
        }
        return JNI.invokePPP(MR, NumSymbols, __functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="LLVMOrcSymbolStringPoolEntryRef *")
    public static PointerBuffer LLVMOrcMaterializationResponsibilityGetRequestedSymbols(@NativeType(value="LLVMOrcMaterializationResponsibilityRef") long MR) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        PointerBuffer NumSymbols = stack.callocPointer(1);
        try {
            long __result = LLVMOrc.nLLVMOrcMaterializationResponsibilityGetRequestedSymbols(MR, MemoryUtil.memAddress(NumSymbols));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBufferSafe(__result, (int)NumSymbols.get(0));
            return pointerBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nLLVMOrcDisposeSymbols(long Symbols) {
        long __functionAddress = Functions.OrcDisposeSymbols;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.invokePV(Symbols, __functionAddress);
    }

    public static void LLVMOrcDisposeSymbols(@NativeType(value="LLVMOrcSymbolStringPoolEntryRef *") PointerBuffer Symbols) {
        LLVMOrc.nLLVMOrcDisposeSymbols(MemoryUtil.memAddress(Symbols));
    }

    public static long nLLVMOrcMaterializationResponsibilityNotifyResolved(long MR, long Symbols, long NumPairs) {
        long __functionAddress = Functions.OrcMaterializationResponsibilityNotifyResolved;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(MR);
        }
        return JNI.invokePPPP(MR, Symbols, NumPairs, __functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcMaterializationResponsibilityNotifyResolved(@NativeType(value="LLVMOrcMaterializationResponsibilityRef") long MR, @NativeType(value="LLVMOrcCSymbolMapPairs") LLVMJITCSymbolMapPair.Buffer Symbols) {
        return LLVMOrc.nLLVMOrcMaterializationResponsibilityNotifyResolved(MR, Symbols.address(), Symbols.remaining());
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcMaterializationResponsibilityNotifyEmitted(@NativeType(value="LLVMOrcMaterializationResponsibilityRef") long MR) {
        long __functionAddress = Functions.OrcMaterializationResponsibilityNotifyEmitted;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(MR);
        }
        return JNI.invokePP(MR, __functionAddress);
    }

    public static long nLLVMOrcMaterializationResponsibilityDefineMaterializing(long MR, long Pairs, long NumPairs) {
        long __functionAddress = Functions.OrcMaterializationResponsibilityDefineMaterializing;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(MR);
        }
        return JNI.invokePPPP(MR, Pairs, NumPairs, __functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcMaterializationResponsibilityDefineMaterializing(@NativeType(value="LLVMOrcMaterializationResponsibilityRef") long MR, @NativeType(value="LLVMOrcCSymbolFlagsMapPairs") LLVMOrcCSymbolFlagsMapPair.Buffer Pairs) {
        return LLVMOrc.nLLVMOrcMaterializationResponsibilityDefineMaterializing(MR, Pairs.address(), Pairs.remaining());
    }

    public static void LLVMOrcMaterializationResponsibilityFailMaterialization(@NativeType(value="LLVMOrcMaterializationResponsibilityRef") long MR) {
        long __functionAddress = Functions.OrcMaterializationResponsibilityFailMaterialization;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(MR);
        }
        JNI.invokePV(MR, __functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcMaterializationResponsibilityReplace(@NativeType(value="LLVMOrcMaterializationResponsibilityRef") long MR, @NativeType(value="LLVMOrcMaterializationUnitRef") long MU) {
        long __functionAddress = Functions.OrcMaterializationResponsibilityReplace;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(MR);
            Checks.check(MU);
        }
        return JNI.invokePPP(MR, MU, __functionAddress);
    }

    public static long nLLVMOrcMaterializationResponsibilityDelegate(long MR, long Symbols, long NumSymbols, long Result) {
        long __functionAddress = Functions.OrcMaterializationResponsibilityDelegate;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(MR);
        }
        return JNI.invokePPPPP(MR, Symbols, NumSymbols, Result, __functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcMaterializationResponsibilityDelegate(@NativeType(value="LLVMOrcMaterializationResponsibilityRef") long MR, @NativeType(value="LLVMOrcSymbolStringPoolEntryRef *") PointerBuffer Symbols, @NativeType(value="LLVMOrcMaterializationResponsibilityRef *") PointerBuffer Result) {
        if (Checks.CHECKS) {
            Checks.check(Result, 1);
        }
        return LLVMOrc.nLLVMOrcMaterializationResponsibilityDelegate(MR, MemoryUtil.memAddress(Symbols), Symbols.remaining(), MemoryUtil.memAddress(Result));
    }

    public static void nLLVMOrcMaterializationResponsibilityAddDependencies(long MR, long Name2, long Dependencies, long NumPairs) {
        long __functionAddress = Functions.OrcMaterializationResponsibilityAddDependencies;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(MR);
            Checks.check(Name2);
        }
        JNI.invokePPPPV(MR, Name2, Dependencies, NumPairs, __functionAddress);
    }

    public static void LLVMOrcMaterializationResponsibilityAddDependencies(@NativeType(value="LLVMOrcMaterializationResponsibilityRef") long MR, @NativeType(value="LLVMOrcSymbolStringPoolEntryRef") long Name2, @NativeType(value="LLVMOrcCDependenceMapPairs") LLVMOrcCDependenceMapPair.Buffer Dependencies) {
        LLVMOrc.nLLVMOrcMaterializationResponsibilityAddDependencies(MR, Name2, Dependencies.address(), Dependencies.remaining());
    }

    public static void nLLVMOrcMaterializationResponsibilityAddDependenciesForAll(long MR, long Dependencies, long NumPairs) {
        long __functionAddress = Functions.OrcMaterializationResponsibilityAddDependenciesForAll;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(MR);
        }
        JNI.invokePPPV(MR, Dependencies, NumPairs, __functionAddress);
    }

    public static void LLVMOrcMaterializationResponsibilityAddDependenciesForAll(@NativeType(value="LLVMOrcMaterializationResponsibilityRef") long MR, @NativeType(value="LLVMOrcCDependenceMapPairs") LLVMOrcCDependenceMapPair.Buffer Dependencies) {
        LLVMOrc.nLLVMOrcMaterializationResponsibilityAddDependenciesForAll(MR, Dependencies.address(), Dependencies.remaining());
    }

    public static long nLLVMOrcExecutionSessionCreateBareJITDylib(long ES, long Name2) {
        long __functionAddress = Functions.OrcExecutionSessionCreateBareJITDylib;
        if (Checks.CHECKS) {
            Checks.check(ES);
        }
        return JNI.invokePPP(ES, Name2, __functionAddress);
    }

    @NativeType(value="LLVMOrcJITDylibRef")
    public static long LLVMOrcExecutionSessionCreateBareJITDylib(@NativeType(value="LLVMOrcExecutionSessionRef") long ES, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMOrc.nLLVMOrcExecutionSessionCreateBareJITDylib(ES, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMOrcJITDylibRef")
    public static long LLVMOrcExecutionSessionCreateBareJITDylib(@NativeType(value="LLVMOrcExecutionSessionRef") long ES, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMOrc.nLLVMOrcExecutionSessionCreateBareJITDylib(ES, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMOrcExecutionSessionCreateJITDylib(long ES, long Result, long Name2) {
        long __functionAddress = Functions.OrcExecutionSessionCreateJITDylib;
        if (Checks.CHECKS) {
            Checks.check(ES);
        }
        return JNI.invokePPPP(ES, Result, Name2, __functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcExecutionSessionCreateJITDylib(@NativeType(value="LLVMOrcExecutionSessionRef") long ES, @NativeType(value="LLVMOrcJITDylibRef *") PointerBuffer Result, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.check(Result, 1);
            Checks.checkNT1(Name2);
        }
        return LLVMOrc.nLLVMOrcExecutionSessionCreateJITDylib(ES, MemoryUtil.memAddress(Result), MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcExecutionSessionCreateJITDylib(@NativeType(value="LLVMOrcExecutionSessionRef") long ES, @NativeType(value="LLVMOrcJITDylibRef *") PointerBuffer Result, @NativeType(value="char const *") CharSequence Name2) {
        if (Checks.CHECKS) {
            Checks.check(Result, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMOrc.nLLVMOrcExecutionSessionCreateJITDylib(ES, MemoryUtil.memAddress(Result), NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMOrcExecutionSessionGetJITDylibByName(long ES, long Name2) {
        long __functionAddress = Functions.OrcExecutionSessionGetJITDylibByName;
        if (Checks.CHECKS) {
            Checks.check(ES);
        }
        return JNI.invokePPP(ES, Name2, __functionAddress);
    }

    @NativeType(value="LLVMOrcJITDylibRef")
    public static long LLVMOrcExecutionSessionGetJITDylibByName(@NativeType(value="LLVMOrcExecutionSessionRef") long ES, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMOrc.nLLVMOrcExecutionSessionGetJITDylibByName(ES, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMOrcJITDylibRef")
    public static long LLVMOrcExecutionSessionGetJITDylibByName(@NativeType(value="LLVMOrcExecutionSessionRef") long ES, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMOrc.nLLVMOrcExecutionSessionGetJITDylibByName(ES, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMOrcResourceTrackerRef")
    public static long LLVMOrcJITDylibCreateResourceTracker(@NativeType(value="LLVMOrcJITDylibRef") long JD) {
        long __functionAddress = Functions.OrcJITDylibCreateResourceTracker;
        if (Checks.CHECKS) {
            Checks.check(JD);
        }
        return JNI.invokePP(JD, __functionAddress);
    }

    @NativeType(value="LLVMOrcResourceTrackerRef")
    public static long LLVMOrcJITDylibGetDefaultResourceTracker(@NativeType(value="LLVMOrcJITDylibRef") long JD) {
        long __functionAddress = Functions.OrcJITDylibGetDefaultResourceTracker;
        if (Checks.CHECKS) {
            Checks.check(JD);
        }
        return JNI.invokePP(JD, __functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcJITDylibDefine(@NativeType(value="LLVMOrcJITDylibRef") long JD, @NativeType(value="LLVMOrcMaterializationUnitRef") long MU) {
        long __functionAddress = Functions.OrcJITDylibDefine;
        if (Checks.CHECKS) {
            Checks.check(JD);
            Checks.check(MU);
        }
        return JNI.invokePPP(JD, MU, __functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcJITDylibClear(@NativeType(value="LLVMOrcJITDylibRef") long JD) {
        long __functionAddress = Functions.OrcJITDylibClear;
        if (Checks.CHECKS) {
            Checks.check(JD);
        }
        return JNI.invokePP(JD, __functionAddress);
    }

    public static void LLVMOrcJITDylibAddGenerator(@NativeType(value="LLVMOrcJITDylibRef") long JD, @NativeType(value="LLVMOrcDefinitionGeneratorRef") long DG) {
        long __functionAddress = Functions.OrcJITDylibAddGenerator;
        if (Checks.CHECKS) {
            Checks.check(JD);
            Checks.check(DG);
        }
        JNI.invokePPV(JD, DG, __functionAddress);
    }

    public static long nLLVMOrcCreateCustomCAPIDefinitionGenerator(long F, long Ctx) {
        long __functionAddress = Functions.OrcCreateCustomCAPIDefinitionGenerator;
        if (Checks.CHECKS) {
            Checks.check(Ctx);
        }
        return JNI.invokePPP(F, Ctx, __functionAddress);
    }

    @NativeType(value="LLVMOrcDefinitionGeneratorRef")
    public static long LLVMOrcCreateCustomCAPIDefinitionGenerator(@NativeType(value="LLVMOrcCAPIDefinitionGeneratorTryToGenerateFunction") LLVMOrcCAPIDefinitionGeneratorTryToGenerateFunctionI F, @NativeType(value="void *") long Ctx) {
        return LLVMOrc.nLLVMOrcCreateCustomCAPIDefinitionGenerator(F.address(), Ctx);
    }

    public static long nLLVMOrcCreateDynamicLibrarySearchGeneratorForProcess(long Result, byte GlobalPrefx, long Filter2, long FilterCtx) {
        long __functionAddress = Functions.OrcCreateDynamicLibrarySearchGeneratorForProcess;
        return JNI.invokePPPP(Result, GlobalPrefx, Filter2, FilterCtx, __functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcCreateDynamicLibrarySearchGeneratorForProcess(@NativeType(value="LLVMOrcDefinitionGeneratorRef *") PointerBuffer Result, @NativeType(value="char") byte GlobalPrefx, @Nullable @NativeType(value="LLVMOrcSymbolPredicate") LLVMOrcSymbolPredicateI Filter2, @NativeType(value="void *") long FilterCtx) {
        if (Checks.CHECKS) {
            Checks.check(Result, 1);
        }
        return LLVMOrc.nLLVMOrcCreateDynamicLibrarySearchGeneratorForProcess(MemoryUtil.memAddress(Result), GlobalPrefx, MemoryUtil.memAddressSafe(Filter2), FilterCtx);
    }

    @NativeType(value="LLVMOrcThreadSafeContextRef")
    public static long LLVMOrcCreateNewThreadSafeContext() {
        long __functionAddress = Functions.OrcCreateNewThreadSafeContext;
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="LLVMContextRef")
    public static long LLVMOrcThreadSafeContextGetContext(@NativeType(value="LLVMOrcThreadSafeContextRef") long TSCtx) {
        long __functionAddress = Functions.OrcThreadSafeContextGetContext;
        if (Checks.CHECKS) {
            Checks.check(TSCtx);
        }
        return JNI.invokePP(TSCtx, __functionAddress);
    }

    public static void LLVMOrcDisposeThreadSafeContext(@NativeType(value="LLVMOrcThreadSafeContextRef") long TSCtx) {
        long __functionAddress = Functions.OrcDisposeThreadSafeContext;
        if (Checks.CHECKS) {
            Checks.check(TSCtx);
        }
        JNI.invokePV(TSCtx, __functionAddress);
    }

    @NativeType(value="LLVMOrcThreadSafeModuleRef")
    public static long LLVMOrcCreateNewThreadSafeModule(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="LLVMOrcThreadSafeContextRef") long TSCtx) {
        long __functionAddress = Functions.OrcCreateNewThreadSafeModule;
        if (Checks.CHECKS) {
            Checks.check(M);
            Checks.check(TSCtx);
        }
        return JNI.invokePPP(M, TSCtx, __functionAddress);
    }

    public static void LLVMOrcDisposeThreadSafeModule(@NativeType(value="LLVMOrcThreadSafeModuleRef") long TSM) {
        long __functionAddress = Functions.OrcDisposeThreadSafeModule;
        if (Checks.CHECKS) {
            Checks.check(TSM);
        }
        JNI.invokePV(TSM, __functionAddress);
    }

    public static long nLLVMOrcThreadSafeModuleWithModuleDo(long TSM, long F, long Ctx) {
        long __functionAddress = Functions.OrcThreadSafeModuleWithModuleDo;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(TSM);
            Checks.check(Ctx);
        }
        return JNI.invokePPPP(TSM, F, Ctx, __functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcThreadSafeModuleWithModuleDo(@NativeType(value="LLVMOrcThreadSafeModuleRef") long TSM, @NativeType(value="LLVMOrcGenericIRModuleOperationFunction") LLVMOrcGenericIRModuleOperationFunctionI F, @NativeType(value="void *") long Ctx) {
        return LLVMOrc.nLLVMOrcThreadSafeModuleWithModuleDo(TSM, F.address(), Ctx);
    }

    public static long nLLVMOrcJITTargetMachineBuilderDetectHost(long Result) {
        long __functionAddress = Functions.OrcJITTargetMachineBuilderDetectHost;
        return JNI.invokePP(Result, __functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcJITTargetMachineBuilderDetectHost(@NativeType(value="LLVMOrcJITTargetMachineBuilderRef *") PointerBuffer Result) {
        if (Checks.CHECKS) {
            Checks.check(Result, 1);
        }
        return LLVMOrc.nLLVMOrcJITTargetMachineBuilderDetectHost(MemoryUtil.memAddress(Result));
    }

    @NativeType(value="LLVMOrcJITTargetMachineBuilderRef")
    public static long LLVMOrcJITTargetMachineBuilderCreateFromTargetMachine(@NativeType(value="LLVMTargetMachineRef") long TM) {
        long __functionAddress = Functions.OrcJITTargetMachineBuilderCreateFromTargetMachine;
        if (Checks.CHECKS) {
            Checks.check(TM);
        }
        return JNI.invokePP(TM, __functionAddress);
    }

    public static void LLVMOrcDisposeJITTargetMachineBuilder(@NativeType(value="LLVMOrcJITTargetMachineBuilderRef") long JTMB) {
        long __functionAddress = Functions.OrcDisposeJITTargetMachineBuilder;
        if (Checks.CHECKS) {
            Checks.check(JTMB);
        }
        JNI.invokePV(JTMB, __functionAddress);
    }

    public static long nLLVMOrcJITTargetMachineBuilderGetTargetTriple(long JTMB) {
        long __functionAddress = Functions.OrcJITTargetMachineBuilderGetTargetTriple;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(JTMB);
        }
        return JNI.invokePP(JTMB, __functionAddress);
    }

    @Nullable
    @NativeType(value="char *")
    public static String LLVMOrcJITTargetMachineBuilderGetTargetTriple(@NativeType(value="LLVMOrcJITTargetMachineBuilderRef") long JTMB) {
        long __result = LLVMOrc.nLLVMOrcJITTargetMachineBuilderGetTargetTriple(JTMB);
        return MemoryUtil.memUTF8Safe(__result);
    }

    public static void nLLVMOrcJITTargetMachineBuilderSetTargetTriple(long JTMB, long TargetTriple) {
        long __functionAddress = Functions.OrcJITTargetMachineBuilderSetTargetTriple;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(JTMB);
        }
        JNI.invokePPV(JTMB, TargetTriple, __functionAddress);
    }

    public static void LLVMOrcJITTargetMachineBuilderSetTargetTriple(@NativeType(value="LLVMOrcJITTargetMachineBuilderRef") long JTMB, @NativeType(value="char const *") ByteBuffer TargetTriple) {
        if (Checks.CHECKS) {
            Checks.checkNT1(TargetTriple);
        }
        LLVMOrc.nLLVMOrcJITTargetMachineBuilderSetTargetTriple(JTMB, MemoryUtil.memAddress(TargetTriple));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void LLVMOrcJITTargetMachineBuilderSetTargetTriple(@NativeType(value="LLVMOrcJITTargetMachineBuilderRef") long JTMB, @NativeType(value="char const *") CharSequence TargetTriple) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(TargetTriple, true);
            long TargetTripleEncoded = stack.getPointerAddress();
            LLVMOrc.nLLVMOrcJITTargetMachineBuilderSetTargetTriple(JTMB, TargetTripleEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcObjectLayerAddObjectFile(@NativeType(value="LLVMOrcObjectLayerRef") long ObjLayer, @NativeType(value="LLVMOrcJITDylibRef") long JD, @NativeType(value="LLVMMemoryBufferRef") long ObjBuffer) {
        long __functionAddress = Functions.OrcObjectLayerAddObjectFile;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(ObjLayer);
            Checks.check(JD);
            Checks.check(ObjBuffer);
        }
        return JNI.invokePPPP(ObjLayer, JD, ObjBuffer, __functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcObjectLayerAddObjectFileWithRT(@NativeType(value="LLVMOrcObjectLayerRef") long ObjLayer, @NativeType(value="LLVMOrcResourceTrackerRef") long RT, @NativeType(value="LLVMMemoryBufferRef") long ObjBuffer) {
        long __functionAddress = Functions.OrcObjectLayerAddObjectFileWithRT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(ObjLayer);
            Checks.check(RT);
            Checks.check(ObjBuffer);
        }
        return JNI.invokePPPP(ObjLayer, RT, ObjBuffer, __functionAddress);
    }

    public static void LLVMOrcObjectLayerEmit(@NativeType(value="LLVMOrcObjectLayerRef") long ObjLayer, @NativeType(value="LLVMOrcMaterializationResponsibilityRef") long R, @NativeType(value="LLVMMemoryBufferRef") long ObjBuffer) {
        long __functionAddress = Functions.OrcObjectLayerEmit;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(ObjLayer);
            Checks.check(R);
            Checks.check(ObjBuffer);
        }
        JNI.invokePPPV(ObjLayer, R, ObjBuffer, __functionAddress);
    }

    public static void LLVMOrcDisposeObjectLayer(@NativeType(value="LLVMOrcObjectLayerRef") long ObjLayer) {
        long __functionAddress = Functions.OrcDisposeObjectLayer;
        if (Checks.CHECKS) {
            Checks.check(ObjLayer);
        }
        JNI.invokePV(ObjLayer, __functionAddress);
    }

    public static void LLVMOrcIRTransformLayerEmit(@NativeType(value="LLVMOrcIRTransformLayerRef") long IRTransformLayer, @NativeType(value="LLVMOrcMaterializationResponsibilityRef") long MR, @NativeType(value="LLVMOrcThreadSafeModuleRef") long TSM) {
        long __functionAddress = Functions.OrcIRTransformLayerEmit;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(IRTransformLayer);
            Checks.check(MR);
            Checks.check(TSM);
        }
        JNI.invokePPPV(IRTransformLayer, MR, TSM, __functionAddress);
    }

    public static void nLLVMOrcIRTransformLayerSetTransform(long IRTransformLayer, long TransformFunction, long Ctx) {
        long __functionAddress = Functions.OrcIRTransformLayerSetTransform;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(IRTransformLayer);
            Checks.check(Ctx);
        }
        JNI.invokePPPV(IRTransformLayer, TransformFunction, Ctx, __functionAddress);
    }

    public static void LLVMOrcIRTransformLayerSetTransform(@NativeType(value="LLVMOrcIRTransformLayerRef") long IRTransformLayer, @NativeType(value="LLVMOrcIRTransformLayerTransformFunction") LLVMOrcIRTransformLayerTransformFunctionI TransformFunction, @NativeType(value="void *") long Ctx) {
        LLVMOrc.nLLVMOrcIRTransformLayerSetTransform(IRTransformLayer, TransformFunction.address(), Ctx);
    }

    public static void nLLVMOrcObjectTransformLayerSetTransform(long ObjTransformLayer, long TransformFunction, long Ctx) {
        long __functionAddress = Functions.OrcObjectTransformLayerSetTransform;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(ObjTransformLayer);
            Checks.check(Ctx);
        }
        JNI.invokePPPV(ObjTransformLayer, TransformFunction, Ctx, __functionAddress);
    }

    public static void LLVMOrcObjectTransformLayerSetTransform(@NativeType(value="LLVMOrcObjectTransformLayerRef") long ObjTransformLayer, @NativeType(value="LLVMOrcObjectTransformLayerTransformFunction") LLVMOrcObjectTransformLayerTransformFunctionI TransformFunction, @NativeType(value="void *") long Ctx) {
        LLVMOrc.nLLVMOrcObjectTransformLayerSetTransform(ObjTransformLayer, TransformFunction.address(), Ctx);
    }

    public static long nLLVMOrcCreateLocalIndirectStubsManager(long TargetTriple) {
        long __functionAddress = Functions.OrcCreateLocalIndirectStubsManager;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.invokePP(TargetTriple, __functionAddress);
    }

    @NativeType(value="LLVMOrcIndirectStubsManagerRef")
    public static long LLVMOrcCreateLocalIndirectStubsManager(@NativeType(value="char const *") ByteBuffer TargetTriple) {
        if (Checks.CHECKS) {
            Checks.checkNT1(TargetTriple);
        }
        return LLVMOrc.nLLVMOrcCreateLocalIndirectStubsManager(MemoryUtil.memAddress(TargetTriple));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMOrcIndirectStubsManagerRef")
    public static long LLVMOrcCreateLocalIndirectStubsManager(@NativeType(value="char const *") CharSequence TargetTriple) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(TargetTriple, true);
            long TargetTripleEncoded = stack.getPointerAddress();
            long l = LLVMOrc.nLLVMOrcCreateLocalIndirectStubsManager(TargetTripleEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void LLVMOrcDisposeIndirectStubsManager(@NativeType(value="LLVMOrcIndirectStubsManagerRef") long ISM) {
        long __functionAddress = Functions.OrcDisposeIndirectStubsManager;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(ISM);
        }
        JNI.invokePV(ISM, __functionAddress);
    }

    public static long nLLVMOrcCreateLocalLazyCallThroughManager(long TargetTriple, long ES, long ErrorHandlerAddr, long LCTM) {
        long __functionAddress = Functions.OrcCreateLocalLazyCallThroughManager;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(ES);
        }
        return JNI.invokePPJPP(TargetTriple, ES, ErrorHandlerAddr, LCTM, __functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcCreateLocalLazyCallThroughManager(@NativeType(value="char const *") ByteBuffer TargetTriple, @NativeType(value="LLVMOrcExecutionSessionRef") long ES, @NativeType(value="LLVMOrcJITTargetAddress") long ErrorHandlerAddr, @NativeType(value="LLVMOrcLazyCallThroughManagerRef *") PointerBuffer LCTM) {
        if (Checks.CHECKS) {
            Checks.checkNT1(TargetTriple);
            Checks.check(LCTM, 1);
        }
        return LLVMOrc.nLLVMOrcCreateLocalLazyCallThroughManager(MemoryUtil.memAddress(TargetTriple), ES, ErrorHandlerAddr, MemoryUtil.memAddress(LCTM));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcCreateLocalLazyCallThroughManager(@NativeType(value="char const *") CharSequence TargetTriple, @NativeType(value="LLVMOrcExecutionSessionRef") long ES, @NativeType(value="LLVMOrcJITTargetAddress") long ErrorHandlerAddr, @NativeType(value="LLVMOrcLazyCallThroughManagerRef *") PointerBuffer LCTM) {
        if (Checks.CHECKS) {
            Checks.check(LCTM, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(TargetTriple, true);
            long TargetTripleEncoded = stack.getPointerAddress();
            long l = LLVMOrc.nLLVMOrcCreateLocalLazyCallThroughManager(TargetTripleEncoded, ES, ErrorHandlerAddr, MemoryUtil.memAddress(LCTM));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void LLVMOrcDisposeLazyCallThroughManager(@NativeType(value="LLVMOrcLazyCallThroughManagerRef") long LCTM) {
        long __functionAddress = Functions.OrcDisposeLazyCallThroughManager;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(LCTM);
        }
        JNI.invokePV(LCTM, __functionAddress);
    }

    public static long nLLVMOrcCreateDumpObjects(long DumpDir, long IdentifierOverride) {
        long __functionAddress = Functions.OrcCreateDumpObjects;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.invokePPP(DumpDir, IdentifierOverride, __functionAddress);
    }

    @NativeType(value="LLVMOrcDumpObjectsRef")
    public static long LLVMOrcCreateDumpObjects(@NativeType(value="char const *") ByteBuffer DumpDir, @NativeType(value="char const *") ByteBuffer IdentifierOverride) {
        if (Checks.CHECKS) {
            Checks.checkNT1(DumpDir);
            Checks.checkNT1(IdentifierOverride);
        }
        return LLVMOrc.nLLVMOrcCreateDumpObjects(MemoryUtil.memAddress(DumpDir), MemoryUtil.memAddress(IdentifierOverride));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMOrcDumpObjectsRef")
    public static long LLVMOrcCreateDumpObjects(@NativeType(value="char const *") CharSequence DumpDir, @NativeType(value="char const *") CharSequence IdentifierOverride) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(DumpDir, true);
            long DumpDirEncoded = stack.getPointerAddress();
            stack.nUTF8(IdentifierOverride, true);
            long IdentifierOverrideEncoded = stack.getPointerAddress();
            long l = LLVMOrc.nLLVMOrcCreateDumpObjects(DumpDirEncoded, IdentifierOverrideEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void LLVMOrcDisposeDumpObjects(@NativeType(value="LLVMOrcDumpObjectsRef") long DumpObjects) {
        long __functionAddress = Functions.OrcDisposeDumpObjects;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(DumpObjects);
        }
        JNI.invokePV(DumpObjects, __functionAddress);
    }

    public static long nLLVMOrcDumpObjects_CallOperator(long DumpObjects, long ObjBuffer) {
        long __functionAddress = Functions.OrcDumpObjects_CallOperator;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(DumpObjects);
        }
        return JNI.invokePPP(DumpObjects, ObjBuffer, __functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcDumpObjects_CallOperator(@NativeType(value="LLVMOrcDumpObjectsRef") long DumpObjects, @NativeType(value="LLVMMemoryBufferRef *") PointerBuffer ObjBuffer) {
        if (Checks.CHECKS) {
            Checks.check(ObjBuffer, 1);
        }
        return LLVMOrc.nLLVMOrcDumpObjects_CallOperator(DumpObjects, MemoryUtil.memAddress(ObjBuffer));
    }

    public static final class Functions {
        public static final long OrcExecutionSessionSetErrorReporter = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcExecutionSessionSetErrorReporter");
        public static final long OrcExecutionSessionGetSymbolStringPool = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcExecutionSessionGetSymbolStringPool");
        public static final long OrcSymbolStringPoolClearDeadEntries = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcSymbolStringPoolClearDeadEntries");
        public static final long OrcExecutionSessionIntern = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcExecutionSessionIntern");
        public static final long OrcRetainSymbolStringPoolEntry = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcRetainSymbolStringPoolEntry");
        public static final long OrcReleaseSymbolStringPoolEntry = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcReleaseSymbolStringPoolEntry");
        public static final long OrcSymbolStringPoolEntryStr = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcSymbolStringPoolEntryStr");
        public static final long OrcReleaseResourceTracker = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcReleaseResourceTracker");
        public static final long OrcResourceTrackerTransferTo = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcResourceTrackerTransferTo");
        public static final long OrcResourceTrackerRemove = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcResourceTrackerRemove");
        public static final long OrcDisposeDefinitionGenerator = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcDisposeDefinitionGenerator");
        public static final long OrcDisposeMaterializationUnit = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcDisposeMaterializationUnit");
        public static final long OrcCreateCustomMaterializationUnit = LLVMCore.getLibrary().getFunctionAddress("LLVMOrcCreateCustomMaterializationUnit");
        public static final long OrcAbsoluteSymbols = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcAbsoluteSymbols");
        public static final long OrcLazyReexports = LLVMCore.getLibrary().getFunctionAddress("LLVMOrcLazyReexports");
        public static final long OrcDisposeMaterializationResponsibility = LLVMCore.getLibrary().getFunctionAddress("LLVMOrcDisposeMaterializationResponsibility");
        public static final long OrcMaterializationResponsibilityGetTargetDylib = LLVMCore.getLibrary().getFunctionAddress("LLVMOrcMaterializationResponsibilityGetTargetDylib");
        public static final long OrcMaterializationResponsibilityGetExecutionSession = LLVMCore.getLibrary().getFunctionAddress("LLVMOrcMaterializationResponsibilityGetExecutionSession");
        public static final long OrcMaterializationResponsibilityGetSymbols = LLVMCore.getLibrary().getFunctionAddress("LLVMOrcMaterializationResponsibilityGetSymbols");
        public static final long OrcDisposeCSymbolFlagsMap = LLVMCore.getLibrary().getFunctionAddress("LLVMOrcDisposeCSymbolFlagsMap");
        public static final long OrcMaterializationResponsibilityGetInitializerSymbol = LLVMCore.getLibrary().getFunctionAddress("LLVMOrcMaterializationResponsibilityGetInitializerSymbol");
        public static final long OrcMaterializationResponsibilityGetRequestedSymbols = LLVMCore.getLibrary().getFunctionAddress("LLVMOrcMaterializationResponsibilityGetRequestedSymbols");
        public static final long OrcDisposeSymbols = LLVMCore.getLibrary().getFunctionAddress("LLVMOrcDisposeSymbols");
        public static final long OrcMaterializationResponsibilityNotifyResolved = LLVMCore.getLibrary().getFunctionAddress("LLVMOrcMaterializationResponsibilityNotifyResolved");
        public static final long OrcMaterializationResponsibilityNotifyEmitted = LLVMCore.getLibrary().getFunctionAddress("LLVMOrcMaterializationResponsibilityNotifyEmitted");
        public static final long OrcMaterializationResponsibilityDefineMaterializing = LLVMCore.getLibrary().getFunctionAddress("LLVMOrcMaterializationResponsibilityDefineMaterializing");
        public static final long OrcMaterializationResponsibilityFailMaterialization = LLVMCore.getLibrary().getFunctionAddress("LLVMOrcMaterializationResponsibilityFailMaterialization");
        public static final long OrcMaterializationResponsibilityReplace = LLVMCore.getLibrary().getFunctionAddress("LLVMOrcMaterializationResponsibilityReplace");
        public static final long OrcMaterializationResponsibilityDelegate = LLVMCore.getLibrary().getFunctionAddress("LLVMOrcMaterializationResponsibilityDelegate");
        public static final long OrcMaterializationResponsibilityAddDependencies = LLVMCore.getLibrary().getFunctionAddress("LLVMOrcMaterializationResponsibilityAddDependencies");
        public static final long OrcMaterializationResponsibilityAddDependenciesForAll = LLVMCore.getLibrary().getFunctionAddress("LLVMOrcMaterializationResponsibilityAddDependenciesForAll");
        public static final long OrcExecutionSessionCreateBareJITDylib = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcExecutionSessionCreateBareJITDylib");
        public static final long OrcExecutionSessionCreateJITDylib = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcExecutionSessionCreateJITDylib");
        public static final long OrcExecutionSessionGetJITDylibByName = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcExecutionSessionGetJITDylibByName");
        public static final long OrcJITDylibCreateResourceTracker = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcJITDylibCreateResourceTracker");
        public static final long OrcJITDylibGetDefaultResourceTracker = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcJITDylibGetDefaultResourceTracker");
        public static final long OrcJITDylibDefine = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcJITDylibDefine");
        public static final long OrcJITDylibClear = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcJITDylibClear");
        public static final long OrcJITDylibAddGenerator = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcJITDylibAddGenerator");
        public static final long OrcCreateCustomCAPIDefinitionGenerator = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcCreateCustomCAPIDefinitionGenerator");
        public static final long OrcCreateDynamicLibrarySearchGeneratorForProcess = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcCreateDynamicLibrarySearchGeneratorForProcess");
        public static final long OrcCreateNewThreadSafeContext = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcCreateNewThreadSafeContext");
        public static final long OrcThreadSafeContextGetContext = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcThreadSafeContextGetContext");
        public static final long OrcDisposeThreadSafeContext = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcDisposeThreadSafeContext");
        public static final long OrcCreateNewThreadSafeModule = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcCreateNewThreadSafeModule");
        public static final long OrcDisposeThreadSafeModule = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcDisposeThreadSafeModule");
        public static final long OrcThreadSafeModuleWithModuleDo = LLVMCore.getLibrary().getFunctionAddress("LLVMOrcThreadSafeModuleWithModuleDo");
        public static final long OrcJITTargetMachineBuilderDetectHost = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcJITTargetMachineBuilderDetectHost");
        public static final long OrcJITTargetMachineBuilderCreateFromTargetMachine = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcJITTargetMachineBuilderCreateFromTargetMachine");
        public static final long OrcDisposeJITTargetMachineBuilder = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcDisposeJITTargetMachineBuilder");
        public static final long OrcJITTargetMachineBuilderGetTargetTriple = LLVMCore.getLibrary().getFunctionAddress("LLVMOrcJITTargetMachineBuilderGetTargetTriple");
        public static final long OrcJITTargetMachineBuilderSetTargetTriple = LLVMCore.getLibrary().getFunctionAddress("LLVMOrcJITTargetMachineBuilderSetTargetTriple");
        public static final long OrcObjectLayerAddObjectFile = LLVMCore.getLibrary().getFunctionAddress("LLVMOrcObjectLayerAddObjectFile");
        public static final long OrcObjectLayerAddObjectFileWithRT = LLVMCore.getLibrary().getFunctionAddress("LLVMOrcObjectLayerAddObjectFileWithRT");
        public static final long OrcObjectLayerEmit = LLVMCore.getLibrary().getFunctionAddress("LLVMOrcObjectLayerEmit");
        public static final long OrcDisposeObjectLayer = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMOrcDisposeObjectLayer");
        public static final long OrcIRTransformLayerEmit = LLVMCore.getLibrary().getFunctionAddress("LLVMOrcIRTransformLayerEmit");
        public static final long OrcIRTransformLayerSetTransform = LLVMCore.getLibrary().getFunctionAddress("LLVMOrcIRTransformLayerSetTransform");
        public static final long OrcObjectTransformLayerSetTransform = LLVMCore.getLibrary().getFunctionAddress("LLVMOrcObjectTransformLayerSetTransform");
        public static final long OrcCreateLocalIndirectStubsManager = LLVMCore.getLibrary().getFunctionAddress("LLVMOrcCreateLocalIndirectStubsManager");
        public static final long OrcDisposeIndirectStubsManager = LLVMCore.getLibrary().getFunctionAddress("LLVMOrcDisposeIndirectStubsManager");
        public static final long OrcCreateLocalLazyCallThroughManager = LLVMCore.getLibrary().getFunctionAddress("LLVMOrcCreateLocalLazyCallThroughManager");
        public static final long OrcDisposeLazyCallThroughManager = LLVMCore.getLibrary().getFunctionAddress("LLVMOrcDisposeLazyCallThroughManager");
        public static final long OrcCreateDumpObjects = LLVMCore.getLibrary().getFunctionAddress("LLVMOrcCreateDumpObjects");
        public static final long OrcDisposeDumpObjects = LLVMCore.getLibrary().getFunctionAddress("LLVMOrcDisposeDumpObjects");
        public static final long OrcDumpObjects_CallOperator = LLVMCore.getLibrary().getFunctionAddress("LLVMOrcDumpObjects_CallOperator");

        private Functions() {
        }
    }
}

