/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.llvm.LLVMJITEvaluatedSymbol;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class LLVMJITCSymbolMapPair
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NAME;
    public static final int SYM;

    public LLVMJITCSymbolMapPair(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), LLVMJITCSymbolMapPair.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="LLVMOrcSymbolStringPoolEntryRef")
    public long Name() {
        return LLVMJITCSymbolMapPair.nName(this.address());
    }

    public LLVMJITEvaluatedSymbol Sym() {
        return LLVMJITCSymbolMapPair.nSym(this.address());
    }

    public LLVMJITCSymbolMapPair Name(@NativeType(value="LLVMOrcSymbolStringPoolEntryRef") long value) {
        LLVMJITCSymbolMapPair.nName(this.address(), value);
        return this;
    }

    public LLVMJITCSymbolMapPair Sym(LLVMJITEvaluatedSymbol value) {
        LLVMJITCSymbolMapPair.nSym(this.address(), value);
        return this;
    }

    public LLVMJITCSymbolMapPair Sym(Consumer<LLVMJITEvaluatedSymbol> consumer) {
        consumer.accept(this.Sym());
        return this;
    }

    public LLVMJITCSymbolMapPair set(long Name2, LLVMJITEvaluatedSymbol Sym) {
        this.Name(Name2);
        this.Sym(Sym);
        return this;
    }

    public LLVMJITCSymbolMapPair set(LLVMJITCSymbolMapPair src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static LLVMJITCSymbolMapPair malloc() {
        return LLVMJITCSymbolMapPair.wrap(LLVMJITCSymbolMapPair.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static LLVMJITCSymbolMapPair calloc() {
        return LLVMJITCSymbolMapPair.wrap(LLVMJITCSymbolMapPair.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static LLVMJITCSymbolMapPair create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return LLVMJITCSymbolMapPair.wrap(LLVMJITCSymbolMapPair.class, MemoryUtil.memAddress(container), container);
    }

    public static LLVMJITCSymbolMapPair create(long address) {
        return LLVMJITCSymbolMapPair.wrap(LLVMJITCSymbolMapPair.class, address);
    }

    @Nullable
    public static LLVMJITCSymbolMapPair createSafe(long address) {
        return address == 0L ? null : LLVMJITCSymbolMapPair.wrap(LLVMJITCSymbolMapPair.class, address);
    }

    public static Buffer malloc(int capacity) {
        return LLVMJITCSymbolMapPair.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(LLVMJITCSymbolMapPair.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return LLVMJITCSymbolMapPair.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = LLVMJITCSymbolMapPair.__create(capacity, SIZEOF);
        return LLVMJITCSymbolMapPair.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return LLVMJITCSymbolMapPair.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : LLVMJITCSymbolMapPair.wrap(Buffer.class, address, capacity);
    }

    public static LLVMJITCSymbolMapPair malloc(MemoryStack stack) {
        return LLVMJITCSymbolMapPair.wrap(LLVMJITCSymbolMapPair.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static LLVMJITCSymbolMapPair calloc(MemoryStack stack) {
        return LLVMJITCSymbolMapPair.wrap(LLVMJITCSymbolMapPair.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return LLVMJITCSymbolMapPair.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return LLVMJITCSymbolMapPair.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nName(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NAME);
    }

    public static LLVMJITEvaluatedSymbol nSym(long struct) {
        return LLVMJITEvaluatedSymbol.create(struct + (long)SYM);
    }

    public static void nName(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NAME, Checks.check(value));
    }

    public static void nSym(long struct, LLVMJITEvaluatedSymbol value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SYM, LLVMJITEvaluatedSymbol.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)NAME));
    }

    static {
        Struct.Layout layout = LLVMJITCSymbolMapPair.__struct(LLVMJITCSymbolMapPair.__member(POINTER_SIZE), LLVMJITCSymbolMapPair.__member(LLVMJITEvaluatedSymbol.SIZEOF, LLVMJITEvaluatedSymbol.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NAME = layout.offsetof(0);
        SYM = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<LLVMJITCSymbolMapPair, Buffer>
    implements NativeResource {
        private static final LLVMJITCSymbolMapPair ELEMENT_FACTORY = LLVMJITCSymbolMapPair.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected LLVMJITCSymbolMapPair getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="LLVMOrcSymbolStringPoolEntryRef")
        public long Name() {
            return LLVMJITCSymbolMapPair.nName(this.address());
        }

        public LLVMJITEvaluatedSymbol Sym() {
            return LLVMJITCSymbolMapPair.nSym(this.address());
        }

        public Buffer Name(@NativeType(value="LLVMOrcSymbolStringPoolEntryRef") long value) {
            LLVMJITCSymbolMapPair.nName(this.address(), value);
            return this;
        }

        public Buffer Sym(LLVMJITEvaluatedSymbol value) {
            LLVMJITCSymbolMapPair.nSym(this.address(), value);
            return this;
        }

        public Buffer Sym(Consumer<LLVMJITEvaluatedSymbol> consumer) {
            consumer.accept(this.Sym());
            return this;
        }
    }
}

