/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.llvm.LLVMCore;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class LLVMDebugInfo {
    public static final int LLVMDIFlagZero = 0;
    public static final int LLVMDIFlagPrivate = 1;
    public static final int LLVMDIFlagProtected = 2;
    public static final int LLVMDIFlagPublic = 3;
    public static final int LLVMDIFlagFwdDecl = 4;
    public static final int LLVMDIFlagAppleBlock = 8;
    public static final int LLVMDIFlagReservedBit4 = 16;
    public static final int LLVMDIFlagVirtual = 32;
    public static final int LLVMDIFlagArtificial = 64;
    public static final int LLVMDIFlagExplicit = 128;
    public static final int LLVMDIFlagPrototyped = 256;
    public static final int LLVMDIFlagObjcClassComplete = 512;
    public static final int LLVMDIFlagObjectPointer = 1024;
    public static final int LLVMDIFlagVector = 2048;
    public static final int LLVMDIFlagStaticMember = 4096;
    public static final int LLVMDIFlagLValueReference = 8192;
    public static final int LLVMDIFlagRValueReference = 16384;
    public static final int LLVMDIFlagReserved = 32768;
    public static final int LLVMDIFlagSingleInheritance = 65536;
    public static final int LLVMDIFlagMultipleInheritance = 131072;
    public static final int LLVMDIFlagVirtualInheritance = 196608;
    public static final int LLVMDIFlagIntroducedVirtual = 262144;
    public static final int LLVMDIFlagBitField = 524288;
    public static final int LLVMDIFlagNoReturn = 0x100000;
    public static final int LLVMDIFlagTypePassByValue = 0x400000;
    public static final int LLVMDIFlagTypePassByReference = 0x800000;
    public static final int LLVMDIFlagEnumClass = 0x1000000;
    public static final int LLVMDIFlagFixedEnum = 0x1000000;
    public static final int LLVMDIFlagThunk = 0x2000000;
    public static final int LLVMDIFlagNonTrivial = 0x4000000;
    public static final int LLVMDIFlagBigEndian = 0x8000000;
    public static final int LLVMDIFlagLittleEndian = 0x10000000;
    public static final int LLVMDIFlagIndirectVirtualBase = 36;
    public static final int LLVMDIFlagAccessibility = 3;
    public static final int LLVMDIFlagPtrToMemberRep = 196608;
    public static final int LLVMDWARFSourceLanguageC89 = 0;
    public static final int LLVMDWARFSourceLanguageC = 1;
    public static final int LLVMDWARFSourceLanguageAda83 = 2;
    public static final int LLVMDWARFSourceLanguageC_plus_plus = 3;
    public static final int LLVMDWARFSourceLanguageCobol74 = 4;
    public static final int LLVMDWARFSourceLanguageCobol85 = 5;
    public static final int LLVMDWARFSourceLanguageFortran77 = 6;
    public static final int LLVMDWARFSourceLanguageFortran90 = 7;
    public static final int LLVMDWARFSourceLanguagePascal83 = 8;
    public static final int LLVMDWARFSourceLanguageModula2 = 9;
    public static final int LLVMDWARFSourceLanguageJava = 10;
    public static final int LLVMDWARFSourceLanguageC99 = 11;
    public static final int LLVMDWARFSourceLanguageAda95 = 12;
    public static final int LLVMDWARFSourceLanguageFortran95 = 13;
    public static final int LLVMDWARFSourceLanguagePLI = 14;
    public static final int LLVMDWARFSourceLanguageObjC = 15;
    public static final int LLVMDWARFSourceLanguageObjC_plus_plus = 16;
    public static final int LLVMDWARFSourceLanguageUPC = 17;
    public static final int LLVMDWARFSourceLanguageD = 18;
    public static final int LLVMDWARFSourceLanguagePython = 19;
    public static final int LLVMDWARFSourceLanguageOpenCL = 20;
    public static final int LLVMDWARFSourceLanguageGo = 21;
    public static final int LLVMDWARFSourceLanguageModula3 = 22;
    public static final int LLVMDWARFSourceLanguageHaskell = 23;
    public static final int LLVMDWARFSourceLanguageC_plus_plus_03 = 24;
    public static final int LLVMDWARFSourceLanguageC_plus_plus_11 = 25;
    public static final int LLVMDWARFSourceLanguageOCaml = 26;
    public static final int LLVMDWARFSourceLanguageRust = 27;
    public static final int LLVMDWARFSourceLanguageC11 = 28;
    public static final int LLVMDWARFSourceLanguageSwift = 29;
    public static final int LLVMDWARFSourceLanguageJulia = 30;
    public static final int LLVMDWARFSourceLanguageDylan = 31;
    public static final int LLVMDWARFSourceLanguageC_plus_plus_14 = 32;
    public static final int LLVMDWARFSourceLanguageFortran03 = 33;
    public static final int LLVMDWARFSourceLanguageFortran08 = 34;
    public static final int LLVMDWARFSourceLanguageRenderScript = 35;
    public static final int LLVMDWARFSourceLanguageBLISS = 36;
    public static final int LLVMDWARFSourceLanguageMips_Assembler = 37;
    public static final int LLVMDWARFSourceLanguageGOOGLE_RenderScript = 38;
    public static final int LLVMDWARFSourceLanguageBORLAND_Delphi = 39;
    public static final int LLVMDWARFEmissionNone = 0;
    public static final int LLVMDWARFEmissionFull = 1;
    public static final int LLVMDWARFEmissionLineTablesOnly = 2;
    public static final int LLVMMDStringMetadataKind = 0;
    public static final int LLVMConstantAsMetadataMetadataKind = 1;
    public static final int LLVMLocalAsMetadataMetadataKind = 2;
    public static final int LLVMDistinctMDOperandPlaceholderMetadataKind = 3;
    public static final int LLVMMDTupleMetadataKind = 4;
    public static final int LLVMDILocationMetadataKind = 5;
    public static final int LLVMDIExpressionMetadataKind = 6;
    public static final int LLVMDIGlobalVariableExpressionMetadataKind = 7;
    public static final int LLVMGenericDINodeMetadataKind = 8;
    public static final int LLVMDISubrangeMetadataKind = 9;
    public static final int LLVMDIEnumeratorMetadataKind = 10;
    public static final int LLVMDIBasicTypeMetadataKind = 11;
    public static final int LLVMDIDerivedTypeMetadataKind = 12;
    public static final int LLVMDICompositeTypeMetadataKind = 13;
    public static final int LLVMDISubroutineTypeMetadataKind = 14;
    public static final int LLVMDIFileMetadataKind = 15;
    public static final int LLVMDICompileUnitMetadataKind = 16;
    public static final int LLVMDISubprogramMetadataKind = 17;
    public static final int LLVMDILexicalBlockMetadataKind = 18;
    public static final int LLVMDILexicalBlockFileMetadataKind = 19;
    public static final int LLVMDINamespaceMetadataKind = 20;
    public static final int LLVMDIModuleMetadataKind = 21;
    public static final int LLVMDITemplateTypeParameterMetadataKind = 22;
    public static final int LLVMDITemplateValueParameterMetadataKind = 23;
    public static final int LLVMDIGlobalVariableMetadataKind = 24;
    public static final int LLVMDILocalVariableMetadataKind = 25;
    public static final int LLVMDILabelMetadataKind = 26;
    public static final int LLVMDIObjCPropertyMetadataKind = 27;
    public static final int LLVMDIImportedEntityMetadataKind = 28;
    public static final int LLVMDIMacroMetadataKind = 29;
    public static final int LLVMDIMacroFileMetadataKind = 30;
    public static final int LLVMDICommonBlockMetadataKind = 31;
    public static final int LLVMDIStringTypeMetadataKind = 32;
    public static final int LLVMDIGenericSubrangeMetadataKind = 33;
    public static final int LLVMDIArgListMetadataKind = 34;
    public static final int LLVMDWARFMacinfoRecordTypeDefine = 1;
    public static final int LLVMDWARFMacinfoRecordTypeMacro = 2;
    public static final int LLVMDWARFMacinfoRecordTypeStartFile = 3;
    public static final int LLVMDWARFMacinfoRecordTypeEndFile = 4;
    public static final int LLVMDWARFMacinfoRecordTypeVendorExt = 255;

    protected LLVMDebugInfo() {
        throw new UnsupportedOperationException();
    }

    @NativeType(value="unsigned int")
    public static int LLVMDebugMetadataVersion() {
        long __functionAddress = Functions.DebugMetadataVersion;
        return JNI.invokeI(__functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetModuleDebugMetadataVersion(@NativeType(value="LLVMModuleRef") long Module2) {
        long __functionAddress = Functions.GetModuleDebugMetadataVersion;
        if (Checks.CHECKS) {
            Checks.check(Module2);
        }
        return JNI.invokePI(Module2, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMStripModuleDebugInfo(@NativeType(value="LLVMModuleRef") long Module2) {
        long __functionAddress = Functions.StripModuleDebugInfo;
        if (Checks.CHECKS) {
            Checks.check(Module2);
        }
        return JNI.invokePI(Module2, __functionAddress) != 0;
    }

    @NativeType(value="LLVMDIBuilderRef")
    public static long LLVMCreateDIBuilderDisallowUnresolved(@NativeType(value="LLVMModuleRef") long M) {
        long __functionAddress = Functions.CreateDIBuilderDisallowUnresolved;
        if (Checks.CHECKS) {
            Checks.check(M);
        }
        return JNI.invokePP(M, __functionAddress);
    }

    @NativeType(value="LLVMDIBuilderRef")
    public static long LLVMCreateDIBuilder(@NativeType(value="LLVMModuleRef") long M) {
        long __functionAddress = Functions.CreateDIBuilder;
        if (Checks.CHECKS) {
            Checks.check(M);
        }
        return JNI.invokePP(M, __functionAddress);
    }

    public static void LLVMDisposeDIBuilder(@NativeType(value="LLVMDIBuilderRef") long Builder2) {
        long __functionAddress = Functions.DisposeDIBuilder;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
        }
        JNI.invokePV(Builder2, __functionAddress);
    }

    public static void LLVMDIBuilderFinalize(@NativeType(value="LLVMDIBuilderRef") long Builder2) {
        long __functionAddress = Functions.DIBuilderFinalize;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
        }
        JNI.invokePV(Builder2, __functionAddress);
    }

    public static long nLLVMDIBuilderCreateCompileUnit(long Builder2, int Lang, long FileRef, long Producer, long ProducerLen, int isOptimized, long Flags, long FlagsLen, int RuntimeVer, long SplitName, long SplitNameLen, int Kind2, int DWOId, int SplitDebugInlining, int DebugInfoForProfiling, long SysRoot, long SysRootLen, long SDK, long SDKLen) {
        long __functionAddress = Functions.DIBuilderCreateCompileUnit;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(FileRef);
        }
        return JNI.invokePPPPPPPPPPPPP(Builder2, Lang, FileRef, Producer, ProducerLen, isOptimized, Flags, FlagsLen, RuntimeVer, SplitName, SplitNameLen, Kind2, DWOId, SplitDebugInlining, DebugInfoForProfiling, SysRoot, SysRootLen, SDK, SDKLen, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateCompileUnit(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMDWARFSourceLanguage") int Lang, @NativeType(value="LLVMMetadataRef") long FileRef, @NativeType(value="char const *") ByteBuffer Producer, @NativeType(value="LLVMBool") boolean isOptimized, @NativeType(value="char const *") ByteBuffer Flags, @NativeType(value="unsigned int") int RuntimeVer, @NativeType(value="char const *") ByteBuffer SplitName, @NativeType(value="LLVMDWARFEmissionKind") int Kind2, @NativeType(value="unsigned int") int DWOId, @NativeType(value="LLVMBool") boolean SplitDebugInlining, @NativeType(value="LLVMBool") boolean DebugInfoForProfiling, @NativeType(value="char const *") ByteBuffer SysRoot, @NativeType(value="char const *") ByteBuffer SDK) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateCompileUnit(Builder2, Lang, FileRef, MemoryUtil.memAddress(Producer), Producer.remaining(), isOptimized ? 1 : 0, MemoryUtil.memAddress(Flags), Flags.remaining(), RuntimeVer, MemoryUtil.memAddress(SplitName), SplitName.remaining(), Kind2, DWOId, SplitDebugInlining ? 1 : 0, DebugInfoForProfiling ? 1 : 0, MemoryUtil.memAddress(SysRoot), SysRoot.remaining(), MemoryUtil.memAddress(SDK), SDK.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateCompileUnit(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMDWARFSourceLanguage") int Lang, @NativeType(value="LLVMMetadataRef") long FileRef, @NativeType(value="char const *") CharSequence Producer, @NativeType(value="LLVMBool") boolean isOptimized, @NativeType(value="char const *") CharSequence Flags, @NativeType(value="unsigned int") int RuntimeVer, @NativeType(value="char const *") CharSequence SplitName, @NativeType(value="LLVMDWARFEmissionKind") int Kind2, @NativeType(value="unsigned int") int DWOId, @NativeType(value="LLVMBool") boolean SplitDebugInlining, @NativeType(value="LLVMBool") boolean DebugInfoForProfiling, @NativeType(value="char const *") CharSequence SysRoot, @NativeType(value="char const *") CharSequence SDK) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int ProducerEncodedLength = stack.nUTF8(Producer, false);
            long ProducerEncoded = stack.getPointerAddress();
            int FlagsEncodedLength = stack.nUTF8(Flags, false);
            long FlagsEncoded = stack.getPointerAddress();
            int SplitNameEncodedLength = stack.nUTF8(SplitName, false);
            long SplitNameEncoded = stack.getPointerAddress();
            int SysRootEncodedLength = stack.nUTF8(SysRoot, false);
            long SysRootEncoded = stack.getPointerAddress();
            int SDKEncodedLength = stack.nUTF8(SDK, false);
            long SDKEncoded = stack.getPointerAddress();
            long l = LLVMDebugInfo.nLLVMDIBuilderCreateCompileUnit(Builder2, Lang, FileRef, ProducerEncoded, ProducerEncodedLength, isOptimized ? 1 : 0, FlagsEncoded, FlagsEncodedLength, RuntimeVer, SplitNameEncoded, SplitNameEncodedLength, Kind2, DWOId, SplitDebugInlining ? 1 : 0, DebugInfoForProfiling ? 1 : 0, SysRootEncoded, SysRootEncodedLength, SDKEncoded, SDKEncodedLength);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMDIBuilderCreateFile(long Builder2, long Filename, long FilenameLen, long Directory, long DirectoryLen) {
        long __functionAddress = Functions.DIBuilderCreateFile;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
        }
        return JNI.invokePPPPPP(Builder2, Filename, FilenameLen, Directory, DirectoryLen, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateFile(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="char const *") ByteBuffer Filename, @NativeType(value="char const *") ByteBuffer Directory) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateFile(Builder2, MemoryUtil.memAddress(Filename), Filename.remaining(), MemoryUtil.memAddress(Directory), Directory.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateFile(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="char const *") CharSequence Filename, @NativeType(value="char const *") CharSequence Directory) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int FilenameEncodedLength = stack.nUTF8(Filename, false);
            long FilenameEncoded = stack.getPointerAddress();
            int DirectoryEncodedLength = stack.nUTF8(Directory, false);
            long DirectoryEncoded = stack.getPointerAddress();
            long l = LLVMDebugInfo.nLLVMDIBuilderCreateFile(Builder2, FilenameEncoded, FilenameEncodedLength, DirectoryEncoded, DirectoryEncodedLength);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMDIBuilderCreateModule(long Builder2, long ParentScope, long Name2, long NameLen, long ConfigMacros, long ConfigMacrosLen, long IncludePath, long IncludePathLen, long APINotesFile, long APINotesFileLen) {
        long __functionAddress = Functions.DIBuilderCreateModule;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(ParentScope);
        }
        return JNI.invokePPPPPPPPPPP(Builder2, ParentScope, Name2, NameLen, ConfigMacros, ConfigMacrosLen, IncludePath, IncludePathLen, APINotesFile, APINotesFileLen, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateModule(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMMetadataRef") long ParentScope, @NativeType(value="char const *") ByteBuffer Name2, @NativeType(value="char const *") ByteBuffer ConfigMacros, @NativeType(value="char const *") ByteBuffer IncludePath, @NativeType(value="char const *") ByteBuffer APINotesFile) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateModule(Builder2, ParentScope, MemoryUtil.memAddress(Name2), Name2.remaining(), MemoryUtil.memAddress(ConfigMacros), ConfigMacros.remaining(), MemoryUtil.memAddress(IncludePath), IncludePath.remaining(), MemoryUtil.memAddress(APINotesFile), APINotesFile.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateModule(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMMetadataRef") long ParentScope, @NativeType(value="char const *") CharSequence Name2, @NativeType(value="char const *") CharSequence ConfigMacros, @NativeType(value="char const *") CharSequence IncludePath, @NativeType(value="char const *") CharSequence APINotesFile) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name2, false);
            long NameEncoded = stack.getPointerAddress();
            int ConfigMacrosEncodedLength = stack.nUTF8(ConfigMacros, false);
            long ConfigMacrosEncoded = stack.getPointerAddress();
            int IncludePathEncodedLength = stack.nUTF8(IncludePath, false);
            long IncludePathEncoded = stack.getPointerAddress();
            int APINotesFileEncodedLength = stack.nUTF8(APINotesFile, false);
            long APINotesFileEncoded = stack.getPointerAddress();
            long l = LLVMDebugInfo.nLLVMDIBuilderCreateModule(Builder2, ParentScope, NameEncoded, NameEncodedLength, ConfigMacrosEncoded, ConfigMacrosEncodedLength, IncludePathEncoded, IncludePathEncodedLength, APINotesFileEncoded, APINotesFileEncodedLength);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMDIBuilderCreateNameSpace(long Builder2, long ParentScope, long Name2, long NameLen, int ExportSymbols) {
        long __functionAddress = Functions.DIBuilderCreateNameSpace;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(ParentScope);
        }
        return JNI.invokePPPPP(Builder2, ParentScope, Name2, NameLen, ExportSymbols, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateNameSpace(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMMetadataRef") long ParentScope, @NativeType(value="char const *") ByteBuffer Name2, @NativeType(value="LLVMBool") boolean ExportSymbols) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateNameSpace(Builder2, ParentScope, MemoryUtil.memAddress(Name2), Name2.remaining(), ExportSymbols ? 1 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateNameSpace(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMMetadataRef") long ParentScope, @NativeType(value="char const *") CharSequence Name2, @NativeType(value="LLVMBool") boolean ExportSymbols) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name2, false);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMDebugInfo.nLLVMDIBuilderCreateNameSpace(Builder2, ParentScope, NameEncoded, NameEncodedLength, ExportSymbols ? 1 : 0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMDIBuilderCreateFunction(long Builder2, long Scope, long Name2, long NameLen, long LinkageName, long LinkageNameLen, long File2, int LineNo, long Ty, int IsLocalToUnit, int IsDefinition, int ScopeLine, int Flags, int IsOptimized) {
        long __functionAddress = Functions.DIBuilderCreateFunction;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Scope);
            Checks.check(File2);
            Checks.check(Ty);
        }
        return JNI.invokePPPPPPPPP(Builder2, Scope, Name2, NameLen, LinkageName, LinkageNameLen, File2, LineNo, Ty, IsLocalToUnit, IsDefinition, ScopeLine, Flags, IsOptimized, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateFunction(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="char const *") ByteBuffer Name2, @NativeType(value="char const *") ByteBuffer LinkageName, @NativeType(value="LLVMMetadataRef") long File2, @NativeType(value="unsigned int") int LineNo, @NativeType(value="LLVMMetadataRef") long Ty, @NativeType(value="LLVMBool") boolean IsLocalToUnit, @NativeType(value="LLVMBool") boolean IsDefinition, @NativeType(value="unsigned int") int ScopeLine, @NativeType(value="LLVMDIFlags") int Flags, @NativeType(value="LLVMBool") boolean IsOptimized) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateFunction(Builder2, Scope, MemoryUtil.memAddress(Name2), Name2.remaining(), MemoryUtil.memAddress(LinkageName), LinkageName.remaining(), File2, LineNo, Ty, IsLocalToUnit ? 1 : 0, IsDefinition ? 1 : 0, ScopeLine, Flags, IsOptimized ? 1 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateFunction(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="char const *") CharSequence Name2, @NativeType(value="char const *") CharSequence LinkageName, @NativeType(value="LLVMMetadataRef") long File2, @NativeType(value="unsigned int") int LineNo, @NativeType(value="LLVMMetadataRef") long Ty, @NativeType(value="LLVMBool") boolean IsLocalToUnit, @NativeType(value="LLVMBool") boolean IsDefinition, @NativeType(value="unsigned int") int ScopeLine, @NativeType(value="LLVMDIFlags") int Flags, @NativeType(value="LLVMBool") boolean IsOptimized) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name2, false);
            long NameEncoded = stack.getPointerAddress();
            int LinkageNameEncodedLength = stack.nUTF8(LinkageName, false);
            long LinkageNameEncoded = stack.getPointerAddress();
            long l = LLVMDebugInfo.nLLVMDIBuilderCreateFunction(Builder2, Scope, NameEncoded, NameEncodedLength, LinkageNameEncoded, LinkageNameEncodedLength, File2, LineNo, Ty, IsLocalToUnit ? 1 : 0, IsDefinition ? 1 : 0, ScopeLine, Flags, IsOptimized ? 1 : 0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateLexicalBlock(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="LLVMMetadataRef") long File2, @NativeType(value="unsigned int") int Line, @NativeType(value="unsigned int") int Column) {
        long __functionAddress = Functions.DIBuilderCreateLexicalBlock;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Scope);
            Checks.check(File2);
        }
        return JNI.invokePPPP(Builder2, Scope, File2, Line, Column, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateLexicalBlockFile(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="LLVMMetadataRef") long File2, @NativeType(value="unsigned int") int Discriminator) {
        long __functionAddress = Functions.DIBuilderCreateLexicalBlockFile;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Scope);
            Checks.check(File2);
        }
        return JNI.invokePPPP(Builder2, Scope, File2, Discriminator, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateImportedModuleFromNamespace(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="LLVMMetadataRef") long NS, @NativeType(value="LLVMMetadataRef") long File2, @NativeType(value="unsigned int") int Line) {
        long __functionAddress = Functions.DIBuilderCreateImportedModuleFromNamespace;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Scope);
            Checks.check(NS);
            Checks.check(File2);
        }
        return JNI.invokePPPPP(Builder2, Scope, NS, File2, Line, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateImportedModuleFromAlias(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="LLVMMetadataRef") long ImportedEntity, @NativeType(value="LLVMMetadataRef") long File2, @NativeType(value="unsigned int") int Line) {
        long __functionAddress = Functions.DIBuilderCreateImportedModuleFromAlias;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Scope);
            Checks.check(ImportedEntity);
            Checks.check(File2);
        }
        return JNI.invokePPPPP(Builder2, Scope, ImportedEntity, File2, Line, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateImportedModuleFromModule(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="LLVMMetadataRef") long M, @NativeType(value="LLVMMetadataRef") long File2, @NativeType(value="unsigned int") int Line) {
        long __functionAddress = Functions.DIBuilderCreateImportedModuleFromModule;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Scope);
            Checks.check(M);
            Checks.check(File2);
        }
        return JNI.invokePPPPP(Builder2, Scope, M, File2, Line, __functionAddress);
    }

    public static long nLLVMDIBuilderCreateImportedDeclaration(long Builder2, long Scope, long Decl, long File2, int Line, long Name2, long NameLen) {
        long __functionAddress = Functions.DIBuilderCreateImportedDeclaration;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Scope);
            Checks.check(Decl);
            Checks.check(File2);
        }
        return JNI.invokePPPPPPP(Builder2, Scope, Decl, File2, Line, Name2, NameLen, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateImportedDeclaration(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="LLVMMetadataRef") long Decl, @NativeType(value="LLVMMetadataRef") long File2, @NativeType(value="unsigned int") int Line, @NativeType(value="char const *") ByteBuffer Name2) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateImportedDeclaration(Builder2, Scope, Decl, File2, Line, MemoryUtil.memAddress(Name2), Name2.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateImportedDeclaration(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="LLVMMetadataRef") long Decl, @NativeType(value="LLVMMetadataRef") long File2, @NativeType(value="unsigned int") int Line, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name2, false);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMDebugInfo.nLLVMDIBuilderCreateImportedDeclaration(Builder2, Scope, Decl, File2, Line, NameEncoded, NameEncodedLength);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateDebugLocation(@NativeType(value="LLVMContextRef") long Ctx, @NativeType(value="unsigned int") int Line, @NativeType(value="unsigned int") int Column, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="LLVMMetadataRef") long InlinedAt) {
        long __functionAddress = Functions.DIBuilderCreateDebugLocation;
        if (Checks.CHECKS) {
            Checks.check(Ctx);
            Checks.check(Scope);
            Checks.check(InlinedAt);
        }
        return JNI.invokePPPP(Ctx, Line, Column, Scope, InlinedAt, __functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMDILocationGetLine(@NativeType(value="LLVMMetadataRef") long Location2) {
        long __functionAddress = Functions.DILocationGetLine;
        if (Checks.CHECKS) {
            Checks.check(Location2);
        }
        return JNI.invokePI(Location2, __functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMDILocationGetColumn(@NativeType(value="LLVMMetadataRef") long Location2) {
        long __functionAddress = Functions.DILocationGetColumn;
        if (Checks.CHECKS) {
            Checks.check(Location2);
        }
        return JNI.invokePI(Location2, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDILocationGetScope(@NativeType(value="LLVMMetadataRef") long Location2) {
        long __functionAddress = Functions.DILocationGetScope;
        if (Checks.CHECKS) {
            Checks.check(Location2);
        }
        return JNI.invokePP(Location2, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDILocationGetInlinedAt(@NativeType(value="LLVMMetadataRef") long Location2) {
        long __functionAddress = Functions.DILocationGetInlinedAt;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Location2);
        }
        return JNI.invokePP(Location2, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIScopeGetFile(@NativeType(value="LLVMMetadataRef") long Scope) {
        long __functionAddress = Functions.DIScopeGetFile;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Scope);
        }
        return JNI.invokePP(Scope, __functionAddress);
    }

    public static long nLLVMDIFileGetDirectory(long File2, long Len) {
        long __functionAddress = Functions.DIFileGetDirectory;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(File2);
        }
        return JNI.invokePPP(File2, Len, __functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="char const *")
    public static String LLVMDIFileGetDirectory(@NativeType(value="LLVMMetadataRef") long File2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer Len = stack.callocInt(1);
            long __result = LLVMDebugInfo.nLLVMDIFileGetDirectory(File2, MemoryUtil.memAddress(Len));
            String string = MemoryUtil.memUTF8Safe(__result, Len.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMDIFileGetFilename(long File2, long Len) {
        long __functionAddress = Functions.DIFileGetFilename;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(File2);
        }
        return JNI.invokePPP(File2, Len, __functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="char const *")
    public static String LLVMDIFileGetFilename(@NativeType(value="LLVMMetadataRef") long File2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer Len = stack.callocInt(1);
            long __result = LLVMDebugInfo.nLLVMDIFileGetFilename(File2, MemoryUtil.memAddress(Len));
            String string = MemoryUtil.memUTF8Safe(__result, Len.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMDIFileGetSource(long File2, long Len) {
        long __functionAddress = Functions.DIFileGetSource;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(File2);
        }
        return JNI.invokePPP(File2, Len, __functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="char const *")
    public static String LLVMDIFileGetSource(@NativeType(value="LLVMMetadataRef") long File2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer Len = stack.callocInt(1);
            long __result = LLVMDebugInfo.nLLVMDIFileGetSource(File2, MemoryUtil.memAddress(Len));
            String string = MemoryUtil.memUTF8Safe(__result, Len.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMDIBuilderGetOrCreateTypeArray(long Builder2, long Data, long NumElements) {
        long __functionAddress = Functions.DIBuilderGetOrCreateTypeArray;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
        }
        return JNI.invokePPPP(Builder2, Data, NumElements, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderGetOrCreateTypeArray(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMMetadataRef *") PointerBuffer Data) {
        return LLVMDebugInfo.nLLVMDIBuilderGetOrCreateTypeArray(Builder2, MemoryUtil.memAddress(Data), Data.remaining());
    }

    public static long nLLVMDIBuilderCreateSubroutineType(long Builder2, long File2, long ParameterTypes, int NumParameterTypes, int Flags) {
        long __functionAddress = Functions.DIBuilderCreateSubroutineType;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(File2);
        }
        return JNI.invokePPPP(Builder2, File2, ParameterTypes, NumParameterTypes, Flags, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateSubroutineType(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMMetadataRef") long File2, @NativeType(value="LLVMMetadataRef *") PointerBuffer ParameterTypes, @NativeType(value="LLVMDIFlags") int Flags) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateSubroutineType(Builder2, File2, MemoryUtil.memAddress(ParameterTypes), ParameterTypes.remaining(), Flags);
    }

    public static long nLLVMDIBuilderCreateMacro(long Builder2, long ParentMacroFile, int Line, int RecordType, long Name2, long NameLen, long Value, long ValueLen) {
        long __functionAddress = Functions.DIBuilderCreateMacro;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Builder2);
        }
        return JNI.invokePPPPPPP(Builder2, ParentMacroFile, Line, RecordType, Name2, NameLen, Value, ValueLen, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateMacro(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMMetadataRef") long ParentMacroFile, @NativeType(value="unsigned") int Line, @NativeType(value="LLVMDWARFMacinfoRecordType") int RecordType, @NativeType(value="char const *") ByteBuffer Name2, @NativeType(value="char const *") ByteBuffer Value) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateMacro(Builder2, ParentMacroFile, Line, RecordType, MemoryUtil.memAddress(Name2), Name2.remaining(), MemoryUtil.memAddress(Value), Value.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateMacro(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMMetadataRef") long ParentMacroFile, @NativeType(value="unsigned") int Line, @NativeType(value="LLVMDWARFMacinfoRecordType") int RecordType, @NativeType(value="char const *") CharSequence Name2, @NativeType(value="char const *") CharSequence Value) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name2, false);
            long NameEncoded = stack.getPointerAddress();
            int ValueEncodedLength = stack.nUTF8(Value, false);
            long ValueEncoded = stack.getPointerAddress();
            long l = LLVMDebugInfo.nLLVMDIBuilderCreateMacro(Builder2, ParentMacroFile, Line, RecordType, NameEncoded, NameEncodedLength, ValueEncoded, ValueEncodedLength);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateTempMacroFile(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMMetadataRef") long ParentMacroFile, @NativeType(value="unsigned") int Line, @NativeType(value="LLVMMetadataRef") long File2) {
        long __functionAddress = Functions.DIBuilderCreateTempMacroFile;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Builder2);
            Checks.check(ParentMacroFile);
            Checks.check(File2);
        }
        return JNI.invokePPPP(Builder2, ParentMacroFile, Line, File2, __functionAddress);
    }

    public static long nLLVMDIBuilderCreateEnumerator(long Builder2, long Name2, long NameLen, long Value, int IsUnsigned) {
        long __functionAddress = Functions.DIBuilderCreateEnumerator;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Builder2);
        }
        return JNI.invokePPPJP(Builder2, Name2, NameLen, Value, IsUnsigned, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateEnumerator(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="char const *") ByteBuffer Name2, @NativeType(value="int64_t") long Value, @NativeType(value="LLVMBool") boolean IsUnsigned) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateEnumerator(Builder2, MemoryUtil.memAddress(Name2), Name2.remaining(), Value, IsUnsigned ? 1 : 0);
    }

    public static long nLLVMDIBuilderCreateEnumerationType(long Builder2, long Scope, long Name2, long NameLen, long File2, int LineNumber, long SizeInBits, int AlignInBits, long Elements, int NumElements, long ClassTy) {
        long __functionAddress = Functions.DIBuilderCreateEnumerationType;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Scope);
            Checks.check(File2);
            Checks.check(ClassTy);
        }
        return JNI.invokePPPPPJPPP(Builder2, Scope, Name2, NameLen, File2, LineNumber, SizeInBits, AlignInBits, Elements, NumElements, ClassTy, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateEnumerationType(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="char const *") ByteBuffer Name2, @NativeType(value="LLVMMetadataRef") long File2, @NativeType(value="unsigned int") int LineNumber, @NativeType(value="uint64_t") long SizeInBits, @NativeType(value="uint32_t") int AlignInBits, @NativeType(value="LLVMMetadataRef *") PointerBuffer Elements, @NativeType(value="LLVMMetadataRef") long ClassTy) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateEnumerationType(Builder2, Scope, MemoryUtil.memAddress(Name2), Name2.remaining(), File2, LineNumber, SizeInBits, AlignInBits, MemoryUtil.memAddress(Elements), Elements.remaining(), ClassTy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateEnumerationType(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="char const *") CharSequence Name2, @NativeType(value="LLVMMetadataRef") long File2, @NativeType(value="unsigned int") int LineNumber, @NativeType(value="uint64_t") long SizeInBits, @NativeType(value="uint32_t") int AlignInBits, @NativeType(value="LLVMMetadataRef *") PointerBuffer Elements, @NativeType(value="LLVMMetadataRef") long ClassTy) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name2, false);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMDebugInfo.nLLVMDIBuilderCreateEnumerationType(Builder2, Scope, NameEncoded, NameEncodedLength, File2, LineNumber, SizeInBits, AlignInBits, MemoryUtil.memAddress(Elements), Elements.remaining(), ClassTy);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMDIBuilderCreateUnionType(long Builder2, long Scope, long Name2, long NameLen, long File2, int LineNumber, long SizeInBits, int AlignInBits, int Flags, long Elements, int NumElements, int RunTimeLang, long UniqueId, long UniqueIdLen) {
        long __functionAddress = Functions.DIBuilderCreateUnionType;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Scope);
            Checks.check(File2);
        }
        return JNI.invokePPPPPJPPPP(Builder2, Scope, Name2, NameLen, File2, LineNumber, SizeInBits, AlignInBits, Flags, Elements, NumElements, RunTimeLang, UniqueId, UniqueIdLen, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateUnionType(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="char const *") ByteBuffer Name2, @NativeType(value="LLVMMetadataRef") long File2, @NativeType(value="unsigned int") int LineNumber, @NativeType(value="uint64_t") long SizeInBits, @NativeType(value="uint32_t") int AlignInBits, @NativeType(value="LLVMDIFlags") int Flags, @NativeType(value="LLVMMetadataRef *") PointerBuffer Elements, @NativeType(value="unsigned int") int RunTimeLang, @NativeType(value="char const *") ByteBuffer UniqueId) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateUnionType(Builder2, Scope, MemoryUtil.memAddress(Name2), Name2.remaining(), File2, LineNumber, SizeInBits, AlignInBits, Flags, MemoryUtil.memAddress(Elements), Elements.remaining(), RunTimeLang, MemoryUtil.memAddress(UniqueId), UniqueId.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateUnionType(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="char const *") CharSequence Name2, @NativeType(value="LLVMMetadataRef") long File2, @NativeType(value="unsigned int") int LineNumber, @NativeType(value="uint64_t") long SizeInBits, @NativeType(value="uint32_t") int AlignInBits, @NativeType(value="LLVMDIFlags") int Flags, @NativeType(value="LLVMMetadataRef *") PointerBuffer Elements, @NativeType(value="unsigned int") int RunTimeLang, @NativeType(value="char const *") CharSequence UniqueId) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name2, false);
            long NameEncoded = stack.getPointerAddress();
            int UniqueIdEncodedLength = stack.nUTF8(UniqueId, false);
            long UniqueIdEncoded = stack.getPointerAddress();
            long l = LLVMDebugInfo.nLLVMDIBuilderCreateUnionType(Builder2, Scope, NameEncoded, NameEncodedLength, File2, LineNumber, SizeInBits, AlignInBits, Flags, MemoryUtil.memAddress(Elements), Elements.remaining(), RunTimeLang, UniqueIdEncoded, UniqueIdEncodedLength);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMDIBuilderCreateArrayType(long Builder2, long Size, int AlignInBits, long Ty, long Subscripts, int NumSubscripts) {
        long __functionAddress = Functions.DIBuilderCreateArrayType;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Ty);
        }
        return JNI.invokePJPPP(Builder2, Size, AlignInBits, Ty, Subscripts, NumSubscripts, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateArrayType(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="uint64_t") long Size, @NativeType(value="uint32_t") int AlignInBits, @NativeType(value="LLVMMetadataRef") long Ty, @NativeType(value="LLVMMetadataRef *") PointerBuffer Subscripts) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateArrayType(Builder2, Size, AlignInBits, Ty, MemoryUtil.memAddress(Subscripts), Subscripts.remaining());
    }

    public static long nLLVMDIBuilderCreateVectorType(long Builder2, long Size, int AlignInBits, long Ty, long Subscripts, int NumSubscripts) {
        long __functionAddress = Functions.DIBuilderCreateVectorType;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Ty);
        }
        return JNI.invokePJPPP(Builder2, Size, AlignInBits, Ty, Subscripts, NumSubscripts, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateVectorType(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="uint64_t") long Size, @NativeType(value="uint32_t") int AlignInBits, @NativeType(value="LLVMMetadataRef") long Ty, @NativeType(value="LLVMMetadataRef *") PointerBuffer Subscripts) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateVectorType(Builder2, Size, AlignInBits, Ty, MemoryUtil.memAddress(Subscripts), Subscripts.remaining());
    }

    public static long nLLVMDIBuilderCreateUnspecifiedType(long Builder2, long Name2, long NameLen) {
        long __functionAddress = Functions.DIBuilderCreateUnspecifiedType;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
        }
        return JNI.invokePPPP(Builder2, Name2, NameLen, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateUnspecifiedType(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="char const *") ByteBuffer Name2) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateUnspecifiedType(Builder2, MemoryUtil.memAddress(Name2), Name2.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateUnspecifiedType(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name2, false);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMDebugInfo.nLLVMDIBuilderCreateUnspecifiedType(Builder2, NameEncoded, NameEncodedLength);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMDIBuilderCreateBasicType(long Builder2, long Name2, long NameLen, long SizeInBits, int Encoding, int Flags) {
        long __functionAddress = Functions.DIBuilderCreateBasicType;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
        }
        return JNI.invokePPPJP(Builder2, Name2, NameLen, SizeInBits, Encoding, Flags, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateBasicType(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="char const *") ByteBuffer Name2, @NativeType(value="uint64_t") long SizeInBits, @NativeType(value="LLVMDWARFTypeEncoding") int Encoding, @NativeType(value="LLVMDIFlags") int Flags) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateBasicType(Builder2, MemoryUtil.memAddress(Name2), Name2.remaining(), SizeInBits, Encoding, Flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateBasicType(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="char const *") CharSequence Name2, @NativeType(value="uint64_t") long SizeInBits, @NativeType(value="LLVMDWARFTypeEncoding") int Encoding, @NativeType(value="LLVMDIFlags") int Flags) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name2, false);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMDebugInfo.nLLVMDIBuilderCreateBasicType(Builder2, NameEncoded, NameEncodedLength, SizeInBits, Encoding, Flags);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMDIBuilderCreatePointerType(long Builder2, long PointeeTy, long SizeInBits, int AlignInBits, int AddressSpace, long Name2, long NameLen) {
        long __functionAddress = Functions.DIBuilderCreatePointerType;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(PointeeTy);
        }
        return JNI.invokePPJPPP(Builder2, PointeeTy, SizeInBits, AlignInBits, AddressSpace, Name2, NameLen, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreatePointerType(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMMetadataRef") long PointeeTy, @NativeType(value="uint64_t") long SizeInBits, @NativeType(value="uint32_t") int AlignInBits, @NativeType(value="unsigned int") int AddressSpace, @NativeType(value="char const *") ByteBuffer Name2) {
        return LLVMDebugInfo.nLLVMDIBuilderCreatePointerType(Builder2, PointeeTy, SizeInBits, AlignInBits, AddressSpace, MemoryUtil.memAddress(Name2), Name2.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreatePointerType(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMMetadataRef") long PointeeTy, @NativeType(value="uint64_t") long SizeInBits, @NativeType(value="uint32_t") int AlignInBits, @NativeType(value="unsigned int") int AddressSpace, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name2, false);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMDebugInfo.nLLVMDIBuilderCreatePointerType(Builder2, PointeeTy, SizeInBits, AlignInBits, AddressSpace, NameEncoded, NameEncodedLength);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMDIBuilderCreateStructType(long Builder2, long Scope, long Name2, long NameLen, long File2, int LineNumber, long SizeInBits, int AlignInBits, int Flags, long DerivedFrom, long Elements, int NumElements, int RunTimeLang, long VTableHolder, long UniqueId, long UniqueIdLen) {
        long __functionAddress = Functions.DIBuilderCreateStructType;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Scope);
            Checks.check(File2);
            Checks.check(DerivedFrom);
            Checks.check(VTableHolder);
        }
        return JNI.invokePPPPPJPPPPPP(Builder2, Scope, Name2, NameLen, File2, LineNumber, SizeInBits, AlignInBits, Flags, DerivedFrom, Elements, NumElements, RunTimeLang, VTableHolder, UniqueId, UniqueIdLen, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateStructType(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="char const *") ByteBuffer Name2, @NativeType(value="LLVMMetadataRef") long File2, @NativeType(value="unsigned int") int LineNumber, @NativeType(value="uint64_t") long SizeInBits, @NativeType(value="uint32_t") int AlignInBits, @NativeType(value="LLVMDIFlags") int Flags, @NativeType(value="LLVMMetadataRef") long DerivedFrom, @NativeType(value="LLVMMetadataRef *") PointerBuffer Elements, @NativeType(value="unsigned int") int RunTimeLang, @NativeType(value="LLVMMetadataRef") long VTableHolder, @NativeType(value="char const *") ByteBuffer UniqueId) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateStructType(Builder2, Scope, MemoryUtil.memAddress(Name2), Name2.remaining(), File2, LineNumber, SizeInBits, AlignInBits, Flags, DerivedFrom, MemoryUtil.memAddress(Elements), Elements.remaining(), RunTimeLang, VTableHolder, MemoryUtil.memAddress(UniqueId), UniqueId.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateStructType(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="char const *") CharSequence Name2, @NativeType(value="LLVMMetadataRef") long File2, @NativeType(value="unsigned int") int LineNumber, @NativeType(value="uint64_t") long SizeInBits, @NativeType(value="uint32_t") int AlignInBits, @NativeType(value="LLVMDIFlags") int Flags, @NativeType(value="LLVMMetadataRef") long DerivedFrom, @NativeType(value="LLVMMetadataRef *") PointerBuffer Elements, @NativeType(value="unsigned int") int RunTimeLang, @NativeType(value="LLVMMetadataRef") long VTableHolder, @NativeType(value="char const *") CharSequence UniqueId) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name2, false);
            long NameEncoded = stack.getPointerAddress();
            int UniqueIdEncodedLength = stack.nUTF8(UniqueId, false);
            long UniqueIdEncoded = stack.getPointerAddress();
            long l = LLVMDebugInfo.nLLVMDIBuilderCreateStructType(Builder2, Scope, NameEncoded, NameEncodedLength, File2, LineNumber, SizeInBits, AlignInBits, Flags, DerivedFrom, MemoryUtil.memAddress(Elements), Elements.remaining(), RunTimeLang, VTableHolder, UniqueIdEncoded, UniqueIdEncodedLength);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMDIBuilderCreateMemberType(long Builder2, long Scope, long Name2, long NameLen, long File2, int LineNo, long SizeInBits, int AlignInBits, long OffsetInBits, int Flags, long Ty) {
        long __functionAddress = Functions.DIBuilderCreateMemberType;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Scope);
            Checks.check(File2);
            Checks.check(Ty);
        }
        return JNI.invokePPPPPJJPP(Builder2, Scope, Name2, NameLen, File2, LineNo, SizeInBits, AlignInBits, OffsetInBits, Flags, Ty, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateMemberType(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="char const *") ByteBuffer Name2, @NativeType(value="LLVMMetadataRef") long File2, @NativeType(value="unsigned int") int LineNo, @NativeType(value="uint64_t") long SizeInBits, @NativeType(value="uint32_t") int AlignInBits, @NativeType(value="uint64_t") long OffsetInBits, @NativeType(value="LLVMDIFlags") int Flags, @NativeType(value="LLVMMetadataRef") long Ty) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateMemberType(Builder2, Scope, MemoryUtil.memAddress(Name2), Name2.remaining(), File2, LineNo, SizeInBits, AlignInBits, OffsetInBits, Flags, Ty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateMemberType(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="char const *") CharSequence Name2, @NativeType(value="LLVMMetadataRef") long File2, @NativeType(value="unsigned int") int LineNo, @NativeType(value="uint64_t") long SizeInBits, @NativeType(value="uint32_t") int AlignInBits, @NativeType(value="uint64_t") long OffsetInBits, @NativeType(value="LLVMDIFlags") int Flags, @NativeType(value="LLVMMetadataRef") long Ty) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name2, false);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMDebugInfo.nLLVMDIBuilderCreateMemberType(Builder2, Scope, NameEncoded, NameEncodedLength, File2, LineNo, SizeInBits, AlignInBits, OffsetInBits, Flags, Ty);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMDIBuilderCreateStaticMemberType(long Builder2, long Scope, long Name2, long NameLen, long File2, int LineNumber, long Type2, int Flags, long ConstantVal, int AlignInBits) {
        long __functionAddress = Functions.DIBuilderCreateStaticMemberType;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Scope);
            Checks.check(File2);
            Checks.check(Type2);
            Checks.check(ConstantVal);
        }
        return JNI.invokePPPPPPPP(Builder2, Scope, Name2, NameLen, File2, LineNumber, Type2, Flags, ConstantVal, AlignInBits, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateStaticMemberType(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="char const *") ByteBuffer Name2, @NativeType(value="LLVMMetadataRef") long File2, @NativeType(value="unsigned int") int LineNumber, @NativeType(value="LLVMMetadataRef") long Type2, @NativeType(value="LLVMDIFlags") int Flags, @NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="uint32_t") int AlignInBits) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateStaticMemberType(Builder2, Scope, MemoryUtil.memAddress(Name2), Name2.remaining(), File2, LineNumber, Type2, Flags, ConstantVal, AlignInBits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateStaticMemberType(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="char const *") CharSequence Name2, @NativeType(value="LLVMMetadataRef") long File2, @NativeType(value="unsigned int") int LineNumber, @NativeType(value="LLVMMetadataRef") long Type2, @NativeType(value="LLVMDIFlags") int Flags, @NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="uint32_t") int AlignInBits) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name2, false);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMDebugInfo.nLLVMDIBuilderCreateStaticMemberType(Builder2, Scope, NameEncoded, NameEncodedLength, File2, LineNumber, Type2, Flags, ConstantVal, AlignInBits);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateMemberPointerType(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMMetadataRef") long PointeeType, @NativeType(value="LLVMMetadataRef") long ClassType, @NativeType(value="uint64_t") long SizeInBits, @NativeType(value="uint32_t") int AlignInBits, @NativeType(value="LLVMDIFlags") int Flags) {
        long __functionAddress = Functions.DIBuilderCreateMemberPointerType;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(PointeeType);
            Checks.check(ClassType);
        }
        return JNI.invokePPPJP(Builder2, PointeeType, ClassType, SizeInBits, AlignInBits, Flags, __functionAddress);
    }

    public static long nLLVMDIBuilderCreateObjCIVar(long Builder2, long Name2, long NameLen, long File2, int LineNo, long SizeInBits, int AlignInBits, long OffsetInBits, int Flags, long Ty, long PropertyNode) {
        long __functionAddress = Functions.DIBuilderCreateObjCIVar;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(File2);
            Checks.check(Ty);
            Checks.check(PropertyNode);
        }
        return JNI.invokePPPPJJPPP(Builder2, Name2, NameLen, File2, LineNo, SizeInBits, AlignInBits, OffsetInBits, Flags, Ty, PropertyNode, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateObjCIVar(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="char const *") ByteBuffer Name2, @NativeType(value="LLVMMetadataRef") long File2, @NativeType(value="unsigned int") int LineNo, @NativeType(value="uint64_t") long SizeInBits, @NativeType(value="uint32_t") int AlignInBits, @NativeType(value="uint64_t") long OffsetInBits, @NativeType(value="LLVMDIFlags") int Flags, @NativeType(value="LLVMMetadataRef") long Ty, @NativeType(value="LLVMMetadataRef") long PropertyNode) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateObjCIVar(Builder2, MemoryUtil.memAddress(Name2), Name2.remaining(), File2, LineNo, SizeInBits, AlignInBits, OffsetInBits, Flags, Ty, PropertyNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateObjCIVar(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="char const *") CharSequence Name2, @NativeType(value="LLVMMetadataRef") long File2, @NativeType(value="unsigned int") int LineNo, @NativeType(value="uint64_t") long SizeInBits, @NativeType(value="uint32_t") int AlignInBits, @NativeType(value="uint64_t") long OffsetInBits, @NativeType(value="LLVMDIFlags") int Flags, @NativeType(value="LLVMMetadataRef") long Ty, @NativeType(value="LLVMMetadataRef") long PropertyNode) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name2, false);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMDebugInfo.nLLVMDIBuilderCreateObjCIVar(Builder2, NameEncoded, NameEncodedLength, File2, LineNo, SizeInBits, AlignInBits, OffsetInBits, Flags, Ty, PropertyNode);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMDIBuilderCreateObjCProperty(long Builder2, long Name2, long NameLen, long File2, int LineNo, long GetterName, long GetterNameLen, long SetterName, long SetterNameLen, int PropertyAttributes, long Ty) {
        long __functionAddress = Functions.DIBuilderCreateObjCProperty;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(File2);
            Checks.check(Ty);
        }
        return JNI.invokePPPPPPPPPP(Builder2, Name2, NameLen, File2, LineNo, GetterName, GetterNameLen, SetterName, SetterNameLen, PropertyAttributes, Ty, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateObjCProperty(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="char const *") ByteBuffer Name2, @NativeType(value="LLVMMetadataRef") long File2, @NativeType(value="unsigned int") int LineNo, @NativeType(value="char const *") ByteBuffer GetterName, @NativeType(value="char const *") ByteBuffer SetterName, @NativeType(value="unsigned int") int PropertyAttributes, @NativeType(value="LLVMMetadataRef") long Ty) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateObjCProperty(Builder2, MemoryUtil.memAddress(Name2), Name2.remaining(), File2, LineNo, MemoryUtil.memAddress(GetterName), GetterName.remaining(), MemoryUtil.memAddress(SetterName), SetterName.remaining(), PropertyAttributes, Ty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateObjCProperty(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="char const *") CharSequence Name2, @NativeType(value="LLVMMetadataRef") long File2, @NativeType(value="unsigned int") int LineNo, @NativeType(value="char const *") CharSequence GetterName, @NativeType(value="char const *") CharSequence SetterName, @NativeType(value="unsigned int") int PropertyAttributes, @NativeType(value="LLVMMetadataRef") long Ty) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name2, false);
            long NameEncoded = stack.getPointerAddress();
            int GetterNameEncodedLength = stack.nUTF8(GetterName, false);
            long GetterNameEncoded = stack.getPointerAddress();
            int SetterNameEncodedLength = stack.nUTF8(SetterName, false);
            long SetterNameEncoded = stack.getPointerAddress();
            long l = LLVMDebugInfo.nLLVMDIBuilderCreateObjCProperty(Builder2, NameEncoded, NameEncodedLength, File2, LineNo, GetterNameEncoded, GetterNameEncodedLength, SetterNameEncoded, SetterNameEncodedLength, PropertyAttributes, Ty);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateObjectPointerType(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMMetadataRef") long Type2) {
        long __functionAddress = Functions.DIBuilderCreateObjectPointerType;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Type2);
        }
        return JNI.invokePPP(Builder2, Type2, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateQualifiedType(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="unsigned int") int Tag, @NativeType(value="LLVMMetadataRef") long Type2) {
        long __functionAddress = Functions.DIBuilderCreateQualifiedType;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Type2);
        }
        return JNI.invokePPP(Builder2, Tag, Type2, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateReferenceType(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="unsigned int") int Tag, @NativeType(value="LLVMMetadataRef") long Type2) {
        long __functionAddress = Functions.DIBuilderCreateReferenceType;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Type2);
        }
        return JNI.invokePPP(Builder2, Tag, Type2, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateNullPtrType(@NativeType(value="LLVMDIBuilderRef") long Builder2) {
        long __functionAddress = Functions.DIBuilderCreateNullPtrType;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
        }
        return JNI.invokePP(Builder2, __functionAddress);
    }

    public static long nLLVMDIBuilderCreateTypedef(long Builder2, long Type2, long Name2, long NameLen, long File2, int LineNo, long Scope, int AlignInBits) {
        long __functionAddress = Functions.DIBuilderCreateTypedef;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Type2);
            Checks.check(File2);
            Checks.check(Scope);
        }
        return JNI.invokePPPPPPP(Builder2, Type2, Name2, NameLen, File2, LineNo, Scope, AlignInBits, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateTypedef(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMMetadataRef") long Type2, @NativeType(value="char const *") ByteBuffer Name2, @NativeType(value="LLVMMetadataRef") long File2, @NativeType(value="unsigned int") int LineNo, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="uint32_t") int AlignInBits) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateTypedef(Builder2, Type2, MemoryUtil.memAddress(Name2), Name2.remaining(), File2, LineNo, Scope, AlignInBits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateTypedef(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMMetadataRef") long Type2, @NativeType(value="char const *") CharSequence Name2, @NativeType(value="LLVMMetadataRef") long File2, @NativeType(value="unsigned int") int LineNo, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="uint32_t") int AlignInBits) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name2, false);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMDebugInfo.nLLVMDIBuilderCreateTypedef(Builder2, Type2, NameEncoded, NameEncodedLength, File2, LineNo, Scope, AlignInBits);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateInheritance(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMMetadataRef") long Ty, @NativeType(value="LLVMMetadataRef") long BaseTy, @NativeType(value="uint64_t") long BaseOffset, @NativeType(value="uint32_t") int VBPtrOffset, @NativeType(value="LLVMDIFlags") int Flags) {
        long __functionAddress = Functions.DIBuilderCreateInheritance;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Ty);
            Checks.check(BaseTy);
        }
        return JNI.invokePPPJP(Builder2, Ty, BaseTy, BaseOffset, VBPtrOffset, Flags, __functionAddress);
    }

    public static long nLLVMDIBuilderCreateForwardDecl(long Builder2, int Tag, long Name2, long NameLen, long Scope, long File2, int Line, int RuntimeLang, long SizeInBits, int AlignInBits, long UniqueIdentifier, long UniqueIdentifierLen) {
        long __functionAddress = Functions.DIBuilderCreateForwardDecl;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Scope);
            Checks.check(File2);
        }
        return JNI.invokePPPPPJPPP(Builder2, Tag, Name2, NameLen, Scope, File2, Line, RuntimeLang, SizeInBits, AlignInBits, UniqueIdentifier, UniqueIdentifierLen, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateForwardDecl(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="unsigned int") int Tag, @NativeType(value="char const *") ByteBuffer Name2, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="LLVMMetadataRef") long File2, @NativeType(value="unsigned int") int Line, @NativeType(value="unsigned int") int RuntimeLang, @NativeType(value="uint64_t") long SizeInBits, @NativeType(value="uint32_t") int AlignInBits, @NativeType(value="char const *") ByteBuffer UniqueIdentifier) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateForwardDecl(Builder2, Tag, MemoryUtil.memAddress(Name2), Name2.remaining(), Scope, File2, Line, RuntimeLang, SizeInBits, AlignInBits, MemoryUtil.memAddress(UniqueIdentifier), UniqueIdentifier.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateForwardDecl(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="unsigned int") int Tag, @NativeType(value="char const *") CharSequence Name2, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="LLVMMetadataRef") long File2, @NativeType(value="unsigned int") int Line, @NativeType(value="unsigned int") int RuntimeLang, @NativeType(value="uint64_t") long SizeInBits, @NativeType(value="uint32_t") int AlignInBits, @NativeType(value="char const *") CharSequence UniqueIdentifier) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name2, false);
            long NameEncoded = stack.getPointerAddress();
            int UniqueIdentifierEncodedLength = stack.nUTF8(UniqueIdentifier, false);
            long UniqueIdentifierEncoded = stack.getPointerAddress();
            long l = LLVMDebugInfo.nLLVMDIBuilderCreateForwardDecl(Builder2, Tag, NameEncoded, NameEncodedLength, Scope, File2, Line, RuntimeLang, SizeInBits, AlignInBits, UniqueIdentifierEncoded, UniqueIdentifierEncodedLength);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMDIBuilderCreateReplaceableCompositeType(long Builder2, int Tag, long Name2, long NameLen, long Scope, long File2, int Line, int RuntimeLang, long SizeInBits, int AlignInBits, int Flags, long UniqueIdentifier, long UniqueIdentifierLen) {
        long __functionAddress = Functions.DIBuilderCreateReplaceableCompositeType;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Scope);
            Checks.check(File2);
        }
        return JNI.invokePPPPPJPPP(Builder2, Tag, Name2, NameLen, Scope, File2, Line, RuntimeLang, SizeInBits, AlignInBits, Flags, UniqueIdentifier, UniqueIdentifierLen, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateReplaceableCompositeType(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="unsigned int") int Tag, @NativeType(value="char const *") ByteBuffer Name2, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="LLVMMetadataRef") long File2, @NativeType(value="unsigned int") int Line, @NativeType(value="unsigned int") int RuntimeLang, @NativeType(value="uint64_t") long SizeInBits, @NativeType(value="uint32_t") int AlignInBits, @NativeType(value="LLVMDIFlags") int Flags, @NativeType(value="char const *") ByteBuffer UniqueIdentifier) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateReplaceableCompositeType(Builder2, Tag, MemoryUtil.memAddress(Name2), Name2.remaining(), Scope, File2, Line, RuntimeLang, SizeInBits, AlignInBits, Flags, MemoryUtil.memAddress(UniqueIdentifier), UniqueIdentifier.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateReplaceableCompositeType(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="unsigned int") int Tag, @NativeType(value="char const *") CharSequence Name2, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="LLVMMetadataRef") long File2, @NativeType(value="unsigned int") int Line, @NativeType(value="unsigned int") int RuntimeLang, @NativeType(value="uint64_t") long SizeInBits, @NativeType(value="uint32_t") int AlignInBits, @NativeType(value="LLVMDIFlags") int Flags, @NativeType(value="char const *") CharSequence UniqueIdentifier) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name2, false);
            long NameEncoded = stack.getPointerAddress();
            int UniqueIdentifierEncodedLength = stack.nUTF8(UniqueIdentifier, false);
            long UniqueIdentifierEncoded = stack.getPointerAddress();
            long l = LLVMDebugInfo.nLLVMDIBuilderCreateReplaceableCompositeType(Builder2, Tag, NameEncoded, NameEncodedLength, Scope, File2, Line, RuntimeLang, SizeInBits, AlignInBits, Flags, UniqueIdentifierEncoded, UniqueIdentifierEncodedLength);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMDIBuilderCreateBitFieldMemberType(long Builder2, long Scope, long Name2, long NameLen, long File2, int LineNumber, long SizeInBits, long OffsetInBits, long StorageOffsetInBits, int Flags, long Type2) {
        long __functionAddress = Functions.DIBuilderCreateBitFieldMemberType;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Scope);
            Checks.check(File2);
            Checks.check(Type2);
        }
        return JNI.invokePPPPPJJJPP(Builder2, Scope, Name2, NameLen, File2, LineNumber, SizeInBits, OffsetInBits, StorageOffsetInBits, Flags, Type2, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateBitFieldMemberType(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="char const *") ByteBuffer Name2, @NativeType(value="LLVMMetadataRef") long File2, @NativeType(value="unsigned int") int LineNumber, @NativeType(value="uint64_t") long SizeInBits, @NativeType(value="uint64_t") long OffsetInBits, @NativeType(value="uint64_t") long StorageOffsetInBits, @NativeType(value="LLVMDIFlags") int Flags, @NativeType(value="LLVMMetadataRef") long Type2) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateBitFieldMemberType(Builder2, Scope, MemoryUtil.memAddress(Name2), Name2.remaining(), File2, LineNumber, SizeInBits, OffsetInBits, StorageOffsetInBits, Flags, Type2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateBitFieldMemberType(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="char const *") CharSequence Name2, @NativeType(value="LLVMMetadataRef") long File2, @NativeType(value="unsigned int") int LineNumber, @NativeType(value="uint64_t") long SizeInBits, @NativeType(value="uint64_t") long OffsetInBits, @NativeType(value="uint64_t") long StorageOffsetInBits, @NativeType(value="LLVMDIFlags") int Flags, @NativeType(value="LLVMMetadataRef") long Type2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name2, false);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMDebugInfo.nLLVMDIBuilderCreateBitFieldMemberType(Builder2, Scope, NameEncoded, NameEncodedLength, File2, LineNumber, SizeInBits, OffsetInBits, StorageOffsetInBits, Flags, Type2);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMDIBuilderCreateClassType(long Builder2, long Scope, long Name2, long NameLen, long File2, int LineNumber, long SizeInBits, int AlignInBits, long OffsetInBits, int Flags, long DerivedFrom, long Elements, int NumElements, long VTableHolder, long TemplateParamsNode, long UniqueIdentifier, long UniqueIdentifierLen) {
        long __functionAddress = Functions.DIBuilderCreateClassType;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Scope);
            Checks.check(File2);
            Checks.check(DerivedFrom);
            Checks.check(VTableHolder);
            Checks.check(TemplateParamsNode);
        }
        return JNI.invokePPPPPJJPPPPPPP(Builder2, Scope, Name2, NameLen, File2, LineNumber, SizeInBits, AlignInBits, OffsetInBits, Flags, DerivedFrom, Elements, NumElements, VTableHolder, TemplateParamsNode, UniqueIdentifier, UniqueIdentifierLen, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateClassType(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="char const *") ByteBuffer Name2, @NativeType(value="LLVMMetadataRef") long File2, @NativeType(value="unsigned int") int LineNumber, @NativeType(value="uint64_t") long SizeInBits, @NativeType(value="uint32_t") int AlignInBits, @NativeType(value="uint64_t") long OffsetInBits, @NativeType(value="LLVMDIFlags") int Flags, @NativeType(value="LLVMMetadataRef") long DerivedFrom, @NativeType(value="LLVMMetadataRef *") PointerBuffer Elements, @NativeType(value="LLVMMetadataRef") long VTableHolder, @NativeType(value="LLVMMetadataRef") long TemplateParamsNode, @NativeType(value="char const *") ByteBuffer UniqueIdentifier) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateClassType(Builder2, Scope, MemoryUtil.memAddress(Name2), Name2.remaining(), File2, LineNumber, SizeInBits, AlignInBits, OffsetInBits, Flags, DerivedFrom, MemoryUtil.memAddress(Elements), Elements.remaining(), VTableHolder, TemplateParamsNode, MemoryUtil.memAddress(UniqueIdentifier), UniqueIdentifier.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateClassType(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="char const *") CharSequence Name2, @NativeType(value="LLVMMetadataRef") long File2, @NativeType(value="unsigned int") int LineNumber, @NativeType(value="uint64_t") long SizeInBits, @NativeType(value="uint32_t") int AlignInBits, @NativeType(value="uint64_t") long OffsetInBits, @NativeType(value="LLVMDIFlags") int Flags, @NativeType(value="LLVMMetadataRef") long DerivedFrom, @NativeType(value="LLVMMetadataRef *") PointerBuffer Elements, @NativeType(value="LLVMMetadataRef") long VTableHolder, @NativeType(value="LLVMMetadataRef") long TemplateParamsNode, @NativeType(value="char const *") CharSequence UniqueIdentifier) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name2, false);
            long NameEncoded = stack.getPointerAddress();
            int UniqueIdentifierEncodedLength = stack.nUTF8(UniqueIdentifier, false);
            long UniqueIdentifierEncoded = stack.getPointerAddress();
            long l = LLVMDebugInfo.nLLVMDIBuilderCreateClassType(Builder2, Scope, NameEncoded, NameEncodedLength, File2, LineNumber, SizeInBits, AlignInBits, OffsetInBits, Flags, DerivedFrom, MemoryUtil.memAddress(Elements), Elements.remaining(), VTableHolder, TemplateParamsNode, UniqueIdentifierEncoded, UniqueIdentifierEncodedLength);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateArtificialType(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMMetadataRef") long Type2) {
        long __functionAddress = Functions.DIBuilderCreateArtificialType;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Type2);
        }
        return JNI.invokePPP(Builder2, Type2, __functionAddress);
    }

    public static long nLLVMDITypeGetName(long DType, long Length) {
        long __functionAddress = Functions.DITypeGetName;
        if (Checks.CHECKS) {
            Checks.check(DType);
        }
        return JNI.invokePPP(DType, Length, __functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="char const *")
    public static String LLVMDITypeGetName(@NativeType(value="LLVMMetadataRef") long DType) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer Length = stack.callocPointer(1);
            long __result = LLVMDebugInfo.nLLVMDITypeGetName(DType, MemoryUtil.memAddress(Length));
            String string = MemoryUtil.memUTF8Safe(__result, (int)Length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="uint64_t")
    public static long LLVMDITypeGetSizeInBits(@NativeType(value="LLVMMetadataRef") long DType) {
        long __functionAddress = Functions.DITypeGetSizeInBits;
        if (Checks.CHECKS) {
            Checks.check(DType);
        }
        return JNI.invokePJ(DType, __functionAddress);
    }

    @NativeType(value="uint64_t")
    public static long LLVMDITypeGetOffsetInBits(@NativeType(value="LLVMMetadataRef") long DType) {
        long __functionAddress = Functions.DITypeGetOffsetInBits;
        if (Checks.CHECKS) {
            Checks.check(DType);
        }
        return JNI.invokePJ(DType, __functionAddress);
    }

    @NativeType(value="uint32_t")
    public static int LLVMDITypeGetAlignInBits(@NativeType(value="LLVMMetadataRef") long DType) {
        long __functionAddress = Functions.DITypeGetAlignInBits;
        if (Checks.CHECKS) {
            Checks.check(DType);
        }
        return JNI.invokePI(DType, __functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMDITypeGetLine(@NativeType(value="LLVMMetadataRef") long DType) {
        long __functionAddress = Functions.DITypeGetLine;
        if (Checks.CHECKS) {
            Checks.check(DType);
        }
        return JNI.invokePI(DType, __functionAddress);
    }

    @NativeType(value="LLVMDIFlags")
    public static int LLVMDITypeGetFlags(@NativeType(value="LLVMMetadataRef") long DType) {
        long __functionAddress = Functions.DITypeGetFlags;
        if (Checks.CHECKS) {
            Checks.check(DType);
        }
        return JNI.invokePI(DType, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderGetOrCreateSubrange(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="int64_t") long LowerBound, @NativeType(value="int64_t") long Count) {
        long __functionAddress = Functions.DIBuilderGetOrCreateSubrange;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
        }
        return JNI.invokePJJP(Builder2, LowerBound, Count, __functionAddress);
    }

    public static long nLLVMDIBuilderGetOrCreateArray(long Builder2, long Data, long NumElements) {
        long __functionAddress = Functions.DIBuilderGetOrCreateArray;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
        }
        return JNI.invokePPPP(Builder2, Data, NumElements, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderGetOrCreateArray(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMMetadataRef *") PointerBuffer Data) {
        return LLVMDebugInfo.nLLVMDIBuilderGetOrCreateArray(Builder2, MemoryUtil.memAddress(Data), Data.remaining());
    }

    public static long nLLVMDIBuilderCreateExpression(long Builder2, long Addr, long Length) {
        long __functionAddress = Functions.DIBuilderCreateExpression;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
        }
        return JNI.invokePPPP(Builder2, Addr, Length, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateExpression(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="int64_t *") LongBuffer Addr) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateExpression(Builder2, MemoryUtil.memAddress(Addr), Addr.remaining());
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateConstantValueExpression(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="int64_t") long Value) {
        long __functionAddress = Functions.DIBuilderCreateConstantValueExpression;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
        }
        return JNI.invokePJP(Builder2, Value, __functionAddress);
    }

    public static long nLLVMDIBuilderCreateGlobalVariableExpression(long Builder2, long Scope, long Name2, long NameLen, long Linkage, long LinkLen, long File2, int LineNo, long Ty, int LocalToUnit, long Expr, long Decl, int AlignInBits) {
        long __functionAddress = Functions.DIBuilderCreateGlobalVariableExpression;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Scope);
            Checks.check(File2);
            Checks.check(Ty);
            Checks.check(Expr);
            Checks.check(Decl);
        }
        return JNI.invokePPPPPPPPPPP(Builder2, Scope, Name2, NameLen, Linkage, LinkLen, File2, LineNo, Ty, LocalToUnit, Expr, Decl, AlignInBits, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateGlobalVariableExpression(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="char const *") ByteBuffer Name2, @NativeType(value="char const *") ByteBuffer Linkage, @NativeType(value="LLVMMetadataRef") long File2, @NativeType(value="unsigned int") int LineNo, @NativeType(value="LLVMMetadataRef") long Ty, @NativeType(value="LLVMBool") boolean LocalToUnit, @NativeType(value="LLVMMetadataRef") long Expr, @NativeType(value="LLVMMetadataRef") long Decl, @NativeType(value="uint32_t") int AlignInBits) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateGlobalVariableExpression(Builder2, Scope, MemoryUtil.memAddress(Name2), Name2.remaining(), MemoryUtil.memAddress(Linkage), Linkage.remaining(), File2, LineNo, Ty, LocalToUnit ? 1 : 0, Expr, Decl, AlignInBits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateGlobalVariableExpression(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="char const *") CharSequence Name2, @NativeType(value="char const *") CharSequence Linkage, @NativeType(value="LLVMMetadataRef") long File2, @NativeType(value="unsigned int") int LineNo, @NativeType(value="LLVMMetadataRef") long Ty, @NativeType(value="LLVMBool") boolean LocalToUnit, @NativeType(value="LLVMMetadataRef") long Expr, @NativeType(value="LLVMMetadataRef") long Decl, @NativeType(value="uint32_t") int AlignInBits) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name2, false);
            long NameEncoded = stack.getPointerAddress();
            int LinkageEncodedLength = stack.nUTF8(Linkage, false);
            long LinkageEncoded = stack.getPointerAddress();
            long l = LLVMDebugInfo.nLLVMDIBuilderCreateGlobalVariableExpression(Builder2, Scope, NameEncoded, NameEncodedLength, LinkageEncoded, LinkageEncodedLength, File2, LineNo, Ty, LocalToUnit ? 1 : 0, Expr, Decl, AlignInBits);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIGlobalVariableExpressionGetVariable(@NativeType(value="LLVMMetadataRef") long GVE) {
        long __functionAddress = Functions.DIGlobalVariableExpressionGetVariable;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(GVE);
        }
        return JNI.invokePP(GVE, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIGlobalVariableExpressionGetExpression(@NativeType(value="LLVMMetadataRef") long GVE) {
        long __functionAddress = Functions.DIGlobalVariableExpressionGetExpression;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(GVE);
        }
        return JNI.invokePP(GVE, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIVariableGetFile(@NativeType(value="LLVMMetadataRef") long Var) {
        long __functionAddress = Functions.DIVariableGetFile;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Var);
        }
        return JNI.invokePP(Var, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIVariableGetScope(@NativeType(value="LLVMMetadataRef") long Var) {
        long __functionAddress = Functions.DIVariableGetScope;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Var);
        }
        return JNI.invokePP(Var, __functionAddress);
    }

    @NativeType(value="unsigned")
    public static int LLVMDIVariableGetLine(@NativeType(value="LLVMMetadataRef") long Var) {
        long __functionAddress = Functions.DIVariableGetLine;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Var);
        }
        return JNI.invokePI(Var, __functionAddress);
    }

    public static long nLLVMTemporaryMDNode(long Ctx, long Data, long NumElements) {
        long __functionAddress = Functions.TemporaryMDNode;
        if (Checks.CHECKS) {
            Checks.check(Ctx);
        }
        return JNI.invokePPPP(Ctx, Data, NumElements, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMTemporaryMDNode(@NativeType(value="LLVMContextRef") long Ctx, @NativeType(value="LLVMMetadataRef *") PointerBuffer Data) {
        return LLVMDebugInfo.nLLVMTemporaryMDNode(Ctx, MemoryUtil.memAddress(Data), Data.remaining());
    }

    public static void LLVMDisposeTemporaryMDNode(@NativeType(value="LLVMMetadataRef") long TempNode) {
        long __functionAddress = Functions.DisposeTemporaryMDNode;
        if (Checks.CHECKS) {
            Checks.check(TempNode);
        }
        JNI.invokePV(TempNode, __functionAddress);
    }

    public static void LLVMMetadataReplaceAllUsesWith(@NativeType(value="LLVMMetadataRef") long TempTargetMetadata, @NativeType(value="LLVMMetadataRef") long Replacement) {
        long __functionAddress = Functions.MetadataReplaceAllUsesWith;
        if (Checks.CHECKS) {
            Checks.check(TempTargetMetadata);
            Checks.check(Replacement);
        }
        JNI.invokePPV(TempTargetMetadata, Replacement, __functionAddress);
    }

    public static long nLLVMDIBuilderCreateTempGlobalVariableFwdDecl(long Builder2, long Scope, long Name2, long NameLen, long Linkage, long LnkLen, long File2, int LineNo, long Ty, int LocalToUnit, long Decl, int AlignInBits) {
        long __functionAddress = Functions.DIBuilderCreateTempGlobalVariableFwdDecl;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Scope);
            Checks.check(File2);
            Checks.check(Ty);
            Checks.check(Decl);
        }
        return JNI.invokePPPPPPPPPP(Builder2, Scope, Name2, NameLen, Linkage, LnkLen, File2, LineNo, Ty, LocalToUnit, Decl, AlignInBits, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateTempGlobalVariableFwdDecl(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="char const *") ByteBuffer Name2, @NativeType(value="char const *") ByteBuffer Linkage, @NativeType(value="LLVMMetadataRef") long File2, @NativeType(value="unsigned int") int LineNo, @NativeType(value="LLVMMetadataRef") long Ty, @NativeType(value="LLVMBool") boolean LocalToUnit, @NativeType(value="LLVMMetadataRef") long Decl, @NativeType(value="uint32_t") int AlignInBits) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateTempGlobalVariableFwdDecl(Builder2, Scope, MemoryUtil.memAddress(Name2), Name2.remaining(), MemoryUtil.memAddress(Linkage), Linkage.remaining(), File2, LineNo, Ty, LocalToUnit ? 1 : 0, Decl, AlignInBits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateTempGlobalVariableFwdDecl(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="char const *") CharSequence Name2, @NativeType(value="char const *") CharSequence Linkage, @NativeType(value="LLVMMetadataRef") long File2, @NativeType(value="unsigned int") int LineNo, @NativeType(value="LLVMMetadataRef") long Ty, @NativeType(value="LLVMBool") boolean LocalToUnit, @NativeType(value="LLVMMetadataRef") long Decl, @NativeType(value="uint32_t") int AlignInBits) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name2, false);
            long NameEncoded = stack.getPointerAddress();
            int LinkageEncodedLength = stack.nUTF8(Linkage, false);
            long LinkageEncoded = stack.getPointerAddress();
            long l = LLVMDebugInfo.nLLVMDIBuilderCreateTempGlobalVariableFwdDecl(Builder2, Scope, NameEncoded, NameEncodedLength, LinkageEncoded, LinkageEncodedLength, File2, LineNo, Ty, LocalToUnit ? 1 : 0, Decl, AlignInBits);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMDIBuilderInsertDeclareBefore(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Storage, @NativeType(value="LLVMMetadataRef") long VarInfo, @NativeType(value="LLVMMetadataRef") long Expr, @NativeType(value="LLVMMetadataRef") long DebugLoc, @NativeType(value="LLVMValueRef") long Instr) {
        long __functionAddress = Functions.DIBuilderInsertDeclareBefore;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Storage);
            Checks.check(VarInfo);
            Checks.check(Expr);
            Checks.check(DebugLoc);
            Checks.check(Instr);
        }
        return JNI.invokePPPPPPP(Builder2, Storage, VarInfo, Expr, DebugLoc, Instr, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMDIBuilderInsertDeclareAtEnd(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Storage, @NativeType(value="LLVMMetadataRef") long VarInfo, @NativeType(value="LLVMMetadataRef") long Expr, @NativeType(value="LLVMMetadataRef") long DebugLoc, @NativeType(value="LLVMBasicBlockRef") long Block) {
        long __functionAddress = Functions.DIBuilderInsertDeclareAtEnd;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Storage);
            Checks.check(VarInfo);
            Checks.check(Expr);
            Checks.check(DebugLoc);
            Checks.check(Block);
        }
        return JNI.invokePPPPPPP(Builder2, Storage, VarInfo, Expr, DebugLoc, Block, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMDIBuilderInsertDbgValueBefore(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMMetadataRef") long VarInfo, @NativeType(value="LLVMMetadataRef") long Expr, @NativeType(value="LLVMMetadataRef") long DebugLoc, @NativeType(value="LLVMValueRef") long Instr) {
        long __functionAddress = Functions.DIBuilderInsertDbgValueBefore;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Val);
            Checks.check(VarInfo);
            Checks.check(Expr);
            Checks.check(DebugLoc);
            Checks.check(Instr);
        }
        return JNI.invokePPPPPPP(Builder2, Val, VarInfo, Expr, DebugLoc, Instr, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMDIBuilderInsertDbgValueAtEnd(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMMetadataRef") long VarInfo, @NativeType(value="LLVMMetadataRef") long Expr, @NativeType(value="LLVMMetadataRef") long DebugLoc, @NativeType(value="LLVMBasicBlockRef") long Block) {
        long __functionAddress = Functions.DIBuilderInsertDbgValueAtEnd;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Val);
            Checks.check(VarInfo);
            Checks.check(Expr);
            Checks.check(DebugLoc);
            Checks.check(Block);
        }
        return JNI.invokePPPPPPP(Builder2, Val, VarInfo, Expr, DebugLoc, Block, __functionAddress);
    }

    public static long nLLVMDIBuilderCreateAutoVariable(long Builder2, long Scope, long Name2, long NameLen, long File2, int LineNo, long Ty, int AlwaysPreserve, int Flags, int AlignInBits) {
        long __functionAddress = Functions.DIBuilderCreateAutoVariable;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Scope);
            Checks.check(File2);
            Checks.check(Ty);
        }
        return JNI.invokePPPPPPP(Builder2, Scope, Name2, NameLen, File2, LineNo, Ty, AlwaysPreserve, Flags, AlignInBits, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateAutoVariable(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="char const *") ByteBuffer Name2, @NativeType(value="LLVMMetadataRef") long File2, @NativeType(value="unsigned int") int LineNo, @NativeType(value="LLVMMetadataRef") long Ty, @NativeType(value="LLVMBool") boolean AlwaysPreserve, @NativeType(value="LLVMDIFlags") int Flags, @NativeType(value="uint32_t") int AlignInBits) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateAutoVariable(Builder2, Scope, MemoryUtil.memAddress(Name2), Name2.remaining(), File2, LineNo, Ty, AlwaysPreserve ? 1 : 0, Flags, AlignInBits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateAutoVariable(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="char const *") CharSequence Name2, @NativeType(value="LLVMMetadataRef") long File2, @NativeType(value="unsigned int") int LineNo, @NativeType(value="LLVMMetadataRef") long Ty, @NativeType(value="LLVMBool") boolean AlwaysPreserve, @NativeType(value="LLVMDIFlags") int Flags, @NativeType(value="uint32_t") int AlignInBits) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name2, false);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMDebugInfo.nLLVMDIBuilderCreateAutoVariable(Builder2, Scope, NameEncoded, NameEncodedLength, File2, LineNo, Ty, AlwaysPreserve ? 1 : 0, Flags, AlignInBits);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMDIBuilderCreateParameterVariable(long Builder2, long Scope, long Name2, long NameLen, int ArgNo, long File2, int LineNo, long Ty, int AlwaysPreserve, int Flags) {
        long __functionAddress = Functions.DIBuilderCreateParameterVariable;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Scope);
            Checks.check(File2);
            Checks.check(Ty);
        }
        return JNI.invokePPPPPPP(Builder2, Scope, Name2, NameLen, ArgNo, File2, LineNo, Ty, AlwaysPreserve, Flags, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateParameterVariable(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="char const *") ByteBuffer Name2, @NativeType(value="unsigned int") int ArgNo, @NativeType(value="LLVMMetadataRef") long File2, @NativeType(value="unsigned int") int LineNo, @NativeType(value="LLVMMetadataRef") long Ty, @NativeType(value="LLVMBool") boolean AlwaysPreserve, @NativeType(value="LLVMDIFlags") int Flags) {
        return LLVMDebugInfo.nLLVMDIBuilderCreateParameterVariable(Builder2, Scope, MemoryUtil.memAddress(Name2), Name2.remaining(), ArgNo, File2, LineNo, Ty, AlwaysPreserve ? 1 : 0, Flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMDIBuilderCreateParameterVariable(@NativeType(value="LLVMDIBuilderRef") long Builder2, @NativeType(value="LLVMMetadataRef") long Scope, @NativeType(value="char const *") CharSequence Name2, @NativeType(value="unsigned int") int ArgNo, @NativeType(value="LLVMMetadataRef") long File2, @NativeType(value="unsigned int") int LineNo, @NativeType(value="LLVMMetadataRef") long Ty, @NativeType(value="LLVMBool") boolean AlwaysPreserve, @NativeType(value="LLVMDIFlags") int Flags) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name2, false);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMDebugInfo.nLLVMDIBuilderCreateParameterVariable(Builder2, Scope, NameEncoded, NameEncodedLength, ArgNo, File2, LineNo, Ty, AlwaysPreserve ? 1 : 0, Flags);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMGetSubprogram(@NativeType(value="LLVMValueRef") long Func) {
        long __functionAddress = Functions.GetSubprogram;
        if (Checks.CHECKS) {
            Checks.check(Func);
        }
        return JNI.invokePP(Func, __functionAddress);
    }

    public static void LLVMSetSubprogram(@NativeType(value="LLVMValueRef") long Func, @NativeType(value="LLVMMetadataRef") long SP) {
        long __functionAddress = Functions.SetSubprogram;
        if (Checks.CHECKS) {
            Checks.check(Func);
            Checks.check(SP);
        }
        JNI.invokePPV(Func, SP, __functionAddress);
    }

    @NativeType(value="unsigned")
    public static int LLVMDISubprogramGetLine(@NativeType(value="LLVMMetadataRef") long Subprogram) {
        long __functionAddress = Functions.DISubprogramGetLine;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Subprogram);
        }
        return JNI.invokePI(Subprogram, __functionAddress);
    }

    @NativeType(value="unsigned")
    public static int LLVMInstructionGetDebugLoc(@NativeType(value="LLVMValueRef") long Inst) {
        long __functionAddress = Functions.InstructionGetDebugLoc;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Inst);
        }
        return JNI.invokePI(Inst, __functionAddress);
    }

    public static void LLVMInstructionSetDebugLoc(@NativeType(value="LLVMValueRef") long Inst, @NativeType(value="LLVMMetadataRef") long Loc) {
        long __functionAddress = Functions.InstructionSetDebugLoc;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Inst);
        }
        JNI.invokePPV(Inst, Loc, __functionAddress);
    }

    @NativeType(value="LLVMMetadataKind")
    public static int LLVMGetMetadataKind(@NativeType(value="LLVMMetadataRef") long Metadata) {
        long __functionAddress = Functions.GetMetadataKind;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Metadata);
        }
        return JNI.invokePI(Metadata, __functionAddress);
    }

    public static final class Functions {
        public static final long DebugMetadataVersion = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDebugMetadataVersion");
        public static final long GetModuleDebugMetadataVersion = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMGetModuleDebugMetadataVersion");
        public static final long StripModuleDebugInfo = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMStripModuleDebugInfo");
        public static final long CreateDIBuilderDisallowUnresolved = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMCreateDIBuilderDisallowUnresolved");
        public static final long CreateDIBuilder = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMCreateDIBuilder");
        public static final long DisposeDIBuilder = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDisposeDIBuilder");
        public static final long DIBuilderFinalize = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDIBuilderFinalize");
        public static final long DIBuilderCreateCompileUnit = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDIBuilderCreateCompileUnit");
        public static final long DIBuilderCreateFile = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDIBuilderCreateFile");
        public static final long DIBuilderCreateModule = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDIBuilderCreateModule");
        public static final long DIBuilderCreateNameSpace = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDIBuilderCreateNameSpace");
        public static final long DIBuilderCreateFunction = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDIBuilderCreateFunction");
        public static final long DIBuilderCreateLexicalBlock = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDIBuilderCreateLexicalBlock");
        public static final long DIBuilderCreateLexicalBlockFile = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDIBuilderCreateLexicalBlockFile");
        public static final long DIBuilderCreateImportedModuleFromNamespace = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDIBuilderCreateImportedModuleFromNamespace");
        public static final long DIBuilderCreateImportedModuleFromAlias = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDIBuilderCreateImportedModuleFromAlias");
        public static final long DIBuilderCreateImportedModuleFromModule = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDIBuilderCreateImportedModuleFromModule");
        public static final long DIBuilderCreateImportedDeclaration = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDIBuilderCreateImportedDeclaration");
        public static final long DIBuilderCreateDebugLocation = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDIBuilderCreateDebugLocation");
        public static final long DILocationGetLine = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDILocationGetLine");
        public static final long DILocationGetColumn = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDILocationGetColumn");
        public static final long DILocationGetScope = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDILocationGetScope");
        public static final long DILocationGetInlinedAt = LLVMCore.getLibrary().getFunctionAddress("LLVMDILocationGetInlinedAt");
        public static final long DIScopeGetFile = LLVMCore.getLibrary().getFunctionAddress("LLVMDIScopeGetFile");
        public static final long DIFileGetDirectory = LLVMCore.getLibrary().getFunctionAddress("LLVMDIFileGetDirectory");
        public static final long DIFileGetFilename = LLVMCore.getLibrary().getFunctionAddress("LLVMDIFileGetFilename");
        public static final long DIFileGetSource = LLVMCore.getLibrary().getFunctionAddress("LLVMDIFileGetSource");
        public static final long DIBuilderGetOrCreateTypeArray = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDIBuilderGetOrCreateTypeArray");
        public static final long DIBuilderCreateSubroutineType = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDIBuilderCreateSubroutineType");
        public static final long DIBuilderCreateMacro = LLVMCore.getLibrary().getFunctionAddress("LLVMDIBuilderCreateMacro");
        public static final long DIBuilderCreateTempMacroFile = LLVMCore.getLibrary().getFunctionAddress("LLVMDIBuilderCreateTempMacroFile");
        public static final long DIBuilderCreateEnumerator = LLVMCore.getLibrary().getFunctionAddress("LLVMDIBuilderCreateEnumerator");
        public static final long DIBuilderCreateEnumerationType = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDIBuilderCreateEnumerationType");
        public static final long DIBuilderCreateUnionType = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDIBuilderCreateUnionType");
        public static final long DIBuilderCreateArrayType = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDIBuilderCreateArrayType");
        public static final long DIBuilderCreateVectorType = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDIBuilderCreateVectorType");
        public static final long DIBuilderCreateUnspecifiedType = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDIBuilderCreateUnspecifiedType");
        public static final long DIBuilderCreateBasicType = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDIBuilderCreateBasicType");
        public static final long DIBuilderCreatePointerType = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDIBuilderCreatePointerType");
        public static final long DIBuilderCreateStructType = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDIBuilderCreateStructType");
        public static final long DIBuilderCreateMemberType = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDIBuilderCreateMemberType");
        public static final long DIBuilderCreateStaticMemberType = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDIBuilderCreateStaticMemberType");
        public static final long DIBuilderCreateMemberPointerType = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDIBuilderCreateMemberPointerType");
        public static final long DIBuilderCreateObjCIVar = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDIBuilderCreateObjCIVar");
        public static final long DIBuilderCreateObjCProperty = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDIBuilderCreateObjCProperty");
        public static final long DIBuilderCreateObjectPointerType = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDIBuilderCreateObjectPointerType");
        public static final long DIBuilderCreateQualifiedType = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDIBuilderCreateQualifiedType");
        public static final long DIBuilderCreateReferenceType = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDIBuilderCreateReferenceType");
        public static final long DIBuilderCreateNullPtrType = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDIBuilderCreateNullPtrType");
        public static final long DIBuilderCreateTypedef = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDIBuilderCreateTypedef");
        public static final long DIBuilderCreateInheritance = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDIBuilderCreateInheritance");
        public static final long DIBuilderCreateForwardDecl = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDIBuilderCreateForwardDecl");
        public static final long DIBuilderCreateReplaceableCompositeType = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDIBuilderCreateReplaceableCompositeType");
        public static final long DIBuilderCreateBitFieldMemberType = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDIBuilderCreateBitFieldMemberType");
        public static final long DIBuilderCreateClassType = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDIBuilderCreateClassType");
        public static final long DIBuilderCreateArtificialType = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDIBuilderCreateArtificialType");
        public static final long DITypeGetName = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDITypeGetName");
        public static final long DITypeGetSizeInBits = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDITypeGetSizeInBits");
        public static final long DITypeGetOffsetInBits = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDITypeGetOffsetInBits");
        public static final long DITypeGetAlignInBits = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDITypeGetAlignInBits");
        public static final long DITypeGetLine = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDITypeGetLine");
        public static final long DITypeGetFlags = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDITypeGetFlags");
        public static final long DIBuilderGetOrCreateSubrange = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDIBuilderGetOrCreateSubrange");
        public static final long DIBuilderGetOrCreateArray = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDIBuilderGetOrCreateArray");
        public static final long DIBuilderCreateExpression = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDIBuilderCreateExpression");
        public static final long DIBuilderCreateConstantValueExpression = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDIBuilderCreateConstantValueExpression");
        public static final long DIBuilderCreateGlobalVariableExpression = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDIBuilderCreateGlobalVariableExpression");
        public static final long DIGlobalVariableExpressionGetVariable = LLVMCore.getLibrary().getFunctionAddress("LLVMDIGlobalVariableExpressionGetVariable");
        public static final long DIGlobalVariableExpressionGetExpression = LLVMCore.getLibrary().getFunctionAddress("LLVMDIGlobalVariableExpressionGetExpression");
        public static final long DIVariableGetFile = LLVMCore.getLibrary().getFunctionAddress("LLVMDIVariableGetFile");
        public static final long DIVariableGetScope = LLVMCore.getLibrary().getFunctionAddress("LLVMDIVariableGetScope");
        public static final long DIVariableGetLine = LLVMCore.getLibrary().getFunctionAddress("LLVMDIVariableGetLine");
        public static final long TemporaryMDNode = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMTemporaryMDNode");
        public static final long DisposeTemporaryMDNode = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDisposeTemporaryMDNode");
        public static final long MetadataReplaceAllUsesWith = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMMetadataReplaceAllUsesWith");
        public static final long DIBuilderCreateTempGlobalVariableFwdDecl = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDIBuilderCreateTempGlobalVariableFwdDecl");
        public static final long DIBuilderInsertDeclareBefore = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDIBuilderInsertDeclareBefore");
        public static final long DIBuilderInsertDeclareAtEnd = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDIBuilderInsertDeclareAtEnd");
        public static final long DIBuilderInsertDbgValueBefore = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDIBuilderInsertDbgValueBefore");
        public static final long DIBuilderInsertDbgValueAtEnd = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDIBuilderInsertDbgValueAtEnd");
        public static final long DIBuilderCreateAutoVariable = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDIBuilderCreateAutoVariable");
        public static final long DIBuilderCreateParameterVariable = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMDIBuilderCreateParameterVariable");
        public static final long GetSubprogram = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMGetSubprogram");
        public static final long SetSubprogram = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMSetSubprogram");
        public static final long DISubprogramGetLine = LLVMCore.getLibrary().getFunctionAddress("LLVMDISubprogramGetLine");
        public static final long InstructionGetDebugLoc = LLVMCore.getLibrary().getFunctionAddress("LLVMInstructionGetDebugLoc");
        public static final long InstructionSetDebugLoc = LLVMCore.getLibrary().getFunctionAddress("LLVMInstructionSetDebugLoc");
        public static final long GetMetadataKind = LLVMCore.getLibrary().getFunctionAddress("LLVMGetMetadataKind");

        private Functions() {
        }
    }
}

