/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.llvm.LLVMDiagnosticHandler;
import org.lwjgl.llvm.LLVMDiagnosticHandlerI;
import org.lwjgl.llvm.LLVMYieldCallbackI;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.SharedLibrary;

public class LLVMCore {
    private static final SharedLibrary LLVM = Library.loadNative(LLVMCore.class, "org.lwjgl.llvm", Configuration.LLVM_LIBRARY_NAME, "LLVM", "LLVM-C");
    public static final int LLVMRet = 1;
    public static final int LLVMBr = 2;
    public static final int LLVMSwitch = 3;
    public static final int LLVMIndirectBr = 4;
    public static final int LLVMInvoke = 5;
    public static final int LLVMUnreachable = 7;
    public static final int LLVMCallBr = 67;
    public static final int LLVMFNeg = 66;
    public static final int LLVMAdd = 8;
    public static final int LLVMFAdd = 9;
    public static final int LLVMSub = 10;
    public static final int LLVMFSub = 11;
    public static final int LLVMMul = 12;
    public static final int LLVMFMul = 13;
    public static final int LLVMUDiv = 14;
    public static final int LLVMSDiv = 15;
    public static final int LLVMFDiv = 16;
    public static final int LLVMURem = 17;
    public static final int LLVMSRem = 18;
    public static final int LLVMFRem = 19;
    public static final int LLVMShl = 20;
    public static final int LLVMLShr = 21;
    public static final int LLVMAShr = 22;
    public static final int LLVMAnd = 23;
    public static final int LLVMOr = 24;
    public static final int LLVMXor = 25;
    public static final int LLVMAlloca = 26;
    public static final int LLVMLoad = 27;
    public static final int LLVMStore = 28;
    public static final int LLVMGetElementPtr = 29;
    public static final int LLVMTrunc = 30;
    public static final int LLVMZExt = 31;
    public static final int LLVMSExt = 32;
    public static final int LLVMFPToUI = 33;
    public static final int LLVMFPToSI = 34;
    public static final int LLVMUIToFP = 35;
    public static final int LLVMSIToFP = 36;
    public static final int LLVMFPTrunc = 37;
    public static final int LLVMFPExt = 38;
    public static final int LLVMPtrToInt = 39;
    public static final int LLVMIntToPtr = 40;
    public static final int LLVMBitCast = 41;
    public static final int LLVMAddrSpaceCast = 60;
    public static final int LLVMICmp = 42;
    public static final int LLVMFCmp = 43;
    public static final int LLVMPHI = 44;
    public static final int LLVMCall = 45;
    public static final int LLVMSelect = 46;
    public static final int LLVMUserOp1 = 47;
    public static final int LLVMUserOp2 = 48;
    public static final int LLVMVAArg = 49;
    public static final int LLVMExtractElement = 50;
    public static final int LLVMInsertElement = 51;
    public static final int LLVMShuffleVector = 52;
    public static final int LLVMExtractValue = 53;
    public static final int LLVMInsertValue = 54;
    public static final int LLVMFreeze = 68;
    public static final int LLVMFence = 55;
    public static final int LLVMAtomicCmpXchg = 56;
    public static final int LLVMAtomicRMW = 57;
    public static final int LLVMResume = 58;
    public static final int LLVMLandingPad = 59;
    public static final int LLVMCleanupRet = 61;
    public static final int LLVMCatchRet = 62;
    public static final int LLVMCatchPad = 63;
    public static final int LLVMCleanupPad = 64;
    public static final int LLVMCatchSwitch = 65;
    public static final int LLVMVoidTypeKind = 0;
    public static final int LLVMHalfTypeKind = 1;
    public static final int LLVMFloatTypeKind = 2;
    public static final int LLVMDoubleTypeKind = 3;
    public static final int LLVMX86_FP80TypeKind = 4;
    public static final int LLVMFP128TypeKind = 5;
    public static final int LLVMPPC_FP128TypeKind = 6;
    public static final int LLVMLabelTypeKind = 7;
    public static final int LLVMIntegerTypeKind = 8;
    public static final int LLVMFunctionTypeKind = 9;
    public static final int LLVMStructTypeKind = 10;
    public static final int LLVMArrayTypeKind = 11;
    public static final int LLVMPointerTypeKind = 12;
    public static final int LLVMVectorTypeKind = 13;
    public static final int LLVMMetadataTypeKind = 14;
    public static final int LLVMX86_MMXTypeKind = 15;
    public static final int LLVMTokenTypeKind = 16;
    public static final int LLVMScalableVectorTypeKind = 17;
    public static final int LLVMBFloatTypeKind = 18;
    public static final int LLVMX86_AMXTypeKind = 19;
    public static final int LLVMExternalLinkage = 0;
    public static final int LLVMAvailableExternallyLinkage = 1;
    public static final int LLVMLinkOnceAnyLinkage = 2;
    public static final int LLVMLinkOnceODRLinkage = 3;
    public static final int LLVMLinkOnceODRAutoHideLinkage = 4;
    public static final int LLVMWeakAnyLinkage = 5;
    public static final int LLVMWeakODRLinkage = 6;
    public static final int LLVMAppendingLinkage = 7;
    public static final int LLVMInternalLinkage = 8;
    public static final int LLVMPrivateLinkage = 9;
    public static final int LLVMDLLImportLinkage = 10;
    public static final int LLVMDLLExportLinkage = 11;
    public static final int LLVMExternalWeakLinkage = 12;
    public static final int LLVMGhostLinkage = 13;
    public static final int LLVMCommonLinkage = 14;
    public static final int LLVMLinkerPrivateLinkage = 15;
    public static final int LLVMLinkerPrivateWeakLinkage = 16;
    public static final int LLVMDefaultVisibility = 0;
    public static final int LLVMHiddenVisibility = 1;
    public static final int LLVMProtectedVisibility = 2;
    public static final int LLVMNoUnnamedAddr = 0;
    public static final int LLVMLocalUnnamedAddr = 1;
    public static final int LLVMGlobalUnnamedAddr = 2;
    public static final int LLVMDefaultStorageClass = 0;
    public static final int LLVMDLLImportStorageClass = 1;
    public static final int LLVMDLLExportStorageClass = 2;
    public static final int LLVMCCallConv = 0;
    public static final int LLVMFastCallConv = 8;
    public static final int LLVMColdCallConv = 9;
    public static final int LLVMGHCCallConv = 10;
    public static final int LLVMHiPECallConv = 11;
    public static final int LLVMWebKitJSCallConv = 12;
    public static final int LLVMAnyRegCallConv = 13;
    public static final int LLVMPreserveMostCallConv = 14;
    public static final int LLVMPreserveAllCallConv = 15;
    public static final int LLVMSwiftCallConv = 16;
    public static final int LLVMCXXFASTTLSCallConv = 17;
    public static final int LLVMX86StdcallCallConv = 64;
    public static final int LLVMX86FastcallCallConv = 65;
    public static final int LLVMARMAPCSCallConv = 66;
    public static final int LLVMARMAAPCSCallConv = 67;
    public static final int LLVMARMAAPCSVFPCallConv = 68;
    public static final int LLVMMSP430INTRCallConv = 69;
    public static final int LLVMX86ThisCallCallConv = 70;
    public static final int LLVMPTXKernelCallConv = 71;
    public static final int LLVMPTXDeviceCallConv = 72;
    public static final int LLVMSPIRFUNCCallConv = 75;
    public static final int LLVMSPIRKERNELCallConv = 76;
    public static final int LLVMIntelOCLBICallConv = 77;
    public static final int LLVMX8664SysVCallConv = 78;
    public static final int LLVMWin64CallConv = 79;
    public static final int LLVMX86VectorCallCallConv = 80;
    public static final int LLVMHHVMCallConv = 81;
    public static final int LLVMHHVMCCallConv = 82;
    public static final int LLVMX86INTRCallConv = 83;
    public static final int LLVMAVRINTRCallConv = 84;
    public static final int LLVMAVRSIGNALCallConv = 85;
    public static final int LLVMAVRBUILTINCallConv = 86;
    public static final int LLVMAMDGPUVSCallConv = 87;
    public static final int LLVMAMDGPUGSCallConv = 88;
    public static final int LLVMAMDGPUPSCallConv = 89;
    public static final int LLVMAMDGPUCSCallConv = 90;
    public static final int LLVMAMDGPUKERNELCallConv = 91;
    public static final int LLVMX86RegCallCallConv = 92;
    public static final int LLVMAMDGPUHSCallConv = 93;
    public static final int LLVMMSP430BUILTINCallConv = 94;
    public static final int LLVMAMDGPULSCallConv = 95;
    public static final int LLVMAMDGPUESCallConv = 96;
    public static final int LLVMArgumentValueKind = 0;
    public static final int LLVMBasicBlockValueKind = 1;
    public static final int LLVMMemoryUseValueKind = 2;
    public static final int LLVMMemoryDefValueKind = 3;
    public static final int LLVMMemoryPhiValueKind = 4;
    public static final int LLVMFunctionValueKind = 5;
    public static final int LLVMGlobalAliasValueKind = 6;
    public static final int LLVMGlobalIFuncValueKind = 7;
    public static final int LLVMGlobalVariableValueKind = 8;
    public static final int LLVMBlockAddressValueKind = 9;
    public static final int LLVMConstantExprValueKind = 10;
    public static final int LLVMConstantArrayValueKind = 11;
    public static final int LLVMConstantStructValueKind = 12;
    public static final int LLVMConstantVectorValueKind = 13;
    public static final int LLVMUndefValueValueKind = 14;
    public static final int LLVMConstantAggregateZeroValueKind = 15;
    public static final int LLVMConstantDataArrayValueKind = 16;
    public static final int LLVMConstantDataVectorValueKind = 17;
    public static final int LLVMConstantIntValueKind = 18;
    public static final int LLVMConstantFPValueKind = 19;
    public static final int LLVMConstantPointerNullValueKind = 20;
    public static final int LLVMConstantTokenNoneValueKind = 21;
    public static final int LLVMMetadataAsValueValueKind = 22;
    public static final int LLVMInlineAsmValueKind = 23;
    public static final int LLVMInstructionValueKind = 24;
    public static final int LLVMPoisonValueValueKind = 25;
    public static final int LLVMIntEQ = 32;
    public static final int LLVMIntNE = 33;
    public static final int LLVMIntUGT = 34;
    public static final int LLVMIntUGE = 35;
    public static final int LLVMIntULT = 36;
    public static final int LLVMIntULE = 37;
    public static final int LLVMIntSGT = 38;
    public static final int LLVMIntSGE = 39;
    public static final int LLVMIntSLT = 40;
    public static final int LLVMIntSLE = 41;
    public static final int LLVMRealPredicateFalse = 0;
    public static final int LLVMRealOEQ = 1;
    public static final int LLVMRealOGT = 2;
    public static final int LLVMRealOGE = 3;
    public static final int LLVMRealOLT = 4;
    public static final int LLVMRealOLE = 5;
    public static final int LLVMRealONE = 6;
    public static final int LLVMRealORD = 7;
    public static final int LLVMRealUNO = 8;
    public static final int LLVMRealUEQ = 9;
    public static final int LLVMRealUGT = 10;
    public static final int LLVMRealUGE = 11;
    public static final int LLVMRealULT = 12;
    public static final int LLVMRealULE = 13;
    public static final int LLVMRealUNE = 14;
    public static final int LLVMRealPredicateTrue = 15;
    public static final int LLVMLandingPadCatch = 0;
    public static final int LLVMLandingPadFilter = 1;
    public static final int LLVMNotThreadLocal = 0;
    public static final int LLVMGeneralDynamicTLSModel = 1;
    public static final int LLVMLocalDynamicTLSModel = 2;
    public static final int LLVMInitialExecTLSModel = 3;
    public static final int LLVMLocalExecTLSModel = 4;
    public static final int LLVMAtomicOrderingNotAtomic = 0;
    public static final int LLVMAtomicOrderingUnordered = 1;
    public static final int LLVMAtomicOrderingMonotonic = 2;
    public static final int LLVMAtomicOrderingAcquire = 4;
    public static final int LLVMAtomicOrderingRelease = 5;
    public static final int LLVMAtomicOrderingAcquireRelease = 6;
    public static final int LLVMAtomicOrderingSequentiallyConsistent = 7;
    public static final int LLVMAtomicRMWBinOpXchg = 0;
    public static final int LLVMAtomicRMWBinOpAdd = 1;
    public static final int LLVMAtomicRMWBinOpSub = 2;
    public static final int LLVMAtomicRMWBinOpAnd = 3;
    public static final int LLVMAtomicRMWBinOpNand = 4;
    public static final int LLVMAtomicRMWBinOpOr = 5;
    public static final int LLVMAtomicRMWBinOpXor = 6;
    public static final int LLVMAtomicRMWBinOpMax = 7;
    public static final int LLVMAtomicRMWBinOpMin = 8;
    public static final int LLVMAtomicRMWBinOpUMax = 9;
    public static final int LLVMAtomicRMWBinOpUMin = 10;
    public static final int LLVMAtomicRMWBinOpFAdd = 11;
    public static final int LLVMAtomicRMWBinOpFSub = 12;
    public static final int LLVMDSError = 0;
    public static final int LLVMDSWarning = 1;
    public static final int LLVMDSRemark = 2;
    public static final int LLVMDSNote = 3;
    public static final int LLVMInlineAsmDialectATT = 0;
    public static final int LLVMInlineAsmDialectIntel = 1;
    public static final int LLVMModuleFlagBehaviorError = 0;
    public static final int LLVMModuleFlagBehaviorWarning = 1;
    public static final int LLVMModuleFlagBehaviorRequire = 2;
    public static final int LLVMModuleFlagBehaviorOverride = 3;
    public static final int LLVMModuleFlagBehaviorAppend = 4;
    public static final int LLVMModuleFlagBehaviorAppendUnique = 5;
    public static final int LLVMAttributeReturnIndex = 0;
    public static final int LLVMAttributeFunctionIndex = -1;

    public static SharedLibrary getLibrary() {
        return LLVM;
    }

    protected LLVMCore() {
        throw new UnsupportedOperationException();
    }

    public static void LLVMInitializeCore(@NativeType(value="LLVMPassRegistryRef") long R) {
        long __functionAddress = Functions.InitializeCore;
        if (Checks.CHECKS) {
            Checks.check(R);
        }
        JNI.invokePV(R, __functionAddress);
    }

    public static void LLVMShutdown() {
        long __functionAddress = Functions.Shutdown;
        JNI.invokeV(__functionAddress);
    }

    public static long nLLVMCreateMessage(long Message) {
        long __functionAddress = Functions.CreateMessage;
        return JNI.invokePP(Message, __functionAddress);
    }

    @NativeType(value="char *")
    public static String LLVMCreateMessage(@NativeType(value="char const *") ByteBuffer Message) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Message);
        }
        long __result = LLVMCore.nLLVMCreateMessage(MemoryUtil.memAddress(Message));
        return MemoryUtil.memUTF8(__result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="char *")
    public static String LLVMCreateMessage(@NativeType(value="char const *") CharSequence Message) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Message, true);
            long MessageEncoded = stack.getPointerAddress();
            long __result = LLVMCore.nLLVMCreateMessage(MessageEncoded);
            String string = MemoryUtil.memUTF8(__result);
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nLLVMDisposeMessage(long Message) {
        long __functionAddress = Functions.DisposeMessage;
        JNI.invokePV(Message, __functionAddress);
    }

    public static void LLVMDisposeMessage(@NativeType(value="char *") ByteBuffer Message) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Message);
        }
        LLVMCore.nLLVMDisposeMessage(MemoryUtil.memAddress(Message));
    }

    @NativeType(value="LLVMContextRef")
    public static long LLVMContextCreate() {
        long __functionAddress = Functions.ContextCreate;
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="LLVMContextRef")
    public static long LLVMGetGlobalContext() {
        long __functionAddress = Functions.GetGlobalContext;
        return JNI.invokeP(__functionAddress);
    }

    public static void nLLVMContextSetDiagnosticHandler(long C, long Handler, long DiagnosticContext) {
        long __functionAddress = Functions.ContextSetDiagnosticHandler;
        if (Checks.CHECKS) {
            Checks.check(C);
        }
        JNI.invokePPPV(C, Handler, DiagnosticContext, __functionAddress);
    }

    public static void LLVMContextSetDiagnosticHandler(@NativeType(value="LLVMContextRef") long C, @Nullable @NativeType(value="void (*) (LLVMDiagnosticInfoRef, void *)") LLVMDiagnosticHandlerI Handler, @NativeType(value="void *") long DiagnosticContext) {
        LLVMCore.nLLVMContextSetDiagnosticHandler(C, MemoryUtil.memAddressSafe(Handler), DiagnosticContext);
    }

    public static long nLLVMContextGetDiagnosticHandler(long C) {
        long __functionAddress = Functions.ContextGetDiagnosticHandler;
        if (Checks.CHECKS) {
            Checks.check(C);
        }
        return JNI.invokePP(C, __functionAddress);
    }

    @Nullable
    @NativeType(value="void (*) (LLVMDiagnosticInfoRef, void *)")
    public static LLVMDiagnosticHandler LLVMContextGetDiagnosticHandler(@NativeType(value="LLVMContextRef") long C) {
        return LLVMDiagnosticHandler.createSafe(LLVMCore.nLLVMContextGetDiagnosticHandler(C));
    }

    @NativeType(value="void *")
    public static long LLVMContextGetDiagnosticContext(@NativeType(value="LLVMContextRef") long C) {
        long __functionAddress = Functions.ContextGetDiagnosticContext;
        if (Checks.CHECKS) {
            Checks.check(C);
        }
        return JNI.invokePP(C, __functionAddress);
    }

    public static void nLLVMContextSetYieldCallback(long C, long Callback2, long OpaqueHandle) {
        long __functionAddress = Functions.ContextSetYieldCallback;
        if (Checks.CHECKS) {
            Checks.check(C);
        }
        JNI.invokePPPV(C, Callback2, OpaqueHandle, __functionAddress);
    }

    public static void LLVMContextSetYieldCallback(@NativeType(value="LLVMContextRef") long C, @Nullable @NativeType(value="void (*) (LLVMContextRef, void *)") LLVMYieldCallbackI Callback2, @NativeType(value="void *") long OpaqueHandle) {
        LLVMCore.nLLVMContextSetYieldCallback(C, MemoryUtil.memAddressSafe(Callback2), OpaqueHandle);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMContextShouldDiscardValueNames(@NativeType(value="LLVMContextRef") long C) {
        long __functionAddress = Functions.ContextShouldDiscardValueNames;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(C);
        }
        return JNI.invokePI(C, __functionAddress) != 0;
    }

    public static void LLVMContextSetDiscardValueNames(@NativeType(value="LLVMContextRef") long C, @NativeType(value="LLVMBool") boolean Discard) {
        long __functionAddress = Functions.ContextSetDiscardValueNames;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(C);
        }
        JNI.invokePV(C, Discard ? 1 : 0, __functionAddress);
    }

    public static void LLVMContextDispose(@NativeType(value="LLVMContextRef") long C) {
        long __functionAddress = Functions.ContextDispose;
        if (Checks.CHECKS) {
            Checks.check(C);
        }
        JNI.invokePV(C, __functionAddress);
    }

    public static long nLLVMGetDiagInfoDescription(long DI) {
        long __functionAddress = Functions.GetDiagInfoDescription;
        if (Checks.CHECKS) {
            Checks.check(DI);
        }
        return JNI.invokePP(DI, __functionAddress);
    }

    @NativeType(value="char *")
    public static String LLVMGetDiagInfoDescription(@NativeType(value="LLVMDiagnosticInfoRef") long DI) {
        long __result = LLVMCore.nLLVMGetDiagInfoDescription(DI);
        return MemoryUtil.memUTF8(__result);
    }

    @NativeType(value="LLVMDiagnosticSeverity")
    public static int LLVMGetDiagInfoSeverity(@NativeType(value="LLVMDiagnosticInfoRef") long DI) {
        long __functionAddress = Functions.GetDiagInfoSeverity;
        if (Checks.CHECKS) {
            Checks.check(DI);
        }
        return JNI.invokePI(DI, __functionAddress);
    }

    public static int nLLVMGetMDKindIDInContext(long C, long Name2, int SLen) {
        long __functionAddress = Functions.GetMDKindIDInContext;
        if (Checks.CHECKS) {
            Checks.check(C);
        }
        return JNI.invokePPI(C, Name2, SLen, __functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetMDKindIDInContext(@NativeType(value="LLVMContextRef") long C, @NativeType(value="char const *") ByteBuffer Name2) {
        return LLVMCore.nLLVMGetMDKindIDInContext(C, MemoryUtil.memAddress(Name2), Name2.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="unsigned int")
    public static int LLVMGetMDKindIDInContext(@NativeType(value="LLVMContextRef") long C, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name2, false);
            long NameEncoded = stack.getPointerAddress();
            int n = LLVMCore.nLLVMGetMDKindIDInContext(C, NameEncoded, NameEncodedLength);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nLLVMGetMDKindID(long Name2, int SLen) {
        long __functionAddress = Functions.GetMDKindID;
        return JNI.invokePI(Name2, SLen, __functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetMDKindID(@NativeType(value="char const *") ByteBuffer Name2) {
        return LLVMCore.nLLVMGetMDKindID(MemoryUtil.memAddress(Name2), Name2.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="unsigned int")
    public static int LLVMGetMDKindID(@NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name2, false);
            long NameEncoded = stack.getPointerAddress();
            int n = LLVMCore.nLLVMGetMDKindID(NameEncoded, NameEncodedLength);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nLLVMGetEnumAttributeKindForName(long Name2, long SLen) {
        long __functionAddress = Functions.GetEnumAttributeKindForName;
        return JNI.invokePPI(Name2, SLen, __functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetEnumAttributeKindForName(@NativeType(value="char const *") ByteBuffer Name2) {
        return LLVMCore.nLLVMGetEnumAttributeKindForName(MemoryUtil.memAddress(Name2), Name2.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="unsigned int")
    public static int LLVMGetEnumAttributeKindForName(@NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name2, false);
            long NameEncoded = stack.getPointerAddress();
            int n = LLVMCore.nLLVMGetEnumAttributeKindForName(NameEncoded, NameEncodedLength);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetLastEnumAttributeKind() {
        long __functionAddress = Functions.GetLastEnumAttributeKind;
        return JNI.invokeI(__functionAddress);
    }

    @NativeType(value="LLVMAttributeRef")
    public static long LLVMCreateEnumAttribute(@NativeType(value="LLVMContextRef") long C, @NativeType(value="unsigned int") int KindID, @NativeType(value="uint64_t") long Val) {
        long __functionAddress = Functions.CreateEnumAttribute;
        if (Checks.CHECKS) {
            Checks.check(C);
        }
        return JNI.invokePJP(C, KindID, Val, __functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetEnumAttributeKind(@NativeType(value="LLVMAttributeRef") long A) {
        long __functionAddress = Functions.GetEnumAttributeKind;
        if (Checks.CHECKS) {
            Checks.check(A);
        }
        return JNI.invokePI(A, __functionAddress);
    }

    @NativeType(value="uint64_t")
    public static long LLVMGetEnumAttributeValue(@NativeType(value="LLVMAttributeRef") long A) {
        long __functionAddress = Functions.GetEnumAttributeValue;
        if (Checks.CHECKS) {
            Checks.check(A);
        }
        return JNI.invokePJ(A, __functionAddress);
    }

    @NativeType(value="LLVMAttributeRef")
    public static long LLVMCreateTypeAttribute(@NativeType(value="LLVMContextRef") long C, @NativeType(value="unsigned") int KindID, @NativeType(value="LLVMTypeRef") long type_ref) {
        long __functionAddress = Functions.CreateTypeAttribute;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(C);
            Checks.check(type_ref);
        }
        return JNI.invokePPP(C, KindID, type_ref, __functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMGetTypeAttributeValue(@NativeType(value="LLVMAttributeRef") long A) {
        long __functionAddress = Functions.GetTypeAttributeValue;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(A);
        }
        return JNI.invokePP(A, __functionAddress);
    }

    public static long nLLVMCreateStringAttribute(long C, long K, int KLength, long V, int VLength) {
        long __functionAddress = Functions.CreateStringAttribute;
        if (Checks.CHECKS) {
            Checks.check(C);
        }
        return JNI.invokePPPP(C, K, KLength, V, VLength, __functionAddress);
    }

    @NativeType(value="LLVMAttributeRef")
    public static long LLVMCreateStringAttribute(@NativeType(value="LLVMContextRef") long C, @NativeType(value="char const *") ByteBuffer K, @NativeType(value="char const *") ByteBuffer V) {
        return LLVMCore.nLLVMCreateStringAttribute(C, MemoryUtil.memAddress(K), K.remaining(), MemoryUtil.memAddress(V), V.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMAttributeRef")
    public static long LLVMCreateStringAttribute(@NativeType(value="LLVMContextRef") long C, @NativeType(value="char const *") CharSequence K, @NativeType(value="char const *") CharSequence V) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int KEncodedLength = stack.nUTF8(K, false);
            long KEncoded = stack.getPointerAddress();
            int VEncodedLength = stack.nUTF8(V, false);
            long VEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMCreateStringAttribute(C, KEncoded, KEncodedLength, VEncoded, VEncodedLength);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMGetStringAttributeKind(long A, long Length) {
        long __functionAddress = Functions.GetStringAttributeKind;
        if (Checks.CHECKS) {
            Checks.check(A);
        }
        return JNI.invokePPP(A, Length, __functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="char const *")
    public static String LLVMGetStringAttributeKind(@NativeType(value="LLVMAttributeRef") long A) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer Length = stack.callocInt(1);
            long __result = LLVMCore.nLLVMGetStringAttributeKind(A, MemoryUtil.memAddress(Length));
            String string = MemoryUtil.memUTF8(__result, Length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMGetStringAttributeValue(long A, long Length) {
        long __functionAddress = Functions.GetStringAttributeValue;
        if (Checks.CHECKS) {
            Checks.check(A);
        }
        return JNI.invokePPP(A, Length, __functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="char const *")
    public static String LLVMGetStringAttributeValue(@NativeType(value="LLVMAttributeRef") long A) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer Length = stack.callocInt(1);
            long __result = LLVMCore.nLLVMGetStringAttributeValue(A, MemoryUtil.memAddress(Length));
            String string = MemoryUtil.memUTF8(__result, Length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsEnumAttribute(@NativeType(value="LLVMAttributeRef") long A) {
        long __functionAddress = Functions.IsEnumAttribute;
        if (Checks.CHECKS) {
            Checks.check(A);
        }
        return JNI.invokePI(A, __functionAddress) != 0;
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsStringAttribute(@NativeType(value="LLVMAttributeRef") long A) {
        long __functionAddress = Functions.IsStringAttribute;
        if (Checks.CHECKS) {
            Checks.check(A);
        }
        return JNI.invokePI(A, __functionAddress) != 0;
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsTypeAttribute(@NativeType(value="LLVMAttributeRef") long A) {
        long __functionAddress = Functions.IsTypeAttribute;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(A);
        }
        return JNI.invokePI(A, __functionAddress) != 0;
    }

    public static long nLLVMGetTypeByName2(long C, long Name2) {
        long __functionAddress = Functions.GetTypeByName2;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(C);
        }
        return JNI.invokePPP(C, Name2, __functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMGetTypeByName2(@NativeType(value="LLVMContextRef") long C, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMGetTypeByName2(C, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMTypeRef")
    public static long LLVMGetTypeByName2(@NativeType(value="LLVMContextRef") long C, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMGetTypeByName2(C, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMModuleCreateWithName(long ModuleID) {
        long __functionAddress = Functions.ModuleCreateWithName;
        return JNI.invokePP(ModuleID, __functionAddress);
    }

    @NativeType(value="LLVMModuleRef")
    public static long LLVMModuleCreateWithName(@NativeType(value="char const *") ByteBuffer ModuleID) {
        if (Checks.CHECKS) {
            Checks.checkNT1(ModuleID);
        }
        return LLVMCore.nLLVMModuleCreateWithName(MemoryUtil.memAddress(ModuleID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMModuleRef")
    public static long LLVMModuleCreateWithName(@NativeType(value="char const *") CharSequence ModuleID) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(ModuleID, true);
            long ModuleIDEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMModuleCreateWithName(ModuleIDEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMModuleCreateWithNameInContext(long ModuleID, long C) {
        long __functionAddress = Functions.ModuleCreateWithNameInContext;
        if (Checks.CHECKS) {
            Checks.check(C);
        }
        return JNI.invokePPP(ModuleID, C, __functionAddress);
    }

    @NativeType(value="LLVMModuleRef")
    public static long LLVMModuleCreateWithNameInContext(@NativeType(value="char const *") ByteBuffer ModuleID, @NativeType(value="LLVMContextRef") long C) {
        if (Checks.CHECKS) {
            Checks.checkNT1(ModuleID);
        }
        return LLVMCore.nLLVMModuleCreateWithNameInContext(MemoryUtil.memAddress(ModuleID), C);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMModuleRef")
    public static long LLVMModuleCreateWithNameInContext(@NativeType(value="char const *") CharSequence ModuleID, @NativeType(value="LLVMContextRef") long C) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(ModuleID, true);
            long ModuleIDEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMModuleCreateWithNameInContext(ModuleIDEncoded, C);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMModuleRef")
    public static long LLVMCloneModule(@NativeType(value="LLVMModuleRef") long M) {
        long __functionAddress = Functions.CloneModule;
        if (Checks.CHECKS) {
            Checks.check(M);
        }
        return JNI.invokePP(M, __functionAddress);
    }

    public static void LLVMDisposeModule(@NativeType(value="LLVMModuleRef") long M) {
        long __functionAddress = Functions.DisposeModule;
        if (Checks.CHECKS) {
            Checks.check(M);
        }
        JNI.invokePV(M, __functionAddress);
    }

    public static long nLLVMGetModuleIdentifier(long M, long Len) {
        long __functionAddress = Functions.GetModuleIdentifier;
        if (Checks.CHECKS) {
            Checks.check(M);
        }
        return JNI.invokePPP(M, Len, __functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="char const *")
    public static String LLVMGetModuleIdentifier(@NativeType(value="LLVMModuleRef") long M) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer Len = stack.callocPointer(1);
            long __result = LLVMCore.nLLVMGetModuleIdentifier(M, MemoryUtil.memAddress(Len));
            String string = MemoryUtil.memUTF8(__result, (int)Len.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nLLVMSetModuleIdentifier(long M, long Ident, long Len) {
        long __functionAddress = Functions.SetModuleIdentifier;
        if (Checks.CHECKS) {
            Checks.check(M);
        }
        JNI.invokePPPV(M, Ident, Len, __functionAddress);
    }

    public static void LLVMSetModuleIdentifier(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") ByteBuffer Ident) {
        LLVMCore.nLLVMSetModuleIdentifier(M, MemoryUtil.memAddress(Ident), Ident.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void LLVMSetModuleIdentifier(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") CharSequence Ident) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int IdentEncodedLength = stack.nUTF8(Ident, false);
            long IdentEncoded = stack.getPointerAddress();
            LLVMCore.nLLVMSetModuleIdentifier(M, IdentEncoded, IdentEncodedLength);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMGetSourceFileName(long M, long Len) {
        long __functionAddress = Functions.GetSourceFileName;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(M);
        }
        return JNI.invokePPP(M, Len, __functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="char const *")
    public static String LLVMGetSourceFileName(@NativeType(value="LLVMModuleRef") long M) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer Len = stack.callocPointer(1);
            long __result = LLVMCore.nLLVMGetSourceFileName(M, MemoryUtil.memAddress(Len));
            String string = MemoryUtil.memUTF8(__result, (int)Len.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nLLVMSetSourceFileName(long M, long Name2, long Len) {
        long __functionAddress = Functions.SetSourceFileName;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(M);
        }
        JNI.invokePPPV(M, Name2, Len, __functionAddress);
    }

    public static void LLVMSetSourceFileName(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") ByteBuffer Name2) {
        LLVMCore.nLLVMSetSourceFileName(M, MemoryUtil.memAddress(Name2), Name2.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void LLVMSetSourceFileName(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name2, false);
            long NameEncoded = stack.getPointerAddress();
            LLVMCore.nLLVMSetSourceFileName(M, NameEncoded, NameEncodedLength);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMGetDataLayoutStr(long M) {
        long __functionAddress = Functions.GetDataLayoutStr;
        if (Checks.CHECKS) {
            Checks.check(M);
        }
        return JNI.invokePP(M, __functionAddress);
    }

    @NativeType(value="char const *")
    public static String LLVMGetDataLayoutStr(@NativeType(value="LLVMModuleRef") long M) {
        long __result = LLVMCore.nLLVMGetDataLayoutStr(M);
        return MemoryUtil.memUTF8(__result);
    }

    public static long nLLVMGetDataLayout(long M) {
        long __functionAddress = Functions.GetDataLayout;
        if (Checks.CHECKS) {
            Checks.check(M);
        }
        return JNI.invokePP(M, __functionAddress);
    }

    @NativeType(value="char const *")
    public static String LLVMGetDataLayout(@NativeType(value="LLVMModuleRef") long M) {
        long __result = LLVMCore.nLLVMGetDataLayout(M);
        return MemoryUtil.memUTF8(__result);
    }

    public static void nLLVMSetDataLayout(long M, long DataLayoutStr) {
        long __functionAddress = Functions.SetDataLayout;
        if (Checks.CHECKS) {
            Checks.check(M);
        }
        JNI.invokePPV(M, DataLayoutStr, __functionAddress);
    }

    public static void LLVMSetDataLayout(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") ByteBuffer DataLayoutStr) {
        if (Checks.CHECKS) {
            Checks.checkNT1(DataLayoutStr);
        }
        LLVMCore.nLLVMSetDataLayout(M, MemoryUtil.memAddress(DataLayoutStr));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void LLVMSetDataLayout(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") CharSequence DataLayoutStr) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(DataLayoutStr, true);
            long DataLayoutStrEncoded = stack.getPointerAddress();
            LLVMCore.nLLVMSetDataLayout(M, DataLayoutStrEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMGetTarget(long M) {
        long __functionAddress = Functions.GetTarget;
        if (Checks.CHECKS) {
            Checks.check(M);
        }
        return JNI.invokePP(M, __functionAddress);
    }

    @NativeType(value="char const *")
    public static String LLVMGetTarget(@NativeType(value="LLVMModuleRef") long M) {
        long __result = LLVMCore.nLLVMGetTarget(M);
        return MemoryUtil.memUTF8(__result);
    }

    public static void nLLVMSetTarget(long M, long Triple) {
        long __functionAddress = Functions.SetTarget;
        if (Checks.CHECKS) {
            Checks.check(M);
        }
        JNI.invokePPV(M, Triple, __functionAddress);
    }

    public static void LLVMSetTarget(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") ByteBuffer Triple) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Triple);
        }
        LLVMCore.nLLVMSetTarget(M, MemoryUtil.memAddress(Triple));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void LLVMSetTarget(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") CharSequence Triple) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Triple, true);
            long TripleEncoded = stack.getPointerAddress();
            LLVMCore.nLLVMSetTarget(M, TripleEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMCopyModuleFlagsMetadata(long M, long Len) {
        long __functionAddress = Functions.CopyModuleFlagsMetadata;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(M);
        }
        return JNI.invokePPP(M, Len, __functionAddress);
    }

    @NativeType(value="LLVMModuleFlagEntry *")
    public static long LLVMCopyModuleFlagsMetadata(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="size_t *") PointerBuffer Len) {
        if (Checks.CHECKS) {
            Checks.check(Len, 1);
        }
        return LLVMCore.nLLVMCopyModuleFlagsMetadata(M, MemoryUtil.memAddress(Len));
    }

    public static void LLVMDisposeModuleFlagsMetadata(@NativeType(value="LLVMModuleFlagEntry *") long Entries) {
        long __functionAddress = Functions.DisposeModuleFlagsMetadata;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Entries);
        }
        JNI.invokePV(Entries, __functionAddress);
    }

    @NativeType(value="LLVMModuleFlagBehavior")
    public static int LLVMModuleFlagEntriesGetFlagBehavior(@NativeType(value="LLVMModuleFlagEntry *") long Entries, @NativeType(value="unsigned int") int Index) {
        long __functionAddress = Functions.ModuleFlagEntriesGetFlagBehavior;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Entries);
        }
        return JNI.invokePI(Entries, Index, __functionAddress);
    }

    public static long nLLVMModuleFlagEntriesGetKey(long Entries, int Index, long Len) {
        long __functionAddress = Functions.ModuleFlagEntriesGetKey;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Entries);
        }
        return JNI.invokePPP(Entries, Index, Len, __functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="char const *")
    public static String LLVMModuleFlagEntriesGetKey(@NativeType(value="LLVMModuleFlagEntry *") long Entries, @NativeType(value="unsigned int") int Index) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer Len = stack.callocPointer(1);
            long __result = LLVMCore.nLLVMModuleFlagEntriesGetKey(Entries, Index, MemoryUtil.memAddress(Len));
            String string = MemoryUtil.memUTF8(__result, (int)Len.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMModuleFlagEntriesGetMetadata(@NativeType(value="LLVMModuleFlagEntry *") long Entries, @NativeType(value="unsigned int") int Index) {
        long __functionAddress = Functions.ModuleFlagEntriesGetMetadata;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Entries);
        }
        return JNI.invokePP(Entries, Index, __functionAddress);
    }

    public static long nLLVMGetModuleFlag(long M, long Key, long KeyLen) {
        long __functionAddress = Functions.GetModuleFlag;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(M);
        }
        return JNI.invokePPPP(M, Key, KeyLen, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMGetModuleFlag(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") ByteBuffer Key) {
        return LLVMCore.nLLVMGetModuleFlag(M, MemoryUtil.memAddress(Key), Key.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMGetModuleFlag(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") CharSequence Key) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int KeyEncodedLength = stack.nUTF8(Key, false);
            long KeyEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMGetModuleFlag(M, KeyEncoded, KeyEncodedLength);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nLLVMAddModuleFlag(long M, int Behavior, long Key, long KeyLen, long Val) {
        long __functionAddress = Functions.AddModuleFlag;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(M);
            Checks.check(Val);
        }
        JNI.invokePPPPV(M, Behavior, Key, KeyLen, Val, __functionAddress);
    }

    public static void LLVMAddModuleFlag(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="LLVMModuleFlagBehavior") int Behavior, @NativeType(value="char const *") ByteBuffer Key, @NativeType(value="LLVMMetadataRef") long Val) {
        LLVMCore.nLLVMAddModuleFlag(M, Behavior, MemoryUtil.memAddress(Key), Key.remaining(), Val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void LLVMAddModuleFlag(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="LLVMModuleFlagBehavior") int Behavior, @NativeType(value="char const *") CharSequence Key, @NativeType(value="LLVMMetadataRef") long Val) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int KeyEncodedLength = stack.nUTF8(Key, false);
            long KeyEncoded = stack.getPointerAddress();
            LLVMCore.nLLVMAddModuleFlag(M, Behavior, KeyEncoded, KeyEncodedLength, Val);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void LLVMDumpModule(@NativeType(value="LLVMModuleRef") long M) {
        long __functionAddress = Functions.DumpModule;
        if (Checks.CHECKS) {
            Checks.check(M);
        }
        JNI.invokePV(M, __functionAddress);
    }

    public static int nLLVMPrintModuleToFile(long M, long Filename, long ErrorMessage) {
        long __functionAddress = Functions.PrintModuleToFile;
        if (Checks.CHECKS) {
            Checks.check(M);
        }
        return JNI.invokePPPI(M, Filename, ErrorMessage, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMPrintModuleToFile(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") ByteBuffer Filename, @NativeType(value="char **") PointerBuffer ErrorMessage) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Filename);
            Checks.check(ErrorMessage, 1);
        }
        return LLVMCore.nLLVMPrintModuleToFile(M, MemoryUtil.memAddress(Filename), MemoryUtil.memAddress(ErrorMessage)) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMBool")
    public static boolean LLVMPrintModuleToFile(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") CharSequence Filename, @NativeType(value="char **") PointerBuffer ErrorMessage) {
        if (Checks.CHECKS) {
            Checks.check(ErrorMessage, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Filename, true);
            long FilenameEncoded = stack.getPointerAddress();
            boolean bl = LLVMCore.nLLVMPrintModuleToFile(M, FilenameEncoded, MemoryUtil.memAddress(ErrorMessage)) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMPrintModuleToString(long M) {
        long __functionAddress = Functions.PrintModuleToString;
        if (Checks.CHECKS) {
            Checks.check(M);
        }
        return JNI.invokePP(M, __functionAddress);
    }

    @NativeType(value="char *")
    public static String LLVMPrintModuleToString(@NativeType(value="LLVMModuleRef") long M) {
        long __result = LLVMCore.nLLVMPrintModuleToString(M);
        return MemoryUtil.memUTF8(__result);
    }

    public static long nLLVMGetModuleInlineAsm(long M, long Len) {
        long __functionAddress = Functions.GetModuleInlineAsm;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(M);
        }
        return JNI.invokePPP(M, Len, __functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="char const *")
    public static String LLVMGetModuleInlineAsm(@NativeType(value="LLVMModuleRef") long M) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer Len = stack.callocPointer(1);
            long __result = LLVMCore.nLLVMGetModuleInlineAsm(M, MemoryUtil.memAddress(Len));
            String string = MemoryUtil.memUTF8(__result, (int)Len.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nLLVMSetModuleInlineAsm2(long M, long Asm, long Len) {
        long __functionAddress = Functions.SetModuleInlineAsm2;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(M);
        }
        JNI.invokePPPV(M, Asm, Len, __functionAddress);
    }

    public static void LLVMSetModuleInlineAsm2(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") ByteBuffer Asm) {
        LLVMCore.nLLVMSetModuleInlineAsm2(M, MemoryUtil.memAddress(Asm), Asm.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void LLVMSetModuleInlineAsm2(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") CharSequence Asm) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int AsmEncodedLength = stack.nUTF8(Asm, false);
            long AsmEncoded = stack.getPointerAddress();
            LLVMCore.nLLVMSetModuleInlineAsm2(M, AsmEncoded, AsmEncodedLength);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nLLVMAppendModuleInlineAsm(long M, long Asm, long Len) {
        long __functionAddress = Functions.AppendModuleInlineAsm;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(M);
        }
        JNI.invokePPPV(M, Asm, Len, __functionAddress);
    }

    public static void LLVMAppendModuleInlineAsm(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") ByteBuffer Asm) {
        LLVMCore.nLLVMAppendModuleInlineAsm(M, MemoryUtil.memAddress(Asm), Asm.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void LLVMAppendModuleInlineAsm(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") CharSequence Asm) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int AsmEncodedLength = stack.nUTF8(Asm, false);
            long AsmEncoded = stack.getPointerAddress();
            LLVMCore.nLLVMAppendModuleInlineAsm(M, AsmEncoded, AsmEncodedLength);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMGetInlineAsm(long Ty, long AsmString, long AsmStringSize, long Constraints, long ConstraintsSize, int HasSideEffects, int IsAlignStack, int Dialect, int CanThrow) {
        long __functionAddress = Functions.GetInlineAsm;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Ty);
        }
        return JNI.invokePPPPPP(Ty, AsmString, AsmStringSize, Constraints, ConstraintsSize, HasSideEffects, IsAlignStack, Dialect, CanThrow, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetInlineAsm(@NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="char *") ByteBuffer AsmString, @NativeType(value="char *") ByteBuffer Constraints, @NativeType(value="LLVMBool") boolean HasSideEffects, @NativeType(value="LLVMBool") boolean IsAlignStack, @NativeType(value="LLVMInlineAsmDialect") int Dialect, @NativeType(value="LLVMBool") boolean CanThrow) {
        return LLVMCore.nLLVMGetInlineAsm(Ty, MemoryUtil.memAddress(AsmString), AsmString.remaining(), MemoryUtil.memAddress(Constraints), Constraints.remaining(), HasSideEffects ? 1 : 0, IsAlignStack ? 1 : 0, Dialect, CanThrow ? 1 : 0);
    }

    @NativeType(value="LLVMContextRef")
    public static long LLVMGetModuleContext(@NativeType(value="LLVMModuleRef") long M) {
        long __functionAddress = Functions.GetModuleContext;
        if (Checks.CHECKS) {
            Checks.check(M);
        }
        return JNI.invokePP(M, __functionAddress);
    }

    public static long nLLVMGetTypeByName(long M, long Name2) {
        long __functionAddress = Functions.GetTypeByName;
        if (Checks.CHECKS) {
            Checks.check(M);
        }
        return JNI.invokePPP(M, Name2, __functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMGetTypeByName(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMGetTypeByName(M, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMTypeRef")
    public static long LLVMGetTypeByName(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMGetTypeByName(M, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMNamedMDNodeRef")
    public static long LLVMGetFirstNamedMetadata(@NativeType(value="LLVMModuleRef") long M) {
        long __functionAddress = Functions.GetFirstNamedMetadata;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(M);
        }
        return JNI.invokePP(M, __functionAddress);
    }

    @NativeType(value="LLVMNamedMDNodeRef")
    public static long LLVMGetLastNamedMetadata(@NativeType(value="LLVMModuleRef") long M) {
        long __functionAddress = Functions.GetLastNamedMetadata;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(M);
        }
        return JNI.invokePP(M, __functionAddress);
    }

    @NativeType(value="LLVMNamedMDNodeRef")
    public static long LLVMGetNextNamedMetadata(@NativeType(value="LLVMNamedMDNodeRef") long NamedMDNode) {
        long __functionAddress = Functions.GetNextNamedMetadata;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(NamedMDNode);
        }
        return JNI.invokePP(NamedMDNode, __functionAddress);
    }

    @NativeType(value="LLVMNamedMDNodeRef")
    public static long LLVMGetPreviousNamedMetadata(@NativeType(value="LLVMNamedMDNodeRef") long NamedMDNode) {
        long __functionAddress = Functions.GetPreviousNamedMetadata;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(NamedMDNode);
        }
        return JNI.invokePP(NamedMDNode, __functionAddress);
    }

    public static long nLLVMGetNamedMetadata(long M, long Name2, long NameLen) {
        long __functionAddress = Functions.GetNamedMetadata;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(M);
        }
        return JNI.invokePPPP(M, Name2, NameLen, __functionAddress);
    }

    @NativeType(value="LLVMNamedMDNodeRef")
    public static long LLVMGetNamedMetadata(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") ByteBuffer Name2) {
        return LLVMCore.nLLVMGetNamedMetadata(M, MemoryUtil.memAddress(Name2), Name2.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMNamedMDNodeRef")
    public static long LLVMGetNamedMetadata(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name2, false);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMGetNamedMetadata(M, NameEncoded, NameEncodedLength);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMGetOrInsertNamedMetadata(long M, long Name2, long NameLen) {
        long __functionAddress = Functions.GetOrInsertNamedMetadata;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(M);
        }
        return JNI.invokePPPP(M, Name2, NameLen, __functionAddress);
    }

    @NativeType(value="LLVMNamedMDNodeRef")
    public static long LLVMGetOrInsertNamedMetadata(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") ByteBuffer Name2) {
        return LLVMCore.nLLVMGetOrInsertNamedMetadata(M, MemoryUtil.memAddress(Name2), Name2.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMNamedMDNodeRef")
    public static long LLVMGetOrInsertNamedMetadata(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name2, false);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMGetOrInsertNamedMetadata(M, NameEncoded, NameEncodedLength);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMGetNamedMetadataName(long NamedMD, long NameLen) {
        long __functionAddress = Functions.GetNamedMetadataName;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(NamedMD);
        }
        return JNI.invokePPP(NamedMD, NameLen, __functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="char const *")
    public static String LLVMGetNamedMetadataName(@NativeType(value="LLVMNamedMDNodeRef") long NamedMD) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer NameLen = stack.callocPointer(1);
            long __result = LLVMCore.nLLVMGetNamedMetadataName(NamedMD, MemoryUtil.memAddress(NameLen));
            String string = MemoryUtil.memUTF8(__result, (int)NameLen.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nLLVMGetNamedMetadataNumOperands(long M, long Name2) {
        long __functionAddress = Functions.GetNamedMetadataNumOperands;
        if (Checks.CHECKS) {
            Checks.check(M);
        }
        return JNI.invokePPI(M, Name2, __functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetNamedMetadataNumOperands(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMGetNamedMetadataNumOperands(M, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="unsigned int")
    public static int LLVMGetNamedMetadataNumOperands(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            int n = LLVMCore.nLLVMGetNamedMetadataNumOperands(M, NameEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nLLVMGetNamedMetadataOperands(long M, long Name2, long Dest) {
        long __functionAddress = Functions.GetNamedMetadataOperands;
        if (Checks.CHECKS) {
            Checks.check(M);
        }
        JNI.invokePPPV(M, Name2, Dest, __functionAddress);
    }

    public static void LLVMGetNamedMetadataOperands(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") ByteBuffer Name2, @NativeType(value="LLVMValueRef *") PointerBuffer Dest) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
            if (Checks.DEBUG) {
                Checks.check(Dest, LLVMCore.LLVMGetNamedMetadataNumOperands(M, Name2));
            }
        }
        LLVMCore.nLLVMGetNamedMetadataOperands(M, MemoryUtil.memAddress(Name2), MemoryUtil.memAddress(Dest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void LLVMGetNamedMetadataOperands(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") CharSequence Name2, @NativeType(value="LLVMValueRef *") PointerBuffer Dest) {
        if (Checks.CHECKS && Checks.DEBUG) {
            Checks.check(Dest, LLVMCore.LLVMGetNamedMetadataNumOperands(M, Name2));
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            LLVMCore.nLLVMGetNamedMetadataOperands(M, NameEncoded, MemoryUtil.memAddress(Dest));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nLLVMAddNamedMetadataOperand(long M, long Name2, long Val) {
        long __functionAddress = Functions.AddNamedMetadataOperand;
        if (Checks.CHECKS) {
            Checks.check(M);
            Checks.check(Val);
        }
        JNI.invokePPPV(M, Name2, Val, __functionAddress);
    }

    public static void LLVMAddNamedMetadataOperand(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") ByteBuffer Name2, @NativeType(value="LLVMValueRef") long Val) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        LLVMCore.nLLVMAddNamedMetadataOperand(M, MemoryUtil.memAddress(Name2), Val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void LLVMAddNamedMetadataOperand(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") CharSequence Name2, @NativeType(value="LLVMValueRef") long Val) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            LLVMCore.nLLVMAddNamedMetadataOperand(M, NameEncoded, Val);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMGetDebugLocDirectory(long Val, long Length) {
        long __functionAddress = Functions.GetDebugLocDirectory;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Val);
        }
        return JNI.invokePPP(Val, Length, __functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="char const *")
    public static String LLVMGetDebugLocDirectory(@NativeType(value="LLVMValueRef") long Val) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer Length = stack.callocInt(1);
            long __result = LLVMCore.nLLVMGetDebugLocDirectory(Val, MemoryUtil.memAddress(Length));
            String string = MemoryUtil.memUTF8Safe(__result, Length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMGetDebugLocFilename(long Val, long Length) {
        long __functionAddress = Functions.GetDebugLocFilename;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Val);
        }
        return JNI.invokePPP(Val, Length, __functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="char const *")
    public static String LLVMGetDebugLocFilename(@NativeType(value="LLVMValueRef") long Val) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer Length = stack.callocInt(1);
            long __result = LLVMCore.nLLVMGetDebugLocFilename(Val, MemoryUtil.memAddress(Length));
            String string = MemoryUtil.memUTF8Safe(__result, Length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetDebugLocLine(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.GetDebugLocLine;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Val);
        }
        return JNI.invokePI(Val, __functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetDebugLocColumn(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.GetDebugLocColumn;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Val);
        }
        return JNI.invokePI(Val, __functionAddress);
    }

    public static long nLLVMAddFunction(long M, long Name2, long FunctionTy) {
        long __functionAddress = Functions.AddFunction;
        if (Checks.CHECKS) {
            Checks.check(M);
            Checks.check(FunctionTy);
        }
        return JNI.invokePPPP(M, Name2, FunctionTy, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMAddFunction(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") ByteBuffer Name2, @NativeType(value="LLVMTypeRef") long FunctionTy) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMAddFunction(M, MemoryUtil.memAddress(Name2), FunctionTy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMAddFunction(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") CharSequence Name2, @NativeType(value="LLVMTypeRef") long FunctionTy) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMAddFunction(M, NameEncoded, FunctionTy);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMGetNamedFunction(long M, long Name2) {
        long __functionAddress = Functions.GetNamedFunction;
        if (Checks.CHECKS) {
            Checks.check(M);
        }
        return JNI.invokePPP(M, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetNamedFunction(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMGetNamedFunction(M, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMGetNamedFunction(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMGetNamedFunction(M, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetFirstFunction(@NativeType(value="LLVMModuleRef") long M) {
        long __functionAddress = Functions.GetFirstFunction;
        if (Checks.CHECKS) {
            Checks.check(M);
        }
        return JNI.invokePP(M, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetLastFunction(@NativeType(value="LLVMModuleRef") long M) {
        long __functionAddress = Functions.GetLastFunction;
        if (Checks.CHECKS) {
            Checks.check(M);
        }
        return JNI.invokePP(M, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetNextFunction(@NativeType(value="LLVMValueRef") long Fn) {
        long __functionAddress = Functions.GetNextFunction;
        if (Checks.CHECKS) {
            Checks.check(Fn);
        }
        return JNI.invokePP(Fn, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetPreviousFunction(@NativeType(value="LLVMValueRef") long Fn) {
        long __functionAddress = Functions.GetPreviousFunction;
        if (Checks.CHECKS) {
            Checks.check(Fn);
        }
        return JNI.invokePP(Fn, __functionAddress);
    }

    public static void nLLVMSetModuleInlineAsm(long M, long Asm) {
        long __functionAddress = Functions.SetModuleInlineAsm;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(M);
        }
        JNI.invokePPV(M, Asm, __functionAddress);
    }

    public static void LLVMSetModuleInlineAsm(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") ByteBuffer Asm) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Asm);
        }
        LLVMCore.nLLVMSetModuleInlineAsm(M, MemoryUtil.memAddress(Asm));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void LLVMSetModuleInlineAsm(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") CharSequence Asm) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Asm, true);
            long AsmEncoded = stack.getPointerAddress();
            LLVMCore.nLLVMSetModuleInlineAsm(M, AsmEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMTypeKind")
    public static int LLVMGetTypeKind(@NativeType(value="LLVMTypeRef") long Ty) {
        long __functionAddress = Functions.GetTypeKind;
        if (Checks.CHECKS) {
            Checks.check(Ty);
        }
        return JNI.invokePI(Ty, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMTypeIsSized(@NativeType(value="LLVMTypeRef") long Ty) {
        long __functionAddress = Functions.TypeIsSized;
        if (Checks.CHECKS) {
            Checks.check(Ty);
        }
        return JNI.invokePI(Ty, __functionAddress) != 0;
    }

    @NativeType(value="LLVMContextRef")
    public static long LLVMGetTypeContext(@NativeType(value="LLVMTypeRef") long Ty) {
        long __functionAddress = Functions.GetTypeContext;
        if (Checks.CHECKS) {
            Checks.check(Ty);
        }
        return JNI.invokePP(Ty, __functionAddress);
    }

    public static void LLVMDumpType(@NativeType(value="LLVMTypeRef") long Val) {
        long __functionAddress = Functions.DumpType;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Val);
        }
        JNI.invokePV(Val, __functionAddress);
    }

    public static long nLLVMPrintTypeToString(long Val) {
        long __functionAddress = Functions.PrintTypeToString;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="char *")
    public static String LLVMPrintTypeToString(@NativeType(value="LLVMTypeRef") long Val) {
        long __result = LLVMCore.nLLVMPrintTypeToString(Val);
        return MemoryUtil.memUTF8(__result);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMInt1TypeInContext(@NativeType(value="LLVMContextRef") long C) {
        long __functionAddress = Functions.Int1TypeInContext;
        if (Checks.CHECKS) {
            Checks.check(C);
        }
        return JNI.invokePP(C, __functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMInt8TypeInContext(@NativeType(value="LLVMContextRef") long C) {
        long __functionAddress = Functions.Int8TypeInContext;
        if (Checks.CHECKS) {
            Checks.check(C);
        }
        return JNI.invokePP(C, __functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMInt16TypeInContext(@NativeType(value="LLVMContextRef") long C) {
        long __functionAddress = Functions.Int16TypeInContext;
        if (Checks.CHECKS) {
            Checks.check(C);
        }
        return JNI.invokePP(C, __functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMInt32TypeInContext(@NativeType(value="LLVMContextRef") long C) {
        long __functionAddress = Functions.Int32TypeInContext;
        if (Checks.CHECKS) {
            Checks.check(C);
        }
        return JNI.invokePP(C, __functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMInt64TypeInContext(@NativeType(value="LLVMContextRef") long C) {
        long __functionAddress = Functions.Int64TypeInContext;
        if (Checks.CHECKS) {
            Checks.check(C);
        }
        return JNI.invokePP(C, __functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMInt128TypeInContext(@NativeType(value="LLVMContextRef") long C) {
        long __functionAddress = Functions.Int128TypeInContext;
        if (Checks.CHECKS) {
            Checks.check(C);
        }
        return JNI.invokePP(C, __functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMIntTypeInContext(@NativeType(value="LLVMContextRef") long C, @NativeType(value="unsigned int") int NumBits) {
        long __functionAddress = Functions.IntTypeInContext;
        if (Checks.CHECKS) {
            Checks.check(C);
        }
        return JNI.invokePP(C, NumBits, __functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMInt1Type() {
        long __functionAddress = Functions.Int1Type;
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMInt8Type() {
        long __functionAddress = Functions.Int8Type;
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMInt16Type() {
        long __functionAddress = Functions.Int16Type;
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMInt32Type() {
        long __functionAddress = Functions.Int32Type;
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMInt64Type() {
        long __functionAddress = Functions.Int64Type;
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMInt128Type() {
        long __functionAddress = Functions.Int128Type;
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMIntType(@NativeType(value="unsigned int") int NumBits) {
        long __functionAddress = Functions.IntType;
        return JNI.invokeP(NumBits, __functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetIntTypeWidth(@NativeType(value="LLVMTypeRef") long IntegerTy) {
        long __functionAddress = Functions.GetIntTypeWidth;
        if (Checks.CHECKS) {
            Checks.check(IntegerTy);
        }
        return JNI.invokePI(IntegerTy, __functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMHalfTypeInContext(@NativeType(value="LLVMContextRef") long C) {
        long __functionAddress = Functions.HalfTypeInContext;
        if (Checks.CHECKS) {
            Checks.check(C);
        }
        return JNI.invokePP(C, __functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMBFloatTypeInContext(@NativeType(value="LLVMContextRef") long C) {
        long __functionAddress = Functions.BFloatTypeInContext;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(C);
        }
        return JNI.invokePP(C, __functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMFloatTypeInContext(@NativeType(value="LLVMContextRef") long C) {
        long __functionAddress = Functions.FloatTypeInContext;
        if (Checks.CHECKS) {
            Checks.check(C);
        }
        return JNI.invokePP(C, __functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMDoubleTypeInContext(@NativeType(value="LLVMContextRef") long C) {
        long __functionAddress = Functions.DoubleTypeInContext;
        if (Checks.CHECKS) {
            Checks.check(C);
        }
        return JNI.invokePP(C, __functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMX86FP80TypeInContext(@NativeType(value="LLVMContextRef") long C) {
        long __functionAddress = Functions.X86FP80TypeInContext;
        if (Checks.CHECKS) {
            Checks.check(C);
        }
        return JNI.invokePP(C, __functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMFP128TypeInContext(@NativeType(value="LLVMContextRef") long C) {
        long __functionAddress = Functions.FP128TypeInContext;
        if (Checks.CHECKS) {
            Checks.check(C);
        }
        return JNI.invokePP(C, __functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMPPCFP128TypeInContext(@NativeType(value="LLVMContextRef") long C) {
        long __functionAddress = Functions.PPCFP128TypeInContext;
        if (Checks.CHECKS) {
            Checks.check(C);
        }
        return JNI.invokePP(C, __functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMHalfType() {
        long __functionAddress = Functions.HalfType;
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMBFloatType() {
        long __functionAddress = Functions.BFloatType;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMFloatType() {
        long __functionAddress = Functions.FloatType;
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMDoubleType() {
        long __functionAddress = Functions.DoubleType;
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMX86FP80Type() {
        long __functionAddress = Functions.X86FP80Type;
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMFP128Type() {
        long __functionAddress = Functions.FP128Type;
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMPPCFP128Type() {
        long __functionAddress = Functions.PPCFP128Type;
        return JNI.invokeP(__functionAddress);
    }

    public static long nLLVMFunctionType(long ReturnType, long ParamTypes, int ParamCount, int IsVarArg) {
        long __functionAddress = Functions.FunctionType;
        if (Checks.CHECKS) {
            Checks.check(ReturnType);
        }
        return JNI.invokePPP(ReturnType, ParamTypes, ParamCount, IsVarArg, __functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMFunctionType(@NativeType(value="LLVMTypeRef") long ReturnType, @NativeType(value="LLVMTypeRef *") PointerBuffer ParamTypes, @NativeType(value="LLVMBool") boolean IsVarArg) {
        return LLVMCore.nLLVMFunctionType(ReturnType, MemoryUtil.memAddress(ParamTypes), ParamTypes.remaining(), IsVarArg ? 1 : 0);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsFunctionVarArg(@NativeType(value="LLVMTypeRef") long FunctionTy) {
        long __functionAddress = Functions.IsFunctionVarArg;
        if (Checks.CHECKS) {
            Checks.check(FunctionTy);
        }
        return JNI.invokePI(FunctionTy, __functionAddress) != 0;
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMGetReturnType(@NativeType(value="LLVMTypeRef") long FunctionTy) {
        long __functionAddress = Functions.GetReturnType;
        if (Checks.CHECKS) {
            Checks.check(FunctionTy);
        }
        return JNI.invokePP(FunctionTy, __functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMCountParamTypes(@NativeType(value="LLVMTypeRef") long FunctionTy) {
        long __functionAddress = Functions.CountParamTypes;
        if (Checks.CHECKS) {
            Checks.check(FunctionTy);
        }
        return JNI.invokePI(FunctionTy, __functionAddress);
    }

    public static void nLLVMGetParamTypes(long FunctionTy, long Dest) {
        long __functionAddress = Functions.GetParamTypes;
        if (Checks.CHECKS) {
            Checks.check(FunctionTy);
        }
        JNI.invokePPV(FunctionTy, Dest, __functionAddress);
    }

    public static void LLVMGetParamTypes(@NativeType(value="LLVMTypeRef") long FunctionTy, @NativeType(value="LLVMTypeRef *") PointerBuffer Dest) {
        if (Checks.CHECKS && Checks.DEBUG) {
            Checks.check(Dest, LLVMCore.LLVMCountParamTypes(FunctionTy));
        }
        LLVMCore.nLLVMGetParamTypes(FunctionTy, MemoryUtil.memAddress(Dest));
    }

    public static long nLLVMStructTypeInContext(long C, long ElementTypes, int ElementCount, int Packed) {
        long __functionAddress = Functions.StructTypeInContext;
        if (Checks.CHECKS) {
            Checks.check(C);
        }
        return JNI.invokePPP(C, ElementTypes, ElementCount, Packed, __functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMStructTypeInContext(@NativeType(value="LLVMContextRef") long C, @NativeType(value="LLVMTypeRef *") PointerBuffer ElementTypes, @NativeType(value="LLVMBool") boolean Packed) {
        return LLVMCore.nLLVMStructTypeInContext(C, MemoryUtil.memAddress(ElementTypes), ElementTypes.remaining(), Packed ? 1 : 0);
    }

    public static long nLLVMStructType(long ElementTypes, int ElementCount, int Packed) {
        long __functionAddress = Functions.StructType;
        return JNI.invokePP(ElementTypes, ElementCount, Packed, __functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMStructType(@NativeType(value="LLVMTypeRef *") PointerBuffer ElementTypes, @NativeType(value="LLVMBool") boolean Packed) {
        return LLVMCore.nLLVMStructType(MemoryUtil.memAddress(ElementTypes), ElementTypes.remaining(), Packed ? 1 : 0);
    }

    public static long nLLVMStructCreateNamed(long C, long Name2) {
        long __functionAddress = Functions.StructCreateNamed;
        if (Checks.CHECKS) {
            Checks.check(C);
        }
        return JNI.invokePPP(C, Name2, __functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMStructCreateNamed(@NativeType(value="LLVMContextRef") long C, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMStructCreateNamed(C, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMTypeRef")
    public static long LLVMStructCreateNamed(@NativeType(value="LLVMContextRef") long C, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMStructCreateNamed(C, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMGetStructName(long Ty) {
        long __functionAddress = Functions.GetStructName;
        if (Checks.CHECKS) {
            Checks.check(Ty);
        }
        return JNI.invokePP(Ty, __functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String LLVMGetStructName(@NativeType(value="LLVMTypeRef") long Ty) {
        long __result = LLVMCore.nLLVMGetStructName(Ty);
        return MemoryUtil.memUTF8Safe(__result);
    }

    public static void nLLVMStructSetBody(long StructTy, long ElementTypes, int ElementCount, int Packed) {
        long __functionAddress = Functions.StructSetBody;
        if (Checks.CHECKS) {
            Checks.check(StructTy);
        }
        JNI.invokePPV(StructTy, ElementTypes, ElementCount, Packed, __functionAddress);
    }

    public static void LLVMStructSetBody(@NativeType(value="LLVMTypeRef") long StructTy, @NativeType(value="LLVMTypeRef *") PointerBuffer ElementTypes, @NativeType(value="LLVMBool") boolean Packed) {
        LLVMCore.nLLVMStructSetBody(StructTy, MemoryUtil.memAddress(ElementTypes), ElementTypes.remaining(), Packed ? 1 : 0);
    }

    @NativeType(value="unsigned int")
    public static int LLVMCountStructElementTypes(@NativeType(value="LLVMTypeRef") long StructTy) {
        long __functionAddress = Functions.CountStructElementTypes;
        if (Checks.CHECKS) {
            Checks.check(StructTy);
        }
        return JNI.invokePI(StructTy, __functionAddress);
    }

    public static void nLLVMGetStructElementTypes(long StructTy, long Dest) {
        long __functionAddress = Functions.GetStructElementTypes;
        if (Checks.CHECKS) {
            Checks.check(StructTy);
        }
        JNI.invokePPV(StructTy, Dest, __functionAddress);
    }

    public static void LLVMGetStructElementTypes(@NativeType(value="LLVMTypeRef") long StructTy, @NativeType(value="LLVMTypeRef *") PointerBuffer Dest) {
        if (Checks.CHECKS && Checks.DEBUG) {
            Checks.check(Dest, LLVMCore.LLVMCountStructElementTypes(StructTy));
        }
        LLVMCore.nLLVMGetStructElementTypes(StructTy, MemoryUtil.memAddress(Dest));
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMStructGetTypeAtIndex(@NativeType(value="LLVMTypeRef") long StructTy, @NativeType(value="unsigned int") int i) {
        long __functionAddress = Functions.StructGetTypeAtIndex;
        if (Checks.CHECKS) {
            Checks.check(StructTy);
        }
        return JNI.invokePP(StructTy, i, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsPackedStruct(@NativeType(value="LLVMTypeRef") long StructTy) {
        long __functionAddress = Functions.IsPackedStruct;
        if (Checks.CHECKS) {
            Checks.check(StructTy);
        }
        return JNI.invokePI(StructTy, __functionAddress) != 0;
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsOpaqueStruct(@NativeType(value="LLVMTypeRef") long StructTy) {
        long __functionAddress = Functions.IsOpaqueStruct;
        if (Checks.CHECKS) {
            Checks.check(StructTy);
        }
        return JNI.invokePI(StructTy, __functionAddress) != 0;
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsLiteralStruct(@NativeType(value="LLVMTypeRef") long StructTy) {
        long __functionAddress = Functions.IsLiteralStruct;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(StructTy);
        }
        return JNI.invokePI(StructTy, __functionAddress) != 0;
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMGetElementType(@NativeType(value="LLVMTypeRef") long Ty) {
        long __functionAddress = Functions.GetElementType;
        if (Checks.CHECKS) {
            Checks.check(Ty);
        }
        return JNI.invokePP(Ty, __functionAddress);
    }

    public static void nLLVMGetSubtypes(long Tp, long Arr) {
        long __functionAddress = Functions.GetSubtypes;
        if (Checks.CHECKS) {
            Checks.check(Tp);
        }
        JNI.invokePPV(Tp, Arr, __functionAddress);
    }

    public static void LLVMGetSubtypes(@NativeType(value="LLVMTypeRef") long Tp, @NativeType(value="LLVMTypeRef *") PointerBuffer Arr) {
        LLVMCore.nLLVMGetSubtypes(Tp, MemoryUtil.memAddress(Arr));
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetNumContainedTypes(@NativeType(value="LLVMTypeRef") long Tp) {
        long __functionAddress = Functions.GetNumContainedTypes;
        if (Checks.CHECKS) {
            Checks.check(Tp);
        }
        return JNI.invokePI(Tp, __functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMArrayType(@NativeType(value="LLVMTypeRef") long ElementType2, @NativeType(value="unsigned int") int ElementCount) {
        long __functionAddress = Functions.ArrayType;
        if (Checks.CHECKS) {
            Checks.check(ElementType2);
        }
        return JNI.invokePP(ElementType2, ElementCount, __functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetArrayLength(@NativeType(value="LLVMTypeRef") long ArrayTy) {
        long __functionAddress = Functions.GetArrayLength;
        if (Checks.CHECKS) {
            Checks.check(ArrayTy);
        }
        return JNI.invokePI(ArrayTy, __functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMPointerType(@NativeType(value="LLVMTypeRef") long ElementType2, @NativeType(value="unsigned int") int AddressSpace) {
        long __functionAddress = Functions.PointerType;
        if (Checks.CHECKS) {
            Checks.check(ElementType2);
        }
        return JNI.invokePP(ElementType2, AddressSpace, __functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetPointerAddressSpace(@NativeType(value="LLVMTypeRef") long PointerTy) {
        long __functionAddress = Functions.GetPointerAddressSpace;
        if (Checks.CHECKS) {
            Checks.check(PointerTy);
        }
        return JNI.invokePI(PointerTy, __functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMVectorType(@NativeType(value="LLVMTypeRef") long ElementType2, @NativeType(value="unsigned int") int ElementCount) {
        long __functionAddress = Functions.VectorType;
        if (Checks.CHECKS) {
            Checks.check(ElementType2);
        }
        return JNI.invokePP(ElementType2, ElementCount, __functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMScalableVectorType(@NativeType(value="LLVMTypeRef") long ElementType2, @NativeType(value="unsigned") int ElementCount) {
        long __functionAddress = Functions.ScalableVectorType;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(ElementType2);
        }
        return JNI.invokePP(ElementType2, ElementCount, __functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetVectorSize(@NativeType(value="LLVMTypeRef") long VectorTy) {
        long __functionAddress = Functions.GetVectorSize;
        if (Checks.CHECKS) {
            Checks.check(VectorTy);
        }
        return JNI.invokePI(VectorTy, __functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMVoidTypeInContext(@NativeType(value="LLVMContextRef") long C) {
        long __functionAddress = Functions.VoidTypeInContext;
        if (Checks.CHECKS) {
            Checks.check(C);
        }
        return JNI.invokePP(C, __functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMLabelTypeInContext(@NativeType(value="LLVMContextRef") long C) {
        long __functionAddress = Functions.LabelTypeInContext;
        if (Checks.CHECKS) {
            Checks.check(C);
        }
        return JNI.invokePP(C, __functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMX86MMXTypeInContext(@NativeType(value="LLVMContextRef") long C) {
        long __functionAddress = Functions.X86MMXTypeInContext;
        if (Checks.CHECKS) {
            Checks.check(C);
        }
        return JNI.invokePP(C, __functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMX86AMXTypeInContext(@NativeType(value="LLVMContextRef") long C) {
        long __functionAddress = Functions.X86AMXTypeInContext;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(C);
        }
        return JNI.invokePP(C, __functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMTokenTypeInContext(@NativeType(value="LLVMContextRef") long C) {
        long __functionAddress = Functions.TokenTypeInContext;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(C);
        }
        return JNI.invokePP(C, __functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMMetadataTypeInContext(@NativeType(value="LLVMContextRef") long C) {
        long __functionAddress = Functions.MetadataTypeInContext;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(C);
        }
        return JNI.invokePP(C, __functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMVoidType() {
        long __functionAddress = Functions.VoidType;
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMLabelType() {
        long __functionAddress = Functions.LabelType;
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMX86MMXType() {
        long __functionAddress = Functions.X86MMXType;
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMX86AMXType() {
        long __functionAddress = Functions.X86AMXType;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMTypeOf(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.TypeOf;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueKind")
    public static int LLVMGetValueKind(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.GetValueKind;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePI(Val, __functionAddress);
    }

    public static long nLLVMGetValueName2(long Val, long Length) {
        long __functionAddress = Functions.GetValueName2;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Val);
        }
        return JNI.invokePPP(Val, Length, __functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="char const *")
    public static String LLVMGetValueName2(@NativeType(value="LLVMValueRef") long Val) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer Length = stack.callocPointer(1);
            long __result = LLVMCore.nLLVMGetValueName2(Val, MemoryUtil.memAddress(Length));
            String string = MemoryUtil.memUTF8(__result, (int)Length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nLLVMSetValueName2(long Val, long Name2, long NameLen) {
        long __functionAddress = Functions.SetValueName2;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Val);
        }
        JNI.invokePPPV(Val, Name2, NameLen, __functionAddress);
    }

    public static void LLVMSetValueName2(@NativeType(value="LLVMValueRef") long Val, @NativeType(value="char const *") ByteBuffer Name2) {
        LLVMCore.nLLVMSetValueName2(Val, MemoryUtil.memAddress(Name2), Name2.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void LLVMSetValueName2(@NativeType(value="LLVMValueRef") long Val, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name2, false);
            long NameEncoded = stack.getPointerAddress();
            LLVMCore.nLLVMSetValueName2(Val, NameEncoded, NameEncodedLength);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void LLVMDumpValue(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.DumpValue;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        JNI.invokePV(Val, __functionAddress);
    }

    public static long nLLVMPrintValueToString(long Val) {
        long __functionAddress = Functions.PrintValueToString;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="char *")
    public static String LLVMPrintValueToString(@NativeType(value="LLVMValueRef") long Val) {
        long __result = LLVMCore.nLLVMPrintValueToString(Val);
        return MemoryUtil.memUTF8(__result);
    }

    public static void LLVMReplaceAllUsesWith(@NativeType(value="LLVMValueRef") long OldVal, @NativeType(value="LLVMValueRef") long NewVal) {
        long __functionAddress = Functions.ReplaceAllUsesWith;
        if (Checks.CHECKS) {
            Checks.check(OldVal);
            Checks.check(NewVal);
        }
        JNI.invokePPV(OldVal, NewVal, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsConstant(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsConstant;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePI(Val, __functionAddress) != 0;
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsUndef(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsUndef;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePI(Val, __functionAddress) != 0;
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsPoison(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsPoison;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Val);
        }
        return JNI.invokePI(Val, __functionAddress) != 0;
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAArgument(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAArgument;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsABasicBlock(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsABasicBlock;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAInlineAsm(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAInlineAsm;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAUser(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAUser;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAConstant(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAConstant;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsABlockAddress(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsABlockAddress;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAConstantAggregateZero(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAConstantAggregateZero;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAConstantArray(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAConstantArray;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAConstantDataSequential(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAConstantDataSequential;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAConstantDataArray(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAConstantDataArray;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAConstantDataVector(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAConstantDataVector;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAConstantExpr(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAConstantExpr;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAConstantFP(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAConstantFP;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAConstantInt(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAConstantInt;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAConstantPointerNull(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAConstantPointerNull;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAConstantStruct(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAConstantStruct;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAConstantTokenNone(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAConstantTokenNone;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAConstantVector(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAConstantVector;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAGlobalValue(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAGlobalValue;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAGlobalAlias(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAGlobalAlias;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAGlobalIFunc(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAGlobalIFunc;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAGlobalObject(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAGlobalObject;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAFunction(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAFunction;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAGlobalVariable(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAGlobalVariable;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAUndefValue(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAUndefValue;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAInstruction(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAInstruction;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsABinaryOperator(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsABinaryOperator;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsACallInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsACallInst;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAIntrinsicInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAIntrinsicInst;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsADbgInfoIntrinsic(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsADbgInfoIntrinsic;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsADbgVariableIntrinsic(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsADbgVariableIntrinsic;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsADbgDeclareInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsADbgDeclareInst;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsADbgLabelInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsADbgLabelInst;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAMemIntrinsic(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAMemIntrinsic;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAMemCpyInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAMemCpyInst;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAMemMoveInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAMemMoveInst;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAMemSetInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAMemSetInst;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsACmpInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsACmpInst;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAFCmpInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAFCmpInst;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAICmpInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAICmpInst;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAExtractElementInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAExtractElementInst;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAGetElementPtrInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAGetElementPtrInst;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAInsertElementInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAInsertElementInst;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAInsertValueInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAInsertValueInst;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsALandingPadInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsALandingPadInst;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAPHINode(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAPHINode;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsASelectInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsASelectInst;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAShuffleVectorInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAShuffleVectorInst;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAStoreInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAStoreInst;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsABranchInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsABranchInst;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAIndirectBrInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAIndirectBrInst;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAInvokeInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAInvokeInst;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAReturnInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAReturnInst;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsASwitchInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsASwitchInst;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAUnreachableInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAUnreachableInst;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAResumeInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAResumeInst;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsACleanupReturnInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsACleanupReturnInst;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsACatchReturnInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsACatchReturnInst;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAFuncletPadInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAFuncletPadInst;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsACatchPadInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsACatchPadInst;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsACleanupPadInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsACleanupPadInst;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAUnaryInstruction(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAUnaryInstruction;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAAllocaInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAAllocaInst;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsACastInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsACastInst;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAAddrSpaceCastInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAAddrSpaceCastInst;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsABitCastInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsABitCastInst;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAFPExtInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAFPExtInst;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAFPToSIInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAFPToSIInst;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAFPToUIInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAFPToUIInst;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAFPTruncInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAFPTruncInst;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAIntToPtrInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAIntToPtrInst;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAPtrToIntInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAPtrToIntInst;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsASExtInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsASExtInst;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsASIToFPInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsASIToFPInst;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsATruncInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsATruncInst;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAUIToFPInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAUIToFPInst;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAZExtInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAZExtInst;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAExtractValueInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAExtractValueInst;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsALoadInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsALoadInst;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAVAArgInst(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAVAArgInst;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAMDNode(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAMDNode;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsAMDString(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsAMDString;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    public static long nLLVMGetValueName(long Val) {
        long __functionAddress = Functions.GetValueName;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="char const *")
    public static String LLVMGetValueName(@NativeType(value="LLVMValueRef") long Val) {
        long __result = LLVMCore.nLLVMGetValueName(Val);
        return MemoryUtil.memUTF8(__result);
    }

    public static void nLLVMSetValueName(long Val, long Name2) {
        long __functionAddress = Functions.SetValueName;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        JNI.invokePPV(Val, Name2, __functionAddress);
    }

    public static void LLVMSetValueName(@NativeType(value="LLVMValueRef") long Val, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        LLVMCore.nLLVMSetValueName(Val, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void LLVMSetValueName(@NativeType(value="LLVMValueRef") long Val, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            LLVMCore.nLLVMSetValueName(Val, NameEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMUseRef")
    public static long LLVMGetFirstUse(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.GetFirstUse;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    @NativeType(value="LLVMUseRef")
    public static long LLVMGetNextUse(@NativeType(value="LLVMUseRef") long U) {
        long __functionAddress = Functions.GetNextUse;
        if (Checks.CHECKS) {
            Checks.check(U);
        }
        return JNI.invokePP(U, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetUser(@NativeType(value="LLVMUseRef") long U) {
        long __functionAddress = Functions.GetUser;
        if (Checks.CHECKS) {
            Checks.check(U);
        }
        return JNI.invokePP(U, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetUsedValue(@NativeType(value="LLVMUseRef") long U) {
        long __functionAddress = Functions.GetUsedValue;
        if (Checks.CHECKS) {
            Checks.check(U);
        }
        return JNI.invokePP(U, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetOperand(@NativeType(value="LLVMValueRef") long Val, @NativeType(value="unsigned int") int Index) {
        long __functionAddress = Functions.GetOperand;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, Index, __functionAddress);
    }

    @NativeType(value="LLVMUseRef")
    public static long LLVMGetOperandUse(@NativeType(value="LLVMValueRef") long Val, @NativeType(value="unsigned int") int Index) {
        long __functionAddress = Functions.GetOperandUse;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, Index, __functionAddress);
    }

    public static void LLVMSetOperand(@NativeType(value="LLVMValueRef") long User, @NativeType(value="unsigned int") int Index, @NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.SetOperand;
        if (Checks.CHECKS) {
            Checks.check(User);
            Checks.check(Val);
        }
        JNI.invokePPV(User, Index, Val, __functionAddress);
    }

    public static int LLVMGetNumOperands(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.GetNumOperands;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePI(Val, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstNull(@NativeType(value="LLVMTypeRef") long Ty) {
        long __functionAddress = Functions.ConstNull;
        if (Checks.CHECKS) {
            Checks.check(Ty);
        }
        return JNI.invokePP(Ty, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstAllOnes(@NativeType(value="LLVMTypeRef") long Ty) {
        long __functionAddress = Functions.ConstAllOnes;
        if (Checks.CHECKS) {
            Checks.check(Ty);
        }
        return JNI.invokePP(Ty, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetUndef(@NativeType(value="LLVMTypeRef") long Ty) {
        long __functionAddress = Functions.GetUndef;
        if (Checks.CHECKS) {
            Checks.check(Ty);
        }
        return JNI.invokePP(Ty, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetPoison(@NativeType(value="LLVMTypeRef") long Ty) {
        long __functionAddress = Functions.GetPoison;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Ty);
        }
        return JNI.invokePP(Ty, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsNull(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.IsNull;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePI(Val, __functionAddress) != 0;
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstPointerNull(@NativeType(value="LLVMTypeRef") long Ty) {
        long __functionAddress = Functions.ConstPointerNull;
        if (Checks.CHECKS) {
            Checks.check(Ty);
        }
        return JNI.invokePP(Ty, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstInt(@NativeType(value="LLVMTypeRef") long IntTy, @NativeType(value="unsigned long long") long N, @NativeType(value="LLVMBool") boolean SignExtend) {
        long __functionAddress = Functions.ConstInt;
        if (Checks.CHECKS) {
            Checks.check(IntTy);
        }
        return JNI.invokePJP(IntTy, N, SignExtend ? 1 : 0, __functionAddress);
    }

    public static long nLLVMConstIntOfArbitraryPrecision(long IntTy, int NumWords, long Words) {
        long __functionAddress = Functions.ConstIntOfArbitraryPrecision;
        if (Checks.CHECKS) {
            Checks.check(IntTy);
        }
        return JNI.invokePPP(IntTy, NumWords, Words, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstIntOfArbitraryPrecision(@NativeType(value="LLVMTypeRef") long IntTy, @NativeType(value="uint64_t const *") LongBuffer Words) {
        return LLVMCore.nLLVMConstIntOfArbitraryPrecision(IntTy, Words.remaining(), MemoryUtil.memAddress(Words));
    }

    public static long nLLVMConstIntOfString(long IntTy, long Text, byte Radix) {
        long __functionAddress = Functions.ConstIntOfString;
        if (Checks.CHECKS) {
            Checks.check(IntTy);
        }
        return JNI.invokePPP(IntTy, Text, Radix, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstIntOfString(@NativeType(value="LLVMTypeRef") long IntTy, @NativeType(value="char const *") ByteBuffer Text, @NativeType(value="uint8_t") byte Radix) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Text);
        }
        return LLVMCore.nLLVMConstIntOfString(IntTy, MemoryUtil.memAddress(Text), Radix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMConstIntOfString(@NativeType(value="LLVMTypeRef") long IntTy, @NativeType(value="char const *") CharSequence Text, @NativeType(value="uint8_t") byte Radix) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Text, true);
            long TextEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMConstIntOfString(IntTy, TextEncoded, Radix);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMConstIntOfStringAndSize(long IntTy, long Text, int SLen, byte Radix) {
        long __functionAddress = Functions.ConstIntOfStringAndSize;
        if (Checks.CHECKS) {
            Checks.check(IntTy);
        }
        return JNI.invokePPP(IntTy, Text, SLen, Radix, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstIntOfStringAndSize(@NativeType(value="LLVMTypeRef") long IntTy, @NativeType(value="char const *") ByteBuffer Text, @NativeType(value="uint8_t") byte Radix) {
        return LLVMCore.nLLVMConstIntOfStringAndSize(IntTy, MemoryUtil.memAddress(Text), Text.remaining(), Radix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMConstIntOfStringAndSize(@NativeType(value="LLVMTypeRef") long IntTy, @NativeType(value="char const *") CharSequence Text, @NativeType(value="uint8_t") byte Radix) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int TextEncodedLength = stack.nUTF8(Text, false);
            long TextEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMConstIntOfStringAndSize(IntTy, TextEncoded, TextEncodedLength, Radix);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstReal(@NativeType(value="LLVMTypeRef") long RealTy, double N) {
        long __functionAddress = Functions.ConstReal;
        if (Checks.CHECKS) {
            Checks.check(RealTy);
        }
        return JNI.invokePP(RealTy, N, __functionAddress);
    }

    public static long nLLVMConstRealOfString(long RealTy, long Text) {
        long __functionAddress = Functions.ConstRealOfString;
        if (Checks.CHECKS) {
            Checks.check(RealTy);
        }
        return JNI.invokePPP(RealTy, Text, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstRealOfString(@NativeType(value="LLVMTypeRef") long RealTy, @NativeType(value="char const *") ByteBuffer Text) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Text);
        }
        return LLVMCore.nLLVMConstRealOfString(RealTy, MemoryUtil.memAddress(Text));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMConstRealOfString(@NativeType(value="LLVMTypeRef") long RealTy, @NativeType(value="char const *") CharSequence Text) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Text, true);
            long TextEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMConstRealOfString(RealTy, TextEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMConstRealOfStringAndSize(long RealTy, long Text, int SLen) {
        long __functionAddress = Functions.ConstRealOfStringAndSize;
        if (Checks.CHECKS) {
            Checks.check(RealTy);
        }
        return JNI.invokePPP(RealTy, Text, SLen, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstRealOfStringAndSize(@NativeType(value="LLVMTypeRef") long RealTy, @NativeType(value="char const *") ByteBuffer Text) {
        return LLVMCore.nLLVMConstRealOfStringAndSize(RealTy, MemoryUtil.memAddress(Text), Text.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMConstRealOfStringAndSize(@NativeType(value="LLVMTypeRef") long RealTy, @NativeType(value="char const *") CharSequence Text) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int TextEncodedLength = stack.nUTF8(Text, false);
            long TextEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMConstRealOfStringAndSize(RealTy, TextEncoded, TextEncodedLength);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="unsigned long long")
    public static long LLVMConstIntGetZExtValue(@NativeType(value="LLVMValueRef") long ConstantVal) {
        long __functionAddress = Functions.ConstIntGetZExtValue;
        if (Checks.CHECKS) {
            Checks.check(ConstantVal);
        }
        return JNI.invokePJ(ConstantVal, __functionAddress);
    }

    @NativeType(value="long long")
    public static long LLVMConstIntGetSExtValue(@NativeType(value="LLVMValueRef") long ConstantVal) {
        long __functionAddress = Functions.ConstIntGetSExtValue;
        if (Checks.CHECKS) {
            Checks.check(ConstantVal);
        }
        return JNI.invokePJ(ConstantVal, __functionAddress);
    }

    public static double nLLVMConstRealGetDouble(long ConstantVal, long losesInfo) {
        long __functionAddress = Functions.ConstRealGetDouble;
        if (Checks.CHECKS) {
            Checks.check(ConstantVal);
        }
        return JNI.invokePPD(ConstantVal, losesInfo, __functionAddress);
    }

    public static double LLVMConstRealGetDouble(@NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="LLVMBool *") IntBuffer losesInfo) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)losesInfo, 1);
        }
        return LLVMCore.nLLVMConstRealGetDouble(ConstantVal, MemoryUtil.memAddress(losesInfo));
    }

    public static long nLLVMConstStringInContext(long C, long Str, int Length, int DontNullTerminate) {
        long __functionAddress = Functions.ConstStringInContext;
        if (Checks.CHECKS) {
            Checks.check(C);
        }
        return JNI.invokePPP(C, Str, Length, DontNullTerminate, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstStringInContext(@NativeType(value="LLVMContextRef") long C, @NativeType(value="char const *") ByteBuffer Str, @NativeType(value="LLVMBool") boolean DontNullTerminate) {
        return LLVMCore.nLLVMConstStringInContext(C, MemoryUtil.memAddress(Str), Str.remaining(), DontNullTerminate ? 1 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMConstStringInContext(@NativeType(value="LLVMContextRef") long C, @NativeType(value="char const *") CharSequence Str, @NativeType(value="LLVMBool") boolean DontNullTerminate) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int StrEncodedLength = stack.nUTF8(Str, false);
            long StrEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMConstStringInContext(C, StrEncoded, StrEncodedLength, DontNullTerminate ? 1 : 0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMConstString(long Str, int Length, int DontNullTerminate) {
        long __functionAddress = Functions.ConstString;
        return JNI.invokePP(Str, Length, DontNullTerminate, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstString(@NativeType(value="char const *") ByteBuffer Str, @NativeType(value="LLVMBool") boolean DontNullTerminate) {
        return LLVMCore.nLLVMConstString(MemoryUtil.memAddress(Str), Str.remaining(), DontNullTerminate ? 1 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMConstString(@NativeType(value="char const *") CharSequence Str, @NativeType(value="LLVMBool") boolean DontNullTerminate) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int StrEncodedLength = stack.nUTF8(Str, false);
            long StrEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMConstString(StrEncoded, StrEncodedLength, DontNullTerminate ? 1 : 0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsConstantString(@NativeType(value="LLVMValueRef") long c) {
        long __functionAddress = Functions.IsConstantString;
        if (Checks.CHECKS) {
            Checks.check(c);
        }
        return JNI.invokePI(c, __functionAddress) != 0;
    }

    public static long nLLVMGetAsString(long c, long Length) {
        long __functionAddress = Functions.GetAsString;
        if (Checks.CHECKS) {
            Checks.check(c);
        }
        return JNI.invokePPP(c, Length, __functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="char const *")
    public static String LLVMGetAsString(@NativeType(value="LLVMValueRef") long c) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer Length = stack.callocPointer(1);
            long __result = LLVMCore.nLLVMGetAsString(c, MemoryUtil.memAddress(Length));
            String string = MemoryUtil.memUTF8(__result, (int)Length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMConstStructInContext(long C, long ConstantVals, int Count, int Packed) {
        long __functionAddress = Functions.ConstStructInContext;
        if (Checks.CHECKS) {
            Checks.check(C);
        }
        return JNI.invokePPP(C, ConstantVals, Count, Packed, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstStructInContext(@NativeType(value="LLVMContextRef") long C, @NativeType(value="LLVMValueRef *") PointerBuffer ConstantVals, @NativeType(value="LLVMBool") boolean Packed) {
        return LLVMCore.nLLVMConstStructInContext(C, MemoryUtil.memAddress(ConstantVals), ConstantVals.remaining(), Packed ? 1 : 0);
    }

    public static long nLLVMConstStruct(long ConstantVals, int Count, int Packed) {
        long __functionAddress = Functions.ConstStruct;
        return JNI.invokePP(ConstantVals, Count, Packed, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstStruct(@NativeType(value="LLVMValueRef *") PointerBuffer ConstantVals, @NativeType(value="LLVMBool") boolean Packed) {
        return LLVMCore.nLLVMConstStruct(MemoryUtil.memAddress(ConstantVals), ConstantVals.remaining(), Packed ? 1 : 0);
    }

    public static long nLLVMConstArray(long ElementTy, long ConstantVals, int Length) {
        long __functionAddress = Functions.ConstArray;
        if (Checks.CHECKS) {
            Checks.check(ElementTy);
        }
        return JNI.invokePPP(ElementTy, ConstantVals, Length, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstArray(@NativeType(value="LLVMTypeRef") long ElementTy, @NativeType(value="LLVMValueRef *") PointerBuffer ConstantVals) {
        return LLVMCore.nLLVMConstArray(ElementTy, MemoryUtil.memAddress(ConstantVals), ConstantVals.remaining());
    }

    public static long nLLVMConstNamedStruct(long StructTy, long ConstantVals, int Count) {
        long __functionAddress = Functions.ConstNamedStruct;
        if (Checks.CHECKS) {
            Checks.check(StructTy);
        }
        return JNI.invokePPP(StructTy, ConstantVals, Count, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstNamedStruct(@NativeType(value="LLVMTypeRef") long StructTy, @NativeType(value="LLVMValueRef *") PointerBuffer ConstantVals) {
        return LLVMCore.nLLVMConstNamedStruct(StructTy, MemoryUtil.memAddress(ConstantVals), ConstantVals.remaining());
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetElementAsConstant(@NativeType(value="LLVMValueRef") long C, @NativeType(value="unsigned int") int idx) {
        long __functionAddress = Functions.GetElementAsConstant;
        if (Checks.CHECKS) {
            Checks.check(C);
        }
        return JNI.invokePP(C, idx, __functionAddress);
    }

    public static long nLLVMConstVector(long ScalarConstantVals, int Size) {
        long __functionAddress = Functions.ConstVector;
        return JNI.invokePP(ScalarConstantVals, Size, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstVector(@NativeType(value="LLVMValueRef *") PointerBuffer ScalarConstantVals) {
        return LLVMCore.nLLVMConstVector(MemoryUtil.memAddress(ScalarConstantVals), ScalarConstantVals.remaining());
    }

    @NativeType(value="LLVMOpcode")
    public static int LLVMGetConstOpcode(@NativeType(value="LLVMValueRef") long ConstantVal) {
        long __functionAddress = Functions.GetConstOpcode;
        if (Checks.CHECKS) {
            Checks.check(ConstantVal);
        }
        return JNI.invokePI(ConstantVal, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMAlignOf(@NativeType(value="LLVMTypeRef") long Ty) {
        long __functionAddress = Functions.AlignOf;
        if (Checks.CHECKS) {
            Checks.check(Ty);
        }
        return JNI.invokePP(Ty, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMSizeOf(@NativeType(value="LLVMTypeRef") long Ty) {
        long __functionAddress = Functions.SizeOf;
        if (Checks.CHECKS) {
            Checks.check(Ty);
        }
        return JNI.invokePP(Ty, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstNeg(@NativeType(value="LLVMValueRef") long ConstantVal) {
        long __functionAddress = Functions.ConstNeg;
        if (Checks.CHECKS) {
            Checks.check(ConstantVal);
        }
        return JNI.invokePP(ConstantVal, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstNSWNeg(@NativeType(value="LLVMValueRef") long ConstantVal) {
        long __functionAddress = Functions.ConstNSWNeg;
        if (Checks.CHECKS) {
            Checks.check(ConstantVal);
        }
        return JNI.invokePP(ConstantVal, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstNUWNeg(@NativeType(value="LLVMValueRef") long ConstantVal) {
        long __functionAddress = Functions.ConstNUWNeg;
        if (Checks.CHECKS) {
            Checks.check(ConstantVal);
        }
        return JNI.invokePP(ConstantVal, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstFNeg(@NativeType(value="LLVMValueRef") long ConstantVal) {
        long __functionAddress = Functions.ConstFNeg;
        if (Checks.CHECKS) {
            Checks.check(ConstantVal);
        }
        return JNI.invokePP(ConstantVal, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstNot(@NativeType(value="LLVMValueRef") long ConstantVal) {
        long __functionAddress = Functions.ConstNot;
        if (Checks.CHECKS) {
            Checks.check(ConstantVal);
        }
        return JNI.invokePP(ConstantVal, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstAdd(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstAdd;
        if (Checks.CHECKS) {
            Checks.check(LHSConstant);
            Checks.check(RHSConstant);
        }
        return JNI.invokePPP(LHSConstant, RHSConstant, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstNSWAdd(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstNSWAdd;
        if (Checks.CHECKS) {
            Checks.check(LHSConstant);
            Checks.check(RHSConstant);
        }
        return JNI.invokePPP(LHSConstant, RHSConstant, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstNUWAdd(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstNUWAdd;
        if (Checks.CHECKS) {
            Checks.check(LHSConstant);
            Checks.check(RHSConstant);
        }
        return JNI.invokePPP(LHSConstant, RHSConstant, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstFAdd(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstFAdd;
        if (Checks.CHECKS) {
            Checks.check(LHSConstant);
            Checks.check(RHSConstant);
        }
        return JNI.invokePPP(LHSConstant, RHSConstant, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstSub(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstSub;
        if (Checks.CHECKS) {
            Checks.check(LHSConstant);
            Checks.check(RHSConstant);
        }
        return JNI.invokePPP(LHSConstant, RHSConstant, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstNSWSub(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstNSWSub;
        if (Checks.CHECKS) {
            Checks.check(LHSConstant);
            Checks.check(RHSConstant);
        }
        return JNI.invokePPP(LHSConstant, RHSConstant, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstNUWSub(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstNUWSub;
        if (Checks.CHECKS) {
            Checks.check(LHSConstant);
            Checks.check(RHSConstant);
        }
        return JNI.invokePPP(LHSConstant, RHSConstant, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstFSub(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstFSub;
        if (Checks.CHECKS) {
            Checks.check(LHSConstant);
            Checks.check(RHSConstant);
        }
        return JNI.invokePPP(LHSConstant, RHSConstant, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstMul(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstMul;
        if (Checks.CHECKS) {
            Checks.check(LHSConstant);
            Checks.check(RHSConstant);
        }
        return JNI.invokePPP(LHSConstant, RHSConstant, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstNSWMul(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstNSWMul;
        if (Checks.CHECKS) {
            Checks.check(LHSConstant);
            Checks.check(RHSConstant);
        }
        return JNI.invokePPP(LHSConstant, RHSConstant, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstNUWMul(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstNUWMul;
        if (Checks.CHECKS) {
            Checks.check(LHSConstant);
            Checks.check(RHSConstant);
        }
        return JNI.invokePPP(LHSConstant, RHSConstant, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstFMul(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstFMul;
        if (Checks.CHECKS) {
            Checks.check(LHSConstant);
            Checks.check(RHSConstant);
        }
        return JNI.invokePPP(LHSConstant, RHSConstant, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstUDiv(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstUDiv;
        if (Checks.CHECKS) {
            Checks.check(LHSConstant);
            Checks.check(RHSConstant);
        }
        return JNI.invokePPP(LHSConstant, RHSConstant, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstExactUDiv(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstExactUDiv;
        if (Checks.CHECKS) {
            Checks.check(LHSConstant);
            Checks.check(RHSConstant);
        }
        return JNI.invokePPP(LHSConstant, RHSConstant, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstSDiv(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstSDiv;
        if (Checks.CHECKS) {
            Checks.check(LHSConstant);
            Checks.check(RHSConstant);
        }
        return JNI.invokePPP(LHSConstant, RHSConstant, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstExactSDiv(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstExactSDiv;
        if (Checks.CHECKS) {
            Checks.check(LHSConstant);
            Checks.check(RHSConstant);
        }
        return JNI.invokePPP(LHSConstant, RHSConstant, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstFDiv(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstFDiv;
        if (Checks.CHECKS) {
            Checks.check(LHSConstant);
            Checks.check(RHSConstant);
        }
        return JNI.invokePPP(LHSConstant, RHSConstant, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstURem(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstURem;
        if (Checks.CHECKS) {
            Checks.check(LHSConstant);
            Checks.check(RHSConstant);
        }
        return JNI.invokePPP(LHSConstant, RHSConstant, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstSRem(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstSRem;
        if (Checks.CHECKS) {
            Checks.check(LHSConstant);
            Checks.check(RHSConstant);
        }
        return JNI.invokePPP(LHSConstant, RHSConstant, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstFRem(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstFRem;
        if (Checks.CHECKS) {
            Checks.check(LHSConstant);
            Checks.check(RHSConstant);
        }
        return JNI.invokePPP(LHSConstant, RHSConstant, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstAnd(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstAnd;
        if (Checks.CHECKS) {
            Checks.check(LHSConstant);
            Checks.check(RHSConstant);
        }
        return JNI.invokePPP(LHSConstant, RHSConstant, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstOr(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstOr;
        if (Checks.CHECKS) {
            Checks.check(LHSConstant);
            Checks.check(RHSConstant);
        }
        return JNI.invokePPP(LHSConstant, RHSConstant, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstXor(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstXor;
        if (Checks.CHECKS) {
            Checks.check(LHSConstant);
            Checks.check(RHSConstant);
        }
        return JNI.invokePPP(LHSConstant, RHSConstant, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstICmp(@NativeType(value="LLVMIntPredicate") int Predicate2, @NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstICmp;
        if (Checks.CHECKS) {
            Checks.check(LHSConstant);
            Checks.check(RHSConstant);
        }
        return JNI.invokePPP(Predicate2, LHSConstant, RHSConstant, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstFCmp(@NativeType(value="LLVMRealPredicate") int Predicate2, @NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstFCmp;
        if (Checks.CHECKS) {
            Checks.check(LHSConstant);
            Checks.check(RHSConstant);
        }
        return JNI.invokePPP(Predicate2, LHSConstant, RHSConstant, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstShl(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstShl;
        if (Checks.CHECKS) {
            Checks.check(LHSConstant);
            Checks.check(RHSConstant);
        }
        return JNI.invokePPP(LHSConstant, RHSConstant, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstLShr(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstLShr;
        if (Checks.CHECKS) {
            Checks.check(LHSConstant);
            Checks.check(RHSConstant);
        }
        return JNI.invokePPP(LHSConstant, RHSConstant, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstAShr(@NativeType(value="LLVMValueRef") long LHSConstant, @NativeType(value="LLVMValueRef") long RHSConstant) {
        long __functionAddress = Functions.ConstAShr;
        if (Checks.CHECKS) {
            Checks.check(LHSConstant);
            Checks.check(RHSConstant);
        }
        return JNI.invokePPP(LHSConstant, RHSConstant, __functionAddress);
    }

    public static long nLLVMConstGEP(long ConstantVal, long ConstantIndices, int NumIndices) {
        long __functionAddress = Functions.ConstGEP;
        if (Checks.CHECKS) {
            Checks.check(ConstantVal);
        }
        return JNI.invokePPP(ConstantVal, ConstantIndices, NumIndices, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstGEP(@NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="LLVMValueRef *") PointerBuffer ConstantIndices) {
        return LLVMCore.nLLVMConstGEP(ConstantVal, MemoryUtil.memAddress(ConstantIndices), ConstantIndices.remaining());
    }

    public static long nLLVMConstGEP2(long Ty, long ConstantVal, long ConstantIndices, int NumIndices) {
        long __functionAddress = Functions.ConstGEP2;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Ty);
            Checks.check(ConstantVal);
        }
        return JNI.invokePPPP(Ty, ConstantVal, ConstantIndices, NumIndices, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstGEP2(@NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="LLVMValueRef *") PointerBuffer ConstantIndices) {
        return LLVMCore.nLLVMConstGEP2(Ty, ConstantVal, MemoryUtil.memAddress(ConstantIndices), ConstantIndices.remaining());
    }

    public static long nLLVMConstInBoundsGEP(long ConstantVal, long ConstantIndices, int NumIndices) {
        long __functionAddress = Functions.ConstInBoundsGEP;
        if (Checks.CHECKS) {
            Checks.check(ConstantVal);
        }
        return JNI.invokePPP(ConstantVal, ConstantIndices, NumIndices, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstInBoundsGEP(@NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="LLVMValueRef *") PointerBuffer ConstantIndices) {
        return LLVMCore.nLLVMConstInBoundsGEP(ConstantVal, MemoryUtil.memAddress(ConstantIndices), ConstantIndices.remaining());
    }

    public static long nLLVMConstInBoundsGEP2(long Ty, long ConstantVal, long ConstantIndices, int NumIndices) {
        long __functionAddress = Functions.ConstInBoundsGEP2;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Ty);
            Checks.check(ConstantVal);
        }
        return JNI.invokePPPP(Ty, ConstantVal, ConstantIndices, NumIndices, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstInBoundsGEP2(@NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="LLVMValueRef *") PointerBuffer ConstantIndices) {
        return LLVMCore.nLLVMConstInBoundsGEP2(Ty, ConstantVal, MemoryUtil.memAddress(ConstantIndices), ConstantIndices.remaining());
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstTrunc(@NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="LLVMTypeRef") long ToType) {
        long __functionAddress = Functions.ConstTrunc;
        if (Checks.CHECKS) {
            Checks.check(ConstantVal);
            Checks.check(ToType);
        }
        return JNI.invokePPP(ConstantVal, ToType, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstSExt(@NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="LLVMTypeRef") long ToType) {
        long __functionAddress = Functions.ConstSExt;
        if (Checks.CHECKS) {
            Checks.check(ConstantVal);
            Checks.check(ToType);
        }
        return JNI.invokePPP(ConstantVal, ToType, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstZExt(@NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="LLVMTypeRef") long ToType) {
        long __functionAddress = Functions.ConstZExt;
        if (Checks.CHECKS) {
            Checks.check(ConstantVal);
            Checks.check(ToType);
        }
        return JNI.invokePPP(ConstantVal, ToType, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstFPTrunc(@NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="LLVMTypeRef") long ToType) {
        long __functionAddress = Functions.ConstFPTrunc;
        if (Checks.CHECKS) {
            Checks.check(ConstantVal);
            Checks.check(ToType);
        }
        return JNI.invokePPP(ConstantVal, ToType, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstFPExt(@NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="LLVMTypeRef") long ToType) {
        long __functionAddress = Functions.ConstFPExt;
        if (Checks.CHECKS) {
            Checks.check(ConstantVal);
            Checks.check(ToType);
        }
        return JNI.invokePPP(ConstantVal, ToType, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstUIToFP(@NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="LLVMTypeRef") long ToType) {
        long __functionAddress = Functions.ConstUIToFP;
        if (Checks.CHECKS) {
            Checks.check(ConstantVal);
            Checks.check(ToType);
        }
        return JNI.invokePPP(ConstantVal, ToType, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstSIToFP(@NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="LLVMTypeRef") long ToType) {
        long __functionAddress = Functions.ConstSIToFP;
        if (Checks.CHECKS) {
            Checks.check(ConstantVal);
            Checks.check(ToType);
        }
        return JNI.invokePPP(ConstantVal, ToType, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstFPToUI(@NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="LLVMTypeRef") long ToType) {
        long __functionAddress = Functions.ConstFPToUI;
        if (Checks.CHECKS) {
            Checks.check(ConstantVal);
            Checks.check(ToType);
        }
        return JNI.invokePPP(ConstantVal, ToType, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstFPToSI(@NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="LLVMTypeRef") long ToType) {
        long __functionAddress = Functions.ConstFPToSI;
        if (Checks.CHECKS) {
            Checks.check(ConstantVal);
            Checks.check(ToType);
        }
        return JNI.invokePPP(ConstantVal, ToType, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstPtrToInt(@NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="LLVMTypeRef") long ToType) {
        long __functionAddress = Functions.ConstPtrToInt;
        if (Checks.CHECKS) {
            Checks.check(ConstantVal);
            Checks.check(ToType);
        }
        return JNI.invokePPP(ConstantVal, ToType, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstIntToPtr(@NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="LLVMTypeRef") long ToType) {
        long __functionAddress = Functions.ConstIntToPtr;
        if (Checks.CHECKS) {
            Checks.check(ConstantVal);
            Checks.check(ToType);
        }
        return JNI.invokePPP(ConstantVal, ToType, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstBitCast(@NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="LLVMTypeRef") long ToType) {
        long __functionAddress = Functions.ConstBitCast;
        if (Checks.CHECKS) {
            Checks.check(ConstantVal);
            Checks.check(ToType);
        }
        return JNI.invokePPP(ConstantVal, ToType, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstAddrSpaceCast(@NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="LLVMTypeRef") long ToType) {
        long __functionAddress = Functions.ConstAddrSpaceCast;
        if (Checks.CHECKS) {
            Checks.check(ConstantVal);
            Checks.check(ToType);
        }
        return JNI.invokePPP(ConstantVal, ToType, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstZExtOrBitCast(@NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="LLVMTypeRef") long ToType) {
        long __functionAddress = Functions.ConstZExtOrBitCast;
        if (Checks.CHECKS) {
            Checks.check(ConstantVal);
            Checks.check(ToType);
        }
        return JNI.invokePPP(ConstantVal, ToType, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstSExtOrBitCast(@NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="LLVMTypeRef") long ToType) {
        long __functionAddress = Functions.ConstSExtOrBitCast;
        if (Checks.CHECKS) {
            Checks.check(ConstantVal);
            Checks.check(ToType);
        }
        return JNI.invokePPP(ConstantVal, ToType, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstTruncOrBitCast(@NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="LLVMTypeRef") long ToType) {
        long __functionAddress = Functions.ConstTruncOrBitCast;
        if (Checks.CHECKS) {
            Checks.check(ConstantVal);
            Checks.check(ToType);
        }
        return JNI.invokePPP(ConstantVal, ToType, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstPointerCast(@NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="LLVMTypeRef") long ToType) {
        long __functionAddress = Functions.ConstPointerCast;
        if (Checks.CHECKS) {
            Checks.check(ConstantVal);
            Checks.check(ToType);
        }
        return JNI.invokePPP(ConstantVal, ToType, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstIntCast(@NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="LLVMTypeRef") long ToType, @NativeType(value="LLVMBool") boolean isSigned) {
        long __functionAddress = Functions.ConstIntCast;
        if (Checks.CHECKS) {
            Checks.check(ConstantVal);
            Checks.check(ToType);
        }
        return JNI.invokePPP(ConstantVal, ToType, isSigned ? 1 : 0, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstFPCast(@NativeType(value="LLVMValueRef") long ConstantVal, @NativeType(value="LLVMTypeRef") long ToType) {
        long __functionAddress = Functions.ConstFPCast;
        if (Checks.CHECKS) {
            Checks.check(ConstantVal);
            Checks.check(ToType);
        }
        return JNI.invokePPP(ConstantVal, ToType, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstSelect(@NativeType(value="LLVMValueRef") long ConstantCondition, @NativeType(value="LLVMValueRef") long ConstantIfTrue, @NativeType(value="LLVMValueRef") long ConstantIfFalse) {
        long __functionAddress = Functions.ConstSelect;
        if (Checks.CHECKS) {
            Checks.check(ConstantCondition);
            Checks.check(ConstantIfTrue);
            Checks.check(ConstantIfFalse);
        }
        return JNI.invokePPPP(ConstantCondition, ConstantIfTrue, ConstantIfFalse, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstExtractElement(@NativeType(value="LLVMValueRef") long VectorConstant, @NativeType(value="LLVMValueRef") long IndexConstant) {
        long __functionAddress = Functions.ConstExtractElement;
        if (Checks.CHECKS) {
            Checks.check(VectorConstant);
            Checks.check(IndexConstant);
        }
        return JNI.invokePPP(VectorConstant, IndexConstant, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstInsertElement(@NativeType(value="LLVMValueRef") long VectorConstant, @NativeType(value="LLVMValueRef") long ElementValueConstant, @NativeType(value="LLVMValueRef") long IndexConstant) {
        long __functionAddress = Functions.ConstInsertElement;
        if (Checks.CHECKS) {
            Checks.check(VectorConstant);
            Checks.check(ElementValueConstant);
            Checks.check(IndexConstant);
        }
        return JNI.invokePPPP(VectorConstant, ElementValueConstant, IndexConstant, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstShuffleVector(@NativeType(value="LLVMValueRef") long VectorAConstant, @NativeType(value="LLVMValueRef") long VectorBConstant, @NativeType(value="LLVMValueRef") long MaskConstant) {
        long __functionAddress = Functions.ConstShuffleVector;
        if (Checks.CHECKS) {
            Checks.check(VectorAConstant);
            Checks.check(VectorBConstant);
            Checks.check(MaskConstant);
        }
        return JNI.invokePPPP(VectorAConstant, VectorBConstant, MaskConstant, __functionAddress);
    }

    public static long nLLVMConstExtractValue(long AggConstant, long IdxList, int NumIdx) {
        long __functionAddress = Functions.ConstExtractValue;
        if (Checks.CHECKS) {
            Checks.check(AggConstant);
        }
        return JNI.invokePPP(AggConstant, IdxList, NumIdx, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstExtractValue(@NativeType(value="LLVMValueRef") long AggConstant, @NativeType(value="unsigned int *") IntBuffer IdxList) {
        return LLVMCore.nLLVMConstExtractValue(AggConstant, MemoryUtil.memAddress(IdxList), IdxList.remaining());
    }

    public static long nLLVMConstInsertValue(long AggConstant, long ElementValueConstant, long IdxList, int NumIdx) {
        long __functionAddress = Functions.ConstInsertValue;
        if (Checks.CHECKS) {
            Checks.check(AggConstant);
            Checks.check(ElementValueConstant);
        }
        return JNI.invokePPPP(AggConstant, ElementValueConstant, IdxList, NumIdx, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstInsertValue(@NativeType(value="LLVMValueRef") long AggConstant, @NativeType(value="LLVMValueRef") long ElementValueConstant, @NativeType(value="unsigned int *") IntBuffer IdxList) {
        return LLVMCore.nLLVMConstInsertValue(AggConstant, ElementValueConstant, MemoryUtil.memAddress(IdxList), IdxList.remaining());
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBlockAddress(@NativeType(value="LLVMValueRef") long F, @NativeType(value="LLVMBasicBlockRef") long BB) {
        long __functionAddress = Functions.BlockAddress;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(F);
            Checks.check(BB);
        }
        return JNI.invokePPP(F, BB, __functionAddress);
    }

    public static long nLLVMConstInlineAsm(long Ty, long AsmString, long Constraints, int HasSideEffects, int IsAlignStack) {
        long __functionAddress = Functions.ConstInlineAsm;
        if (Checks.CHECKS) {
            Checks.check(Ty);
        }
        return JNI.invokePPPP(Ty, AsmString, Constraints, HasSideEffects, IsAlignStack, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMConstInlineAsm(@NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="char const *") ByteBuffer AsmString, @NativeType(value="char const *") ByteBuffer Constraints, @NativeType(value="LLVMBool") boolean HasSideEffects, @NativeType(value="LLVMBool") boolean IsAlignStack) {
        if (Checks.CHECKS) {
            Checks.checkNT1(AsmString);
            Checks.checkNT1(Constraints);
        }
        return LLVMCore.nLLVMConstInlineAsm(Ty, MemoryUtil.memAddress(AsmString), MemoryUtil.memAddress(Constraints), HasSideEffects ? 1 : 0, IsAlignStack ? 1 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMConstInlineAsm(@NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="char const *") CharSequence AsmString, @NativeType(value="char const *") CharSequence Constraints, @NativeType(value="LLVMBool") boolean HasSideEffects, @NativeType(value="LLVMBool") boolean IsAlignStack) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(AsmString, true);
            long AsmStringEncoded = stack.getPointerAddress();
            stack.nUTF8(Constraints, true);
            long ConstraintsEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMConstInlineAsm(Ty, AsmStringEncoded, ConstraintsEncoded, HasSideEffects ? 1 : 0, IsAlignStack ? 1 : 0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMModuleRef")
    public static long LLVMGetGlobalParent(@NativeType(value="LLVMValueRef") long Global) {
        long __functionAddress = Functions.GetGlobalParent;
        if (Checks.CHECKS) {
            Checks.check(Global);
        }
        return JNI.invokePP(Global, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsDeclaration(@NativeType(value="LLVMValueRef") long Global) {
        long __functionAddress = Functions.IsDeclaration;
        if (Checks.CHECKS) {
            Checks.check(Global);
        }
        return JNI.invokePI(Global, __functionAddress) != 0;
    }

    @NativeType(value="LLVMLinkage")
    public static int LLVMGetLinkage(@NativeType(value="LLVMValueRef") long Global) {
        long __functionAddress = Functions.GetLinkage;
        if (Checks.CHECKS) {
            Checks.check(Global);
        }
        return JNI.invokePI(Global, __functionAddress);
    }

    public static void LLVMSetLinkage(@NativeType(value="LLVMValueRef") long Global, @NativeType(value="LLVMLinkage") int Linkage) {
        long __functionAddress = Functions.SetLinkage;
        if (Checks.CHECKS) {
            Checks.check(Global);
        }
        JNI.invokePV(Global, Linkage, __functionAddress);
    }

    public static long nLLVMGetSection(long Global) {
        long __functionAddress = Functions.GetSection;
        if (Checks.CHECKS) {
            Checks.check(Global);
        }
        return JNI.invokePP(Global, __functionAddress);
    }

    @NativeType(value="char const *")
    public static String LLVMGetSection(@NativeType(value="LLVMValueRef") long Global) {
        long __result = LLVMCore.nLLVMGetSection(Global);
        return MemoryUtil.memUTF8(__result);
    }

    public static void nLLVMSetSection(long Global, long Section) {
        long __functionAddress = Functions.SetSection;
        if (Checks.CHECKS) {
            Checks.check(Global);
        }
        JNI.invokePPV(Global, Section, __functionAddress);
    }

    public static void LLVMSetSection(@NativeType(value="LLVMValueRef") long Global, @NativeType(value="char const *") ByteBuffer Section) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Section);
        }
        LLVMCore.nLLVMSetSection(Global, MemoryUtil.memAddress(Section));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void LLVMSetSection(@NativeType(value="LLVMValueRef") long Global, @NativeType(value="char const *") CharSequence Section) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Section, true);
            long SectionEncoded = stack.getPointerAddress();
            LLVMCore.nLLVMSetSection(Global, SectionEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMVisibility")
    public static int LLVMGetVisibility(@NativeType(value="LLVMValueRef") long Global) {
        long __functionAddress = Functions.GetVisibility;
        if (Checks.CHECKS) {
            Checks.check(Global);
        }
        return JNI.invokePI(Global, __functionAddress);
    }

    public static void LLVMSetVisibility(@NativeType(value="LLVMValueRef") long Global, @NativeType(value="LLVMVisibility") int Viz) {
        long __functionAddress = Functions.SetVisibility;
        if (Checks.CHECKS) {
            Checks.check(Global);
        }
        JNI.invokePV(Global, Viz, __functionAddress);
    }

    @NativeType(value="LLVMDLLStorageClass")
    public static int LLVMGetDLLStorageClass(@NativeType(value="LLVMValueRef") long Global) {
        long __functionAddress = Functions.GetDLLStorageClass;
        if (Checks.CHECKS) {
            Checks.check(Global);
        }
        return JNI.invokePI(Global, __functionAddress);
    }

    public static void LLVMSetDLLStorageClass(@NativeType(value="LLVMValueRef") long Global, @NativeType(value="LLVMDLLStorageClass") int Class2) {
        long __functionAddress = Functions.SetDLLStorageClass;
        if (Checks.CHECKS) {
            Checks.check(Global);
        }
        JNI.invokePV(Global, Class2, __functionAddress);
    }

    @NativeType(value="LLVMUnnamedAddr")
    public static int LLVMGetUnnamedAddress(@NativeType(value="LLVMValueRef") long Global) {
        long __functionAddress = Functions.GetUnnamedAddress;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Global);
        }
        return JNI.invokePI(Global, __functionAddress);
    }

    public static void LLVMSetUnnamedAddress(@NativeType(value="LLVMValueRef") long Global, @NativeType(value="LLVMUnnamedAddr") int UnnamedAddr) {
        long __functionAddress = Functions.SetUnnamedAddress;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Global);
        }
        JNI.invokePV(Global, UnnamedAddr, __functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMGlobalGetValueType(@NativeType(value="LLVMValueRef") long Global) {
        long __functionAddress = Functions.GlobalGetValueType;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Global);
        }
        return JNI.invokePP(Global, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMHasUnnamedAddr(@NativeType(value="LLVMValueRef") long Global) {
        long __functionAddress = Functions.HasUnnamedAddr;
        if (Checks.CHECKS) {
            Checks.check(Global);
        }
        return JNI.invokePI(Global, __functionAddress) != 0;
    }

    public static void LLVMSetUnnamedAddr(@NativeType(value="LLVMValueRef") long Global, @NativeType(value="LLVMBool") boolean HasUnnamedAddr) {
        long __functionAddress = Functions.SetUnnamedAddr;
        if (Checks.CHECKS) {
            Checks.check(Global);
        }
        JNI.invokePV(Global, HasUnnamedAddr ? 1 : 0, __functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetAlignment(@NativeType(value="LLVMValueRef") long V) {
        long __functionAddress = Functions.GetAlignment;
        if (Checks.CHECKS) {
            Checks.check(V);
        }
        return JNI.invokePI(V, __functionAddress);
    }

    public static void LLVMSetAlignment(@NativeType(value="LLVMValueRef") long V, @NativeType(value="unsigned int") int Bytes) {
        long __functionAddress = Functions.SetAlignment;
        if (Checks.CHECKS) {
            Checks.check(V);
        }
        JNI.invokePV(V, Bytes, __functionAddress);
    }

    public static void LLVMGlobalSetMetadata(@NativeType(value="LLVMValueRef") long Global, @NativeType(value="unsigned int") int Kind2, @NativeType(value="LLVMMetadataRef") long MD) {
        long __functionAddress = Functions.GlobalSetMetadata;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Global);
            Checks.check(MD);
        }
        JNI.invokePPV(Global, Kind2, MD, __functionAddress);
    }

    public static void LLVMGlobalEraseMetadata(@NativeType(value="LLVMValueRef") long Global, @NativeType(value="unsigned int") int Kind2) {
        long __functionAddress = Functions.GlobalEraseMetadata;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Global);
        }
        JNI.invokePV(Global, Kind2, __functionAddress);
    }

    public static void LLVMGlobalClearMetadata(@NativeType(value="LLVMValueRef") long Global) {
        long __functionAddress = Functions.GlobalClearMetadata;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Global);
        }
        JNI.invokePV(Global, __functionAddress);
    }

    public static long nLLVMGlobalCopyAllMetadata(long Value, long NumEntries) {
        long __functionAddress = Functions.GlobalCopyAllMetadata;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Value);
        }
        return JNI.invokePPP(Value, NumEntries, __functionAddress);
    }

    @NativeType(value="LLVMValueMetadataEntry *")
    public static long LLVMGlobalCopyAllMetadata(@NativeType(value="LLVMValueRef") long Value, @NativeType(value="size_t *") PointerBuffer NumEntries) {
        if (Checks.CHECKS) {
            Checks.check(NumEntries, 1);
        }
        return LLVMCore.nLLVMGlobalCopyAllMetadata(Value, MemoryUtil.memAddress(NumEntries));
    }

    public static void LLVMDisposeValueMetadataEntries(@NativeType(value="LLVMValueMetadataEntry *") long Entries) {
        long __functionAddress = Functions.DisposeValueMetadataEntries;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Entries);
        }
        JNI.invokePV(Entries, __functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMValueMetadataEntriesGetKind(@NativeType(value="LLVMValueMetadataEntry *") long Entries, @NativeType(value="unsigned int") int Index) {
        long __functionAddress = Functions.ValueMetadataEntriesGetKind;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Entries);
        }
        return JNI.invokePI(Entries, Index, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMValueMetadataEntriesGetMetadata(@NativeType(value="LLVMValueMetadataEntry *") long Entries, @NativeType(value="unsigned int") int Index) {
        long __functionAddress = Functions.ValueMetadataEntriesGetMetadata;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Entries);
        }
        return JNI.invokePP(Entries, Index, __functionAddress);
    }

    public static long nLLVMAddGlobal(long M, long Ty, long Name2) {
        long __functionAddress = Functions.AddGlobal;
        if (Checks.CHECKS) {
            Checks.check(M);
            Checks.check(Ty);
        }
        return JNI.invokePPPP(M, Ty, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMAddGlobal(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMAddGlobal(M, Ty, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMAddGlobal(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMAddGlobal(M, Ty, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMAddGlobalInAddressSpace(long M, long Ty, long Name2, int AddressSpace) {
        long __functionAddress = Functions.AddGlobalInAddressSpace;
        if (Checks.CHECKS) {
            Checks.check(M);
            Checks.check(Ty);
        }
        return JNI.invokePPPP(M, Ty, Name2, AddressSpace, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMAddGlobalInAddressSpace(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="char const *") ByteBuffer Name2, @NativeType(value="unsigned int") int AddressSpace) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMAddGlobalInAddressSpace(M, Ty, MemoryUtil.memAddress(Name2), AddressSpace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMAddGlobalInAddressSpace(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="char const *") CharSequence Name2, @NativeType(value="unsigned int") int AddressSpace) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMAddGlobalInAddressSpace(M, Ty, NameEncoded, AddressSpace);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMGetNamedGlobal(long M, long Name2) {
        long __functionAddress = Functions.GetNamedGlobal;
        if (Checks.CHECKS) {
            Checks.check(M);
        }
        return JNI.invokePPP(M, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetNamedGlobal(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMGetNamedGlobal(M, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMGetNamedGlobal(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMGetNamedGlobal(M, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetFirstGlobal(@NativeType(value="LLVMModuleRef") long M) {
        long __functionAddress = Functions.GetFirstGlobal;
        if (Checks.CHECKS) {
            Checks.check(M);
        }
        return JNI.invokePP(M, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetLastGlobal(@NativeType(value="LLVMModuleRef") long M) {
        long __functionAddress = Functions.GetLastGlobal;
        if (Checks.CHECKS) {
            Checks.check(M);
        }
        return JNI.invokePP(M, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetNextGlobal(@NativeType(value="LLVMValueRef") long GlobalVar) {
        long __functionAddress = Functions.GetNextGlobal;
        if (Checks.CHECKS) {
            Checks.check(GlobalVar);
        }
        return JNI.invokePP(GlobalVar, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetPreviousGlobal(@NativeType(value="LLVMValueRef") long GlobalVar) {
        long __functionAddress = Functions.GetPreviousGlobal;
        if (Checks.CHECKS) {
            Checks.check(GlobalVar);
        }
        return JNI.invokePP(GlobalVar, __functionAddress);
    }

    public static void LLVMDeleteGlobal(@NativeType(value="LLVMValueRef") long GlobalVar) {
        long __functionAddress = Functions.DeleteGlobal;
        if (Checks.CHECKS) {
            Checks.check(GlobalVar);
        }
        JNI.invokePV(GlobalVar, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetInitializer(@NativeType(value="LLVMValueRef") long GlobalVar) {
        long __functionAddress = Functions.GetInitializer;
        if (Checks.CHECKS) {
            Checks.check(GlobalVar);
        }
        return JNI.invokePP(GlobalVar, __functionAddress);
    }

    public static void LLVMSetInitializer(@NativeType(value="LLVMValueRef") long GlobalVar, @NativeType(value="LLVMValueRef") long ConstantVal) {
        long __functionAddress = Functions.SetInitializer;
        if (Checks.CHECKS) {
            Checks.check(GlobalVar);
            Checks.check(ConstantVal);
        }
        JNI.invokePPV(GlobalVar, ConstantVal, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsThreadLocal(@NativeType(value="LLVMValueRef") long GlobalVar) {
        long __functionAddress = Functions.IsThreadLocal;
        if (Checks.CHECKS) {
            Checks.check(GlobalVar);
        }
        return JNI.invokePI(GlobalVar, __functionAddress) != 0;
    }

    public static void LLVMSetThreadLocal(@NativeType(value="LLVMValueRef") long GlobalVar, @NativeType(value="LLVMBool") boolean IsThreadLocal) {
        long __functionAddress = Functions.SetThreadLocal;
        if (Checks.CHECKS) {
            Checks.check(GlobalVar);
        }
        JNI.invokePV(GlobalVar, IsThreadLocal ? 1 : 0, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsGlobalConstant(@NativeType(value="LLVMValueRef") long GlobalVar) {
        long __functionAddress = Functions.IsGlobalConstant;
        if (Checks.CHECKS) {
            Checks.check(GlobalVar);
        }
        return JNI.invokePI(GlobalVar, __functionAddress) != 0;
    }

    public static void LLVMSetGlobalConstant(@NativeType(value="LLVMValueRef") long GlobalVar, @NativeType(value="LLVMBool") boolean IsConstant) {
        long __functionAddress = Functions.SetGlobalConstant;
        if (Checks.CHECKS) {
            Checks.check(GlobalVar);
        }
        JNI.invokePV(GlobalVar, IsConstant ? 1 : 0, __functionAddress);
    }

    @NativeType(value="LLVMThreadLocalMode")
    public static int LLVMGetThreadLocalMode(@NativeType(value="LLVMValueRef") long GlobalVar) {
        long __functionAddress = Functions.GetThreadLocalMode;
        if (Checks.CHECKS) {
            Checks.check(GlobalVar);
        }
        return JNI.invokePI(GlobalVar, __functionAddress);
    }

    public static void LLVMSetThreadLocalMode(@NativeType(value="LLVMValueRef") long GlobalVar, @NativeType(value="LLVMThreadLocalMode") int Mode) {
        long __functionAddress = Functions.SetThreadLocalMode;
        if (Checks.CHECKS) {
            Checks.check(GlobalVar);
        }
        JNI.invokePV(GlobalVar, Mode, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsExternallyInitialized(@NativeType(value="LLVMValueRef") long GlobalVar) {
        long __functionAddress = Functions.IsExternallyInitialized;
        if (Checks.CHECKS) {
            Checks.check(GlobalVar);
        }
        return JNI.invokePI(GlobalVar, __functionAddress) != 0;
    }

    public static void LLVMSetExternallyInitialized(@NativeType(value="LLVMValueRef") long GlobalVar, @NativeType(value="LLVMBool") boolean IsExtInit) {
        long __functionAddress = Functions.SetExternallyInitialized;
        if (Checks.CHECKS) {
            Checks.check(GlobalVar);
        }
        JNI.invokePV(GlobalVar, IsExtInit ? 1 : 0, __functionAddress);
    }

    public static long nLLVMAddAlias(long M, long Ty, long Aliasee, long Name2) {
        long __functionAddress = Functions.AddAlias;
        if (Checks.CHECKS) {
            Checks.check(M);
            Checks.check(Ty);
            Checks.check(Aliasee);
        }
        return JNI.invokePPPPP(M, Ty, Aliasee, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMAddAlias(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="LLVMValueRef") long Aliasee, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMAddAlias(M, Ty, Aliasee, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMAddAlias(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="LLVMValueRef") long Aliasee, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMAddAlias(M, Ty, Aliasee, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMGetNamedGlobalAlias(long M, long Name2, long NameLen) {
        long __functionAddress = Functions.GetNamedGlobalAlias;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(M);
        }
        return JNI.invokePPPP(M, Name2, NameLen, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetNamedGlobalAlias(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") ByteBuffer Name2) {
        return LLVMCore.nLLVMGetNamedGlobalAlias(M, MemoryUtil.memAddress(Name2), Name2.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMGetNamedGlobalAlias(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name2, false);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMGetNamedGlobalAlias(M, NameEncoded, NameEncodedLength);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetFirstGlobalAlias(@NativeType(value="LLVMModuleRef") long M) {
        long __functionAddress = Functions.GetFirstGlobalAlias;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(M);
        }
        return JNI.invokePP(M, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetLastGlobalAlias(@NativeType(value="LLVMModuleRef") long M) {
        long __functionAddress = Functions.GetLastGlobalAlias;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(M);
        }
        return JNI.invokePP(M, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetNextGlobalAlias(@NativeType(value="LLVMValueRef") long GA) {
        long __functionAddress = Functions.GetNextGlobalAlias;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(GA);
        }
        return JNI.invokePP(GA, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetPreviousGlobalAlias(@NativeType(value="LLVMValueRef") long GA) {
        long __functionAddress = Functions.GetPreviousGlobalAlias;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(GA);
        }
        return JNI.invokePP(GA, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMAliasGetAliasee(@NativeType(value="LLVMValueRef") long Alias) {
        long __functionAddress = Functions.AliasGetAliasee;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Alias);
        }
        return JNI.invokePP(Alias, __functionAddress);
    }

    public static void LLVMAliasSetAliasee(@NativeType(value="LLVMValueRef") long Alias, @NativeType(value="LLVMValueRef") long Aliasee) {
        long __functionAddress = Functions.AliasSetAliasee;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Alias);
            Checks.check(Aliasee);
        }
        JNI.invokePPV(Alias, Aliasee, __functionAddress);
    }

    public static void LLVMDeleteFunction(@NativeType(value="LLVMValueRef") long Fn) {
        long __functionAddress = Functions.DeleteFunction;
        if (Checks.CHECKS) {
            Checks.check(Fn);
        }
        JNI.invokePV(Fn, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMHasPersonalityFn(@NativeType(value="LLVMValueRef") long Fn) {
        long __functionAddress = Functions.HasPersonalityFn;
        if (Checks.CHECKS) {
            Checks.check(Fn);
        }
        return JNI.invokePI(Fn, __functionAddress) != 0;
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetPersonalityFn(@NativeType(value="LLVMValueRef") long Fn) {
        long __functionAddress = Functions.GetPersonalityFn;
        if (Checks.CHECKS) {
            Checks.check(Fn);
        }
        return JNI.invokePP(Fn, __functionAddress);
    }

    public static void LLVMSetPersonalityFn(@NativeType(value="LLVMValueRef") long Fn, @NativeType(value="LLVMValueRef") long PersonalityFn) {
        long __functionAddress = Functions.SetPersonalityFn;
        if (Checks.CHECKS) {
            Checks.check(Fn);
            Checks.check(PersonalityFn);
        }
        JNI.invokePPV(Fn, PersonalityFn, __functionAddress);
    }

    public static void nLLVMLookupIntrinsicID(long Name2, long NameLen) {
        long __functionAddress = Functions.LookupIntrinsicID;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.invokePPV(Name2, NameLen, __functionAddress);
    }

    public static void LLVMLookupIntrinsicID(@NativeType(value="char const *") ByteBuffer Name2) {
        LLVMCore.nLLVMLookupIntrinsicID(MemoryUtil.memAddress(Name2), Name2.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void LLVMLookupIntrinsicID(@NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name2, false);
            long NameEncoded = stack.getPointerAddress();
            LLVMCore.nLLVMLookupIntrinsicID(NameEncoded, NameEncodedLength);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetIntrinsicID(@NativeType(value="LLVMValueRef") long Fn) {
        long __functionAddress = Functions.GetIntrinsicID;
        if (Checks.CHECKS) {
            Checks.check(Fn);
        }
        return JNI.invokePI(Fn, __functionAddress);
    }

    public static long nLLVMGetIntrinsicDeclaration(long Mod, int ID, long ParamTypes, long ParamCount) {
        long __functionAddress = Functions.GetIntrinsicDeclaration;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Mod);
        }
        return JNI.invokePPPP(Mod, ID, ParamTypes, ParamCount, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetIntrinsicDeclaration(@NativeType(value="LLVMModuleRef") long Mod, @NativeType(value="unsigned") int ID, @NativeType(value="LLVMTypeRef *") PointerBuffer ParamTypes) {
        return LLVMCore.nLLVMGetIntrinsicDeclaration(Mod, ID, MemoryUtil.memAddress(ParamTypes), ParamTypes.remaining());
    }

    public static long nLLVMIntrinsicGetType(long Ctx, int ID, long ParamTypes, long ParamCount) {
        long __functionAddress = Functions.IntrinsicGetType;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Ctx);
        }
        return JNI.invokePPPP(Ctx, ID, ParamTypes, ParamCount, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIntrinsicGetType(@NativeType(value="LLVMContextRef") long Ctx, @NativeType(value="unsigned") int ID, @NativeType(value="LLVMTypeRef *") PointerBuffer ParamTypes) {
        return LLVMCore.nLLVMIntrinsicGetType(Ctx, ID, MemoryUtil.memAddress(ParamTypes), ParamTypes.remaining());
    }

    public static long nLLVMIntrinsicGetName(int ID, long NameLength) {
        long __functionAddress = Functions.IntrinsicGetName;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.invokePP(ID, NameLength, __functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="char const *")
    public static String LLVMIntrinsicGetName(@NativeType(value="unsigned") int ID) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer NameLength = stack.callocPointer(1);
            long __result = LLVMCore.nLLVMIntrinsicGetName(ID, MemoryUtil.memAddress(NameLength));
            String string = MemoryUtil.memUTF8Safe(__result, (int)NameLength.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMIntrinsicCopyOverloadedName(int ID, long ParamTypes, long ParamCount, long NameLength) {
        long __functionAddress = Functions.IntrinsicCopyOverloadedName;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.invokePPPP(ID, ParamTypes, ParamCount, NameLength, __functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="char const *")
    public static String LLVMIntrinsicCopyOverloadedName(@NativeType(value="unsigned") int ID, @NativeType(value="LLVMTypeRef *") PointerBuffer ParamTypes) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer NameLength = stack.callocPointer(1);
            long __result = LLVMCore.nLLVMIntrinsicCopyOverloadedName(ID, MemoryUtil.memAddress(ParamTypes), ParamTypes.remaining(), MemoryUtil.memAddress(NameLength));
            String string = MemoryUtil.memUTF8Safe(__result, (int)NameLength.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMIntrinsicCopyOverloadedName2(long Mod, int ID, long ParamTypes, long ParamCount, long NameLength) {
        long __functionAddress = Functions.IntrinsicCopyOverloadedName2;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Mod);
        }
        return JNI.invokePPPPP(Mod, ID, ParamTypes, ParamCount, NameLength, __functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="char const *")
    public static String LLVMIntrinsicCopyOverloadedName2(@NativeType(value="LLVMModuleRef") long Mod, @NativeType(value="unsigned") int ID, @NativeType(value="LLVMTypeRef *") PointerBuffer ParamTypes) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            PointerBuffer NameLength = stack.callocPointer(1);
            long __result = LLVMCore.nLLVMIntrinsicCopyOverloadedName2(Mod, ID, MemoryUtil.memAddress(ParamTypes), ParamTypes.remaining(), MemoryUtil.memAddress(NameLength));
            String string = MemoryUtil.memUTF8Safe(__result, (int)NameLength.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIntrinsicIsOverloaded(@NativeType(value="unsigned") int ID) {
        long __functionAddress = Functions.IntrinsicIsOverloaded;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.invokeI(ID, __functionAddress) != 0;
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetFunctionCallConv(@NativeType(value="LLVMValueRef") long Fn) {
        long __functionAddress = Functions.GetFunctionCallConv;
        if (Checks.CHECKS) {
            Checks.check(Fn);
        }
        return JNI.invokePI(Fn, __functionAddress);
    }

    public static void LLVMSetFunctionCallConv(@NativeType(value="LLVMValueRef") long Fn, @NativeType(value="unsigned int") int CC) {
        long __functionAddress = Functions.SetFunctionCallConv;
        if (Checks.CHECKS) {
            Checks.check(Fn);
        }
        JNI.invokePV(Fn, CC, __functionAddress);
    }

    public static long nLLVMGetGC(long Fn) {
        long __functionAddress = Functions.GetGC;
        if (Checks.CHECKS) {
            Checks.check(Fn);
        }
        return JNI.invokePP(Fn, __functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String LLVMGetGC(@NativeType(value="LLVMValueRef") long Fn) {
        long __result = LLVMCore.nLLVMGetGC(Fn);
        return MemoryUtil.memUTF8Safe(__result);
    }

    public static void nLLVMSetGC(long Fn, long Name2) {
        long __functionAddress = Functions.SetGC;
        if (Checks.CHECKS) {
            Checks.check(Fn);
        }
        JNI.invokePPV(Fn, Name2, __functionAddress);
    }

    public static void LLVMSetGC(@NativeType(value="LLVMValueRef") long Fn, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        LLVMCore.nLLVMSetGC(Fn, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void LLVMSetGC(@NativeType(value="LLVMValueRef") long Fn, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            LLVMCore.nLLVMSetGC(Fn, NameEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void LLVMAddAttributeAtIndex(@NativeType(value="LLVMValueRef") long F, @NativeType(value="LLVMAttributeIndex") int Idx, @NativeType(value="LLVMAttributeRef") long A) {
        long __functionAddress = Functions.AddAttributeAtIndex;
        if (Checks.CHECKS) {
            Checks.check(F);
            Checks.check(A);
        }
        JNI.invokePPV(F, Idx, A, __functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetAttributeCountAtIndex(@NativeType(value="LLVMValueRef") long F, @NativeType(value="LLVMAttributeIndex") int Idx) {
        long __functionAddress = Functions.GetAttributeCountAtIndex;
        if (Checks.CHECKS) {
            Checks.check(F);
        }
        return JNI.invokePI(F, Idx, __functionAddress);
    }

    public static void nLLVMGetAttributesAtIndex(long F, int Idx, long Attrs) {
        long __functionAddress = Functions.GetAttributesAtIndex;
        if (Checks.CHECKS) {
            Checks.check(F);
        }
        JNI.invokePPV(F, Idx, Attrs, __functionAddress);
    }

    public static void LLVMGetAttributesAtIndex(@NativeType(value="LLVMValueRef") long F, @NativeType(value="LLVMAttributeIndex") int Idx, @NativeType(value="LLVMAttributeRef *") PointerBuffer Attrs) {
        if (Checks.CHECKS && Checks.DEBUG) {
            Checks.check(Attrs, LLVMCore.LLVMGetAttributeCountAtIndex(F, Idx));
        }
        LLVMCore.nLLVMGetAttributesAtIndex(F, Idx, MemoryUtil.memAddress(Attrs));
    }

    @NativeType(value="LLVMAttributeRef")
    public static long LLVMGetEnumAttributeAtIndex(@NativeType(value="LLVMValueRef") long F, @NativeType(value="LLVMAttributeIndex") int Idx, @NativeType(value="unsigned int") int KindID) {
        long __functionAddress = Functions.GetEnumAttributeAtIndex;
        if (Checks.CHECKS) {
            Checks.check(F);
        }
        return JNI.invokePP(F, Idx, KindID, __functionAddress);
    }

    public static long nLLVMGetStringAttributeAtIndex(long F, int Idx, long K, int KLen) {
        long __functionAddress = Functions.GetStringAttributeAtIndex;
        if (Checks.CHECKS) {
            Checks.check(F);
        }
        return JNI.invokePPP(F, Idx, K, KLen, __functionAddress);
    }

    @NativeType(value="LLVMAttributeRef")
    public static long LLVMGetStringAttributeAtIndex(@NativeType(value="LLVMValueRef") long F, @NativeType(value="LLVMAttributeIndex") int Idx, @NativeType(value="char const *") ByteBuffer K) {
        return LLVMCore.nLLVMGetStringAttributeAtIndex(F, Idx, MemoryUtil.memAddress(K), K.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMAttributeRef")
    public static long LLVMGetStringAttributeAtIndex(@NativeType(value="LLVMValueRef") long F, @NativeType(value="LLVMAttributeIndex") int Idx, @NativeType(value="char const *") CharSequence K) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int KEncodedLength = stack.nUTF8(K, false);
            long KEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMGetStringAttributeAtIndex(F, Idx, KEncoded, KEncodedLength);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void LLVMRemoveEnumAttributeAtIndex(@NativeType(value="LLVMValueRef") long F, @NativeType(value="LLVMAttributeIndex") int Idx, @NativeType(value="unsigned int") int KindID) {
        long __functionAddress = Functions.RemoveEnumAttributeAtIndex;
        if (Checks.CHECKS) {
            Checks.check(F);
        }
        JNI.invokePV(F, Idx, KindID, __functionAddress);
    }

    public static void nLLVMRemoveStringAttributeAtIndex(long F, int Idx, long K, int KLen) {
        long __functionAddress = Functions.RemoveStringAttributeAtIndex;
        if (Checks.CHECKS) {
            Checks.check(F);
        }
        JNI.invokePPV(F, Idx, K, KLen, __functionAddress);
    }

    public static void LLVMRemoveStringAttributeAtIndex(@NativeType(value="LLVMValueRef") long F, @NativeType(value="LLVMAttributeIndex") int Idx, @NativeType(value="char const *") ByteBuffer K) {
        LLVMCore.nLLVMRemoveStringAttributeAtIndex(F, Idx, MemoryUtil.memAddress(K), K.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void LLVMRemoveStringAttributeAtIndex(@NativeType(value="LLVMValueRef") long F, @NativeType(value="LLVMAttributeIndex") int Idx, @NativeType(value="char const *") CharSequence K) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int KEncodedLength = stack.nUTF8(K, false);
            long KEncoded = stack.getPointerAddress();
            LLVMCore.nLLVMRemoveStringAttributeAtIndex(F, Idx, KEncoded, KEncodedLength);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nLLVMAddTargetDependentFunctionAttr(long Fn, long A, long V) {
        long __functionAddress = Functions.AddTargetDependentFunctionAttr;
        if (Checks.CHECKS) {
            Checks.check(Fn);
        }
        JNI.invokePPPV(Fn, A, V, __functionAddress);
    }

    public static void LLVMAddTargetDependentFunctionAttr(@NativeType(value="LLVMValueRef") long Fn, @NativeType(value="char const *") ByteBuffer A, @NativeType(value="char const *") ByteBuffer V) {
        if (Checks.CHECKS) {
            Checks.checkNT1(A);
            Checks.checkNT1(V);
        }
        LLVMCore.nLLVMAddTargetDependentFunctionAttr(Fn, MemoryUtil.memAddress(A), MemoryUtil.memAddress(V));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void LLVMAddTargetDependentFunctionAttr(@NativeType(value="LLVMValueRef") long Fn, @NativeType(value="char const *") CharSequence A, @NativeType(value="char const *") CharSequence V) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(A, true);
            long AEncoded = stack.getPointerAddress();
            stack.nUTF8(V, true);
            long VEncoded = stack.getPointerAddress();
            LLVMCore.nLLVMAddTargetDependentFunctionAttr(Fn, AEncoded, VEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="unsigned int")
    public static int LLVMCountParams(@NativeType(value="LLVMValueRef") long Fn) {
        long __functionAddress = Functions.CountParams;
        if (Checks.CHECKS) {
            Checks.check(Fn);
        }
        return JNI.invokePI(Fn, __functionAddress);
    }

    public static void nLLVMGetParams(long Fn, long Params) {
        long __functionAddress = Functions.GetParams;
        if (Checks.CHECKS) {
            Checks.check(Fn);
        }
        JNI.invokePPV(Fn, Params, __functionAddress);
    }

    public static void LLVMGetParams(@NativeType(value="LLVMValueRef") long Fn, @NativeType(value="LLVMValueRef *") PointerBuffer Params) {
        if (Checks.CHECKS && Checks.DEBUG) {
            Checks.check(Params, LLVMCore.LLVMCountParams(Fn));
        }
        LLVMCore.nLLVMGetParams(Fn, MemoryUtil.memAddress(Params));
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetParam(@NativeType(value="LLVMValueRef") long Fn, @NativeType(value="unsigned int") int Index) {
        long __functionAddress = Functions.GetParam;
        if (Checks.CHECKS) {
            Checks.check(Fn);
        }
        return JNI.invokePP(Fn, Index, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetParamParent(@NativeType(value="LLVMValueRef") long Inst) {
        long __functionAddress = Functions.GetParamParent;
        if (Checks.CHECKS) {
            Checks.check(Inst);
        }
        return JNI.invokePP(Inst, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetFirstParam(@NativeType(value="LLVMValueRef") long Fn) {
        long __functionAddress = Functions.GetFirstParam;
        if (Checks.CHECKS) {
            Checks.check(Fn);
        }
        return JNI.invokePP(Fn, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetLastParam(@NativeType(value="LLVMValueRef") long Fn) {
        long __functionAddress = Functions.GetLastParam;
        if (Checks.CHECKS) {
            Checks.check(Fn);
        }
        return JNI.invokePP(Fn, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetNextParam(@NativeType(value="LLVMValueRef") long Arg) {
        long __functionAddress = Functions.GetNextParam;
        if (Checks.CHECKS) {
            Checks.check(Arg);
        }
        return JNI.invokePP(Arg, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetPreviousParam(@NativeType(value="LLVMValueRef") long Arg) {
        long __functionAddress = Functions.GetPreviousParam;
        if (Checks.CHECKS) {
            Checks.check(Arg);
        }
        return JNI.invokePP(Arg, __functionAddress);
    }

    public static void LLVMSetParamAlignment(@NativeType(value="LLVMValueRef") long Arg, @NativeType(value="unsigned int") int Align) {
        long __functionAddress = Functions.SetParamAlignment;
        if (Checks.CHECKS) {
            Checks.check(Arg);
        }
        JNI.invokePV(Arg, Align, __functionAddress);
    }

    public static long nLLVMAddGlobalIFunc(long M, long Name2, long NameLen, long Ty, int AddrSpace, long Resolver) {
        long __functionAddress = Functions.AddGlobalIFunc;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(M);
            Checks.check(Ty);
            Checks.check(Resolver);
        }
        return JNI.invokePPPPPP(M, Name2, NameLen, Ty, AddrSpace, Resolver, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMAddGlobalIFunc(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") ByteBuffer Name2, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="unsigned") int AddrSpace, @NativeType(value="LLVMValueRef") long Resolver) {
        return LLVMCore.nLLVMAddGlobalIFunc(M, MemoryUtil.memAddress(Name2), Name2.remaining(), Ty, AddrSpace, Resolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMAddGlobalIFunc(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") CharSequence Name2, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="unsigned") int AddrSpace, @NativeType(value="LLVMValueRef") long Resolver) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name2, false);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMAddGlobalIFunc(M, NameEncoded, NameEncodedLength, Ty, AddrSpace, Resolver);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMGetNamedGlobalIFunc(long M, long Name2, long NameLen) {
        long __functionAddress = Functions.GetNamedGlobalIFunc;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(M);
        }
        return JNI.invokePPPP(M, Name2, NameLen, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetNamedGlobalIFunc(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") ByteBuffer Name2) {
        return LLVMCore.nLLVMGetNamedGlobalIFunc(M, MemoryUtil.memAddress(Name2), Name2.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMGetNamedGlobalIFunc(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int NameEncodedLength = stack.nUTF8(Name2, false);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMGetNamedGlobalIFunc(M, NameEncoded, NameEncodedLength);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetFirstGlobalIFunc(@NativeType(value="LLVMModuleRef") long M) {
        long __functionAddress = Functions.GetFirstGlobalIFunc;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(M);
        }
        return JNI.invokePP(M, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetLastGlobalIFunc(@NativeType(value="LLVMModuleRef") long M) {
        long __functionAddress = Functions.GetLastGlobalIFunc;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(M);
        }
        return JNI.invokePP(M, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetNextGlobalIFunc(@NativeType(value="LLVMValueRef") long IFunc) {
        long __functionAddress = Functions.GetNextGlobalIFunc;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(IFunc);
        }
        return JNI.invokePP(IFunc, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetPreviousGlobalIFunc(@NativeType(value="LLVMValueRef") long IFunc) {
        long __functionAddress = Functions.GetPreviousGlobalIFunc;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(IFunc);
        }
        return JNI.invokePP(IFunc, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetGlobalIFuncResolver(@NativeType(value="LLVMValueRef") long IFunc) {
        long __functionAddress = Functions.GetGlobalIFuncResolver;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(IFunc);
        }
        return JNI.invokePP(IFunc, __functionAddress);
    }

    public static void LLVMSetGlobalIFuncResolver(@NativeType(value="LLVMValueRef") long IFunc, @NativeType(value="LLVMValueRef") long Resolver) {
        long __functionAddress = Functions.SetGlobalIFuncResolver;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(IFunc);
            Checks.check(Resolver);
        }
        JNI.invokePPV(IFunc, Resolver, __functionAddress);
    }

    public static void LLVMEraseGlobalIFunc(@NativeType(value="LLVMValueRef") long IFunc) {
        long __functionAddress = Functions.EraseGlobalIFunc;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(IFunc);
        }
        JNI.invokePV(IFunc, __functionAddress);
    }

    public static void LLVMRemoveGlobalIFunc(@NativeType(value="LLVMValueRef") long IFunc) {
        long __functionAddress = Functions.RemoveGlobalIFunc;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(IFunc);
        }
        JNI.invokePV(IFunc, __functionAddress);
    }

    public static long nLLVMMDStringInContext2(long C, long Str, long SLen) {
        long __functionAddress = Functions.MDStringInContext2;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(C);
        }
        return JNI.invokePPPP(C, Str, SLen, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMMDStringInContext2(@NativeType(value="LLVMContextRef") long C, @NativeType(value="char const *") ByteBuffer Str) {
        return LLVMCore.nLLVMMDStringInContext2(C, MemoryUtil.memAddress(Str), Str.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMetadataRef")
    public static long LLVMMDStringInContext2(@NativeType(value="LLVMContextRef") long C, @NativeType(value="char const *") CharSequence Str) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int StrEncodedLength = stack.nUTF8(Str, false);
            long StrEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMMDStringInContext2(C, StrEncoded, StrEncodedLength);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMMDNodeInContext2(long C, long MDs, long Count) {
        long __functionAddress = Functions.MDNodeInContext2;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(C);
        }
        return JNI.invokePPPP(C, MDs, Count, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMMDNodeInContext2(@NativeType(value="LLVMContextRef") long C, @NativeType(value="LLVMMetadataRef *") PointerBuffer MDs) {
        return LLVMCore.nLLVMMDNodeInContext2(C, MemoryUtil.memAddress(MDs), MDs.remaining());
    }

    public static long nLLVMMDStringInContext(long C, long Str, int SLen) {
        long __functionAddress = Functions.MDStringInContext;
        if (Checks.CHECKS) {
            Checks.check(C);
        }
        return JNI.invokePPP(C, Str, SLen, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMMDStringInContext(@NativeType(value="LLVMContextRef") long C, @NativeType(value="char const *") ByteBuffer Str) {
        return LLVMCore.nLLVMMDStringInContext(C, MemoryUtil.memAddress(Str), Str.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMMDStringInContext(@NativeType(value="LLVMContextRef") long C, @NativeType(value="char const *") CharSequence Str) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int StrEncodedLength = stack.nUTF8(Str, false);
            long StrEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMMDStringInContext(C, StrEncoded, StrEncodedLength);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMMDString(long Str, int SLen) {
        long __functionAddress = Functions.MDString;
        return JNI.invokePP(Str, SLen, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMMDString(@NativeType(value="char const *") ByteBuffer Str) {
        return LLVMCore.nLLVMMDString(MemoryUtil.memAddress(Str), Str.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMMDString(@NativeType(value="char const *") CharSequence Str) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int StrEncodedLength = stack.nUTF8(Str, false);
            long StrEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMMDString(StrEncoded, StrEncodedLength);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMMDNodeInContext(long C, long Vals, int Count) {
        long __functionAddress = Functions.MDNodeInContext;
        if (Checks.CHECKS) {
            Checks.check(C);
        }
        return JNI.invokePPP(C, Vals, Count, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMMDNodeInContext(@NativeType(value="LLVMContextRef") long C, @NativeType(value="LLVMValueRef *") PointerBuffer Vals) {
        return LLVMCore.nLLVMMDNodeInContext(C, MemoryUtil.memAddress(Vals), Vals.remaining());
    }

    public static long nLLVMMDNode(long Vals, int Count) {
        long __functionAddress = Functions.MDNode;
        return JNI.invokePP(Vals, Count, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMMDNode(@NativeType(value="LLVMValueRef *") PointerBuffer Vals) {
        return LLVMCore.nLLVMMDNode(MemoryUtil.memAddress(Vals), Vals.remaining());
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMMetadataAsValue(@NativeType(value="LLVMContextRef") long C, @NativeType(value="LLVMMetadataRef") long MD) {
        long __functionAddress = Functions.MetadataAsValue;
        if (Checks.CHECKS) {
            Checks.check(C);
            Checks.check(MD);
        }
        return JNI.invokePPP(C, MD, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMValueAsMetadata(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.ValueAsMetadata;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    public static long nLLVMGetMDString(long V, long Length) {
        long __functionAddress = Functions.GetMDString;
        if (Checks.CHECKS) {
            Checks.check(V);
        }
        return JNI.invokePPP(V, Length, __functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="char const *")
    public static String LLVMGetMDString(@NativeType(value="LLVMValueRef") long V) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer Length = stack.callocInt(1);
            long __result = LLVMCore.nLLVMGetMDString(V, MemoryUtil.memAddress(Length));
            String string = MemoryUtil.memUTF8Safe(__result, Length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetMDNodeNumOperands(@NativeType(value="LLVMValueRef") long V) {
        long __functionAddress = Functions.GetMDNodeNumOperands;
        if (Checks.CHECKS) {
            Checks.check(V);
        }
        return JNI.invokePI(V, __functionAddress);
    }

    public static void nLLVMGetMDNodeOperands(long V, long Dest) {
        long __functionAddress = Functions.GetMDNodeOperands;
        if (Checks.CHECKS) {
            Checks.check(V);
        }
        JNI.invokePPV(V, Dest, __functionAddress);
    }

    public static void LLVMGetMDNodeOperands(@NativeType(value="LLVMValueRef") long V, @NativeType(value="LLVMValueRef *") PointerBuffer Dest) {
        if (Checks.CHECKS && Checks.DEBUG) {
            Checks.check(Dest, LLVMCore.LLVMGetMDNodeNumOperands(V));
        }
        LLVMCore.nLLVMGetMDNodeOperands(V, MemoryUtil.memAddress(Dest));
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBasicBlockAsValue(@NativeType(value="LLVMBasicBlockRef") long BB) {
        long __functionAddress = Functions.BasicBlockAsValue;
        if (Checks.CHECKS) {
            Checks.check(BB);
        }
        return JNI.invokePP(BB, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMValueIsBasicBlock(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.ValueIsBasicBlock;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePI(Val, __functionAddress) != 0;
    }

    @NativeType(value="LLVMBasicBlockRef")
    public static long LLVMValueAsBasicBlock(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.ValueAsBasicBlock;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, __functionAddress);
    }

    public static long nLLVMGetBasicBlockName(long BB) {
        long __functionAddress = Functions.GetBasicBlockName;
        if (Checks.CHECKS) {
            Checks.check(BB);
        }
        return JNI.invokePP(BB, __functionAddress);
    }

    @NativeType(value="char const *")
    public static String LLVMGetBasicBlockName(@NativeType(value="LLVMBasicBlockRef") long BB) {
        long __result = LLVMCore.nLLVMGetBasicBlockName(BB);
        return MemoryUtil.memUTF8(__result);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetBasicBlockParent(@NativeType(value="LLVMBasicBlockRef") long BB) {
        long __functionAddress = Functions.GetBasicBlockParent;
        if (Checks.CHECKS) {
            Checks.check(BB);
        }
        return JNI.invokePP(BB, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetBasicBlockTerminator(@NativeType(value="LLVMBasicBlockRef") long BB) {
        long __functionAddress = Functions.GetBasicBlockTerminator;
        if (Checks.CHECKS) {
            Checks.check(BB);
        }
        return JNI.invokePP(BB, __functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMCountBasicBlocks(@NativeType(value="LLVMValueRef") long Fn) {
        long __functionAddress = Functions.CountBasicBlocks;
        if (Checks.CHECKS) {
            Checks.check(Fn);
        }
        return JNI.invokePI(Fn, __functionAddress);
    }

    public static void nLLVMGetBasicBlocks(long Fn, long BasicBlocks) {
        long __functionAddress = Functions.GetBasicBlocks;
        if (Checks.CHECKS) {
            Checks.check(Fn);
        }
        JNI.invokePPV(Fn, BasicBlocks, __functionAddress);
    }

    public static void LLVMGetBasicBlocks(@NativeType(value="LLVMValueRef") long Fn, @NativeType(value="LLVMBasicBlockRef *") PointerBuffer BasicBlocks) {
        if (Checks.CHECKS && Checks.DEBUG) {
            Checks.check(BasicBlocks, LLVMCore.LLVMCountBasicBlocks(Fn));
        }
        LLVMCore.nLLVMGetBasicBlocks(Fn, MemoryUtil.memAddress(BasicBlocks));
    }

    @NativeType(value="LLVMBasicBlockRef")
    public static long LLVMGetFirstBasicBlock(@NativeType(value="LLVMValueRef") long Fn) {
        long __functionAddress = Functions.GetFirstBasicBlock;
        if (Checks.CHECKS) {
            Checks.check(Fn);
        }
        return JNI.invokePP(Fn, __functionAddress);
    }

    @NativeType(value="LLVMBasicBlockRef")
    public static long LLVMGetLastBasicBlock(@NativeType(value="LLVMValueRef") long Fn) {
        long __functionAddress = Functions.GetLastBasicBlock;
        if (Checks.CHECKS) {
            Checks.check(Fn);
        }
        return JNI.invokePP(Fn, __functionAddress);
    }

    @NativeType(value="LLVMBasicBlockRef")
    public static long LLVMGetNextBasicBlock(@NativeType(value="LLVMBasicBlockRef") long BB) {
        long __functionAddress = Functions.GetNextBasicBlock;
        if (Checks.CHECKS) {
            Checks.check(BB);
        }
        return JNI.invokePP(BB, __functionAddress);
    }

    @NativeType(value="LLVMBasicBlockRef")
    public static long LLVMGetPreviousBasicBlock(@NativeType(value="LLVMBasicBlockRef") long BB) {
        long __functionAddress = Functions.GetPreviousBasicBlock;
        if (Checks.CHECKS) {
            Checks.check(BB);
        }
        return JNI.invokePP(BB, __functionAddress);
    }

    @NativeType(value="LLVMBasicBlockRef")
    public static long LLVMGetEntryBasicBlock(@NativeType(value="LLVMValueRef") long Fn) {
        long __functionAddress = Functions.GetEntryBasicBlock;
        if (Checks.CHECKS) {
            Checks.check(Fn);
        }
        return JNI.invokePP(Fn, __functionAddress);
    }

    public static void LLVMInsertExistingBasicBlockAfterInsertBlock(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMBasicBlockRef") long BB) {
        long __functionAddress = Functions.InsertExistingBasicBlockAfterInsertBlock;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Builder2);
            Checks.check(BB);
        }
        JNI.invokePPV(Builder2, BB, __functionAddress);
    }

    public static void LLVMAppendExistingBasicBlock(@NativeType(value="LLVMValueRef") long Fn, @NativeType(value="LLVMBasicBlockRef") long BB) {
        long __functionAddress = Functions.AppendExistingBasicBlock;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Fn);
            Checks.check(BB);
        }
        JNI.invokePPV(Fn, BB, __functionAddress);
    }

    public static long nLLVMCreateBasicBlockInContext(long C, long Name2) {
        long __functionAddress = Functions.CreateBasicBlockInContext;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(C);
        }
        return JNI.invokePPP(C, Name2, __functionAddress);
    }

    @NativeType(value="LLVMBasicBlockRef")
    public static long LLVMCreateBasicBlockInContext(@NativeType(value="LLVMContextRef") long C, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMCreateBasicBlockInContext(C, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMBasicBlockRef")
    public static long LLVMCreateBasicBlockInContext(@NativeType(value="LLVMContextRef") long C, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMCreateBasicBlockInContext(C, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMAppendBasicBlockInContext(long C, long Fn, long Name2) {
        long __functionAddress = Functions.AppendBasicBlockInContext;
        if (Checks.CHECKS) {
            Checks.check(C);
            Checks.check(Fn);
        }
        return JNI.invokePPPP(C, Fn, Name2, __functionAddress);
    }

    @NativeType(value="LLVMBasicBlockRef")
    public static long LLVMAppendBasicBlockInContext(@NativeType(value="LLVMContextRef") long C, @NativeType(value="LLVMValueRef") long Fn, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMAppendBasicBlockInContext(C, Fn, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMBasicBlockRef")
    public static long LLVMAppendBasicBlockInContext(@NativeType(value="LLVMContextRef") long C, @NativeType(value="LLVMValueRef") long Fn, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMAppendBasicBlockInContext(C, Fn, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMAppendBasicBlock(long Fn, long Name2) {
        long __functionAddress = Functions.AppendBasicBlock;
        if (Checks.CHECKS) {
            Checks.check(Fn);
        }
        return JNI.invokePPP(Fn, Name2, __functionAddress);
    }

    @NativeType(value="LLVMBasicBlockRef")
    public static long LLVMAppendBasicBlock(@NativeType(value="LLVMValueRef") long Fn, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMAppendBasicBlock(Fn, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMBasicBlockRef")
    public static long LLVMAppendBasicBlock(@NativeType(value="LLVMValueRef") long Fn, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMAppendBasicBlock(Fn, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMInsertBasicBlockInContext(long C, long BB, long Name2) {
        long __functionAddress = Functions.InsertBasicBlockInContext;
        if (Checks.CHECKS) {
            Checks.check(C);
            Checks.check(BB);
        }
        return JNI.invokePPPP(C, BB, Name2, __functionAddress);
    }

    @NativeType(value="LLVMBasicBlockRef")
    public static long LLVMInsertBasicBlockInContext(@NativeType(value="LLVMContextRef") long C, @NativeType(value="LLVMBasicBlockRef") long BB, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMInsertBasicBlockInContext(C, BB, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMBasicBlockRef")
    public static long LLVMInsertBasicBlockInContext(@NativeType(value="LLVMContextRef") long C, @NativeType(value="LLVMBasicBlockRef") long BB, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMInsertBasicBlockInContext(C, BB, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMInsertBasicBlock(long InsertBeforeBB, long Name2) {
        long __functionAddress = Functions.InsertBasicBlock;
        if (Checks.CHECKS) {
            Checks.check(InsertBeforeBB);
        }
        return JNI.invokePPP(InsertBeforeBB, Name2, __functionAddress);
    }

    @NativeType(value="LLVMBasicBlockRef")
    public static long LLVMInsertBasicBlock(@NativeType(value="LLVMBasicBlockRef") long InsertBeforeBB, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMInsertBasicBlock(InsertBeforeBB, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMBasicBlockRef")
    public static long LLVMInsertBasicBlock(@NativeType(value="LLVMBasicBlockRef") long InsertBeforeBB, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMInsertBasicBlock(InsertBeforeBB, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void LLVMDeleteBasicBlock(@NativeType(value="LLVMBasicBlockRef") long BB) {
        long __functionAddress = Functions.DeleteBasicBlock;
        if (Checks.CHECKS) {
            Checks.check(BB);
        }
        JNI.invokePV(BB, __functionAddress);
    }

    public static void LLVMRemoveBasicBlockFromParent(@NativeType(value="LLVMBasicBlockRef") long BB) {
        long __functionAddress = Functions.RemoveBasicBlockFromParent;
        if (Checks.CHECKS) {
            Checks.check(BB);
        }
        JNI.invokePV(BB, __functionAddress);
    }

    public static void LLVMMoveBasicBlockBefore(@NativeType(value="LLVMBasicBlockRef") long BB, @NativeType(value="LLVMBasicBlockRef") long MovePos) {
        long __functionAddress = Functions.MoveBasicBlockBefore;
        if (Checks.CHECKS) {
            Checks.check(BB);
            Checks.check(MovePos);
        }
        JNI.invokePPV(BB, MovePos, __functionAddress);
    }

    public static void LLVMMoveBasicBlockAfter(@NativeType(value="LLVMBasicBlockRef") long BB, @NativeType(value="LLVMBasicBlockRef") long MovePos) {
        long __functionAddress = Functions.MoveBasicBlockAfter;
        if (Checks.CHECKS) {
            Checks.check(BB);
            Checks.check(MovePos);
        }
        JNI.invokePPV(BB, MovePos, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetFirstInstruction(@NativeType(value="LLVMBasicBlockRef") long BB) {
        long __functionAddress = Functions.GetFirstInstruction;
        if (Checks.CHECKS) {
            Checks.check(BB);
        }
        return JNI.invokePP(BB, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetLastInstruction(@NativeType(value="LLVMBasicBlockRef") long BB) {
        long __functionAddress = Functions.GetLastInstruction;
        if (Checks.CHECKS) {
            Checks.check(BB);
        }
        return JNI.invokePP(BB, __functionAddress);
    }

    @NativeType(value="int")
    public static boolean LLVMHasMetadata(@NativeType(value="LLVMValueRef") long Val) {
        long __functionAddress = Functions.HasMetadata;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePI(Val, __functionAddress) != 0;
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetMetadata(@NativeType(value="LLVMValueRef") long Val, @NativeType(value="unsigned int") int KindID) {
        long __functionAddress = Functions.GetMetadata;
        if (Checks.CHECKS) {
            Checks.check(Val);
        }
        return JNI.invokePP(Val, KindID, __functionAddress);
    }

    public static void LLVMSetMetadata(@NativeType(value="LLVMValueRef") long Val, @NativeType(value="unsigned int") int KindID, @NativeType(value="LLVMValueRef") long Node2) {
        long __functionAddress = Functions.SetMetadata;
        if (Checks.CHECKS) {
            Checks.check(Val);
            Checks.check(Node2);
        }
        JNI.invokePPV(Val, KindID, Node2, __functionAddress);
    }

    public static long nLLVMInstructionGetAllMetadataOtherThanDebugLoc(long Instr, long NumEntries) {
        long __functionAddress = Functions.InstructionGetAllMetadataOtherThanDebugLoc;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Instr);
        }
        return JNI.invokePPP(Instr, NumEntries, __functionAddress);
    }

    @NativeType(value="LLVMValueMetadataEntry *")
    public static long LLVMInstructionGetAllMetadataOtherThanDebugLoc(@NativeType(value="LLVMValueRef") long Instr, @NativeType(value="size_t *") PointerBuffer NumEntries) {
        if (Checks.CHECKS) {
            Checks.check(NumEntries, 1);
        }
        return LLVMCore.nLLVMInstructionGetAllMetadataOtherThanDebugLoc(Instr, MemoryUtil.memAddress(NumEntries));
    }

    @NativeType(value="LLVMBasicBlockRef")
    public static long LLVMGetInstructionParent(@NativeType(value="LLVMValueRef") long Inst) {
        long __functionAddress = Functions.GetInstructionParent;
        if (Checks.CHECKS) {
            Checks.check(Inst);
        }
        return JNI.invokePP(Inst, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetNextInstruction(@NativeType(value="LLVMValueRef") long Inst) {
        long __functionAddress = Functions.GetNextInstruction;
        if (Checks.CHECKS) {
            Checks.check(Inst);
        }
        return JNI.invokePP(Inst, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetPreviousInstruction(@NativeType(value="LLVMValueRef") long Inst) {
        long __functionAddress = Functions.GetPreviousInstruction;
        if (Checks.CHECKS) {
            Checks.check(Inst);
        }
        return JNI.invokePP(Inst, __functionAddress);
    }

    public static void LLVMInstructionRemoveFromParent(@NativeType(value="LLVMValueRef") long Inst) {
        long __functionAddress = Functions.InstructionRemoveFromParent;
        if (Checks.CHECKS) {
            Checks.check(Inst);
        }
        JNI.invokePV(Inst, __functionAddress);
    }

    public static void LLVMInstructionEraseFromParent(@NativeType(value="LLVMValueRef") long Inst) {
        long __functionAddress = Functions.InstructionEraseFromParent;
        if (Checks.CHECKS) {
            Checks.check(Inst);
        }
        JNI.invokePV(Inst, __functionAddress);
    }

    @NativeType(value="LLVMOpcode")
    public static int LLVMGetInstructionOpcode(@NativeType(value="LLVMValueRef") long Inst) {
        long __functionAddress = Functions.GetInstructionOpcode;
        if (Checks.CHECKS) {
            Checks.check(Inst);
        }
        return JNI.invokePI(Inst, __functionAddress);
    }

    @NativeType(value="LLVMIntPredicate")
    public static int LLVMGetICmpPredicate(@NativeType(value="LLVMValueRef") long Inst) {
        long __functionAddress = Functions.GetICmpPredicate;
        if (Checks.CHECKS) {
            Checks.check(Inst);
        }
        return JNI.invokePI(Inst, __functionAddress);
    }

    @NativeType(value="LLVMRealPredicate")
    public static int LLVMGetFCmpPredicate(@NativeType(value="LLVMValueRef") long Inst) {
        long __functionAddress = Functions.GetFCmpPredicate;
        if (Checks.CHECKS) {
            Checks.check(Inst);
        }
        return JNI.invokePI(Inst, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMInstructionClone(@NativeType(value="LLVMValueRef") long Inst) {
        long __functionAddress = Functions.InstructionClone;
        if (Checks.CHECKS) {
            Checks.check(Inst);
        }
        return JNI.invokePP(Inst, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMIsATerminatorInst(@NativeType(value="LLVMValueRef") long Inst) {
        long __functionAddress = Functions.IsATerminatorInst;
        if (Checks.CHECKS) {
            Checks.check(Inst);
        }
        return JNI.invokePP(Inst, __functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetNumArgOperands(@NativeType(value="LLVMValueRef") long Instr) {
        long __functionAddress = Functions.GetNumArgOperands;
        if (Checks.CHECKS) {
            Checks.check(Instr);
        }
        return JNI.invokePI(Instr, __functionAddress);
    }

    public static void LLVMSetInstructionCallConv(@NativeType(value="LLVMValueRef") long Instr, @NativeType(value="unsigned int") int CC) {
        long __functionAddress = Functions.SetInstructionCallConv;
        if (Checks.CHECKS) {
            Checks.check(Instr);
        }
        JNI.invokePV(Instr, CC, __functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetInstructionCallConv(@NativeType(value="LLVMValueRef") long Instr) {
        long __functionAddress = Functions.GetInstructionCallConv;
        if (Checks.CHECKS) {
            Checks.check(Instr);
        }
        return JNI.invokePI(Instr, __functionAddress);
    }

    public static void LLVMSetInstrParamAlignment(@NativeType(value="LLVMValueRef") long Instr, @NativeType(value="unsigned int") int index, @NativeType(value="unsigned int") int Align) {
        long __functionAddress = Functions.SetInstrParamAlignment;
        if (Checks.CHECKS) {
            Checks.check(Instr);
        }
        JNI.invokePV(Instr, index, Align, __functionAddress);
    }

    public static void LLVMAddCallSiteAttribute(@NativeType(value="LLVMValueRef") long C, @NativeType(value="LLVMAttributeIndex") int Idx, @NativeType(value="LLVMAttributeRef") long A) {
        long __functionAddress = Functions.AddCallSiteAttribute;
        if (Checks.CHECKS) {
            Checks.check(C);
            Checks.check(A);
        }
        JNI.invokePPV(C, Idx, A, __functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetCallSiteAttributeCount(@NativeType(value="LLVMValueRef") long C, @NativeType(value="LLVMAttributeIndex") int Idx) {
        long __functionAddress = Functions.GetCallSiteAttributeCount;
        if (Checks.CHECKS) {
            Checks.check(C);
        }
        return JNI.invokePI(C, Idx, __functionAddress);
    }

    public static void nLLVMGetCallSiteAttributes(long C, int Idx, long Attrs) {
        long __functionAddress = Functions.GetCallSiteAttributes;
        if (Checks.CHECKS) {
            Checks.check(C);
        }
        JNI.invokePPV(C, Idx, Attrs, __functionAddress);
    }

    public static void LLVMGetCallSiteAttributes(@NativeType(value="LLVMValueRef") long C, @NativeType(value="LLVMAttributeIndex") int Idx, @NativeType(value="LLVMAttributeRef *") PointerBuffer Attrs) {
        if (Checks.CHECKS && Checks.DEBUG) {
            Checks.check(Attrs, LLVMCore.LLVMGetCallSiteAttributeCount(C, Idx));
        }
        LLVMCore.nLLVMGetCallSiteAttributes(C, Idx, MemoryUtil.memAddress(Attrs));
    }

    @NativeType(value="LLVMAttributeRef")
    public static long LLVMGetCallSiteEnumAttribute(@NativeType(value="LLVMValueRef") long C, @NativeType(value="LLVMAttributeIndex") int Idx, @NativeType(value="unsigned int") int KindID) {
        long __functionAddress = Functions.GetCallSiteEnumAttribute;
        if (Checks.CHECKS) {
            Checks.check(C);
        }
        return JNI.invokePP(C, Idx, KindID, __functionAddress);
    }

    public static long nLLVMGetCallSiteStringAttribute(long C, int Idx, long K, int KLen) {
        long __functionAddress = Functions.GetCallSiteStringAttribute;
        if (Checks.CHECKS) {
            Checks.check(C);
        }
        return JNI.invokePPP(C, Idx, K, KLen, __functionAddress);
    }

    @NativeType(value="LLVMAttributeRef")
    public static long LLVMGetCallSiteStringAttribute(@NativeType(value="LLVMValueRef") long C, @NativeType(value="LLVMAttributeIndex") int Idx, @NativeType(value="char const *") ByteBuffer K) {
        return LLVMCore.nLLVMGetCallSiteStringAttribute(C, Idx, MemoryUtil.memAddress(K), K.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMAttributeRef")
    public static long LLVMGetCallSiteStringAttribute(@NativeType(value="LLVMValueRef") long C, @NativeType(value="LLVMAttributeIndex") int Idx, @NativeType(value="char const *") CharSequence K) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int KEncodedLength = stack.nUTF8(K, false);
            long KEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMGetCallSiteStringAttribute(C, Idx, KEncoded, KEncodedLength);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void LLVMRemoveCallSiteEnumAttribute(@NativeType(value="LLVMValueRef") long C, @NativeType(value="LLVMAttributeIndex") int Idx, @NativeType(value="unsigned int") int KindID) {
        long __functionAddress = Functions.RemoveCallSiteEnumAttribute;
        if (Checks.CHECKS) {
            Checks.check(C);
        }
        JNI.invokePV(C, Idx, KindID, __functionAddress);
    }

    public static void nLLVMRemoveCallSiteStringAttribute(long C, int Idx, long K, int KLen) {
        long __functionAddress = Functions.RemoveCallSiteStringAttribute;
        if (Checks.CHECKS) {
            Checks.check(C);
        }
        JNI.invokePPV(C, Idx, K, KLen, __functionAddress);
    }

    public static void LLVMRemoveCallSiteStringAttribute(@NativeType(value="LLVMValueRef") long C, @NativeType(value="LLVMAttributeIndex") int Idx, @NativeType(value="char const *") ByteBuffer K) {
        LLVMCore.nLLVMRemoveCallSiteStringAttribute(C, Idx, MemoryUtil.memAddress(K), K.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void LLVMRemoveCallSiteStringAttribute(@NativeType(value="LLVMValueRef") long C, @NativeType(value="LLVMAttributeIndex") int Idx, @NativeType(value="char const *") CharSequence K) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int KEncodedLength = stack.nUTF8(K, false);
            long KEncoded = stack.getPointerAddress();
            LLVMCore.nLLVMRemoveCallSiteStringAttribute(C, Idx, KEncoded, KEncodedLength);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMGetCalledFunctionType(@NativeType(value="LLVMValueRef") long C) {
        long __functionAddress = Functions.GetCalledFunctionType;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(C);
        }
        return JNI.invokePP(C, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetCalledValue(@NativeType(value="LLVMValueRef") long Instr) {
        long __functionAddress = Functions.GetCalledValue;
        if (Checks.CHECKS) {
            Checks.check(Instr);
        }
        return JNI.invokePP(Instr, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsTailCall(@NativeType(value="LLVMValueRef") long CallInst) {
        long __functionAddress = Functions.IsTailCall;
        if (Checks.CHECKS) {
            Checks.check(CallInst);
        }
        return JNI.invokePI(CallInst, __functionAddress) != 0;
    }

    public static void LLVMSetTailCall(@NativeType(value="LLVMValueRef") long CallInst, @NativeType(value="LLVMBool") boolean IsTailCall) {
        long __functionAddress = Functions.SetTailCall;
        if (Checks.CHECKS) {
            Checks.check(CallInst);
        }
        JNI.invokePV(CallInst, IsTailCall ? 1 : 0, __functionAddress);
    }

    @NativeType(value="LLVMBasicBlockRef")
    public static long LLVMGetNormalDest(@NativeType(value="LLVMValueRef") long InvokeInst) {
        long __functionAddress = Functions.GetNormalDest;
        if (Checks.CHECKS) {
            Checks.check(InvokeInst);
        }
        return JNI.invokePP(InvokeInst, __functionAddress);
    }

    @NativeType(value="LLVMBasicBlockRef")
    public static long LLVMGetUnwindDest(@NativeType(value="LLVMValueRef") long InvokeInst) {
        long __functionAddress = Functions.GetUnwindDest;
        if (Checks.CHECKS) {
            Checks.check(InvokeInst);
        }
        return JNI.invokePP(InvokeInst, __functionAddress);
    }

    public static void LLVMSetNormalDest(@NativeType(value="LLVMValueRef") long InvokeInst, @NativeType(value="LLVMBasicBlockRef") long B) {
        long __functionAddress = Functions.SetNormalDest;
        if (Checks.CHECKS) {
            Checks.check(InvokeInst);
            Checks.check(B);
        }
        JNI.invokePPV(InvokeInst, B, __functionAddress);
    }

    public static void LLVMSetUnwindDest(@NativeType(value="LLVMValueRef") long InvokeInst, @NativeType(value="LLVMBasicBlockRef") long B) {
        long __functionAddress = Functions.SetUnwindDest;
        if (Checks.CHECKS) {
            Checks.check(InvokeInst);
            Checks.check(B);
        }
        JNI.invokePPV(InvokeInst, B, __functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetNumSuccessors(@NativeType(value="LLVMValueRef") long Term) {
        long __functionAddress = Functions.GetNumSuccessors;
        if (Checks.CHECKS) {
            Checks.check(Term);
        }
        return JNI.invokePI(Term, __functionAddress);
    }

    @NativeType(value="LLVMBasicBlockRef")
    public static long LLVMGetSuccessor(@NativeType(value="LLVMValueRef") long Term, @NativeType(value="unsigned int") int i) {
        long __functionAddress = Functions.GetSuccessor;
        if (Checks.CHECKS) {
            Checks.check(Term);
        }
        return JNI.invokePP(Term, i, __functionAddress);
    }

    public static void LLVMSetSuccessor(@NativeType(value="LLVMValueRef") long Term, @NativeType(value="unsigned int") int i, @NativeType(value="LLVMBasicBlockRef") long block) {
        long __functionAddress = Functions.SetSuccessor;
        if (Checks.CHECKS) {
            Checks.check(Term);
            Checks.check(block);
        }
        JNI.invokePPV(Term, i, block, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsConditional(@NativeType(value="LLVMValueRef") long Branch2) {
        long __functionAddress = Functions.IsConditional;
        if (Checks.CHECKS) {
            Checks.check(Branch2);
        }
        return JNI.invokePI(Branch2, __functionAddress) != 0;
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetCondition(@NativeType(value="LLVMValueRef") long Branch2) {
        long __functionAddress = Functions.GetCondition;
        if (Checks.CHECKS) {
            Checks.check(Branch2);
        }
        return JNI.invokePP(Branch2, __functionAddress);
    }

    public static void LLVMSetCondition(@NativeType(value="LLVMValueRef") long Branch2, @NativeType(value="LLVMValueRef") long Cond) {
        long __functionAddress = Functions.SetCondition;
        if (Checks.CHECKS) {
            Checks.check(Branch2);
            Checks.check(Cond);
        }
        JNI.invokePPV(Branch2, Cond, __functionAddress);
    }

    @NativeType(value="LLVMBasicBlockRef")
    public static long LLVMGetSwitchDefaultDest(@NativeType(value="LLVMValueRef") long SwitchInstr) {
        long __functionAddress = Functions.GetSwitchDefaultDest;
        if (Checks.CHECKS) {
            Checks.check(SwitchInstr);
        }
        return JNI.invokePP(SwitchInstr, __functionAddress);
    }

    @NativeType(value="LLVMTypeRef")
    public static long LLVMGetAllocatedType(@NativeType(value="LLVMValueRef") long Alloca) {
        long __functionAddress = Functions.GetAllocatedType;
        if (Checks.CHECKS) {
            Checks.check(Alloca);
        }
        return JNI.invokePP(Alloca, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsInBounds(@NativeType(value="LLVMValueRef") long GEP) {
        long __functionAddress = Functions.IsInBounds;
        if (Checks.CHECKS) {
            Checks.check(GEP);
        }
        return JNI.invokePI(GEP, __functionAddress) != 0;
    }

    public static void LLVMSetIsInBounds(@NativeType(value="LLVMValueRef") long GEP, @NativeType(value="LLVMBool") boolean InBounds) {
        long __functionAddress = Functions.SetIsInBounds;
        if (Checks.CHECKS) {
            Checks.check(GEP);
        }
        JNI.invokePV(GEP, InBounds ? 1 : 0, __functionAddress);
    }

    public static void nLLVMAddIncoming(long PhiNode, long IncomingValues, long IncomingBlocks, int Count) {
        long __functionAddress = Functions.AddIncoming;
        if (Checks.CHECKS) {
            Checks.check(PhiNode);
        }
        JNI.invokePPPV(PhiNode, IncomingValues, IncomingBlocks, Count, __functionAddress);
    }

    public static void LLVMAddIncoming(@NativeType(value="LLVMValueRef") long PhiNode, @NativeType(value="LLVMValueRef *") PointerBuffer IncomingValues, @NativeType(value="LLVMBasicBlockRef *") PointerBuffer IncomingBlocks) {
        if (Checks.CHECKS) {
            Checks.check(IncomingBlocks, IncomingValues.remaining());
        }
        LLVMCore.nLLVMAddIncoming(PhiNode, MemoryUtil.memAddress(IncomingValues), MemoryUtil.memAddress(IncomingBlocks), IncomingValues.remaining());
    }

    @NativeType(value="unsigned int")
    public static int LLVMCountIncoming(@NativeType(value="LLVMValueRef") long PhiNode) {
        long __functionAddress = Functions.CountIncoming;
        if (Checks.CHECKS) {
            Checks.check(PhiNode);
        }
        return JNI.invokePI(PhiNode, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetIncomingValue(@NativeType(value="LLVMValueRef") long PhiNode, @NativeType(value="unsigned int") int Index) {
        long __functionAddress = Functions.GetIncomingValue;
        if (Checks.CHECKS) {
            Checks.check(PhiNode);
        }
        return JNI.invokePP(PhiNode, Index, __functionAddress);
    }

    @NativeType(value="LLVMBasicBlockRef")
    public static long LLVMGetIncomingBlock(@NativeType(value="LLVMValueRef") long PhiNode, @NativeType(value="unsigned int") int Index) {
        long __functionAddress = Functions.GetIncomingBlock;
        if (Checks.CHECKS) {
            Checks.check(PhiNode);
        }
        return JNI.invokePP(PhiNode, Index, __functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetNumIndices(@NativeType(value="LLVMValueRef") long Inst) {
        long __functionAddress = Functions.GetNumIndices;
        if (Checks.CHECKS) {
            Checks.check(Inst);
        }
        return JNI.invokePI(Inst, __functionAddress);
    }

    public static long nLLVMGetIndices(long Inst) {
        long __functionAddress = Functions.GetIndices;
        if (Checks.CHECKS) {
            Checks.check(Inst);
        }
        return JNI.invokePP(Inst, __functionAddress);
    }

    @NativeType(value="unsigned int const *")
    public static IntBuffer LLVMGetIndices(@NativeType(value="LLVMValueRef") long Inst, @NativeType(value="unsigned int") int Count) {
        long __result = LLVMCore.nLLVMGetIndices(Inst);
        return MemoryUtil.memIntBuffer(__result, Count);
    }

    @NativeType(value="LLVMBuilderRef")
    public static long LLVMCreateBuilderInContext(@NativeType(value="LLVMContextRef") long C) {
        long __functionAddress = Functions.CreateBuilderInContext;
        if (Checks.CHECKS) {
            Checks.check(C);
        }
        return JNI.invokePP(C, __functionAddress);
    }

    @NativeType(value="LLVMBuilderRef")
    public static long LLVMCreateBuilder() {
        long __functionAddress = Functions.CreateBuilder;
        return JNI.invokeP(__functionAddress);
    }

    public static void LLVMPositionBuilder(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMBasicBlockRef") long Block, @NativeType(value="LLVMValueRef") long Instr) {
        long __functionAddress = Functions.PositionBuilder;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Block);
            Checks.check(Instr);
        }
        JNI.invokePPPV(Builder2, Block, Instr, __functionAddress);
    }

    public static void LLVMPositionBuilderBefore(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Instr) {
        long __functionAddress = Functions.PositionBuilderBefore;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Instr);
        }
        JNI.invokePPV(Builder2, Instr, __functionAddress);
    }

    public static void LLVMPositionBuilderAtEnd(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMBasicBlockRef") long Block) {
        long __functionAddress = Functions.PositionBuilderAtEnd;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Block);
        }
        JNI.invokePPV(Builder2, Block, __functionAddress);
    }

    @NativeType(value="LLVMBasicBlockRef")
    public static long LLVMGetInsertBlock(@NativeType(value="LLVMBuilderRef") long Builder2) {
        long __functionAddress = Functions.GetInsertBlock;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
        }
        return JNI.invokePP(Builder2, __functionAddress);
    }

    public static void LLVMClearInsertionPosition(@NativeType(value="LLVMBuilderRef") long Builder2) {
        long __functionAddress = Functions.ClearInsertionPosition;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
        }
        JNI.invokePV(Builder2, __functionAddress);
    }

    public static void LLVMInsertIntoBuilder(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Instr) {
        long __functionAddress = Functions.InsertIntoBuilder;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Instr);
        }
        JNI.invokePPV(Builder2, Instr, __functionAddress);
    }

    public static void nLLVMInsertIntoBuilderWithName(long Builder2, long Instr, long Name2) {
        long __functionAddress = Functions.InsertIntoBuilderWithName;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Instr);
        }
        JNI.invokePPPV(Builder2, Instr, Name2, __functionAddress);
    }

    public static void LLVMInsertIntoBuilderWithName(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Instr, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        LLVMCore.nLLVMInsertIntoBuilderWithName(Builder2, Instr, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void LLVMInsertIntoBuilderWithName(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Instr, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            LLVMCore.nLLVMInsertIntoBuilderWithName(Builder2, Instr, NameEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void LLVMDisposeBuilder(@NativeType(value="LLVMBuilderRef") long Builder2) {
        long __functionAddress = Functions.DisposeBuilder;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
        }
        JNI.invokePV(Builder2, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMGetCurrentDebugLocation2(@NativeType(value="LLVMBuilderRef") long Builder2) {
        long __functionAddress = Functions.GetCurrentDebugLocation2;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Builder2);
        }
        return JNI.invokePP(Builder2, __functionAddress);
    }

    public static void LLVMSetCurrentDebugLocation2(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMMetadataRef") long Loc) {
        long __functionAddress = Functions.SetCurrentDebugLocation2;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Builder2);
        }
        JNI.invokePPV(Builder2, Loc, __functionAddress);
    }

    public static void LLVMSetInstDebugLocation(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Inst) {
        long __functionAddress = Functions.SetInstDebugLocation;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Builder2);
            Checks.check(Inst);
        }
        JNI.invokePPV(Builder2, Inst, __functionAddress);
    }

    @NativeType(value="LLVMMetadataRef")
    public static long LLVMBuilderGetDefaultFPMathTag(@NativeType(value="LLVMBuilderRef") long Builder2) {
        long __functionAddress = Functions.BuilderGetDefaultFPMathTag;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Builder2);
        }
        return JNI.invokePP(Builder2, __functionAddress);
    }

    public static void LLVMBuilderSetDefaultFPMathTag(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMMetadataRef") long FPMathTag) {
        long __functionAddress = Functions.BuilderSetDefaultFPMathTag;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Builder2);
        }
        JNI.invokePPV(Builder2, FPMathTag, __functionAddress);
    }

    public static void LLVMSetCurrentDebugLocation(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long L) {
        long __functionAddress = Functions.SetCurrentDebugLocation;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(L);
        }
        JNI.invokePPV(Builder2, L, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetCurrentDebugLocation(@NativeType(value="LLVMBuilderRef") long Builder2) {
        long __functionAddress = Functions.GetCurrentDebugLocation;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
        }
        return JNI.invokePP(Builder2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildRetVoid(@NativeType(value="LLVMBuilderRef") long Builder2) {
        long __functionAddress = Functions.BuildRetVoid;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
        }
        return JNI.invokePP(Builder2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildRet(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long V) {
        long __functionAddress = Functions.BuildRet;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(V);
        }
        return JNI.invokePPP(Builder2, V, __functionAddress);
    }

    public static long nLLVMBuildAggregateRet(long Builder2, long RetVals, int N) {
        long __functionAddress = Functions.BuildAggregateRet;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
        }
        return JNI.invokePPP(Builder2, RetVals, N, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildAggregateRet(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef *") PointerBuffer RetVals) {
        return LLVMCore.nLLVMBuildAggregateRet(Builder2, MemoryUtil.memAddress(RetVals), RetVals.remaining());
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildBr(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMBasicBlockRef") long Dest) {
        long __functionAddress = Functions.BuildBr;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Dest);
        }
        return JNI.invokePPP(Builder2, Dest, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildCondBr(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long If, @NativeType(value="LLVMBasicBlockRef") long Then, @NativeType(value="LLVMBasicBlockRef") long Else) {
        long __functionAddress = Functions.BuildCondBr;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(If);
            Checks.check(Then);
            Checks.check(Else);
        }
        return JNI.invokePPPPP(Builder2, If, Then, Else, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildSwitch(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long V, @NativeType(value="LLVMBasicBlockRef") long Else, @NativeType(value="unsigned int") int NumCases) {
        long __functionAddress = Functions.BuildSwitch;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(V);
            Checks.check(Else);
        }
        return JNI.invokePPPP(Builder2, V, Else, NumCases, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildIndirectBr(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMValueRef") long Addr, @NativeType(value="unsigned int") int NumDests) {
        long __functionAddress = Functions.BuildIndirectBr;
        if (Checks.CHECKS) {
            Checks.check(B);
            Checks.check(Addr);
        }
        return JNI.invokePPP(B, Addr, NumDests, __functionAddress);
    }

    public static long nLLVMBuildInvoke(long Builder2, long Fn, long Args, int NumArgs, long Then, long Catch, long Name2) {
        long __functionAddress = Functions.BuildInvoke;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Fn);
            Checks.check(Then);
            Checks.check(Catch);
        }
        return JNI.invokePPPPPPP(Builder2, Fn, Args, NumArgs, Then, Catch, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildInvoke(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Fn, @NativeType(value="LLVMValueRef *") PointerBuffer Args, @NativeType(value="LLVMBasicBlockRef") long Then, @NativeType(value="LLVMBasicBlockRef") long Catch, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildInvoke(Builder2, Fn, MemoryUtil.memAddress(Args), Args.remaining(), Then, Catch, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildInvoke(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Fn, @NativeType(value="LLVMValueRef *") PointerBuffer Args, @NativeType(value="LLVMBasicBlockRef") long Then, @NativeType(value="LLVMBasicBlockRef") long Catch, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildInvoke(Builder2, Fn, MemoryUtil.memAddress(Args), Args.remaining(), Then, Catch, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildInvoke2(long Builder2, long Ty, long Fn, long Args, int NumArgs, long Then, long Catch, long Name2) {
        long __functionAddress = Functions.BuildInvoke2;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Builder2);
            Checks.check(Ty);
            Checks.check(Fn);
            Checks.check(Then);
            Checks.check(Catch);
        }
        return JNI.invokePPPPPPPP(Builder2, Ty, Fn, Args, NumArgs, Then, Catch, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildInvoke2(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="LLVMValueRef") long Fn, @NativeType(value="LLVMValueRef *") PointerBuffer Args, @NativeType(value="LLVMBasicBlockRef") long Then, @NativeType(value="LLVMBasicBlockRef") long Catch, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildInvoke2(Builder2, Ty, Fn, MemoryUtil.memAddress(Args), Args.remaining(), Then, Catch, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildInvoke2(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="LLVMValueRef") long Fn, @NativeType(value="LLVMValueRef *") PointerBuffer Args, @NativeType(value="LLVMBasicBlockRef") long Then, @NativeType(value="LLVMBasicBlockRef") long Catch, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildInvoke2(Builder2, Ty, Fn, MemoryUtil.memAddress(Args), Args.remaining(), Then, Catch, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildUnreachable(@NativeType(value="LLVMBuilderRef") long Builder2) {
        long __functionAddress = Functions.BuildUnreachable;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
        }
        return JNI.invokePP(Builder2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildResume(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMValueRef") long Exn) {
        long __functionAddress = Functions.BuildResume;
        if (Checks.CHECKS) {
            Checks.check(B);
            Checks.check(Exn);
        }
        return JNI.invokePPP(B, Exn, __functionAddress);
    }

    public static long nLLVMBuildLandingPad(long B, long Ty, long PersFn, int NumClauses, long Name2) {
        long __functionAddress = Functions.BuildLandingPad;
        if (Checks.CHECKS) {
            Checks.check(B);
            Checks.check(Ty);
            Checks.check(PersFn);
        }
        return JNI.invokePPPPP(B, Ty, PersFn, NumClauses, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildLandingPad(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="LLVMValueRef") long PersFn, @NativeType(value="unsigned int") int NumClauses, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildLandingPad(B, Ty, PersFn, NumClauses, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildLandingPad(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="LLVMValueRef") long PersFn, @NativeType(value="unsigned int") int NumClauses, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildLandingPad(B, Ty, PersFn, NumClauses, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildCleanupRet(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMValueRef") long CatchPad, @NativeType(value="LLVMBasicBlockRef") long BB) {
        long __functionAddress = Functions.BuildCleanupRet;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(B);
            Checks.check(CatchPad);
            Checks.check(BB);
        }
        return JNI.invokePPPP(B, CatchPad, BB, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildCatchRet(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMValueRef") long CatchPad, @NativeType(value="LLVMBasicBlockRef") long BB) {
        long __functionAddress = Functions.BuildCatchRet;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(B);
            Checks.check(CatchPad);
            Checks.check(BB);
        }
        return JNI.invokePPPP(B, CatchPad, BB, __functionAddress);
    }

    public static long nLLVMBuildCatchPad(long B, long ParentPad, long Args, int NumArgs, long Name2) {
        long __functionAddress = Functions.BuildCatchPad;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(B);
            Checks.check(ParentPad);
        }
        return JNI.invokePPPPP(B, ParentPad, Args, NumArgs, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildCatchPad(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMValueRef") long ParentPad, @NativeType(value="LLVMValueRef *") PointerBuffer Args, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildCatchPad(B, ParentPad, MemoryUtil.memAddress(Args), Args.remaining(), MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildCatchPad(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMValueRef") long ParentPad, @NativeType(value="LLVMValueRef *") PointerBuffer Args, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildCatchPad(B, ParentPad, MemoryUtil.memAddress(Args), Args.remaining(), NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildCleanupPad(long B, long ParentPad, long Args, int NumArgs, long Name2) {
        long __functionAddress = Functions.BuildCleanupPad;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(B);
            Checks.check(ParentPad);
        }
        return JNI.invokePPPPP(B, ParentPad, Args, NumArgs, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildCleanupPad(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMValueRef") long ParentPad, @NativeType(value="LLVMValueRef *") PointerBuffer Args, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildCleanupPad(B, ParentPad, MemoryUtil.memAddress(Args), Args.remaining(), MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildCleanupPad(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMValueRef") long ParentPad, @NativeType(value="LLVMValueRef *") PointerBuffer Args, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildCleanupPad(B, ParentPad, MemoryUtil.memAddress(Args), Args.remaining(), NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildCatchSwitch(long B, long ParentPad, long UnwindBB, int NumHandlers, long Name2) {
        long __functionAddress = Functions.BuildCatchSwitch;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(B);
            Checks.check(ParentPad);
            Checks.check(UnwindBB);
        }
        return JNI.invokePPPPP(B, ParentPad, UnwindBB, NumHandlers, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildCatchSwitch(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMValueRef") long ParentPad, @NativeType(value="LLVMBasicBlockRef") long UnwindBB, @NativeType(value="unsigned int") int NumHandlers, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildCatchSwitch(B, ParentPad, UnwindBB, NumHandlers, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildCatchSwitch(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMValueRef") long ParentPad, @NativeType(value="LLVMBasicBlockRef") long UnwindBB, @NativeType(value="unsigned int") int NumHandlers, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildCatchSwitch(B, ParentPad, UnwindBB, NumHandlers, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void LLVMAddCase(@NativeType(value="LLVMValueRef") long Switch, @NativeType(value="LLVMValueRef") long OnVal, @NativeType(value="LLVMBasicBlockRef") long Dest) {
        long __functionAddress = Functions.AddCase;
        if (Checks.CHECKS) {
            Checks.check(Switch);
            Checks.check(OnVal);
            Checks.check(Dest);
        }
        JNI.invokePPPV(Switch, OnVal, Dest, __functionAddress);
    }

    public static void LLVMAddDestination(@NativeType(value="LLVMValueRef") long IndirectBr, @NativeType(value="LLVMBasicBlockRef") long Dest) {
        long __functionAddress = Functions.AddDestination;
        if (Checks.CHECKS) {
            Checks.check(IndirectBr);
            Checks.check(Dest);
        }
        JNI.invokePPV(IndirectBr, Dest, __functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetNumClauses(@NativeType(value="LLVMValueRef") long LandingPad) {
        long __functionAddress = Functions.GetNumClauses;
        if (Checks.CHECKS) {
            Checks.check(LandingPad);
        }
        return JNI.invokePI(LandingPad, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetClause(@NativeType(value="LLVMValueRef") long LandingPad, @NativeType(value="unsigned int") int Idx) {
        long __functionAddress = Functions.GetClause;
        if (Checks.CHECKS) {
            Checks.check(LandingPad);
        }
        return JNI.invokePP(LandingPad, Idx, __functionAddress);
    }

    public static void LLVMAddClause(@NativeType(value="LLVMValueRef") long LandingPad, @NativeType(value="LLVMValueRef") long ClauseVal) {
        long __functionAddress = Functions.AddClause;
        if (Checks.CHECKS) {
            Checks.check(LandingPad);
            Checks.check(ClauseVal);
        }
        JNI.invokePPV(LandingPad, ClauseVal, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsCleanup(@NativeType(value="LLVMValueRef") long LandingPad) {
        long __functionAddress = Functions.IsCleanup;
        if (Checks.CHECKS) {
            Checks.check(LandingPad);
        }
        return JNI.invokePI(LandingPad, __functionAddress) != 0;
    }

    public static void LLVMSetCleanup(@NativeType(value="LLVMValueRef") long LandingPad, @NativeType(value="LLVMBool") boolean Val) {
        long __functionAddress = Functions.SetCleanup;
        if (Checks.CHECKS) {
            Checks.check(LandingPad);
        }
        JNI.invokePV(LandingPad, Val ? 1 : 0, __functionAddress);
    }

    public static void LLVMAddHandler(@NativeType(value="LLVMValueRef") long CatchSwitch, @NativeType(value="LLVMBasicBlockRef") long Dest) {
        long __functionAddress = Functions.AddHandler;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(CatchSwitch);
            Checks.check(Dest);
        }
        JNI.invokePPV(CatchSwitch, Dest, __functionAddress);
    }

    @NativeType(value="unsigned int")
    public static int LLVMGetNumHandlers(@NativeType(value="LLVMValueRef") long CatchSwitch) {
        long __functionAddress = Functions.GetNumHandlers;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(CatchSwitch);
        }
        return JNI.invokePI(CatchSwitch, __functionAddress);
    }

    public static void nLLVMGetHandlers(long CatchSwitch, long Handlers) {
        long __functionAddress = Functions.GetHandlers;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(CatchSwitch);
        }
        JNI.invokePPV(CatchSwitch, Handlers, __functionAddress);
    }

    public static void LLVMGetHandlers(@NativeType(value="LLVMValueRef") long CatchSwitch, @NativeType(value="LLVMBasicBlockRef *") PointerBuffer Handlers) {
        if (Checks.CHECKS && Checks.DEBUG) {
            Checks.check(Handlers, LLVMCore.LLVMGetNumHandlers(CatchSwitch));
        }
        LLVMCore.nLLVMGetHandlers(CatchSwitch, MemoryUtil.memAddress(Handlers));
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetArgOperand(@NativeType(value="LLVMValueRef") long Funclet, @NativeType(value="unsigned int") int i) {
        long __functionAddress = Functions.GetArgOperand;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Funclet);
        }
        return JNI.invokePP(Funclet, i, __functionAddress);
    }

    public static void LLVMSetArgOperand(@NativeType(value="LLVMValueRef") long Funclet, @NativeType(value="unsigned int") int i, @NativeType(value="LLVMValueRef") long value) {
        long __functionAddress = Functions.SetArgOperand;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Funclet);
            Checks.check(value);
        }
        JNI.invokePPV(Funclet, i, value, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMGetParentCatchSwitch(@NativeType(value="LLVMValueRef") long CatchPad) {
        long __functionAddress = Functions.GetParentCatchSwitch;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(CatchPad);
        }
        return JNI.invokePP(CatchPad, __functionAddress);
    }

    public static void LLVMSetParentCatchSwitch(@NativeType(value="LLVMValueRef") long CatchPad, @NativeType(value="LLVMValueRef") long CatchSwitch) {
        long __functionAddress = Functions.SetParentCatchSwitch;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(CatchPad);
            Checks.check(CatchSwitch);
        }
        JNI.invokePPV(CatchPad, CatchSwitch, __functionAddress);
    }

    public static long nLLVMBuildAdd(long Builder2, long LHS, long RHS, long Name2) {
        long __functionAddress = Functions.BuildAdd;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(LHS);
            Checks.check(RHS);
        }
        return JNI.invokePPPPP(Builder2, LHS, RHS, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildAdd(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildAdd(Builder2, LHS, RHS, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildAdd(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildAdd(Builder2, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildNSWAdd(long Builder2, long LHS, long RHS, long Name2) {
        long __functionAddress = Functions.BuildNSWAdd;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(LHS);
            Checks.check(RHS);
        }
        return JNI.invokePPPPP(Builder2, LHS, RHS, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildNSWAdd(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildNSWAdd(Builder2, LHS, RHS, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildNSWAdd(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildNSWAdd(Builder2, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildNUWAdd(long Builder2, long LHS, long RHS, long Name2) {
        long __functionAddress = Functions.BuildNUWAdd;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(LHS);
            Checks.check(RHS);
        }
        return JNI.invokePPPPP(Builder2, LHS, RHS, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildNUWAdd(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildNUWAdd(Builder2, LHS, RHS, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildNUWAdd(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildNUWAdd(Builder2, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildFAdd(long Builder2, long LHS, long RHS, long Name2) {
        long __functionAddress = Functions.BuildFAdd;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(LHS);
            Checks.check(RHS);
        }
        return JNI.invokePPPPP(Builder2, LHS, RHS, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFAdd(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildFAdd(Builder2, LHS, RHS, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFAdd(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildFAdd(Builder2, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildSub(long Builder2, long LHS, long RHS, long Name2) {
        long __functionAddress = Functions.BuildSub;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(LHS);
            Checks.check(RHS);
        }
        return JNI.invokePPPPP(Builder2, LHS, RHS, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildSub(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildSub(Builder2, LHS, RHS, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildSub(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildSub(Builder2, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildNSWSub(long Builder2, long LHS, long RHS, long Name2) {
        long __functionAddress = Functions.BuildNSWSub;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(LHS);
            Checks.check(RHS);
        }
        return JNI.invokePPPPP(Builder2, LHS, RHS, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildNSWSub(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildNSWSub(Builder2, LHS, RHS, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildNSWSub(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildNSWSub(Builder2, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildNUWSub(long Builder2, long LHS, long RHS, long Name2) {
        long __functionAddress = Functions.BuildNUWSub;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(LHS);
            Checks.check(RHS);
        }
        return JNI.invokePPPPP(Builder2, LHS, RHS, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildNUWSub(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildNUWSub(Builder2, LHS, RHS, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildNUWSub(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildNUWSub(Builder2, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildFSub(long Builder2, long LHS, long RHS, long Name2) {
        long __functionAddress = Functions.BuildFSub;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(LHS);
            Checks.check(RHS);
        }
        return JNI.invokePPPPP(Builder2, LHS, RHS, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFSub(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildFSub(Builder2, LHS, RHS, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFSub(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildFSub(Builder2, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildMul(long Builder2, long LHS, long RHS, long Name2) {
        long __functionAddress = Functions.BuildMul;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(LHS);
            Checks.check(RHS);
        }
        return JNI.invokePPPPP(Builder2, LHS, RHS, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildMul(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildMul(Builder2, LHS, RHS, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildMul(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildMul(Builder2, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildNSWMul(long Builder2, long LHS, long RHS, long Name2) {
        long __functionAddress = Functions.BuildNSWMul;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(LHS);
            Checks.check(RHS);
        }
        return JNI.invokePPPPP(Builder2, LHS, RHS, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildNSWMul(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildNSWMul(Builder2, LHS, RHS, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildNSWMul(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildNSWMul(Builder2, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildNUWMul(long Builder2, long LHS, long RHS, long Name2) {
        long __functionAddress = Functions.BuildNUWMul;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(LHS);
            Checks.check(RHS);
        }
        return JNI.invokePPPPP(Builder2, LHS, RHS, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildNUWMul(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildNUWMul(Builder2, LHS, RHS, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildNUWMul(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildNUWMul(Builder2, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildFMul(long Builder2, long LHS, long RHS, long Name2) {
        long __functionAddress = Functions.BuildFMul;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(LHS);
            Checks.check(RHS);
        }
        return JNI.invokePPPPP(Builder2, LHS, RHS, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFMul(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildFMul(Builder2, LHS, RHS, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFMul(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildFMul(Builder2, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildUDiv(long Builder2, long LHS, long RHS, long Name2) {
        long __functionAddress = Functions.BuildUDiv;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(LHS);
            Checks.check(RHS);
        }
        return JNI.invokePPPPP(Builder2, LHS, RHS, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildUDiv(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildUDiv(Builder2, LHS, RHS, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildUDiv(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildUDiv(Builder2, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildExactUDiv(long Builder2, long LHS, long RHS, long Name2) {
        long __functionAddress = Functions.BuildExactUDiv;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(LHS);
            Checks.check(RHS);
        }
        return JNI.invokePPPPP(Builder2, LHS, RHS, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildExactUDiv(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildExactUDiv(Builder2, LHS, RHS, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildExactUDiv(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildExactUDiv(Builder2, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildSDiv(long Builder2, long LHS, long RHS, long Name2) {
        long __functionAddress = Functions.BuildSDiv;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(LHS);
            Checks.check(RHS);
        }
        return JNI.invokePPPPP(Builder2, LHS, RHS, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildSDiv(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildSDiv(Builder2, LHS, RHS, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildSDiv(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildSDiv(Builder2, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildExactSDiv(long Builder2, long LHS, long RHS, long Name2) {
        long __functionAddress = Functions.BuildExactSDiv;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(LHS);
            Checks.check(RHS);
        }
        return JNI.invokePPPPP(Builder2, LHS, RHS, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildExactSDiv(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildExactSDiv(Builder2, LHS, RHS, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildExactSDiv(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildExactSDiv(Builder2, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildFDiv(long Builder2, long LHS, long RHS, long Name2) {
        long __functionAddress = Functions.BuildFDiv;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(LHS);
            Checks.check(RHS);
        }
        return JNI.invokePPPPP(Builder2, LHS, RHS, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFDiv(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildFDiv(Builder2, LHS, RHS, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFDiv(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildFDiv(Builder2, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildURem(long Builder2, long LHS, long RHS, long Name2) {
        long __functionAddress = Functions.BuildURem;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(LHS);
            Checks.check(RHS);
        }
        return JNI.invokePPPPP(Builder2, LHS, RHS, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildURem(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildURem(Builder2, LHS, RHS, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildURem(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildURem(Builder2, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildSRem(long Builder2, long LHS, long RHS, long Name2) {
        long __functionAddress = Functions.BuildSRem;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(LHS);
            Checks.check(RHS);
        }
        return JNI.invokePPPPP(Builder2, LHS, RHS, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildSRem(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildSRem(Builder2, LHS, RHS, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildSRem(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildSRem(Builder2, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildFRem(long Builder2, long LHS, long RHS, long Name2) {
        long __functionAddress = Functions.BuildFRem;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(LHS);
            Checks.check(RHS);
        }
        return JNI.invokePPPPP(Builder2, LHS, RHS, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFRem(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildFRem(Builder2, LHS, RHS, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFRem(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildFRem(Builder2, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildShl(long Builder2, long LHS, long RHS, long Name2) {
        long __functionAddress = Functions.BuildShl;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(LHS);
            Checks.check(RHS);
        }
        return JNI.invokePPPPP(Builder2, LHS, RHS, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildShl(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildShl(Builder2, LHS, RHS, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildShl(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildShl(Builder2, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildLShr(long Builder2, long LHS, long RHS, long Name2) {
        long __functionAddress = Functions.BuildLShr;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(LHS);
            Checks.check(RHS);
        }
        return JNI.invokePPPPP(Builder2, LHS, RHS, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildLShr(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildLShr(Builder2, LHS, RHS, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildLShr(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildLShr(Builder2, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildAShr(long Builder2, long LHS, long RHS, long Name2) {
        long __functionAddress = Functions.BuildAShr;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(LHS);
            Checks.check(RHS);
        }
        return JNI.invokePPPPP(Builder2, LHS, RHS, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildAShr(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildAShr(Builder2, LHS, RHS, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildAShr(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildAShr(Builder2, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildAnd(long Builder2, long LHS, long RHS, long Name2) {
        long __functionAddress = Functions.BuildAnd;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(LHS);
            Checks.check(RHS);
        }
        return JNI.invokePPPPP(Builder2, LHS, RHS, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildAnd(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildAnd(Builder2, LHS, RHS, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildAnd(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildAnd(Builder2, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildOr(long Builder2, long LHS, long RHS, long Name2) {
        long __functionAddress = Functions.BuildOr;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(LHS);
            Checks.check(RHS);
        }
        return JNI.invokePPPPP(Builder2, LHS, RHS, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildOr(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildOr(Builder2, LHS, RHS, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildOr(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildOr(Builder2, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildXor(long Builder2, long LHS, long RHS, long Name2) {
        long __functionAddress = Functions.BuildXor;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(LHS);
            Checks.check(RHS);
        }
        return JNI.invokePPPPP(Builder2, LHS, RHS, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildXor(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildXor(Builder2, LHS, RHS, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildXor(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildXor(Builder2, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildBinOp(long B, int Op, long LHS, long RHS, long Name2) {
        long __functionAddress = Functions.BuildBinOp;
        if (Checks.CHECKS) {
            Checks.check(B);
            Checks.check(LHS);
            Checks.check(RHS);
        }
        return JNI.invokePPPPP(B, Op, LHS, RHS, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildBinOp(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMOpcode") int Op, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildBinOp(B, Op, LHS, RHS, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildBinOp(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMOpcode") int Op, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildBinOp(B, Op, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildNeg(long Builder2, long V, long Name2) {
        long __functionAddress = Functions.BuildNeg;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(V);
        }
        return JNI.invokePPPP(Builder2, V, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildNeg(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long V, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildNeg(Builder2, V, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildNeg(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long V, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildNeg(Builder2, V, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildNSWNeg(long B, long V, long Name2) {
        long __functionAddress = Functions.BuildNSWNeg;
        if (Checks.CHECKS) {
            Checks.check(B);
            Checks.check(V);
        }
        return JNI.invokePPPP(B, V, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildNSWNeg(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMValueRef") long V, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildNSWNeg(B, V, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildNSWNeg(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMValueRef") long V, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildNSWNeg(B, V, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildNUWNeg(long B, long V, long Name2) {
        long __functionAddress = Functions.BuildNUWNeg;
        if (Checks.CHECKS) {
            Checks.check(B);
            Checks.check(V);
        }
        return JNI.invokePPPP(B, V, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildNUWNeg(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMValueRef") long V, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildNUWNeg(B, V, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildNUWNeg(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMValueRef") long V, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildNUWNeg(B, V, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildFNeg(long Builder2, long V, long Name2) {
        long __functionAddress = Functions.BuildFNeg;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(V);
        }
        return JNI.invokePPPP(Builder2, V, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFNeg(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long V, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildFNeg(Builder2, V, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFNeg(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long V, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildFNeg(Builder2, V, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildNot(long Builder2, long V, long Name2) {
        long __functionAddress = Functions.BuildNot;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(V);
        }
        return JNI.invokePPPP(Builder2, V, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildNot(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long V, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildNot(Builder2, V, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildNot(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long V, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildNot(Builder2, V, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildMalloc(long Builder2, long Ty, long Name2) {
        long __functionAddress = Functions.BuildMalloc;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Ty);
        }
        return JNI.invokePPPP(Builder2, Ty, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildMalloc(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildMalloc(Builder2, Ty, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildMalloc(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildMalloc(Builder2, Ty, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildArrayMalloc(long Builder2, long Ty, long Val, long Name2) {
        long __functionAddress = Functions.BuildArrayMalloc;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Ty);
            Checks.check(Val);
        }
        return JNI.invokePPPPP(Builder2, Ty, Val, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildArrayMalloc(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildArrayMalloc(Builder2, Ty, Val, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildArrayMalloc(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildArrayMalloc(Builder2, Ty, Val, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildMemSet(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMValueRef") long Ptr, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMValueRef") long Len, @NativeType(value="unsigned") int Align) {
        long __functionAddress = Functions.BuildMemSet;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(B);
            Checks.check(Ptr);
            Checks.check(Val);
            Checks.check(Len);
        }
        return JNI.invokePPPPP(B, Ptr, Val, Len, Align, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildMemCpy(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMValueRef") long Dst, @NativeType(value="unsigned") int DstAlign, @NativeType(value="LLVMValueRef") long Src, @NativeType(value="unsigned") int SrcAlign, @NativeType(value="LLVMValueRef") long Size) {
        long __functionAddress = Functions.BuildMemCpy;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(B);
            Checks.check(Dst);
            Checks.check(Src);
            Checks.check(Size);
        }
        return JNI.invokePPPPP(B, Dst, DstAlign, Src, SrcAlign, Size, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildMemMove(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMValueRef") long Dst, @NativeType(value="unsigned") int DstAlign, @NativeType(value="LLVMValueRef") long Src, @NativeType(value="unsigned") int SrcAlign, @NativeType(value="LLVMValueRef") long Size) {
        long __functionAddress = Functions.BuildMemMove;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(B);
            Checks.check(Dst);
            Checks.check(Src);
            Checks.check(Size);
        }
        return JNI.invokePPPPP(B, Dst, DstAlign, Src, SrcAlign, Size, __functionAddress);
    }

    public static long nLLVMBuildAlloca(long Builder2, long Ty, long Name2) {
        long __functionAddress = Functions.BuildAlloca;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Ty);
        }
        return JNI.invokePPPP(Builder2, Ty, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildAlloca(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildAlloca(Builder2, Ty, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildAlloca(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildAlloca(Builder2, Ty, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildArrayAlloca(long Builder2, long Ty, long Val, long Name2) {
        long __functionAddress = Functions.BuildArrayAlloca;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Ty);
            Checks.check(Val);
        }
        return JNI.invokePPPPP(Builder2, Ty, Val, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildArrayAlloca(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildArrayAlloca(Builder2, Ty, Val, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildArrayAlloca(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildArrayAlloca(Builder2, Ty, Val, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFree(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long PointerVal) {
        long __functionAddress = Functions.BuildFree;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(PointerVal);
        }
        return JNI.invokePPP(Builder2, PointerVal, __functionAddress);
    }

    public static long nLLVMBuildLoad(long Builder2, long PointerVal, long Name2) {
        long __functionAddress = Functions.BuildLoad;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(PointerVal);
        }
        return JNI.invokePPPP(Builder2, PointerVal, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildLoad(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long PointerVal, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildLoad(Builder2, PointerVal, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildLoad(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long PointerVal, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildLoad(Builder2, PointerVal, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildLoad2(long Builder2, long Ty, long PointerVal, long Name2) {
        long __functionAddress = Functions.BuildLoad2;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Builder2);
            Checks.check(Ty);
            Checks.check(PointerVal);
        }
        return JNI.invokePPPPP(Builder2, Ty, PointerVal, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildLoad2(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="LLVMValueRef") long PointerVal, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildLoad2(Builder2, Ty, PointerVal, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildLoad2(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="LLVMValueRef") long PointerVal, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildLoad2(Builder2, Ty, PointerVal, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildStore(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMValueRef") long Ptr) {
        long __functionAddress = Functions.BuildStore;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Val);
            Checks.check(Ptr);
        }
        return JNI.invokePPPP(Builder2, Val, Ptr, __functionAddress);
    }

    public static long nLLVMBuildGEP(long B, long Pointer2, long Indices, int NumIndices, long Name2) {
        long __functionAddress = Functions.BuildGEP;
        if (Checks.CHECKS) {
            Checks.check(B);
            Checks.check(Pointer2);
        }
        return JNI.invokePPPPP(B, Pointer2, Indices, NumIndices, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildGEP(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMValueRef") long Pointer2, @NativeType(value="LLVMValueRef *") PointerBuffer Indices, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildGEP(B, Pointer2, MemoryUtil.memAddress(Indices), Indices.remaining(), MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildGEP(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMValueRef") long Pointer2, @NativeType(value="LLVMValueRef *") PointerBuffer Indices, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildGEP(B, Pointer2, MemoryUtil.memAddress(Indices), Indices.remaining(), NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildInBoundsGEP(long B, long Pointer2, long Indices, int NumIndices, long Name2) {
        long __functionAddress = Functions.BuildInBoundsGEP;
        if (Checks.CHECKS) {
            Checks.check(B);
            Checks.check(Pointer2);
        }
        return JNI.invokePPPPP(B, Pointer2, Indices, NumIndices, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildInBoundsGEP(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMValueRef") long Pointer2, @NativeType(value="LLVMValueRef *") PointerBuffer Indices, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildInBoundsGEP(B, Pointer2, MemoryUtil.memAddress(Indices), Indices.remaining(), MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildInBoundsGEP(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMValueRef") long Pointer2, @NativeType(value="LLVMValueRef *") PointerBuffer Indices, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildInBoundsGEP(B, Pointer2, MemoryUtil.memAddress(Indices), Indices.remaining(), NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildStructGEP(long B, long Pointer2, int Idx, long Name2) {
        long __functionAddress = Functions.BuildStructGEP;
        if (Checks.CHECKS) {
            Checks.check(B);
            Checks.check(Pointer2);
        }
        return JNI.invokePPPP(B, Pointer2, Idx, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildStructGEP(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMValueRef") long Pointer2, @NativeType(value="unsigned int") int Idx, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildStructGEP(B, Pointer2, Idx, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildStructGEP(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMValueRef") long Pointer2, @NativeType(value="unsigned int") int Idx, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildStructGEP(B, Pointer2, Idx, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildGEP2(long B, long Ty, long Pointer2, long Indices, int NumIndices, long Name2) {
        long __functionAddress = Functions.BuildGEP2;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(B);
            Checks.check(Ty);
            Checks.check(Pointer2);
        }
        return JNI.invokePPPPPP(B, Ty, Pointer2, Indices, NumIndices, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildGEP2(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="LLVMValueRef") long Pointer2, @NativeType(value="LLVMValueRef *") PointerBuffer Indices, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildGEP2(B, Ty, Pointer2, MemoryUtil.memAddress(Indices), Indices.remaining(), MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildGEP2(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="LLVMValueRef") long Pointer2, @NativeType(value="LLVMValueRef *") PointerBuffer Indices, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildGEP2(B, Ty, Pointer2, MemoryUtil.memAddress(Indices), Indices.remaining(), NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildInBoundsGEP2(long B, long Ty, long Pointer2, long Indices, int NumIndices, long Name2) {
        long __functionAddress = Functions.BuildInBoundsGEP2;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(B);
            Checks.check(Ty);
            Checks.check(Pointer2);
        }
        return JNI.invokePPPPPP(B, Ty, Pointer2, Indices, NumIndices, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildInBoundsGEP2(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="LLVMValueRef") long Pointer2, @NativeType(value="LLVMValueRef *") PointerBuffer Indices, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildInBoundsGEP2(B, Ty, Pointer2, MemoryUtil.memAddress(Indices), Indices.remaining(), MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildInBoundsGEP2(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="LLVMValueRef") long Pointer2, @NativeType(value="LLVMValueRef *") PointerBuffer Indices, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildInBoundsGEP2(B, Ty, Pointer2, MemoryUtil.memAddress(Indices), Indices.remaining(), NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildStructGEP2(long B, long Ty, long Pointer2, int Idx, long Name2) {
        long __functionAddress = Functions.BuildStructGEP2;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(B);
            Checks.check(Ty);
            Checks.check(Pointer2);
        }
        return JNI.invokePPPPP(B, Ty, Pointer2, Idx, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildStructGEP2(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="LLVMValueRef") long Pointer2, @NativeType(value="unsigned int") int Idx, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildStructGEP2(B, Ty, Pointer2, Idx, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildStructGEP2(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="LLVMValueRef") long Pointer2, @NativeType(value="unsigned int") int Idx, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildStructGEP2(B, Ty, Pointer2, Idx, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildGlobalString(long B, long Str, long Name2) {
        long __functionAddress = Functions.BuildGlobalString;
        if (Checks.CHECKS) {
            Checks.check(B);
        }
        return JNI.invokePPPP(B, Str, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildGlobalString(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="char const *") ByteBuffer Str, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Str);
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildGlobalString(B, MemoryUtil.memAddress(Str), MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildGlobalString(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="char const *") CharSequence Str, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Str, true);
            long StrEncoded = stack.getPointerAddress();
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildGlobalString(B, StrEncoded, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildGlobalStringPtr(long B, long Str, long Name2) {
        long __functionAddress = Functions.BuildGlobalStringPtr;
        if (Checks.CHECKS) {
            Checks.check(B);
        }
        return JNI.invokePPPP(B, Str, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildGlobalStringPtr(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="char const *") ByteBuffer Str, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Str);
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildGlobalStringPtr(B, MemoryUtil.memAddress(Str), MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildGlobalStringPtr(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="char const *") CharSequence Str, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Str, true);
            long StrEncoded = stack.getPointerAddress();
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildGlobalStringPtr(B, StrEncoded, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMGetVolatile(@NativeType(value="LLVMValueRef") long MemoryAccessInst) {
        long __functionAddress = Functions.GetVolatile;
        if (Checks.CHECKS) {
            Checks.check(MemoryAccessInst);
        }
        return JNI.invokePI(MemoryAccessInst, __functionAddress) != 0;
    }

    public static void LLVMSetVolatile(@NativeType(value="LLVMValueRef") long MemoryAccessInst, @NativeType(value="LLVMBool") boolean IsVolatile) {
        long __functionAddress = Functions.SetVolatile;
        if (Checks.CHECKS) {
            Checks.check(MemoryAccessInst);
        }
        JNI.invokePV(MemoryAccessInst, IsVolatile ? 1 : 0, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMGetWeak(@NativeType(value="LLVMValueRef") long CmpXchgInst) {
        long __functionAddress = Functions.GetWeak;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(CmpXchgInst);
        }
        return JNI.invokePI(CmpXchgInst, __functionAddress) != 0;
    }

    public static void LLVMSetWeak(@NativeType(value="LLVMValueRef") long CmpXchgInst, @NativeType(value="LLVMBool") boolean IsWeak) {
        long __functionAddress = Functions.SetWeak;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(CmpXchgInst);
        }
        JNI.invokePV(CmpXchgInst, IsWeak ? 1 : 0, __functionAddress);
    }

    @NativeType(value="LLVMAtomicOrdering")
    public static int LLVMGetOrdering(@NativeType(value="LLVMValueRef") long MemoryAccessInst) {
        long __functionAddress = Functions.GetOrdering;
        if (Checks.CHECKS) {
            Checks.check(MemoryAccessInst);
        }
        return JNI.invokePI(MemoryAccessInst, __functionAddress);
    }

    public static void LLVMSetOrdering(@NativeType(value="LLVMValueRef") long MemoryAccessInst, @NativeType(value="LLVMAtomicOrdering") int Ordering) {
        long __functionAddress = Functions.SetOrdering;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(MemoryAccessInst);
        }
        JNI.invokePV(MemoryAccessInst, Ordering, __functionAddress);
    }

    @NativeType(value="LLVMAtomicRMWBinOp")
    public static int LLVMGetAtomicRMWBinOp(@NativeType(value="LLVMValueRef") long AtomicRMWInst) {
        long __functionAddress = Functions.GetAtomicRMWBinOp;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(AtomicRMWInst);
        }
        return JNI.invokePI(AtomicRMWInst, __functionAddress);
    }

    public static void LLVMSetAtomicRMWBinOp(@NativeType(value="LLVMValueRef") long AtomicRMWInst, @NativeType(value="LLVMAtomicRMWBinOp") int BinOp) {
        long __functionAddress = Functions.SetAtomicRMWBinOp;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(AtomicRMWInst);
        }
        JNI.invokePV(AtomicRMWInst, BinOp, __functionAddress);
    }

    public static long nLLVMBuildTrunc(long Builder2, long Val, long DestTy, long Name2) {
        long __functionAddress = Functions.BuildTrunc;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Val);
            Checks.check(DestTy);
        }
        return JNI.invokePPPPP(Builder2, Val, DestTy, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildTrunc(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildTrunc(Builder2, Val, DestTy, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildTrunc(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildTrunc(Builder2, Val, DestTy, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildZExt(long Builder2, long Val, long DestTy, long Name2) {
        long __functionAddress = Functions.BuildZExt;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Val);
            Checks.check(DestTy);
        }
        return JNI.invokePPPPP(Builder2, Val, DestTy, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildZExt(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildZExt(Builder2, Val, DestTy, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildZExt(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildZExt(Builder2, Val, DestTy, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildSExt(long Builder2, long Val, long DestTy, long Name2) {
        long __functionAddress = Functions.BuildSExt;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Val);
            Checks.check(DestTy);
        }
        return JNI.invokePPPPP(Builder2, Val, DestTy, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildSExt(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildSExt(Builder2, Val, DestTy, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildSExt(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildSExt(Builder2, Val, DestTy, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildFPToUI(long Builder2, long Val, long DestTy, long Name2) {
        long __functionAddress = Functions.BuildFPToUI;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Val);
            Checks.check(DestTy);
        }
        return JNI.invokePPPPP(Builder2, Val, DestTy, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFPToUI(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildFPToUI(Builder2, Val, DestTy, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFPToUI(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildFPToUI(Builder2, Val, DestTy, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildFPToSI(long Builder2, long Val, long DestTy, long Name2) {
        long __functionAddress = Functions.BuildFPToSI;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Val);
            Checks.check(DestTy);
        }
        return JNI.invokePPPPP(Builder2, Val, DestTy, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFPToSI(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildFPToSI(Builder2, Val, DestTy, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFPToSI(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildFPToSI(Builder2, Val, DestTy, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildUIToFP(long Builder2, long Val, long DestTy, long Name2) {
        long __functionAddress = Functions.BuildUIToFP;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Val);
            Checks.check(DestTy);
        }
        return JNI.invokePPPPP(Builder2, Val, DestTy, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildUIToFP(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildUIToFP(Builder2, Val, DestTy, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildUIToFP(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildUIToFP(Builder2, Val, DestTy, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildSIToFP(long Builder2, long Val, long DestTy, long Name2) {
        long __functionAddress = Functions.BuildSIToFP;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Val);
            Checks.check(DestTy);
        }
        return JNI.invokePPPPP(Builder2, Val, DestTy, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildSIToFP(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildSIToFP(Builder2, Val, DestTy, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildSIToFP(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildSIToFP(Builder2, Val, DestTy, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildFPTrunc(long Builder2, long Val, long DestTy, long Name2) {
        long __functionAddress = Functions.BuildFPTrunc;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Val);
            Checks.check(DestTy);
        }
        return JNI.invokePPPPP(Builder2, Val, DestTy, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFPTrunc(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildFPTrunc(Builder2, Val, DestTy, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFPTrunc(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildFPTrunc(Builder2, Val, DestTy, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildFPExt(long Builder2, long Val, long DestTy, long Name2) {
        long __functionAddress = Functions.BuildFPExt;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Val);
            Checks.check(DestTy);
        }
        return JNI.invokePPPPP(Builder2, Val, DestTy, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFPExt(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildFPExt(Builder2, Val, DestTy, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFPExt(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildFPExt(Builder2, Val, DestTy, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildPtrToInt(long Builder2, long Val, long DestTy, long Name2) {
        long __functionAddress = Functions.BuildPtrToInt;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Val);
            Checks.check(DestTy);
        }
        return JNI.invokePPPPP(Builder2, Val, DestTy, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildPtrToInt(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildPtrToInt(Builder2, Val, DestTy, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildPtrToInt(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildPtrToInt(Builder2, Val, DestTy, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildIntToPtr(long Builder2, long Val, long DestTy, long Name2) {
        long __functionAddress = Functions.BuildIntToPtr;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Val);
            Checks.check(DestTy);
        }
        return JNI.invokePPPPP(Builder2, Val, DestTy, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildIntToPtr(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildIntToPtr(Builder2, Val, DestTy, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildIntToPtr(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildIntToPtr(Builder2, Val, DestTy, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildBitCast(long Builder2, long Val, long DestTy, long Name2) {
        long __functionAddress = Functions.BuildBitCast;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Val);
            Checks.check(DestTy);
        }
        return JNI.invokePPPPP(Builder2, Val, DestTy, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildBitCast(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildBitCast(Builder2, Val, DestTy, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildBitCast(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildBitCast(Builder2, Val, DestTy, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildAddrSpaceCast(long Builder2, long Val, long DestTy, long Name2) {
        long __functionAddress = Functions.BuildAddrSpaceCast;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Val);
            Checks.check(DestTy);
        }
        return JNI.invokePPPPP(Builder2, Val, DestTy, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildAddrSpaceCast(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildAddrSpaceCast(Builder2, Val, DestTy, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildAddrSpaceCast(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildAddrSpaceCast(Builder2, Val, DestTy, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildZExtOrBitCast(long Builder2, long Val, long DestTy, long Name2) {
        long __functionAddress = Functions.BuildZExtOrBitCast;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Val);
            Checks.check(DestTy);
        }
        return JNI.invokePPPPP(Builder2, Val, DestTy, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildZExtOrBitCast(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildZExtOrBitCast(Builder2, Val, DestTy, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildZExtOrBitCast(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildZExtOrBitCast(Builder2, Val, DestTy, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildSExtOrBitCast(long Builder2, long Val, long DestTy, long Name2) {
        long __functionAddress = Functions.BuildSExtOrBitCast;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Val);
            Checks.check(DestTy);
        }
        return JNI.invokePPPPP(Builder2, Val, DestTy, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildSExtOrBitCast(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildSExtOrBitCast(Builder2, Val, DestTy, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildSExtOrBitCast(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildSExtOrBitCast(Builder2, Val, DestTy, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildTruncOrBitCast(long Builder2, long Val, long DestTy, long Name2) {
        long __functionAddress = Functions.BuildTruncOrBitCast;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Val);
            Checks.check(DestTy);
        }
        return JNI.invokePPPPP(Builder2, Val, DestTy, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildTruncOrBitCast(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildTruncOrBitCast(Builder2, Val, DestTy, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildTruncOrBitCast(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildTruncOrBitCast(Builder2, Val, DestTy, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildCast(long B, int Op, long Val, long DestTy, long Name2) {
        long __functionAddress = Functions.BuildCast;
        if (Checks.CHECKS) {
            Checks.check(B);
            Checks.check(Val);
            Checks.check(DestTy);
        }
        return JNI.invokePPPPP(B, Op, Val, DestTy, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildCast(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMOpcode") int Op, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildCast(B, Op, Val, DestTy, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildCast(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMOpcode") int Op, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildCast(B, Op, Val, DestTy, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildPointerCast(long Builder2, long Val, long DestTy, long Name2) {
        long __functionAddress = Functions.BuildPointerCast;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Val);
            Checks.check(DestTy);
        }
        return JNI.invokePPPPP(Builder2, Val, DestTy, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildPointerCast(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildPointerCast(Builder2, Val, DestTy, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildPointerCast(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildPointerCast(Builder2, Val, DestTy, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildPointerCast2(long Builder2, long Val, long DestTy, int IsSigned, long Name2) {
        long __functionAddress = Functions.BuildPointerCast2;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Builder2);
            Checks.check(Val);
            Checks.check(DestTy);
        }
        return JNI.invokePPPPP(Builder2, Val, DestTy, IsSigned, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildPointerCast2(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="LLVMBool") boolean IsSigned, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildPointerCast2(Builder2, Val, DestTy, IsSigned ? 1 : 0, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildPointerCast2(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="LLVMBool") boolean IsSigned, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildPointerCast2(Builder2, Val, DestTy, IsSigned ? 1 : 0, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildIntCast(long Builder2, long Val, long DestTy, long Name2) {
        long __functionAddress = Functions.BuildIntCast;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Val);
            Checks.check(DestTy);
        }
        return JNI.invokePPPPP(Builder2, Val, DestTy, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildIntCast(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildIntCast(Builder2, Val, DestTy, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildIntCast(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildIntCast(Builder2, Val, DestTy, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildFPCast(long Builder2, long Val, long DestTy, long Name2) {
        long __functionAddress = Functions.BuildFPCast;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Val);
            Checks.check(DestTy);
        }
        return JNI.invokePPPPP(Builder2, Val, DestTy, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFPCast(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildFPCast(Builder2, Val, DestTy, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFPCast(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMTypeRef") long DestTy, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildFPCast(Builder2, Val, DestTy, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildICmp(long Builder2, int Op, long LHS, long RHS, long Name2) {
        long __functionAddress = Functions.BuildICmp;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(LHS);
            Checks.check(RHS);
        }
        return JNI.invokePPPPP(Builder2, Op, LHS, RHS, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildICmp(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMIntPredicate") int Op, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildICmp(Builder2, Op, LHS, RHS, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildICmp(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMIntPredicate") int Op, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildICmp(Builder2, Op, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildFCmp(long Builder2, int Op, long LHS, long RHS, long Name2) {
        long __functionAddress = Functions.BuildFCmp;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(LHS);
            Checks.check(RHS);
        }
        return JNI.invokePPPPP(Builder2, Op, LHS, RHS, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFCmp(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMRealPredicate") int Op, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildFCmp(Builder2, Op, LHS, RHS, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFCmp(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMRealPredicate") int Op, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildFCmp(Builder2, Op, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildPhi(long Builder2, long Ty, long Name2) {
        long __functionAddress = Functions.BuildPhi;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Ty);
        }
        return JNI.invokePPPP(Builder2, Ty, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildPhi(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildPhi(Builder2, Ty, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildPhi(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildPhi(Builder2, Ty, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildCall(long Builder2, long Fn, long Args, int NumArgs, long Name2) {
        long __functionAddress = Functions.BuildCall;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Fn);
        }
        return JNI.invokePPPPP(Builder2, Fn, Args, NumArgs, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildCall(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Fn, @NativeType(value="LLVMValueRef *") PointerBuffer Args, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildCall(Builder2, Fn, MemoryUtil.memAddress(Args), Args.remaining(), MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildCall(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Fn, @NativeType(value="LLVMValueRef *") PointerBuffer Args, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildCall(Builder2, Fn, MemoryUtil.memAddress(Args), Args.remaining(), NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildCall2(long Builder2, long Ty, long Fn, long Args, int NumArgs, long Name2) {
        long __functionAddress = Functions.BuildCall2;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Builder2);
            Checks.check(Ty);
            Checks.check(Fn);
        }
        return JNI.invokePPPPPP(Builder2, Ty, Fn, Args, NumArgs, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildCall2(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="LLVMValueRef") long Fn, @NativeType(value="LLVMValueRef *") PointerBuffer Args, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildCall2(Builder2, Ty, Fn, MemoryUtil.memAddress(Args), Args.remaining(), MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildCall2(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="LLVMValueRef") long Fn, @NativeType(value="LLVMValueRef *") PointerBuffer Args, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildCall2(Builder2, Ty, Fn, MemoryUtil.memAddress(Args), Args.remaining(), NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildSelect(long Builder2, long If, long Then, long Else, long Name2) {
        long __functionAddress = Functions.BuildSelect;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(If);
            Checks.check(Then);
            Checks.check(Else);
        }
        return JNI.invokePPPPPP(Builder2, If, Then, Else, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildSelect(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long If, @NativeType(value="LLVMValueRef") long Then, @NativeType(value="LLVMValueRef") long Else, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildSelect(Builder2, If, Then, Else, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildSelect(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long If, @NativeType(value="LLVMValueRef") long Then, @NativeType(value="LLVMValueRef") long Else, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildSelect(Builder2, If, Then, Else, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildVAArg(long Builder2, long List2, long Ty, long Name2) {
        long __functionAddress = Functions.BuildVAArg;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(List2);
            Checks.check(Ty);
        }
        return JNI.invokePPPPP(Builder2, List2, Ty, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildVAArg(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long List2, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildVAArg(Builder2, List2, Ty, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildVAArg(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long List2, @NativeType(value="LLVMTypeRef") long Ty, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildVAArg(Builder2, List2, Ty, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildExtractElement(long Builder2, long VecVal, long Index, long Name2) {
        long __functionAddress = Functions.BuildExtractElement;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(VecVal);
            Checks.check(Index);
        }
        return JNI.invokePPPPP(Builder2, VecVal, Index, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildExtractElement(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long VecVal, @NativeType(value="LLVMValueRef") long Index, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildExtractElement(Builder2, VecVal, Index, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildExtractElement(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long VecVal, @NativeType(value="LLVMValueRef") long Index, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildExtractElement(Builder2, VecVal, Index, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildInsertElement(long Builder2, long VecVal, long EltVal, long Index, long Name2) {
        long __functionAddress = Functions.BuildInsertElement;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(VecVal);
            Checks.check(EltVal);
            Checks.check(Index);
        }
        return JNI.invokePPPPPP(Builder2, VecVal, EltVal, Index, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildInsertElement(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long VecVal, @NativeType(value="LLVMValueRef") long EltVal, @NativeType(value="LLVMValueRef") long Index, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildInsertElement(Builder2, VecVal, EltVal, Index, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildInsertElement(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long VecVal, @NativeType(value="LLVMValueRef") long EltVal, @NativeType(value="LLVMValueRef") long Index, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildInsertElement(Builder2, VecVal, EltVal, Index, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildShuffleVector(long Builder2, long V1, long V2, long Mask, long Name2) {
        long __functionAddress = Functions.BuildShuffleVector;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(V1);
            Checks.check(V2);
            Checks.check(Mask);
        }
        return JNI.invokePPPPPP(Builder2, V1, V2, Mask, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildShuffleVector(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long V1, @NativeType(value="LLVMValueRef") long V2, @NativeType(value="LLVMValueRef") long Mask, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildShuffleVector(Builder2, V1, V2, Mask, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildShuffleVector(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long V1, @NativeType(value="LLVMValueRef") long V2, @NativeType(value="LLVMValueRef") long Mask, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildShuffleVector(Builder2, V1, V2, Mask, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildExtractValue(long Builder2, long AggVal, int Index, long Name2) {
        long __functionAddress = Functions.BuildExtractValue;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(AggVal);
        }
        return JNI.invokePPPP(Builder2, AggVal, Index, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildExtractValue(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long AggVal, @NativeType(value="unsigned int") int Index, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildExtractValue(Builder2, AggVal, Index, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildExtractValue(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long AggVal, @NativeType(value="unsigned int") int Index, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildExtractValue(Builder2, AggVal, Index, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildInsertValue(long Builder2, long AggVal, long EltVal, int Index, long Name2) {
        long __functionAddress = Functions.BuildInsertValue;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(AggVal);
            Checks.check(EltVal);
        }
        return JNI.invokePPPPP(Builder2, AggVal, EltVal, Index, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildInsertValue(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long AggVal, @NativeType(value="LLVMValueRef") long EltVal, @NativeType(value="unsigned int") int Index, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildInsertValue(Builder2, AggVal, EltVal, Index, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildInsertValue(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long AggVal, @NativeType(value="LLVMValueRef") long EltVal, @NativeType(value="unsigned int") int Index, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildInsertValue(Builder2, AggVal, EltVal, Index, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildFreeze(long Builder2, long Val, long Name2) {
        long __functionAddress = Functions.BuildFreeze;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(Builder2);
            Checks.check(Val);
        }
        return JNI.invokePPPP(Builder2, Val, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFreeze(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildFreeze(Builder2, Val, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFreeze(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildFreeze(Builder2, Val, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildIsNull(long Builder2, long Val, long Name2) {
        long __functionAddress = Functions.BuildIsNull;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Val);
        }
        return JNI.invokePPPP(Builder2, Val, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildIsNull(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildIsNull(Builder2, Val, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildIsNull(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildIsNull(Builder2, Val, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildIsNotNull(long Builder2, long Val, long Name2) {
        long __functionAddress = Functions.BuildIsNotNull;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(Val);
        }
        return JNI.invokePPPP(Builder2, Val, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildIsNotNull(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildIsNotNull(Builder2, Val, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildIsNotNull(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildIsNotNull(Builder2, Val, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildPtrDiff(long Builder2, long LHS, long RHS, long Name2) {
        long __functionAddress = Functions.BuildPtrDiff;
        if (Checks.CHECKS) {
            Checks.check(Builder2);
            Checks.check(LHS);
            Checks.check(RHS);
        }
        return JNI.invokePPPPP(Builder2, LHS, RHS, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildPtrDiff(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildPtrDiff(Builder2, LHS, RHS, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildPtrDiff(@NativeType(value="LLVMBuilderRef") long Builder2, @NativeType(value="LLVMValueRef") long LHS, @NativeType(value="LLVMValueRef") long RHS, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildPtrDiff(Builder2, LHS, RHS, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMBuildFence(long B, int ordering, int singleThread, long Name2) {
        long __functionAddress = Functions.BuildFence;
        if (Checks.CHECKS) {
            Checks.check(B);
        }
        return JNI.invokePPP(B, ordering, singleThread, Name2, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFence(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMAtomicOrdering") int ordering, @NativeType(value="LLVMBool") boolean singleThread, @NativeType(value="char const *") ByteBuffer Name2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Name2);
        }
        return LLVMCore.nLLVMBuildFence(B, ordering, singleThread ? 1 : 0, MemoryUtil.memAddress(Name2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildFence(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMAtomicOrdering") int ordering, @NativeType(value="LLVMBool") boolean singleThread, @NativeType(value="char const *") CharSequence Name2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name2, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMBuildFence(B, ordering, singleThread ? 1 : 0, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildAtomicRMW(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMAtomicRMWBinOp") int op, @NativeType(value="LLVMValueRef") long PTR, @NativeType(value="LLVMValueRef") long Val, @NativeType(value="LLVMAtomicOrdering") int ordering, @NativeType(value="LLVMBool") boolean singleThread) {
        long __functionAddress = Functions.BuildAtomicRMW;
        if (Checks.CHECKS) {
            Checks.check(B);
            Checks.check(PTR);
            Checks.check(Val);
        }
        return JNI.invokePPPP(B, op, PTR, Val, ordering, singleThread ? 1 : 0, __functionAddress);
    }

    @NativeType(value="LLVMValueRef")
    public static long LLVMBuildAtomicCmpXchg(@NativeType(value="LLVMBuilderRef") long B, @NativeType(value="LLVMValueRef") long Ptr, @NativeType(value="LLVMValueRef") long Cmp, @NativeType(value="LLVMValueRef") long New, @NativeType(value="LLVMAtomicOrdering") int SuccessOrdering, @NativeType(value="LLVMAtomicOrdering") int FailureOrdering, @NativeType(value="LLVMBool") boolean SingleThread) {
        long __functionAddress = Functions.BuildAtomicCmpXchg;
        if (Checks.CHECKS) {
            Checks.check(B);
            Checks.check(Ptr);
            Checks.check(Cmp);
            Checks.check(New);
        }
        return JNI.invokePPPPP(B, Ptr, Cmp, New, SuccessOrdering, FailureOrdering, SingleThread ? 1 : 0, __functionAddress);
    }

    @NativeType(value="unsigned")
    public static int LLVMGetNumMaskElements(@NativeType(value="LLVMValueRef") long ShuffleVectorInst) {
        long __functionAddress = Functions.GetNumMaskElements;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(ShuffleVectorInst);
        }
        return JNI.invokePI(ShuffleVectorInst, __functionAddress);
    }

    public static int LLVMGetUndefMaskElem() {
        long __functionAddress = Functions.GetUndefMaskElem;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.invokeI(__functionAddress);
    }

    public static int LLVMGetMaskValue(@NativeType(value="LLVMValueRef") long ShuffleVectorInst, @NativeType(value="unsigned") int Elt) {
        long __functionAddress = Functions.GetMaskValue;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(ShuffleVectorInst);
        }
        return JNI.invokePI(ShuffleVectorInst, Elt, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsAtomicSingleThread(@NativeType(value="LLVMValueRef") long AtomicInst) {
        long __functionAddress = Functions.IsAtomicSingleThread;
        if (Checks.CHECKS) {
            Checks.check(AtomicInst);
        }
        return JNI.invokePI(AtomicInst, __functionAddress) != 0;
    }

    public static void LLVMSetAtomicSingleThread(@NativeType(value="LLVMValueRef") long AtomicInst, @NativeType(value="LLVMBool") boolean SingleThread) {
        long __functionAddress = Functions.SetAtomicSingleThread;
        if (Checks.CHECKS) {
            Checks.check(AtomicInst);
        }
        JNI.invokePV(AtomicInst, SingleThread ? 1 : 0, __functionAddress);
    }

    @NativeType(value="LLVMAtomicOrdering")
    public static int LLVMGetCmpXchgSuccessOrdering(@NativeType(value="LLVMValueRef") long CmpXchgInst) {
        long __functionAddress = Functions.GetCmpXchgSuccessOrdering;
        if (Checks.CHECKS) {
            Checks.check(CmpXchgInst);
        }
        return JNI.invokePI(CmpXchgInst, __functionAddress);
    }

    public static void LLVMSetCmpXchgSuccessOrdering(@NativeType(value="LLVMValueRef") long CmpXchgInst, @NativeType(value="LLVMAtomicOrdering") int Ordering) {
        long __functionAddress = Functions.SetCmpXchgSuccessOrdering;
        if (Checks.CHECKS) {
            Checks.check(CmpXchgInst);
        }
        JNI.invokePV(CmpXchgInst, Ordering, __functionAddress);
    }

    @NativeType(value="LLVMAtomicOrdering")
    public static int LLVMGetCmpXchgFailureOrdering(@NativeType(value="LLVMValueRef") long CmpXchgInst) {
        long __functionAddress = Functions.GetCmpXchgFailureOrdering;
        if (Checks.CHECKS) {
            Checks.check(CmpXchgInst);
        }
        return JNI.invokePI(CmpXchgInst, __functionAddress);
    }

    public static void LLVMSetCmpXchgFailureOrdering(@NativeType(value="LLVMValueRef") long CmpXchgInst, @NativeType(value="LLVMAtomicOrdering") int Ordering) {
        long __functionAddress = Functions.SetCmpXchgFailureOrdering;
        if (Checks.CHECKS) {
            Checks.check(CmpXchgInst);
        }
        JNI.invokePV(CmpXchgInst, Ordering, __functionAddress);
    }

    @NativeType(value="LLVMModuleProviderRef")
    public static long LLVMCreateModuleProviderForExistingModule(@NativeType(value="LLVMModuleRef") long M) {
        long __functionAddress = Functions.CreateModuleProviderForExistingModule;
        if (Checks.CHECKS) {
            Checks.check(M);
        }
        return JNI.invokePP(M, __functionAddress);
    }

    public static void LLVMDisposeModuleProvider(@NativeType(value="LLVMModuleProviderRef") long M) {
        long __functionAddress = Functions.DisposeModuleProvider;
        if (Checks.CHECKS) {
            Checks.check(M);
        }
        JNI.invokePV(M, __functionAddress);
    }

    public static int nLLVMCreateMemoryBufferWithContentsOfFile(long Path2, long OutMemBuf, long OutMessage) {
        long __functionAddress = Functions.CreateMemoryBufferWithContentsOfFile;
        return JNI.invokePPPI(Path2, OutMemBuf, OutMessage, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMCreateMemoryBufferWithContentsOfFile(@NativeType(value="char const *") ByteBuffer Path2, @NativeType(value="LLVMMemoryBufferRef *") PointerBuffer OutMemBuf, @NativeType(value="char **") PointerBuffer OutMessage) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Path2);
            Checks.check(OutMemBuf, 1);
            Checks.check(OutMessage, 1);
        }
        return LLVMCore.nLLVMCreateMemoryBufferWithContentsOfFile(MemoryUtil.memAddress(Path2), MemoryUtil.memAddress(OutMemBuf), MemoryUtil.memAddress(OutMessage)) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMBool")
    public static boolean LLVMCreateMemoryBufferWithContentsOfFile(@NativeType(value="char const *") CharSequence Path2, @NativeType(value="LLVMMemoryBufferRef *") PointerBuffer OutMemBuf, @NativeType(value="char **") PointerBuffer OutMessage) {
        if (Checks.CHECKS) {
            Checks.check(OutMemBuf, 1);
            Checks.check(OutMessage, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Path2, true);
            long PathEncoded = stack.getPointerAddress();
            boolean bl = LLVMCore.nLLVMCreateMemoryBufferWithContentsOfFile(PathEncoded, MemoryUtil.memAddress(OutMemBuf), MemoryUtil.memAddress(OutMessage)) != 0;
            return bl;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nLLVMCreateMemoryBufferWithSTDIN(long OutMemBuf, long OutMessage) {
        long __functionAddress = Functions.CreateMemoryBufferWithSTDIN;
        return JNI.invokePPI(OutMemBuf, OutMessage, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMCreateMemoryBufferWithSTDIN(@NativeType(value="LLVMMemoryBufferRef *") PointerBuffer OutMemBuf, @NativeType(value="char **") PointerBuffer OutMessage) {
        if (Checks.CHECKS) {
            Checks.check(OutMemBuf, 1);
            Checks.check(OutMessage, 1);
        }
        return LLVMCore.nLLVMCreateMemoryBufferWithSTDIN(MemoryUtil.memAddress(OutMemBuf), MemoryUtil.memAddress(OutMessage)) != 0;
    }

    public static long nLLVMCreateMemoryBufferWithMemoryRange(long InputData, long InputDataLength, long BufferName, int RequiresNullTerminator) {
        long __functionAddress = Functions.CreateMemoryBufferWithMemoryRange;
        return JNI.invokePPPP(InputData, InputDataLength, BufferName, RequiresNullTerminator, __functionAddress);
    }

    @NativeType(value="LLVMMemoryBufferRef")
    public static long LLVMCreateMemoryBufferWithMemoryRange(@NativeType(value="char const *") ByteBuffer InputData, @NativeType(value="char const *") ByteBuffer BufferName, @NativeType(value="LLVMBool") boolean RequiresNullTerminator) {
        if (Checks.CHECKS) {
            Checks.checkNT1(BufferName);
        }
        return LLVMCore.nLLVMCreateMemoryBufferWithMemoryRange(MemoryUtil.memAddress(InputData), InputData.remaining(), MemoryUtil.memAddress(BufferName), RequiresNullTerminator ? 1 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMemoryBufferRef")
    public static long LLVMCreateMemoryBufferWithMemoryRange(@NativeType(value="char const *") ByteBuffer InputData, @NativeType(value="char const *") CharSequence BufferName, @NativeType(value="LLVMBool") boolean RequiresNullTerminator) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(BufferName, true);
            long BufferNameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMCreateMemoryBufferWithMemoryRange(MemoryUtil.memAddress(InputData), InputData.remaining(), BufferNameEncoded, RequiresNullTerminator ? 1 : 0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMCreateMemoryBufferWithMemoryRangeCopy(long InputData, long InputDataLength, long BufferName) {
        long __functionAddress = Functions.CreateMemoryBufferWithMemoryRangeCopy;
        return JNI.invokePPPP(InputData, InputDataLength, BufferName, __functionAddress);
    }

    @NativeType(value="LLVMMemoryBufferRef")
    public static long LLVMCreateMemoryBufferWithMemoryRangeCopy(@NativeType(value="char const *") ByteBuffer InputData, @NativeType(value="char const *") ByteBuffer BufferName) {
        if (Checks.CHECKS) {
            Checks.checkNT1(BufferName);
        }
        return LLVMCore.nLLVMCreateMemoryBufferWithMemoryRangeCopy(MemoryUtil.memAddress(InputData), InputData.remaining(), MemoryUtil.memAddress(BufferName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMMemoryBufferRef")
    public static long LLVMCreateMemoryBufferWithMemoryRangeCopy(@NativeType(value="char const *") ByteBuffer InputData, @NativeType(value="char const *") CharSequence BufferName) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(BufferName, true);
            long BufferNameEncoded = stack.getPointerAddress();
            long l = LLVMCore.nLLVMCreateMemoryBufferWithMemoryRangeCopy(MemoryUtil.memAddress(InputData), InputData.remaining(), BufferNameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMGetBufferStart(long MemBuf) {
        long __functionAddress = Functions.GetBufferStart;
        if (Checks.CHECKS) {
            Checks.check(MemBuf);
        }
        return JNI.invokePP(MemBuf, __functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String LLVMGetBufferStart(@NativeType(value="LLVMMemoryBufferRef") long MemBuf) {
        long __result = LLVMCore.nLLVMGetBufferStart(MemBuf);
        return MemoryUtil.memUTF8Safe(__result);
    }

    @NativeType(value="size_t")
    public static long LLVMGetBufferSize(@NativeType(value="LLVMMemoryBufferRef") long MemBuf) {
        long __functionAddress = Functions.GetBufferSize;
        if (Checks.CHECKS) {
            Checks.check(MemBuf);
        }
        return JNI.invokePP(MemBuf, __functionAddress);
    }

    public static void LLVMDisposeMemoryBuffer(@NativeType(value="LLVMMemoryBufferRef") long MemBuf) {
        long __functionAddress = Functions.DisposeMemoryBuffer;
        if (Checks.CHECKS) {
            Checks.check(MemBuf);
        }
        JNI.invokePV(MemBuf, __functionAddress);
    }

    @NativeType(value="LLVMPassRegistryRef")
    public static long LLVMGetGlobalPassRegistry() {
        long __functionAddress = Functions.GetGlobalPassRegistry;
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="LLVMPassManagerRef")
    public static long LLVMCreatePassManager() {
        long __functionAddress = Functions.CreatePassManager;
        return JNI.invokeP(__functionAddress);
    }

    @NativeType(value="LLVMPassManagerRef")
    public static long LLVMCreateFunctionPassManagerForModule(@NativeType(value="LLVMModuleRef") long M) {
        long __functionAddress = Functions.CreateFunctionPassManagerForModule;
        if (Checks.CHECKS) {
            Checks.check(M);
        }
        return JNI.invokePP(M, __functionAddress);
    }

    @NativeType(value="LLVMPassManagerRef")
    public static long LLVMCreateFunctionPassManager(@NativeType(value="LLVMModuleProviderRef") long MP) {
        long __functionAddress = Functions.CreateFunctionPassManager;
        if (Checks.CHECKS) {
            Checks.check(MP);
        }
        return JNI.invokePP(MP, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMRunPassManager(@NativeType(value="LLVMPassManagerRef") long PM, @NativeType(value="LLVMModuleRef") long M) {
        long __functionAddress = Functions.RunPassManager;
        if (Checks.CHECKS) {
            Checks.check(PM);
            Checks.check(M);
        }
        return JNI.invokePPI(PM, M, __functionAddress) != 0;
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMInitializeFunctionPassManager(@NativeType(value="LLVMPassManagerRef") long FPM) {
        long __functionAddress = Functions.InitializeFunctionPassManager;
        if (Checks.CHECKS) {
            Checks.check(FPM);
        }
        return JNI.invokePI(FPM, __functionAddress) != 0;
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMRunFunctionPassManager(@NativeType(value="LLVMPassManagerRef") long FPM, @NativeType(value="LLVMValueRef") long F) {
        long __functionAddress = Functions.RunFunctionPassManager;
        if (Checks.CHECKS) {
            Checks.check(FPM);
            Checks.check(F);
        }
        return JNI.invokePPI(FPM, F, __functionAddress) != 0;
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMFinalizeFunctionPassManager(@NativeType(value="LLVMPassManagerRef") long FPM) {
        long __functionAddress = Functions.FinalizeFunctionPassManager;
        if (Checks.CHECKS) {
            Checks.check(FPM);
        }
        return JNI.invokePI(FPM, __functionAddress) != 0;
    }

    public static void LLVMDisposePassManager(@NativeType(value="LLVMPassManagerRef") long PM) {
        long __functionAddress = Functions.DisposePassManager;
        if (Checks.CHECKS) {
            Checks.check(PM);
        }
        JNI.invokePV(PM, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMStartMultithreaded() {
        long __functionAddress = Functions.StartMultithreaded;
        return JNI.invokeI(__functionAddress) != 0;
    }

    public static void LLVMStopMultithreaded() {
        long __functionAddress = Functions.StopMultithreaded;
        JNI.invokeV(__functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsMultithreaded() {
        long __functionAddress = Functions.IsMultithreaded;
        return JNI.invokeI(__functionAddress) != 0;
    }

    static /* synthetic */ SharedLibrary access$000() {
        return LLVM;
    }

    public static final class Functions {
        public static final long InitializeCore = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMInitializeCore");
        public static final long Shutdown = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMShutdown");
        public static final long CreateMessage = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMCreateMessage");
        public static final long DisposeMessage = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMDisposeMessage");
        public static final long ContextCreate = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMContextCreate");
        public static final long GetGlobalContext = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetGlobalContext");
        public static final long ContextSetDiagnosticHandler = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMContextSetDiagnosticHandler");
        public static final long ContextGetDiagnosticHandler = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMContextGetDiagnosticHandler");
        public static final long ContextGetDiagnosticContext = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMContextGetDiagnosticContext");
        public static final long ContextSetYieldCallback = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMContextSetYieldCallback");
        public static final long ContextShouldDiscardValueNames = LLVMCore.access$000().getFunctionAddress("LLVMContextShouldDiscardValueNames");
        public static final long ContextSetDiscardValueNames = LLVMCore.access$000().getFunctionAddress("LLVMContextSetDiscardValueNames");
        public static final long ContextDispose = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMContextDispose");
        public static final long GetDiagInfoDescription = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetDiagInfoDescription");
        public static final long GetDiagInfoSeverity = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetDiagInfoSeverity");
        public static final long GetMDKindIDInContext = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetMDKindIDInContext");
        public static final long GetMDKindID = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetMDKindID");
        public static final long GetEnumAttributeKindForName = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetEnumAttributeKindForName");
        public static final long GetLastEnumAttributeKind = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetLastEnumAttributeKind");
        public static final long CreateEnumAttribute = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMCreateEnumAttribute");
        public static final long GetEnumAttributeKind = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetEnumAttributeKind");
        public static final long GetEnumAttributeValue = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetEnumAttributeValue");
        public static final long CreateTypeAttribute = LLVMCore.access$000().getFunctionAddress("LLVMCreateTypeAttribute");
        public static final long GetTypeAttributeValue = LLVMCore.access$000().getFunctionAddress("LLVMGetTypeAttributeValue");
        public static final long CreateStringAttribute = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMCreateStringAttribute");
        public static final long GetStringAttributeKind = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetStringAttributeKind");
        public static final long GetStringAttributeValue = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetStringAttributeValue");
        public static final long IsEnumAttribute = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsEnumAttribute");
        public static final long IsStringAttribute = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsStringAttribute");
        public static final long IsTypeAttribute = LLVMCore.access$000().getFunctionAddress("LLVMIsTypeAttribute");
        public static final long GetTypeByName2 = LLVMCore.access$000().getFunctionAddress("LLVMGetTypeByName2");
        public static final long ModuleCreateWithName = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMModuleCreateWithName");
        public static final long ModuleCreateWithNameInContext = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMModuleCreateWithNameInContext");
        public static final long CloneModule = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMCloneModule");
        public static final long DisposeModule = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMDisposeModule");
        public static final long GetModuleIdentifier = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetModuleIdentifier");
        public static final long SetModuleIdentifier = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMSetModuleIdentifier");
        public static final long GetSourceFileName = LLVMCore.access$000().getFunctionAddress("LLVMGetSourceFileName");
        public static final long SetSourceFileName = LLVMCore.access$000().getFunctionAddress("LLVMSetSourceFileName");
        public static final long GetDataLayoutStr = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetDataLayoutStr");
        public static final long GetDataLayout = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetDataLayout");
        public static final long SetDataLayout = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMSetDataLayout");
        public static final long GetTarget = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetTarget");
        public static final long SetTarget = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMSetTarget");
        public static final long CopyModuleFlagsMetadata = LLVMCore.access$000().getFunctionAddress("LLVMCopyModuleFlagsMetadata");
        public static final long DisposeModuleFlagsMetadata = LLVMCore.access$000().getFunctionAddress("LLVMDisposeModuleFlagsMetadata");
        public static final long ModuleFlagEntriesGetFlagBehavior = LLVMCore.access$000().getFunctionAddress("LLVMModuleFlagEntriesGetFlagBehavior");
        public static final long ModuleFlagEntriesGetKey = LLVMCore.access$000().getFunctionAddress("LLVMModuleFlagEntriesGetKey");
        public static final long ModuleFlagEntriesGetMetadata = LLVMCore.access$000().getFunctionAddress("LLVMModuleFlagEntriesGetMetadata");
        public static final long GetModuleFlag = LLVMCore.access$000().getFunctionAddress("LLVMGetModuleFlag");
        public static final long AddModuleFlag = LLVMCore.access$000().getFunctionAddress("LLVMAddModuleFlag");
        public static final long DumpModule = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMDumpModule");
        public static final long PrintModuleToFile = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMPrintModuleToFile");
        public static final long PrintModuleToString = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMPrintModuleToString");
        public static final long GetModuleInlineAsm = LLVMCore.access$000().getFunctionAddress("LLVMGetModuleInlineAsm");
        public static final long SetModuleInlineAsm2 = LLVMCore.access$000().getFunctionAddress("LLVMSetModuleInlineAsm2");
        public static final long AppendModuleInlineAsm = LLVMCore.access$000().getFunctionAddress("LLVMAppendModuleInlineAsm");
        public static final long GetInlineAsm = LLVMCore.access$000().getFunctionAddress("LLVMGetInlineAsm");
        public static final long GetModuleContext = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetModuleContext");
        public static final long GetTypeByName = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetTypeByName");
        public static final long GetFirstNamedMetadata = LLVMCore.access$000().getFunctionAddress("LLVMGetFirstNamedMetadata");
        public static final long GetLastNamedMetadata = LLVMCore.access$000().getFunctionAddress("LLVMGetLastNamedMetadata");
        public static final long GetNextNamedMetadata = LLVMCore.access$000().getFunctionAddress("LLVMGetNextNamedMetadata");
        public static final long GetPreviousNamedMetadata = LLVMCore.access$000().getFunctionAddress("LLVMGetPreviousNamedMetadata");
        public static final long GetNamedMetadata = LLVMCore.access$000().getFunctionAddress("LLVMGetNamedMetadata");
        public static final long GetOrInsertNamedMetadata = LLVMCore.access$000().getFunctionAddress("LLVMGetOrInsertNamedMetadata");
        public static final long GetNamedMetadataName = LLVMCore.access$000().getFunctionAddress("LLVMGetNamedMetadataName");
        public static final long GetNamedMetadataNumOperands = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetNamedMetadataNumOperands");
        public static final long GetNamedMetadataOperands = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetNamedMetadataOperands");
        public static final long AddNamedMetadataOperand = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMAddNamedMetadataOperand");
        public static final long GetDebugLocDirectory = LLVMCore.access$000().getFunctionAddress("LLVMGetDebugLocDirectory");
        public static final long GetDebugLocFilename = LLVMCore.access$000().getFunctionAddress("LLVMGetDebugLocFilename");
        public static final long GetDebugLocLine = LLVMCore.access$000().getFunctionAddress("LLVMGetDebugLocLine");
        public static final long GetDebugLocColumn = LLVMCore.access$000().getFunctionAddress("LLVMGetDebugLocColumn");
        public static final long AddFunction = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMAddFunction");
        public static final long GetNamedFunction = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetNamedFunction");
        public static final long GetFirstFunction = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetFirstFunction");
        public static final long GetLastFunction = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetLastFunction");
        public static final long GetNextFunction = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetNextFunction");
        public static final long GetPreviousFunction = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetPreviousFunction");
        public static final long SetModuleInlineAsm = LLVMCore.access$000().getFunctionAddress("LLVMSetModuleInlineAsm");
        public static final long GetTypeKind = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetTypeKind");
        public static final long TypeIsSized = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMTypeIsSized");
        public static final long GetTypeContext = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetTypeContext");
        public static final long DumpType = LLVMCore.access$000().getFunctionAddress("LLVMDumpType");
        public static final long PrintTypeToString = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMPrintTypeToString");
        public static final long Int1TypeInContext = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMInt1TypeInContext");
        public static final long Int8TypeInContext = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMInt8TypeInContext");
        public static final long Int16TypeInContext = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMInt16TypeInContext");
        public static final long Int32TypeInContext = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMInt32TypeInContext");
        public static final long Int64TypeInContext = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMInt64TypeInContext");
        public static final long Int128TypeInContext = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMInt128TypeInContext");
        public static final long IntTypeInContext = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIntTypeInContext");
        public static final long Int1Type = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMInt1Type");
        public static final long Int8Type = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMInt8Type");
        public static final long Int16Type = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMInt16Type");
        public static final long Int32Type = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMInt32Type");
        public static final long Int64Type = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMInt64Type");
        public static final long Int128Type = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMInt128Type");
        public static final long IntType = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIntType");
        public static final long GetIntTypeWidth = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetIntTypeWidth");
        public static final long HalfTypeInContext = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMHalfTypeInContext");
        public static final long BFloatTypeInContext = LLVMCore.access$000().getFunctionAddress("LLVMBFloatTypeInContext");
        public static final long FloatTypeInContext = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMFloatTypeInContext");
        public static final long DoubleTypeInContext = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMDoubleTypeInContext");
        public static final long X86FP80TypeInContext = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMX86FP80TypeInContext");
        public static final long FP128TypeInContext = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMFP128TypeInContext");
        public static final long PPCFP128TypeInContext = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMPPCFP128TypeInContext");
        public static final long HalfType = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMHalfType");
        public static final long BFloatType = LLVMCore.access$000().getFunctionAddress("LLVMBFloatType");
        public static final long FloatType = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMFloatType");
        public static final long DoubleType = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMDoubleType");
        public static final long X86FP80Type = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMX86FP80Type");
        public static final long FP128Type = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMFP128Type");
        public static final long PPCFP128Type = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMPPCFP128Type");
        public static final long FunctionType = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMFunctionType");
        public static final long IsFunctionVarArg = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsFunctionVarArg");
        public static final long GetReturnType = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetReturnType");
        public static final long CountParamTypes = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMCountParamTypes");
        public static final long GetParamTypes = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetParamTypes");
        public static final long StructTypeInContext = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMStructTypeInContext");
        public static final long StructType = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMStructType");
        public static final long StructCreateNamed = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMStructCreateNamed");
        public static final long GetStructName = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetStructName");
        public static final long StructSetBody = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMStructSetBody");
        public static final long CountStructElementTypes = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMCountStructElementTypes");
        public static final long GetStructElementTypes = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetStructElementTypes");
        public static final long StructGetTypeAtIndex = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMStructGetTypeAtIndex");
        public static final long IsPackedStruct = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsPackedStruct");
        public static final long IsOpaqueStruct = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsOpaqueStruct");
        public static final long IsLiteralStruct = LLVMCore.access$000().getFunctionAddress("LLVMIsLiteralStruct");
        public static final long GetElementType = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetElementType");
        public static final long GetSubtypes = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetSubtypes");
        public static final long GetNumContainedTypes = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetNumContainedTypes");
        public static final long ArrayType = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMArrayType");
        public static final long GetArrayLength = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetArrayLength");
        public static final long PointerType = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMPointerType");
        public static final long GetPointerAddressSpace = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetPointerAddressSpace");
        public static final long VectorType = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMVectorType");
        public static final long ScalableVectorType = LLVMCore.access$000().getFunctionAddress("LLVMScalableVectorType");
        public static final long GetVectorSize = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetVectorSize");
        public static final long VoidTypeInContext = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMVoidTypeInContext");
        public static final long LabelTypeInContext = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMLabelTypeInContext");
        public static final long X86MMXTypeInContext = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMX86MMXTypeInContext");
        public static final long X86AMXTypeInContext = LLVMCore.access$000().getFunctionAddress("LLVMX86AMXTypeInContext");
        public static final long TokenTypeInContext = LLVMCore.access$000().getFunctionAddress("LLVMTokenTypeInContext");
        public static final long MetadataTypeInContext = LLVMCore.access$000().getFunctionAddress("LLVMMetadataTypeInContext");
        public static final long VoidType = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMVoidType");
        public static final long LabelType = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMLabelType");
        public static final long X86MMXType = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMX86MMXType");
        public static final long X86AMXType = LLVMCore.access$000().getFunctionAddress("LLVMX86AMXType");
        public static final long TypeOf = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMTypeOf");
        public static final long GetValueKind = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetValueKind");
        public static final long GetValueName2 = LLVMCore.access$000().getFunctionAddress("LLVMGetValueName2");
        public static final long SetValueName2 = LLVMCore.access$000().getFunctionAddress("LLVMSetValueName2");
        public static final long DumpValue = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMDumpValue");
        public static final long PrintValueToString = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMPrintValueToString");
        public static final long ReplaceAllUsesWith = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMReplaceAllUsesWith");
        public static final long IsConstant = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsConstant");
        public static final long IsUndef = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsUndef");
        public static final long IsPoison = LLVMCore.access$000().getFunctionAddress("LLVMIsPoison");
        public static final long IsAArgument = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAArgument");
        public static final long IsABasicBlock = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsABasicBlock");
        public static final long IsAInlineAsm = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAInlineAsm");
        public static final long IsAUser = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAUser");
        public static final long IsAConstant = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAConstant");
        public static final long IsABlockAddress = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsABlockAddress");
        public static final long IsAConstantAggregateZero = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAConstantAggregateZero");
        public static final long IsAConstantArray = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAConstantArray");
        public static final long IsAConstantDataSequential = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAConstantDataSequential");
        public static final long IsAConstantDataArray = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAConstantDataArray");
        public static final long IsAConstantDataVector = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAConstantDataVector");
        public static final long IsAConstantExpr = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAConstantExpr");
        public static final long IsAConstantFP = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAConstantFP");
        public static final long IsAConstantInt = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAConstantInt");
        public static final long IsAConstantPointerNull = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAConstantPointerNull");
        public static final long IsAConstantStruct = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAConstantStruct");
        public static final long IsAConstantTokenNone = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAConstantTokenNone");
        public static final long IsAConstantVector = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAConstantVector");
        public static final long IsAGlobalValue = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAGlobalValue");
        public static final long IsAGlobalAlias = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAGlobalAlias");
        public static final long IsAGlobalIFunc = LLVMCore.access$000().getFunctionAddress("LLVMIsAGlobalIFunc");
        public static final long IsAGlobalObject = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAGlobalObject");
        public static final long IsAFunction = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAFunction");
        public static final long IsAGlobalVariable = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAGlobalVariable");
        public static final long IsAUndefValue = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAUndefValue");
        public static final long IsAInstruction = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAInstruction");
        public static final long IsABinaryOperator = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsABinaryOperator");
        public static final long IsACallInst = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsACallInst");
        public static final long IsAIntrinsicInst = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAIntrinsicInst");
        public static final long IsADbgInfoIntrinsic = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsADbgInfoIntrinsic");
        public static final long IsADbgVariableIntrinsic = LLVMCore.access$000().getFunctionAddress("LLVMIsADbgVariableIntrinsic");
        public static final long IsADbgDeclareInst = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsADbgDeclareInst");
        public static final long IsADbgLabelInst = LLVMCore.access$000().getFunctionAddress("LLVMIsADbgLabelInst");
        public static final long IsAMemIntrinsic = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAMemIntrinsic");
        public static final long IsAMemCpyInst = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAMemCpyInst");
        public static final long IsAMemMoveInst = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAMemMoveInst");
        public static final long IsAMemSetInst = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAMemSetInst");
        public static final long IsACmpInst = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsACmpInst");
        public static final long IsAFCmpInst = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAFCmpInst");
        public static final long IsAICmpInst = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAICmpInst");
        public static final long IsAExtractElementInst = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAExtractElementInst");
        public static final long IsAGetElementPtrInst = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAGetElementPtrInst");
        public static final long IsAInsertElementInst = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAInsertElementInst");
        public static final long IsAInsertValueInst = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAInsertValueInst");
        public static final long IsALandingPadInst = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsALandingPadInst");
        public static final long IsAPHINode = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAPHINode");
        public static final long IsASelectInst = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsASelectInst");
        public static final long IsAShuffleVectorInst = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAShuffleVectorInst");
        public static final long IsAStoreInst = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAStoreInst");
        public static final long IsABranchInst = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsABranchInst");
        public static final long IsAIndirectBrInst = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAIndirectBrInst");
        public static final long IsAInvokeInst = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAInvokeInst");
        public static final long IsAReturnInst = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAReturnInst");
        public static final long IsASwitchInst = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsASwitchInst");
        public static final long IsAUnreachableInst = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAUnreachableInst");
        public static final long IsAResumeInst = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAResumeInst");
        public static final long IsACleanupReturnInst = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsACleanupReturnInst");
        public static final long IsACatchReturnInst = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsACatchReturnInst");
        public static final long IsAFuncletPadInst = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAFuncletPadInst");
        public static final long IsACatchPadInst = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsACatchPadInst");
        public static final long IsACleanupPadInst = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsACleanupPadInst");
        public static final long IsAUnaryInstruction = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAUnaryInstruction");
        public static final long IsAAllocaInst = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAAllocaInst");
        public static final long IsACastInst = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsACastInst");
        public static final long IsAAddrSpaceCastInst = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAAddrSpaceCastInst");
        public static final long IsABitCastInst = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsABitCastInst");
        public static final long IsAFPExtInst = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAFPExtInst");
        public static final long IsAFPToSIInst = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAFPToSIInst");
        public static final long IsAFPToUIInst = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAFPToUIInst");
        public static final long IsAFPTruncInst = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAFPTruncInst");
        public static final long IsAIntToPtrInst = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAIntToPtrInst");
        public static final long IsAPtrToIntInst = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAPtrToIntInst");
        public static final long IsASExtInst = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsASExtInst");
        public static final long IsASIToFPInst = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsASIToFPInst");
        public static final long IsATruncInst = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsATruncInst");
        public static final long IsAUIToFPInst = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAUIToFPInst");
        public static final long IsAZExtInst = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAZExtInst");
        public static final long IsAExtractValueInst = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAExtractValueInst");
        public static final long IsALoadInst = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsALoadInst");
        public static final long IsAVAArgInst = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAVAArgInst");
        public static final long IsAMDNode = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAMDNode");
        public static final long IsAMDString = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAMDString");
        public static final long GetValueName = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetValueName");
        public static final long SetValueName = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMSetValueName");
        public static final long GetFirstUse = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetFirstUse");
        public static final long GetNextUse = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetNextUse");
        public static final long GetUser = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetUser");
        public static final long GetUsedValue = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetUsedValue");
        public static final long GetOperand = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetOperand");
        public static final long GetOperandUse = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetOperandUse");
        public static final long SetOperand = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMSetOperand");
        public static final long GetNumOperands = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetNumOperands");
        public static final long ConstNull = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstNull");
        public static final long ConstAllOnes = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstAllOnes");
        public static final long GetUndef = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetUndef");
        public static final long GetPoison = LLVMCore.access$000().getFunctionAddress("LLVMGetPoison");
        public static final long IsNull = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsNull");
        public static final long ConstPointerNull = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstPointerNull");
        public static final long ConstInt = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstInt");
        public static final long ConstIntOfArbitraryPrecision = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstIntOfArbitraryPrecision");
        public static final long ConstIntOfString = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstIntOfString");
        public static final long ConstIntOfStringAndSize = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstIntOfStringAndSize");
        public static final long ConstReal = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstReal");
        public static final long ConstRealOfString = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstRealOfString");
        public static final long ConstRealOfStringAndSize = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstRealOfStringAndSize");
        public static final long ConstIntGetZExtValue = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstIntGetZExtValue");
        public static final long ConstIntGetSExtValue = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstIntGetSExtValue");
        public static final long ConstRealGetDouble = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstRealGetDouble");
        public static final long ConstStringInContext = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstStringInContext");
        public static final long ConstString = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstString");
        public static final long IsConstantString = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsConstantString");
        public static final long GetAsString = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetAsString");
        public static final long ConstStructInContext = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstStructInContext");
        public static final long ConstStruct = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstStruct");
        public static final long ConstArray = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstArray");
        public static final long ConstNamedStruct = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstNamedStruct");
        public static final long GetElementAsConstant = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetElementAsConstant");
        public static final long ConstVector = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstVector");
        public static final long GetConstOpcode = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetConstOpcode");
        public static final long AlignOf = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMAlignOf");
        public static final long SizeOf = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMSizeOf");
        public static final long ConstNeg = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstNeg");
        public static final long ConstNSWNeg = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstNSWNeg");
        public static final long ConstNUWNeg = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstNUWNeg");
        public static final long ConstFNeg = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstFNeg");
        public static final long ConstNot = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstNot");
        public static final long ConstAdd = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstAdd");
        public static final long ConstNSWAdd = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstNSWAdd");
        public static final long ConstNUWAdd = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstNUWAdd");
        public static final long ConstFAdd = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstFAdd");
        public static final long ConstSub = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstSub");
        public static final long ConstNSWSub = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstNSWSub");
        public static final long ConstNUWSub = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstNUWSub");
        public static final long ConstFSub = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstFSub");
        public static final long ConstMul = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstMul");
        public static final long ConstNSWMul = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstNSWMul");
        public static final long ConstNUWMul = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstNUWMul");
        public static final long ConstFMul = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstFMul");
        public static final long ConstUDiv = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstUDiv");
        public static final long ConstExactUDiv = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstExactUDiv");
        public static final long ConstSDiv = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstSDiv");
        public static final long ConstExactSDiv = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstExactSDiv");
        public static final long ConstFDiv = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstFDiv");
        public static final long ConstURem = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstURem");
        public static final long ConstSRem = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstSRem");
        public static final long ConstFRem = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstFRem");
        public static final long ConstAnd = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstAnd");
        public static final long ConstOr = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstOr");
        public static final long ConstXor = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstXor");
        public static final long ConstICmp = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstICmp");
        public static final long ConstFCmp = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstFCmp");
        public static final long ConstShl = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstShl");
        public static final long ConstLShr = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstLShr");
        public static final long ConstAShr = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstAShr");
        public static final long ConstGEP = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstGEP");
        public static final long ConstGEP2 = LLVMCore.access$000().getFunctionAddress("LLVMConstGEP2");
        public static final long ConstInBoundsGEP = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstInBoundsGEP");
        public static final long ConstInBoundsGEP2 = LLVMCore.access$000().getFunctionAddress("LLVMConstInBoundsGEP2");
        public static final long ConstTrunc = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstTrunc");
        public static final long ConstSExt = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstSExt");
        public static final long ConstZExt = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstZExt");
        public static final long ConstFPTrunc = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstFPTrunc");
        public static final long ConstFPExt = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstFPExt");
        public static final long ConstUIToFP = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstUIToFP");
        public static final long ConstSIToFP = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstSIToFP");
        public static final long ConstFPToUI = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstFPToUI");
        public static final long ConstFPToSI = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstFPToSI");
        public static final long ConstPtrToInt = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstPtrToInt");
        public static final long ConstIntToPtr = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstIntToPtr");
        public static final long ConstBitCast = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstBitCast");
        public static final long ConstAddrSpaceCast = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstAddrSpaceCast");
        public static final long ConstZExtOrBitCast = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstZExtOrBitCast");
        public static final long ConstSExtOrBitCast = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstSExtOrBitCast");
        public static final long ConstTruncOrBitCast = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstTruncOrBitCast");
        public static final long ConstPointerCast = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstPointerCast");
        public static final long ConstIntCast = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstIntCast");
        public static final long ConstFPCast = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstFPCast");
        public static final long ConstSelect = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstSelect");
        public static final long ConstExtractElement = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstExtractElement");
        public static final long ConstInsertElement = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstInsertElement");
        public static final long ConstShuffleVector = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstShuffleVector");
        public static final long ConstExtractValue = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstExtractValue");
        public static final long ConstInsertValue = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstInsertValue");
        public static final long BlockAddress = LLVMCore.access$000().getFunctionAddress("LLVMBlockAddress");
        public static final long ConstInlineAsm = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMConstInlineAsm");
        public static final long GetGlobalParent = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetGlobalParent");
        public static final long IsDeclaration = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsDeclaration");
        public static final long GetLinkage = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetLinkage");
        public static final long SetLinkage = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMSetLinkage");
        public static final long GetSection = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetSection");
        public static final long SetSection = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMSetSection");
        public static final long GetVisibility = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetVisibility");
        public static final long SetVisibility = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMSetVisibility");
        public static final long GetDLLStorageClass = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetDLLStorageClass");
        public static final long SetDLLStorageClass = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMSetDLLStorageClass");
        public static final long GetUnnamedAddress = LLVMCore.access$000().getFunctionAddress("LLVMGetUnnamedAddress");
        public static final long SetUnnamedAddress = LLVMCore.access$000().getFunctionAddress("LLVMSetUnnamedAddress");
        public static final long GlobalGetValueType = LLVMCore.access$000().getFunctionAddress("LLVMGlobalGetValueType");
        public static final long HasUnnamedAddr = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMHasUnnamedAddr");
        public static final long SetUnnamedAddr = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMSetUnnamedAddr");
        public static final long GetAlignment = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetAlignment");
        public static final long SetAlignment = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMSetAlignment");
        public static final long GlobalSetMetadata = LLVMCore.access$000().getFunctionAddress("LLVMGlobalSetMetadata");
        public static final long GlobalEraseMetadata = LLVMCore.access$000().getFunctionAddress("LLVMGlobalEraseMetadata");
        public static final long GlobalClearMetadata = LLVMCore.access$000().getFunctionAddress("LLVMGlobalClearMetadata");
        public static final long GlobalCopyAllMetadata = LLVMCore.access$000().getFunctionAddress("LLVMGlobalCopyAllMetadata");
        public static final long DisposeValueMetadataEntries = LLVMCore.access$000().getFunctionAddress("LLVMDisposeValueMetadataEntries");
        public static final long ValueMetadataEntriesGetKind = LLVMCore.access$000().getFunctionAddress("LLVMValueMetadataEntriesGetKind");
        public static final long ValueMetadataEntriesGetMetadata = LLVMCore.access$000().getFunctionAddress("LLVMValueMetadataEntriesGetMetadata");
        public static final long AddGlobal = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMAddGlobal");
        public static final long AddGlobalInAddressSpace = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMAddGlobalInAddressSpace");
        public static final long GetNamedGlobal = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetNamedGlobal");
        public static final long GetFirstGlobal = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetFirstGlobal");
        public static final long GetLastGlobal = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetLastGlobal");
        public static final long GetNextGlobal = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetNextGlobal");
        public static final long GetPreviousGlobal = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetPreviousGlobal");
        public static final long DeleteGlobal = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMDeleteGlobal");
        public static final long GetInitializer = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetInitializer");
        public static final long SetInitializer = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMSetInitializer");
        public static final long IsThreadLocal = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsThreadLocal");
        public static final long SetThreadLocal = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMSetThreadLocal");
        public static final long IsGlobalConstant = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsGlobalConstant");
        public static final long SetGlobalConstant = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMSetGlobalConstant");
        public static final long GetThreadLocalMode = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetThreadLocalMode");
        public static final long SetThreadLocalMode = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMSetThreadLocalMode");
        public static final long IsExternallyInitialized = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsExternallyInitialized");
        public static final long SetExternallyInitialized = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMSetExternallyInitialized");
        public static final long AddAlias = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMAddAlias");
        public static final long GetNamedGlobalAlias = LLVMCore.access$000().getFunctionAddress("LLVMGetNamedGlobalAlias");
        public static final long GetFirstGlobalAlias = LLVMCore.access$000().getFunctionAddress("LLVMGetFirstGlobalAlias");
        public static final long GetLastGlobalAlias = LLVMCore.access$000().getFunctionAddress("LLVMGetLastGlobalAlias");
        public static final long GetNextGlobalAlias = LLVMCore.access$000().getFunctionAddress("LLVMGetNextGlobalAlias");
        public static final long GetPreviousGlobalAlias = LLVMCore.access$000().getFunctionAddress("LLVMGetPreviousGlobalAlias");
        public static final long AliasGetAliasee = LLVMCore.access$000().getFunctionAddress("LLVMAliasGetAliasee");
        public static final long AliasSetAliasee = LLVMCore.access$000().getFunctionAddress("LLVMAliasSetAliasee");
        public static final long DeleteFunction = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMDeleteFunction");
        public static final long HasPersonalityFn = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMHasPersonalityFn");
        public static final long GetPersonalityFn = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetPersonalityFn");
        public static final long SetPersonalityFn = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMSetPersonalityFn");
        public static final long LookupIntrinsicID = LLVMCore.access$000().getFunctionAddress("LLVMLookupIntrinsicID");
        public static final long GetIntrinsicID = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetIntrinsicID");
        public static final long GetIntrinsicDeclaration = LLVMCore.access$000().getFunctionAddress("LLVMGetIntrinsicDeclaration");
        public static final long IntrinsicGetType = LLVMCore.access$000().getFunctionAddress("LLVMIntrinsicGetType");
        public static final long IntrinsicGetName = LLVMCore.access$000().getFunctionAddress("LLVMIntrinsicGetName");
        public static final long IntrinsicCopyOverloadedName = LLVMCore.access$000().getFunctionAddress("LLVMIntrinsicCopyOverloadedName");
        public static final long IntrinsicCopyOverloadedName2 = LLVMCore.access$000().getFunctionAddress("LLVMIntrinsicCopyOverloadedName2");
        public static final long IntrinsicIsOverloaded = LLVMCore.access$000().getFunctionAddress("LLVMIntrinsicIsOverloaded");
        public static final long GetFunctionCallConv = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetFunctionCallConv");
        public static final long SetFunctionCallConv = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMSetFunctionCallConv");
        public static final long GetGC = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetGC");
        public static final long SetGC = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMSetGC");
        public static final long AddAttributeAtIndex = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMAddAttributeAtIndex");
        public static final long GetAttributeCountAtIndex = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetAttributeCountAtIndex");
        public static final long GetAttributesAtIndex = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetAttributesAtIndex");
        public static final long GetEnumAttributeAtIndex = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetEnumAttributeAtIndex");
        public static final long GetStringAttributeAtIndex = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetStringAttributeAtIndex");
        public static final long RemoveEnumAttributeAtIndex = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMRemoveEnumAttributeAtIndex");
        public static final long RemoveStringAttributeAtIndex = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMRemoveStringAttributeAtIndex");
        public static final long AddTargetDependentFunctionAttr = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMAddTargetDependentFunctionAttr");
        public static final long CountParams = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMCountParams");
        public static final long GetParams = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetParams");
        public static final long GetParam = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetParam");
        public static final long GetParamParent = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetParamParent");
        public static final long GetFirstParam = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetFirstParam");
        public static final long GetLastParam = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetLastParam");
        public static final long GetNextParam = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetNextParam");
        public static final long GetPreviousParam = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetPreviousParam");
        public static final long SetParamAlignment = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMSetParamAlignment");
        public static final long AddGlobalIFunc = LLVMCore.access$000().getFunctionAddress("LLVMAddGlobalIFunc");
        public static final long GetNamedGlobalIFunc = LLVMCore.access$000().getFunctionAddress("LLVMGetNamedGlobalIFunc");
        public static final long GetFirstGlobalIFunc = LLVMCore.access$000().getFunctionAddress("LLVMGetFirstGlobalIFunc");
        public static final long GetLastGlobalIFunc = LLVMCore.access$000().getFunctionAddress("LLVMGetLastGlobalIFunc");
        public static final long GetNextGlobalIFunc = LLVMCore.access$000().getFunctionAddress("LLVMGetNextGlobalIFunc");
        public static final long GetPreviousGlobalIFunc = LLVMCore.access$000().getFunctionAddress("LLVMGetPreviousGlobalIFunc");
        public static final long GetGlobalIFuncResolver = LLVMCore.access$000().getFunctionAddress("LLVMGetGlobalIFuncResolver");
        public static final long SetGlobalIFuncResolver = LLVMCore.access$000().getFunctionAddress("LLVMSetGlobalIFuncResolver");
        public static final long EraseGlobalIFunc = LLVMCore.access$000().getFunctionAddress("LLVMEraseGlobalIFunc");
        public static final long RemoveGlobalIFunc = LLVMCore.access$000().getFunctionAddress("LLVMRemoveGlobalIFunc");
        public static final long MDStringInContext2 = LLVMCore.access$000().getFunctionAddress("LLVMMDStringInContext2");
        public static final long MDNodeInContext2 = LLVMCore.access$000().getFunctionAddress("LLVMMDNodeInContext2");
        public static final long MDStringInContext = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMMDStringInContext");
        public static final long MDString = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMMDString");
        public static final long MDNodeInContext = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMMDNodeInContext");
        public static final long MDNode = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMMDNode");
        public static final long MetadataAsValue = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMMetadataAsValue");
        public static final long ValueAsMetadata = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMValueAsMetadata");
        public static final long GetMDString = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetMDString");
        public static final long GetMDNodeNumOperands = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetMDNodeNumOperands");
        public static final long GetMDNodeOperands = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetMDNodeOperands");
        public static final long BasicBlockAsValue = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBasicBlockAsValue");
        public static final long ValueIsBasicBlock = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMValueIsBasicBlock");
        public static final long ValueAsBasicBlock = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMValueAsBasicBlock");
        public static final long GetBasicBlockName = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetBasicBlockName");
        public static final long GetBasicBlockParent = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetBasicBlockParent");
        public static final long GetBasicBlockTerminator = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetBasicBlockTerminator");
        public static final long CountBasicBlocks = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMCountBasicBlocks");
        public static final long GetBasicBlocks = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetBasicBlocks");
        public static final long GetFirstBasicBlock = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetFirstBasicBlock");
        public static final long GetLastBasicBlock = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetLastBasicBlock");
        public static final long GetNextBasicBlock = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetNextBasicBlock");
        public static final long GetPreviousBasicBlock = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetPreviousBasicBlock");
        public static final long GetEntryBasicBlock = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetEntryBasicBlock");
        public static final long InsertExistingBasicBlockAfterInsertBlock = LLVMCore.access$000().getFunctionAddress("LLVMInsertExistingBasicBlockAfterInsertBlock");
        public static final long AppendExistingBasicBlock = LLVMCore.access$000().getFunctionAddress("LLVMAppendExistingBasicBlock");
        public static final long CreateBasicBlockInContext = LLVMCore.access$000().getFunctionAddress("LLVMCreateBasicBlockInContext");
        public static final long AppendBasicBlockInContext = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMAppendBasicBlockInContext");
        public static final long AppendBasicBlock = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMAppendBasicBlock");
        public static final long InsertBasicBlockInContext = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMInsertBasicBlockInContext");
        public static final long InsertBasicBlock = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMInsertBasicBlock");
        public static final long DeleteBasicBlock = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMDeleteBasicBlock");
        public static final long RemoveBasicBlockFromParent = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMRemoveBasicBlockFromParent");
        public static final long MoveBasicBlockBefore = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMMoveBasicBlockBefore");
        public static final long MoveBasicBlockAfter = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMMoveBasicBlockAfter");
        public static final long GetFirstInstruction = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetFirstInstruction");
        public static final long GetLastInstruction = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetLastInstruction");
        public static final long HasMetadata = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMHasMetadata");
        public static final long GetMetadata = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetMetadata");
        public static final long SetMetadata = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMSetMetadata");
        public static final long InstructionGetAllMetadataOtherThanDebugLoc = LLVMCore.access$000().getFunctionAddress("LLVMInstructionGetAllMetadataOtherThanDebugLoc");
        public static final long GetInstructionParent = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetInstructionParent");
        public static final long GetNextInstruction = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetNextInstruction");
        public static final long GetPreviousInstruction = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetPreviousInstruction");
        public static final long InstructionRemoveFromParent = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMInstructionRemoveFromParent");
        public static final long InstructionEraseFromParent = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMInstructionEraseFromParent");
        public static final long GetInstructionOpcode = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetInstructionOpcode");
        public static final long GetICmpPredicate = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetICmpPredicate");
        public static final long GetFCmpPredicate = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetFCmpPredicate");
        public static final long InstructionClone = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMInstructionClone");
        public static final long IsATerminatorInst = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsATerminatorInst");
        public static final long GetNumArgOperands = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetNumArgOperands");
        public static final long SetInstructionCallConv = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMSetInstructionCallConv");
        public static final long GetInstructionCallConv = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetInstructionCallConv");
        public static final long SetInstrParamAlignment = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMSetInstrParamAlignment");
        public static final long AddCallSiteAttribute = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMAddCallSiteAttribute");
        public static final long GetCallSiteAttributeCount = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetCallSiteAttributeCount");
        public static final long GetCallSiteAttributes = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetCallSiteAttributes");
        public static final long GetCallSiteEnumAttribute = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetCallSiteEnumAttribute");
        public static final long GetCallSiteStringAttribute = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetCallSiteStringAttribute");
        public static final long RemoveCallSiteEnumAttribute = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMRemoveCallSiteEnumAttribute");
        public static final long RemoveCallSiteStringAttribute = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMRemoveCallSiteStringAttribute");
        public static final long GetCalledFunctionType = LLVMCore.access$000().getFunctionAddress("LLVMGetCalledFunctionType");
        public static final long GetCalledValue = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetCalledValue");
        public static final long IsTailCall = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsTailCall");
        public static final long SetTailCall = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMSetTailCall");
        public static final long GetNormalDest = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetNormalDest");
        public static final long GetUnwindDest = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetUnwindDest");
        public static final long SetNormalDest = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMSetNormalDest");
        public static final long SetUnwindDest = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMSetUnwindDest");
        public static final long GetNumSuccessors = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetNumSuccessors");
        public static final long GetSuccessor = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetSuccessor");
        public static final long SetSuccessor = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMSetSuccessor");
        public static final long IsConditional = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsConditional");
        public static final long GetCondition = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetCondition");
        public static final long SetCondition = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMSetCondition");
        public static final long GetSwitchDefaultDest = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetSwitchDefaultDest");
        public static final long GetAllocatedType = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetAllocatedType");
        public static final long IsInBounds = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsInBounds");
        public static final long SetIsInBounds = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMSetIsInBounds");
        public static final long AddIncoming = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMAddIncoming");
        public static final long CountIncoming = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMCountIncoming");
        public static final long GetIncomingValue = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetIncomingValue");
        public static final long GetIncomingBlock = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetIncomingBlock");
        public static final long GetNumIndices = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetNumIndices");
        public static final long GetIndices = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetIndices");
        public static final long CreateBuilderInContext = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMCreateBuilderInContext");
        public static final long CreateBuilder = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMCreateBuilder");
        public static final long PositionBuilder = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMPositionBuilder");
        public static final long PositionBuilderBefore = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMPositionBuilderBefore");
        public static final long PositionBuilderAtEnd = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMPositionBuilderAtEnd");
        public static final long GetInsertBlock = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetInsertBlock");
        public static final long ClearInsertionPosition = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMClearInsertionPosition");
        public static final long InsertIntoBuilder = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMInsertIntoBuilder");
        public static final long InsertIntoBuilderWithName = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMInsertIntoBuilderWithName");
        public static final long DisposeBuilder = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMDisposeBuilder");
        public static final long GetCurrentDebugLocation2 = LLVMCore.access$000().getFunctionAddress("LLVMGetCurrentDebugLocation2");
        public static final long SetCurrentDebugLocation2 = LLVMCore.access$000().getFunctionAddress("LLVMSetCurrentDebugLocation2");
        public static final long SetInstDebugLocation = LLVMCore.access$000().getFunctionAddress("LLVMSetInstDebugLocation");
        public static final long BuilderGetDefaultFPMathTag = LLVMCore.access$000().getFunctionAddress("LLVMBuilderGetDefaultFPMathTag");
        public static final long BuilderSetDefaultFPMathTag = LLVMCore.access$000().getFunctionAddress("LLVMBuilderSetDefaultFPMathTag");
        public static final long SetCurrentDebugLocation = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMSetCurrentDebugLocation");
        public static final long GetCurrentDebugLocation = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetCurrentDebugLocation");
        public static final long BuildRetVoid = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildRetVoid");
        public static final long BuildRet = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildRet");
        public static final long BuildAggregateRet = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildAggregateRet");
        public static final long BuildBr = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildBr");
        public static final long BuildCondBr = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildCondBr");
        public static final long BuildSwitch = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildSwitch");
        public static final long BuildIndirectBr = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildIndirectBr");
        public static final long BuildInvoke = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildInvoke");
        public static final long BuildInvoke2 = LLVMCore.access$000().getFunctionAddress("LLVMBuildInvoke2");
        public static final long BuildUnreachable = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildUnreachable");
        public static final long BuildResume = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildResume");
        public static final long BuildLandingPad = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildLandingPad");
        public static final long BuildCleanupRet = LLVMCore.access$000().getFunctionAddress("LLVMBuildCleanupRet");
        public static final long BuildCatchRet = LLVMCore.access$000().getFunctionAddress("LLVMBuildCatchRet");
        public static final long BuildCatchPad = LLVMCore.access$000().getFunctionAddress("LLVMBuildCatchPad");
        public static final long BuildCleanupPad = LLVMCore.access$000().getFunctionAddress("LLVMBuildCleanupPad");
        public static final long BuildCatchSwitch = LLVMCore.access$000().getFunctionAddress("LLVMBuildCatchSwitch");
        public static final long AddCase = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMAddCase");
        public static final long AddDestination = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMAddDestination");
        public static final long GetNumClauses = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetNumClauses");
        public static final long GetClause = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetClause");
        public static final long AddClause = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMAddClause");
        public static final long IsCleanup = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsCleanup");
        public static final long SetCleanup = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMSetCleanup");
        public static final long AddHandler = LLVMCore.access$000().getFunctionAddress("LLVMAddHandler");
        public static final long GetNumHandlers = LLVMCore.access$000().getFunctionAddress("LLVMGetNumHandlers");
        public static final long GetHandlers = LLVMCore.access$000().getFunctionAddress("LLVMGetHandlers");
        public static final long GetArgOperand = LLVMCore.access$000().getFunctionAddress("LLVMGetArgOperand");
        public static final long SetArgOperand = LLVMCore.access$000().getFunctionAddress("LLVMSetArgOperand");
        public static final long GetParentCatchSwitch = LLVMCore.access$000().getFunctionAddress("LLVMGetParentCatchSwitch");
        public static final long SetParentCatchSwitch = LLVMCore.access$000().getFunctionAddress("LLVMSetParentCatchSwitch");
        public static final long BuildAdd = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildAdd");
        public static final long BuildNSWAdd = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildNSWAdd");
        public static final long BuildNUWAdd = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildNUWAdd");
        public static final long BuildFAdd = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildFAdd");
        public static final long BuildSub = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildSub");
        public static final long BuildNSWSub = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildNSWSub");
        public static final long BuildNUWSub = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildNUWSub");
        public static final long BuildFSub = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildFSub");
        public static final long BuildMul = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildMul");
        public static final long BuildNSWMul = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildNSWMul");
        public static final long BuildNUWMul = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildNUWMul");
        public static final long BuildFMul = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildFMul");
        public static final long BuildUDiv = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildUDiv");
        public static final long BuildExactUDiv = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildExactUDiv");
        public static final long BuildSDiv = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildSDiv");
        public static final long BuildExactSDiv = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildExactSDiv");
        public static final long BuildFDiv = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildFDiv");
        public static final long BuildURem = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildURem");
        public static final long BuildSRem = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildSRem");
        public static final long BuildFRem = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildFRem");
        public static final long BuildShl = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildShl");
        public static final long BuildLShr = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildLShr");
        public static final long BuildAShr = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildAShr");
        public static final long BuildAnd = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildAnd");
        public static final long BuildOr = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildOr");
        public static final long BuildXor = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildXor");
        public static final long BuildBinOp = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildBinOp");
        public static final long BuildNeg = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildNeg");
        public static final long BuildNSWNeg = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildNSWNeg");
        public static final long BuildNUWNeg = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildNUWNeg");
        public static final long BuildFNeg = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildFNeg");
        public static final long BuildNot = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildNot");
        public static final long BuildMalloc = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildMalloc");
        public static final long BuildArrayMalloc = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildArrayMalloc");
        public static final long BuildMemSet = LLVMCore.access$000().getFunctionAddress("LLVMBuildMemSet");
        public static final long BuildMemCpy = LLVMCore.access$000().getFunctionAddress("LLVMBuildMemCpy");
        public static final long BuildMemMove = LLVMCore.access$000().getFunctionAddress("LLVMBuildMemMove");
        public static final long BuildAlloca = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildAlloca");
        public static final long BuildArrayAlloca = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildArrayAlloca");
        public static final long BuildFree = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildFree");
        public static final long BuildLoad = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildLoad");
        public static final long BuildLoad2 = LLVMCore.access$000().getFunctionAddress("LLVMBuildLoad2");
        public static final long BuildStore = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildStore");
        public static final long BuildGEP = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildGEP");
        public static final long BuildInBoundsGEP = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildInBoundsGEP");
        public static final long BuildStructGEP = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildStructGEP");
        public static final long BuildGEP2 = LLVMCore.access$000().getFunctionAddress("LLVMBuildGEP2");
        public static final long BuildInBoundsGEP2 = LLVMCore.access$000().getFunctionAddress("LLVMBuildInBoundsGEP2");
        public static final long BuildStructGEP2 = LLVMCore.access$000().getFunctionAddress("LLVMBuildStructGEP2");
        public static final long BuildGlobalString = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildGlobalString");
        public static final long BuildGlobalStringPtr = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildGlobalStringPtr");
        public static final long GetVolatile = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetVolatile");
        public static final long SetVolatile = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMSetVolatile");
        public static final long GetWeak = LLVMCore.access$000().getFunctionAddress("LLVMGetWeak");
        public static final long SetWeak = LLVMCore.access$000().getFunctionAddress("LLVMSetWeak");
        public static final long GetOrdering = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetOrdering");
        public static final long SetOrdering = LLVMCore.access$000().getFunctionAddress("LLVMSetOrdering");
        public static final long GetAtomicRMWBinOp = LLVMCore.access$000().getFunctionAddress("LLVMGetAtomicRMWBinOp");
        public static final long SetAtomicRMWBinOp = LLVMCore.access$000().getFunctionAddress("LLVMSetAtomicRMWBinOp");
        public static final long BuildTrunc = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildTrunc");
        public static final long BuildZExt = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildZExt");
        public static final long BuildSExt = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildSExt");
        public static final long BuildFPToUI = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildFPToUI");
        public static final long BuildFPToSI = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildFPToSI");
        public static final long BuildUIToFP = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildUIToFP");
        public static final long BuildSIToFP = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildSIToFP");
        public static final long BuildFPTrunc = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildFPTrunc");
        public static final long BuildFPExt = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildFPExt");
        public static final long BuildPtrToInt = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildPtrToInt");
        public static final long BuildIntToPtr = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildIntToPtr");
        public static final long BuildBitCast = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildBitCast");
        public static final long BuildAddrSpaceCast = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildAddrSpaceCast");
        public static final long BuildZExtOrBitCast = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildZExtOrBitCast");
        public static final long BuildSExtOrBitCast = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildSExtOrBitCast");
        public static final long BuildTruncOrBitCast = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildTruncOrBitCast");
        public static final long BuildCast = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildCast");
        public static final long BuildPointerCast = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildPointerCast");
        public static final long BuildPointerCast2 = LLVMCore.access$000().getFunctionAddress("LLVMBuildPointerCast2");
        public static final long BuildIntCast = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildIntCast");
        public static final long BuildFPCast = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildFPCast");
        public static final long BuildICmp = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildICmp");
        public static final long BuildFCmp = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildFCmp");
        public static final long BuildPhi = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildPhi");
        public static final long BuildCall = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildCall");
        public static final long BuildCall2 = LLVMCore.access$000().getFunctionAddress("LLVMBuildCall2");
        public static final long BuildSelect = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildSelect");
        public static final long BuildVAArg = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildVAArg");
        public static final long BuildExtractElement = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildExtractElement");
        public static final long BuildInsertElement = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildInsertElement");
        public static final long BuildShuffleVector = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildShuffleVector");
        public static final long BuildExtractValue = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildExtractValue");
        public static final long BuildInsertValue = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildInsertValue");
        public static final long BuildFreeze = LLVMCore.access$000().getFunctionAddress("LLVMBuildFreeze");
        public static final long BuildIsNull = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildIsNull");
        public static final long BuildIsNotNull = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildIsNotNull");
        public static final long BuildPtrDiff = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildPtrDiff");
        public static final long BuildFence = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildFence");
        public static final long BuildAtomicRMW = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildAtomicRMW");
        public static final long BuildAtomicCmpXchg = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMBuildAtomicCmpXchg");
        public static final long GetNumMaskElements = LLVMCore.access$000().getFunctionAddress("LLVMGetNumMaskElements");
        public static final long GetUndefMaskElem = LLVMCore.access$000().getFunctionAddress("LLVMGetUndefMaskElem");
        public static final long GetMaskValue = LLVMCore.access$000().getFunctionAddress("LLVMGetMaskValue");
        public static final long IsAtomicSingleThread = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsAtomicSingleThread");
        public static final long SetAtomicSingleThread = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMSetAtomicSingleThread");
        public static final long GetCmpXchgSuccessOrdering = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetCmpXchgSuccessOrdering");
        public static final long SetCmpXchgSuccessOrdering = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMSetCmpXchgSuccessOrdering");
        public static final long GetCmpXchgFailureOrdering = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetCmpXchgFailureOrdering");
        public static final long SetCmpXchgFailureOrdering = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMSetCmpXchgFailureOrdering");
        public static final long CreateModuleProviderForExistingModule = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMCreateModuleProviderForExistingModule");
        public static final long DisposeModuleProvider = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMDisposeModuleProvider");
        public static final long CreateMemoryBufferWithContentsOfFile = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMCreateMemoryBufferWithContentsOfFile");
        public static final long CreateMemoryBufferWithSTDIN = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMCreateMemoryBufferWithSTDIN");
        public static final long CreateMemoryBufferWithMemoryRange = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMCreateMemoryBufferWithMemoryRange");
        public static final long CreateMemoryBufferWithMemoryRangeCopy = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMCreateMemoryBufferWithMemoryRangeCopy");
        public static final long GetBufferStart = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetBufferStart");
        public static final long GetBufferSize = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetBufferSize");
        public static final long DisposeMemoryBuffer = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMDisposeMemoryBuffer");
        public static final long GetGlobalPassRegistry = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMGetGlobalPassRegistry");
        public static final long CreatePassManager = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMCreatePassManager");
        public static final long CreateFunctionPassManagerForModule = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMCreateFunctionPassManagerForModule");
        public static final long CreateFunctionPassManager = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMCreateFunctionPassManager");
        public static final long RunPassManager = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMRunPassManager");
        public static final long InitializeFunctionPassManager = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMInitializeFunctionPassManager");
        public static final long RunFunctionPassManager = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMRunFunctionPassManager");
        public static final long FinalizeFunctionPassManager = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMFinalizeFunctionPassManager");
        public static final long DisposePassManager = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMDisposePassManager");
        public static final long StartMultithreaded = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMStartMultithreaded");
        public static final long StopMultithreaded = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMStopMultithreaded");
        public static final long IsMultithreaded = APIUtil.apiGetFunctionAddress(LLVMCore.access$000(), "LLVMIsMultithreaded");

        private Functions() {
        }
    }
}

