/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import org.lwjgl.llvm.LLVMCore;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class LLVMBitWriter {
    protected LLVMBitWriter() {
        throw new UnsupportedOperationException();
    }

    public static int nLLVMWriteBitcodeToFile(long M, long Path2) {
        long __functionAddress = Functions.WriteBitcodeToFile;
        if (Checks.CHECKS) {
            Checks.check(M);
        }
        return JNI.invokePPI(M, Path2, __functionAddress);
    }

    public static int LLVMWriteBitcodeToFile(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") ByteBuffer Path2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(Path2);
        }
        return LLVMBitWriter.nLLVMWriteBitcodeToFile(M, MemoryUtil.memAddress(Path2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int LLVMWriteBitcodeToFile(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="char const *") CharSequence Path2) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Path2, true);
            long PathEncoded = stack.getPointerAddress();
            int n = LLVMBitWriter.nLLVMWriteBitcodeToFile(M, PathEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int LLVMWriteBitcodeToFD(@NativeType(value="LLVMModuleRef") long M, int FD, int ShouldClose, int Unbuffered) {
        long __functionAddress = Functions.WriteBitcodeToFD;
        if (Checks.CHECKS) {
            Checks.check(M);
        }
        return JNI.invokePI(M, FD, ShouldClose, Unbuffered, __functionAddress);
    }

    public static int LLVMWriteBitcodeToFileHandle(@NativeType(value="LLVMModuleRef") long M, int Handle) {
        long __functionAddress = Functions.WriteBitcodeToFileHandle;
        if (Checks.CHECKS) {
            Checks.check(M);
        }
        return JNI.invokePI(M, Handle, __functionAddress);
    }

    @NativeType(value="LLVMMemoryBufferRef")
    public static long LLVMWriteBitcodeToMemoryBuffer(@NativeType(value="LLVMModuleRef") long M) {
        long __functionAddress = Functions.WriteBitcodeToMemoryBuffer;
        if (Checks.CHECKS) {
            Checks.check(M);
        }
        return JNI.invokePP(M, __functionAddress);
    }

    public static final class Functions {
        public static final long WriteBitcodeToFile = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMWriteBitcodeToFile");
        public static final long WriteBitcodeToFD = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMWriteBitcodeToFD");
        public static final long WriteBitcodeToFileHandle = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMWriteBitcodeToFileHandle");
        public static final long WriteBitcodeToMemoryBuffer = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMWriteBitcodeToMemoryBuffer");

        private Functions() {
        }
    }
}

