/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import org.lwjgl.PointerBuffer;
import org.lwjgl.llvm.LLVMCore;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class LLVMBitReader {
    protected LLVMBitReader() {
        throw new UnsupportedOperationException();
    }

    public static int nLLVMParseBitcode(long MemBuf, long OutModule, long OutMessage) {
        long __functionAddress = Functions.ParseBitcode;
        if (Checks.CHECKS) {
            Checks.check(MemBuf);
        }
        return JNI.invokePPPI(MemBuf, OutModule, OutMessage, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMParseBitcode(@NativeType(value="LLVMMemoryBufferRef") long MemBuf, @NativeType(value="LLVMModuleRef *") PointerBuffer OutModule, @NativeType(value="char **") PointerBuffer OutMessage) {
        if (Checks.CHECKS) {
            Checks.check(OutModule, 1);
            Checks.check(OutMessage, 1);
        }
        return LLVMBitReader.nLLVMParseBitcode(MemBuf, MemoryUtil.memAddress(OutModule), MemoryUtil.memAddress(OutMessage)) != 0;
    }

    public static int nLLVMParseBitcode2(long MemBuf, long OutModule) {
        long __functionAddress = Functions.ParseBitcode2;
        if (Checks.CHECKS) {
            Checks.check(MemBuf);
        }
        return JNI.invokePPI(MemBuf, OutModule, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMParseBitcode2(@NativeType(value="LLVMMemoryBufferRef") long MemBuf, @NativeType(value="LLVMModuleRef *") PointerBuffer OutModule) {
        if (Checks.CHECKS) {
            Checks.check(OutModule, 1);
        }
        return LLVMBitReader.nLLVMParseBitcode2(MemBuf, MemoryUtil.memAddress(OutModule)) != 0;
    }

    public static int nLLVMParseBitcodeInContext(long ContextRef, long MemBuf, long OutModule, long OutMessage) {
        long __functionAddress = Functions.ParseBitcodeInContext;
        if (Checks.CHECKS) {
            Checks.check(ContextRef);
            Checks.check(MemBuf);
        }
        return JNI.invokePPPPI(ContextRef, MemBuf, OutModule, OutMessage, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMParseBitcodeInContext(@NativeType(value="LLVMContextRef") long ContextRef, @NativeType(value="LLVMMemoryBufferRef") long MemBuf, @NativeType(value="LLVMModuleRef *") PointerBuffer OutModule, @NativeType(value="char **") PointerBuffer OutMessage) {
        if (Checks.CHECKS) {
            Checks.check(OutModule, 1);
            Checks.check(OutMessage, 1);
        }
        return LLVMBitReader.nLLVMParseBitcodeInContext(ContextRef, MemBuf, MemoryUtil.memAddress(OutModule), MemoryUtil.memAddress(OutMessage)) != 0;
    }

    public static int nLLVMParseBitcodeInContext2(long ContextRef, long MemBuf, long OutModule) {
        long __functionAddress = Functions.ParseBitcodeInContext2;
        if (Checks.CHECKS) {
            Checks.check(ContextRef);
            Checks.check(MemBuf);
        }
        return JNI.invokePPPI(ContextRef, MemBuf, OutModule, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMParseBitcodeInContext2(@NativeType(value="LLVMContextRef") long ContextRef, @NativeType(value="LLVMMemoryBufferRef") long MemBuf, @NativeType(value="LLVMModuleRef *") PointerBuffer OutModule) {
        if (Checks.CHECKS) {
            Checks.check(OutModule, 1);
        }
        return LLVMBitReader.nLLVMParseBitcodeInContext2(ContextRef, MemBuf, MemoryUtil.memAddress(OutModule)) != 0;
    }

    public static int nLLVMGetBitcodeModuleInContext(long ContextRef, long MemBuf, long OutM, long OutMessage) {
        long __functionAddress = Functions.GetBitcodeModuleInContext;
        if (Checks.CHECKS) {
            Checks.check(ContextRef);
            Checks.check(MemBuf);
        }
        return JNI.invokePPPPI(ContextRef, MemBuf, OutM, OutMessage, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMGetBitcodeModuleInContext(@NativeType(value="LLVMContextRef") long ContextRef, @NativeType(value="LLVMMemoryBufferRef") long MemBuf, @NativeType(value="LLVMModuleRef *") PointerBuffer OutM, @NativeType(value="char **") PointerBuffer OutMessage) {
        if (Checks.CHECKS) {
            Checks.check(OutM, 1);
            Checks.check(OutMessage, 1);
        }
        return LLVMBitReader.nLLVMGetBitcodeModuleInContext(ContextRef, MemBuf, MemoryUtil.memAddress(OutM), MemoryUtil.memAddress(OutMessage)) != 0;
    }

    public static int nLLVMGetBitcodeModuleInContext2(long ContextRef, long MemBuf, long OutM) {
        long __functionAddress = Functions.GetBitcodeModuleInContext2;
        if (Checks.CHECKS) {
            Checks.check(ContextRef);
            Checks.check(MemBuf);
        }
        return JNI.invokePPPI(ContextRef, MemBuf, OutM, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMGetBitcodeModuleInContext2(@NativeType(value="LLVMContextRef") long ContextRef, @NativeType(value="LLVMMemoryBufferRef") long MemBuf, @NativeType(value="LLVMModuleRef *") PointerBuffer OutM) {
        if (Checks.CHECKS) {
            Checks.check(OutM, 1);
        }
        return LLVMBitReader.nLLVMGetBitcodeModuleInContext2(ContextRef, MemBuf, MemoryUtil.memAddress(OutM)) != 0;
    }

    public static int nLLVMGetBitcodeModule(long MemBuf, long OutM, long OutMessage) {
        long __functionAddress = Functions.GetBitcodeModule;
        if (Checks.CHECKS) {
            Checks.check(MemBuf);
        }
        return JNI.invokePPPI(MemBuf, OutM, OutMessage, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMGetBitcodeModule(@NativeType(value="LLVMMemoryBufferRef") long MemBuf, @NativeType(value="LLVMModuleRef *") PointerBuffer OutM, @NativeType(value="char **") PointerBuffer OutMessage) {
        if (Checks.CHECKS) {
            Checks.check(OutM, 1);
            Checks.check(OutMessage, 1);
        }
        return LLVMBitReader.nLLVMGetBitcodeModule(MemBuf, MemoryUtil.memAddress(OutM), MemoryUtil.memAddress(OutMessage)) != 0;
    }

    public static int nLLVMGetBitcodeModule2(long MemBuf, long OutM) {
        long __functionAddress = Functions.GetBitcodeModule2;
        if (Checks.CHECKS) {
            Checks.check(MemBuf);
        }
        return JNI.invokePPI(MemBuf, OutM, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMGetBitcodeModule2(@NativeType(value="LLVMMemoryBufferRef") long MemBuf, @NativeType(value="LLVMModuleRef *") PointerBuffer OutM) {
        if (Checks.CHECKS) {
            Checks.check(OutM, 1);
        }
        return LLVMBitReader.nLLVMGetBitcodeModule2(MemBuf, MemoryUtil.memAddress(OutM)) != 0;
    }

    public static final class Functions {
        public static final long ParseBitcode = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMParseBitcode");
        public static final long ParseBitcode2 = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMParseBitcode2");
        public static final long ParseBitcodeInContext = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMParseBitcodeInContext");
        public static final long ParseBitcodeInContext2 = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMParseBitcodeInContext2");
        public static final long GetBitcodeModuleInContext = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMGetBitcodeModuleInContext");
        public static final long GetBitcodeModuleInContext2 = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMGetBitcodeModuleInContext2");
        public static final long GetBitcodeModule = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMGetBitcodeModule");
        public static final long GetBitcodeModule2 = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMGetBitcodeModule2");

        private Functions() {
        }
    }
}

