/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import org.lwjgl.PointerBuffer;
import org.lwjgl.llvm.LLVMCore;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class LLVMAnalysis {
    public static final int LLVMAbortProcessAction = 0;
    public static final int LLVMPrintMessageAction = 1;
    public static final int LLVMReturnStatusAction = 2;

    protected LLVMAnalysis() {
        throw new UnsupportedOperationException();
    }

    public static int nLLVMVerifyModule(long M, int Action, long OutMessage) {
        long __functionAddress = Functions.VerifyModule;
        if (Checks.CHECKS) {
            Checks.check(M);
        }
        return JNI.invokePPI(M, Action, OutMessage, __functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMVerifyModule(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="LLVMVerifierFailureAction") int Action, @NativeType(value="char **") PointerBuffer OutMessage) {
        if (Checks.CHECKS) {
            Checks.check(OutMessage, 1);
        }
        return LLVMAnalysis.nLLVMVerifyModule(M, Action, MemoryUtil.memAddress(OutMessage)) != 0;
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMVerifyFunction(@NativeType(value="LLVMValueRef") long Fn, @NativeType(value="LLVMVerifierFailureAction") int Action) {
        long __functionAddress = Functions.VerifyFunction;
        if (Checks.CHECKS) {
            Checks.check(Fn);
        }
        return JNI.invokePI(Fn, Action, __functionAddress) != 0;
    }

    public static void LLVMViewFunctionCFG(@NativeType(value="LLVMValueRef") long Fn) {
        long __functionAddress = Functions.ViewFunctionCFG;
        if (Checks.CHECKS) {
            Checks.check(Fn);
        }
        JNI.invokePV(Fn, __functionAddress);
    }

    public static void LLVMViewFunctionCFGOnly(@NativeType(value="LLVMValueRef") long Fn) {
        long __functionAddress = Functions.ViewFunctionCFGOnly;
        if (Checks.CHECKS) {
            Checks.check(Fn);
        }
        JNI.invokePV(Fn, __functionAddress);
    }

    public static final class Functions {
        public static final long VerifyModule = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMVerifyModule");
        public static final long VerifyFunction = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMVerifyFunction");
        public static final long ViewFunctionCFG = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMViewFunctionCFG");
        public static final long ViewFunctionCFGOnly = APIUtil.apiGetFunctionAddress(LLVMCore.getLibrary(), "LLVMViewFunctionCFGOnly");

        private Functions() {
        }
    }
}

