/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXVersion
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MAJOR;
    public static final int MINOR;
    public static final int SUBMINOR;

    public CXVersion(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CXVersion.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int Major() {
        return CXVersion.nMajor(this.address());
    }

    public int Minor() {
        return CXVersion.nMinor(this.address());
    }

    public int Subminor() {
        return CXVersion.nSubminor(this.address());
    }

    public static CXVersion create(long address) {
        return CXVersion.wrap(CXVersion.class, address);
    }

    @Nullable
    public static CXVersion createSafe(long address) {
        return address == 0L ? null : CXVersion.wrap(CXVersion.class, address);
    }

    public static Buffer create(long address, int capacity) {
        return CXVersion.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : CXVersion.wrap(Buffer.class, address, capacity);
    }

    public static int nMajor(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAJOR);
    }

    public static int nMinor(long struct) {
        return UNSAFE.getInt(null, struct + (long)MINOR);
    }

    public static int nSubminor(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUBMINOR);
    }

    static {
        Struct.Layout layout = CXVersion.__struct(CXVersion.__member(4), CXVersion.__member(4), CXVersion.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MAJOR = layout.offsetof(0);
        MINOR = layout.offsetof(1);
        SUBMINOR = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<CXVersion, Buffer> {
        private static final CXVersion ELEMENT_FACTORY = CXVersion.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected CXVersion getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public int Major() {
            return CXVersion.nMajor(this.address());
        }

        public int Minor() {
            return CXVersion.nMinor(this.address());
        }

        public int Subminor() {
            return CXVersion.nSubminor(this.address());
        }
    }
}

