/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXType
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int KIND;
    public static final int DATA;

    public CXType(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CXType.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="enum CXTypeKind")
    public int kind() {
        return CXType.nkind(this.address());
    }

    @NativeType(value="void *[2]")
    public PointerBuffer data() {
        return CXType.ndata(this.address());
    }

    @NativeType(value="void *")
    public long data(int index) {
        return CXType.ndata(this.address(), index);
    }

    public static CXType malloc() {
        return CXType.wrap(CXType.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static CXType calloc() {
        return CXType.wrap(CXType.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static CXType create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return CXType.wrap(CXType.class, MemoryUtil.memAddress(container), container);
    }

    public static CXType create(long address) {
        return CXType.wrap(CXType.class, address);
    }

    @Nullable
    public static CXType createSafe(long address) {
        return address == 0L ? null : CXType.wrap(CXType.class, address);
    }

    public static Buffer malloc(int capacity) {
        return CXType.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(CXType.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return CXType.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CXType.__create(capacity, SIZEOF);
        return CXType.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return CXType.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : CXType.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static CXType mallocStack() {
        return CXType.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXType callocStack() {
        return CXType.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXType mallocStack(MemoryStack stack) {
        return CXType.malloc(stack);
    }

    @Deprecated
    public static CXType callocStack(MemoryStack stack) {
        return CXType.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CXType.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CXType.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CXType.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CXType.calloc(capacity, stack);
    }

    public static CXType malloc(MemoryStack stack) {
        return CXType.wrap(CXType.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CXType calloc(MemoryStack stack) {
        return CXType.wrap(CXType.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return CXType.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return CXType.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nkind(long struct) {
        return UNSAFE.getInt(null, struct + (long)KIND);
    }

    public static PointerBuffer ndata(long struct) {
        return MemoryUtil.memPointerBuffer(struct + (long)DATA, 2);
    }

    public static long ndata(long struct, int index) {
        return MemoryUtil.memGetAddress(struct + (long)DATA + Checks.check(index, 2) * (long)POINTER_SIZE);
    }

    static {
        Struct.Layout layout = CXType.__struct(CXType.__member(4), CXType.__array(POINTER_SIZE, 2));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        KIND = layout.offsetof(0);
        DATA = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CXType, Buffer>
    implements NativeResource {
        private static final CXType ELEMENT_FACTORY = CXType.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected CXType getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="enum CXTypeKind")
        public int kind() {
            return CXType.nkind(this.address());
        }

        @NativeType(value="void *[2]")
        public PointerBuffer data() {
            return CXType.ndata(this.address());
        }

        @NativeType(value="void *")
        public long data(int index) {
            return CXType.ndata(this.address(), index);
        }
    }
}

