/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXToken
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int INT_DATA;
    public static final int PTR_DATA;

    public CXToken(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CXToken.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned[4]")
    public IntBuffer int_data() {
        return CXToken.nint_data(this.address());
    }

    @NativeType(value="unsigned")
    public int int_data(int index) {
        return CXToken.nint_data(this.address(), index);
    }

    @NativeType(value="void *")
    public long ptr_data() {
        return CXToken.nptr_data(this.address());
    }

    public static CXToken create(long address) {
        return CXToken.wrap(CXToken.class, address);
    }

    @Nullable
    public static CXToken createSafe(long address) {
        return address == 0L ? null : CXToken.wrap(CXToken.class, address);
    }

    public static Buffer create(long address, int capacity) {
        return CXToken.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : CXToken.wrap(Buffer.class, address, capacity);
    }

    public static IntBuffer nint_data(long struct) {
        return MemoryUtil.memIntBuffer(struct + (long)INT_DATA, 4);
    }

    public static int nint_data(long struct, int index) {
        return UNSAFE.getInt(null, struct + (long)INT_DATA + Checks.check(index, 4) * 4L);
    }

    public static long nptr_data(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PTR_DATA);
    }

    static {
        Struct.Layout layout = CXToken.__struct(CXToken.__array(4, 4), CXToken.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        INT_DATA = layout.offsetof(0);
        PTR_DATA = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CXToken, Buffer> {
        private static final CXToken ELEMENT_FACTORY = CXToken.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected CXToken getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned[4]")
        public IntBuffer int_data() {
            return CXToken.nint_data(this.address());
        }

        @NativeType(value="unsigned")
        public int int_data(int index) {
            return CXToken.nint_data(this.address(), index);
        }

        @NativeType(value="void *")
        public long ptr_data() {
            return CXToken.nptr_data(this.address());
        }
    }
}

