/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.llvm.CXString;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXStringSet
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STRINGS;
    public static final int COUNT;

    public CXStringSet(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CXStringSet.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="CXString *")
    public CXString.Buffer Strings() {
        return CXStringSet.nStrings(this.address());
    }

    @NativeType(value="unsigned")
    public int Count() {
        return CXStringSet.nCount(this.address());
    }

    public static CXStringSet create(long address) {
        return CXStringSet.wrap(CXStringSet.class, address);
    }

    @Nullable
    public static CXStringSet createSafe(long address) {
        return address == 0L ? null : CXStringSet.wrap(CXStringSet.class, address);
    }

    public static Buffer create(long address, int capacity) {
        return CXStringSet.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : CXStringSet.wrap(Buffer.class, address, capacity);
    }

    public static CXString.Buffer nStrings(long struct) {
        return CXString.create(MemoryUtil.memGetAddress(struct + (long)STRINGS), CXStringSet.nCount(struct));
    }

    public static int nCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)COUNT);
    }

    static {
        Struct.Layout layout = CXStringSet.__struct(CXStringSet.__member(POINTER_SIZE), CXStringSet.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STRINGS = layout.offsetof(0);
        COUNT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CXStringSet, Buffer> {
        private static final CXStringSet ELEMENT_FACTORY = CXStringSet.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected CXStringSet getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="CXString *")
        public CXString.Buffer Strings() {
            return CXStringSet.nStrings(this.address());
        }

        @NativeType(value="unsigned")
        public int Count() {
            return CXStringSet.nCount(this.address());
        }
    }
}

