/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXComment
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ASTNODE;
    public static final int TRANSLATIONUNIT;

    public CXComment(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CXComment.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void const *")
    public long ASTNode() {
        return CXComment.nASTNode(this.address());
    }

    @NativeType(value="CXTranslationUnit")
    public long TranslationUnit() {
        return CXComment.nTranslationUnit(this.address());
    }

    public static CXComment malloc() {
        return CXComment.wrap(CXComment.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static CXComment calloc() {
        return CXComment.wrap(CXComment.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static CXComment create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return CXComment.wrap(CXComment.class, MemoryUtil.memAddress(container), container);
    }

    public static CXComment create(long address) {
        return CXComment.wrap(CXComment.class, address);
    }

    @Nullable
    public static CXComment createSafe(long address) {
        return address == 0L ? null : CXComment.wrap(CXComment.class, address);
    }

    public static Buffer malloc(int capacity) {
        return CXComment.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(CXComment.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return CXComment.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CXComment.__create(capacity, SIZEOF);
        return CXComment.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return CXComment.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : CXComment.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static CXComment mallocStack() {
        return CXComment.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXComment callocStack() {
        return CXComment.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXComment mallocStack(MemoryStack stack) {
        return CXComment.malloc(stack);
    }

    @Deprecated
    public static CXComment callocStack(MemoryStack stack) {
        return CXComment.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CXComment.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CXComment.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CXComment.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CXComment.calloc(capacity, stack);
    }

    public static CXComment malloc(MemoryStack stack) {
        return CXComment.wrap(CXComment.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CXComment calloc(MemoryStack stack) {
        return CXComment.wrap(CXComment.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return CXComment.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return CXComment.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nASTNode(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)ASTNODE);
    }

    public static long nTranslationUnit(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)TRANSLATIONUNIT);
    }

    static {
        Struct.Layout layout = CXComment.__struct(CXComment.__member(POINTER_SIZE), CXComment.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ASTNODE = layout.offsetof(0);
        TRANSLATIONUNIT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CXComment, Buffer>
    implements NativeResource {
        private static final CXComment ELEMENT_FACTORY = CXComment.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected CXComment getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void const *")
        public long ASTNode() {
            return CXComment.nASTNode(this.address());
        }

        @NativeType(value="CXTranslationUnit")
        public long TranslationUnit() {
            return CXComment.nTranslationUnit(this.address());
        }
    }
}

