/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.cuda.CUDA;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.SharedLibrary;

public class NVRTC {
    private static final SharedLibrary NVRTC = CUDA.getToolkitLibrary(NVRTC.class, Configuration.CUDA_NVRTC_LIBRARY_NAME, "nvrtc");
    private static final SharedLibrary NVRTC_BUILTINS = CUDA.getToolkitLibrary(NVRTC.class, Configuration.CUDA_NVRTC_BUILTINS_LIBRARY_NAME, "nvrtc-builtins");
    public static final int NVRTC_SUCCESS = 0;
    public static final int NVRTC_ERROR_OUT_OF_MEMORY = 1;
    public static final int NVRTC_ERROR_PROGRAM_CREATION_FAILURE = 2;
    public static final int NVRTC_ERROR_INVALID_INPUT = 3;
    public static final int NVRTC_ERROR_INVALID_PROGRAM = 4;
    public static final int NVRTC_ERROR_INVALID_OPTION = 5;
    public static final int NVRTC_ERROR_COMPILATION = 6;
    public static final int NVRTC_ERROR_BUILTIN_OPERATION_FAILURE = 7;
    public static final int NVRTC_ERROR_NO_NAME_EXPRESSIONS_AFTER_COMPILATION = 8;
    public static final int NVRTC_ERROR_NO_LOWERED_NAMES_BEFORE_COMPILATION = 9;
    public static final int NVRTC_ERROR_NAME_EXPRESSION_NOT_VALID = 10;
    public static final int NVRTC_ERROR_INTERNAL_ERROR = 11;

    public static SharedLibrary getLibrary() {
        return NVRTC;
    }

    protected NVRTC() {
        throw new UnsupportedOperationException();
    }

    public static long nnvrtcGetErrorString(int result) {
        long __functionAddress = Functions.GetErrorString;
        return JNI.callP(result, __functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String nvrtcGetErrorString(@NativeType(value="nvrtcResult") int result) {
        long __result = org.lwjgl.cuda.NVRTC.nnvrtcGetErrorString(result);
        return MemoryUtil.memASCIISafe(__result);
    }

    public static int nnvrtcVersion(long major, long minor) {
        long __functionAddress = Functions.Version;
        return JNI.callPPI(major, minor, __functionAddress);
    }

    @NativeType(value="nvrtcResult")
    public static int nvrtcVersion(@NativeType(value="int *") IntBuffer major, @NativeType(value="int *") IntBuffer minor) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)major, 1);
            Checks.check((Buffer)minor, 1);
        }
        return org.lwjgl.cuda.NVRTC.nnvrtcVersion(MemoryUtil.memAddress(major), MemoryUtil.memAddress(minor));
    }

    public static int nnvrtcGetNumSupportedArchs(long numArchs) {
        long __functionAddress = Functions.GetNumSupportedArchs;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(numArchs, __functionAddress);
    }

    @NativeType(value="nvrtcResult")
    public static int nvrtcGetNumSupportedArchs(@NativeType(value="int *") IntBuffer numArchs) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)numArchs, 1);
        }
        return org.lwjgl.cuda.NVRTC.nnvrtcGetNumSupportedArchs(MemoryUtil.memAddress(numArchs));
    }

    public static int nnvrtcGetSupportedArchs(long supportedArchs) {
        long __functionAddress = Functions.GetSupportedArchs;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPI(supportedArchs, __functionAddress);
    }

    @NativeType(value="nvrtcResult")
    public static int nvrtcGetSupportedArchs(@NativeType(value="int *") IntBuffer supportedArchs) {
        return org.lwjgl.cuda.NVRTC.nnvrtcGetSupportedArchs(MemoryUtil.memAddress(supportedArchs));
    }

    public static int nnvrtcCreateProgram(long prog, long src, long name, int numHeaders, long headers, long includeNames) {
        long __functionAddress = Functions.CreateProgram;
        return JNI.callPPPPPI(prog, src, name, numHeaders, headers, includeNames, __functionAddress);
    }

    @NativeType(value="nvrtcResult")
    public static int nvrtcCreateProgram(@NativeType(value="nvrtcProgram *") PointerBuffer prog, @NativeType(value="char const *") ByteBuffer src, @Nullable @NativeType(value="char const *") ByteBuffer name, @Nullable @NativeType(value="char const * const *") PointerBuffer headers, @Nullable @NativeType(value="char const * const *") PointerBuffer includeNames) {
        if (Checks.CHECKS) {
            Checks.check(prog, 1);
            Checks.checkNT1(src);
            Checks.checkNT1Safe(name);
            Checks.checkSafe(includeNames, Checks.remainingSafe(headers));
        }
        return org.lwjgl.cuda.NVRTC.nnvrtcCreateProgram(MemoryUtil.memAddress(prog), MemoryUtil.memAddress(src), MemoryUtil.memAddressSafe(name), Checks.remainingSafe(headers), MemoryUtil.memAddressSafe(headers), MemoryUtil.memAddressSafe(includeNames));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="nvrtcResult")
    public static int nvrtcCreateProgram(@NativeType(value="nvrtcProgram *") PointerBuffer prog, @NativeType(value="char const *") CharSequence src, @Nullable @NativeType(value="char const *") CharSequence name, @Nullable @NativeType(value="char const * const *") PointerBuffer headers, @Nullable @NativeType(value="char const * const *") PointerBuffer includeNames) {
        if (Checks.CHECKS) {
            Checks.check(prog, 1);
            Checks.checkSafe(includeNames, Checks.remainingSafe(headers));
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(src, true);
            long srcEncoded = stack.getPointerAddress();
            stack.nUTF8Safe(name, true);
            long nameEncoded = name == null ? 0L : stack.getPointerAddress();
            int n = org.lwjgl.cuda.NVRTC.nnvrtcCreateProgram(MemoryUtil.memAddress(prog), srcEncoded, nameEncoded, Checks.remainingSafe(headers), MemoryUtil.memAddressSafe(headers), MemoryUtil.memAddressSafe(includeNames));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nnvrtcDestroyProgram(long prog) {
        long __functionAddress = Functions.DestroyProgram;
        return JNI.callPI(prog, __functionAddress);
    }

    @NativeType(value="nvrtcResult")
    public static int nvrtcDestroyProgram(@NativeType(value="nvrtcProgram *") PointerBuffer prog) {
        if (Checks.CHECKS) {
            Checks.check(prog, 1);
        }
        return org.lwjgl.cuda.NVRTC.nnvrtcDestroyProgram(MemoryUtil.memAddress(prog));
    }

    public static int nnvrtcCompileProgram(long prog, int numOptions, long options) {
        long __functionAddress = Functions.CompileProgram;
        if (Checks.CHECKS) {
            Checks.check(prog);
        }
        return JNI.callPPI(prog, numOptions, options, __functionAddress);
    }

    @NativeType(value="nvrtcResult")
    public static int nvrtcCompileProgram(@NativeType(value="nvrtcProgram") long prog, @Nullable @NativeType(value="char const * const *") PointerBuffer options) {
        return org.lwjgl.cuda.NVRTC.nnvrtcCompileProgram(prog, Checks.remainingSafe(options), MemoryUtil.memAddressSafe(options));
    }

    public static int nnvrtcGetPTXSize(long prog, long ptxSizeRet) {
        long __functionAddress = Functions.GetPTXSize;
        if (Checks.CHECKS) {
            Checks.check(prog);
        }
        return JNI.callPPI(prog, ptxSizeRet, __functionAddress);
    }

    @NativeType(value="nvrtcResult")
    public static int nvrtcGetPTXSize(@NativeType(value="nvrtcProgram") long prog, @NativeType(value="size_t *") PointerBuffer ptxSizeRet) {
        if (Checks.CHECKS) {
            Checks.check(ptxSizeRet, 1);
        }
        return org.lwjgl.cuda.NVRTC.nnvrtcGetPTXSize(prog, MemoryUtil.memAddress(ptxSizeRet));
    }

    public static int nnvrtcGetPTX(long prog, long ptx) {
        long __functionAddress = Functions.GetPTX;
        if (Checks.CHECKS) {
            Checks.check(prog);
        }
        return JNI.callPPI(prog, ptx, __functionAddress);
    }

    @NativeType(value="nvrtcResult")
    public static int nvrtcGetPTX(@NativeType(value="nvrtcProgram") long prog, @NativeType(value="char *") ByteBuffer ptx) {
        return org.lwjgl.cuda.NVRTC.nnvrtcGetPTX(prog, MemoryUtil.memAddress(ptx));
    }

    public static int nnvrtcGetCUBINSize(long prog, long cubinSizeRet) {
        long __functionAddress = Functions.GetCUBINSize;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(prog);
        }
        return JNI.callPPI(prog, cubinSizeRet, __functionAddress);
    }

    @NativeType(value="nvrtcResult")
    public static int nvrtcGetCUBINSize(@NativeType(value="nvrtcProgram") long prog, @NativeType(value="size_t *") PointerBuffer cubinSizeRet) {
        if (Checks.CHECKS) {
            Checks.check(cubinSizeRet, 1);
        }
        return org.lwjgl.cuda.NVRTC.nnvrtcGetCUBINSize(prog, MemoryUtil.memAddress(cubinSizeRet));
    }

    public static int nnvrtcGetCUBIN(long prog, long cubin) {
        long __functionAddress = Functions.GetCUBIN;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(prog);
        }
        return JNI.callPPI(prog, cubin, __functionAddress);
    }

    @NativeType(value="nvrtcResult")
    public static int nvrtcGetCUBIN(@NativeType(value="nvrtcProgram") long prog, @NativeType(value="char *") ByteBuffer cubin) {
        return org.lwjgl.cuda.NVRTC.nnvrtcGetCUBIN(prog, MemoryUtil.memAddress(cubin));
    }

    public static int nnvrtcGetNVVMSize(long prog, long nvvmSizeRet) {
        long __functionAddress = Functions.GetNVVMSize;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(prog);
        }
        return JNI.callPPI(prog, nvvmSizeRet, __functionAddress);
    }

    @NativeType(value="nvrtcResult")
    public static int nvrtcGetNVVMSize(@NativeType(value="nvrtcProgram") long prog, @NativeType(value="size_t *") PointerBuffer nvvmSizeRet) {
        if (Checks.CHECKS) {
            Checks.check(nvvmSizeRet, 1);
        }
        return org.lwjgl.cuda.NVRTC.nnvrtcGetNVVMSize(prog, MemoryUtil.memAddress(nvvmSizeRet));
    }

    public static int nnvrtcGetNVVM(long prog, long nvvm) {
        long __functionAddress = Functions.GetNVVM;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(prog);
        }
        return JNI.callPPI(prog, nvvm, __functionAddress);
    }

    @NativeType(value="nvrtcResult")
    public static int nvrtcGetNVVM(@NativeType(value="nvrtcProgram") long prog, @NativeType(value="char *") ByteBuffer nvvm) {
        return org.lwjgl.cuda.NVRTC.nnvrtcGetNVVM(prog, MemoryUtil.memAddress(nvvm));
    }

    public static int nnvrtcGetProgramLogSize(long prog, long logSizeRet) {
        long __functionAddress = Functions.GetProgramLogSize;
        if (Checks.CHECKS) {
            Checks.check(prog);
        }
        return JNI.callPPI(prog, logSizeRet, __functionAddress);
    }

    @NativeType(value="nvrtcResult")
    public static int nvrtcGetProgramLogSize(@NativeType(value="nvrtcProgram") long prog, @NativeType(value="size_t *") PointerBuffer logSizeRet) {
        if (Checks.CHECKS) {
            Checks.check(logSizeRet, 1);
        }
        return org.lwjgl.cuda.NVRTC.nnvrtcGetProgramLogSize(prog, MemoryUtil.memAddress(logSizeRet));
    }

    public static int nnvrtcGetProgramLog(long prog, long log) {
        long __functionAddress = Functions.GetProgramLog;
        if (Checks.CHECKS) {
            Checks.check(prog);
        }
        return JNI.callPPI(prog, log, __functionAddress);
    }

    @NativeType(value="nvrtcResult")
    public static int nvrtcGetProgramLog(@NativeType(value="nvrtcProgram") long prog, @NativeType(value="char *") ByteBuffer log) {
        return org.lwjgl.cuda.NVRTC.nnvrtcGetProgramLog(prog, MemoryUtil.memAddress(log));
    }

    public static int nnvrtcAddNameExpression(long prog, long name_expression) {
        long __functionAddress = Functions.AddNameExpression;
        if (Checks.CHECKS) {
            Checks.check(prog);
        }
        return JNI.callPPI(prog, name_expression, __functionAddress);
    }

    @NativeType(value="nvrtcResult")
    public static int nvrtcAddNameExpression(@NativeType(value="nvrtcProgram") long prog, @NativeType(value="char const * const") ByteBuffer name_expression) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name_expression);
        }
        return org.lwjgl.cuda.NVRTC.nnvrtcAddNameExpression(prog, MemoryUtil.memAddress(name_expression));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="nvrtcResult")
    public static int nvrtcAddNameExpression(@NativeType(value="nvrtcProgram") long prog, @NativeType(value="char const * const") CharSequence name_expression) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(name_expression, true);
            long name_expressionEncoded = stack.getPointerAddress();
            int n = org.lwjgl.cuda.NVRTC.nnvrtcAddNameExpression(prog, name_expressionEncoded);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static int nnvrtcGetLoweredName(long prog, long name_expression, long lowered_name) {
        long __functionAddress = Functions.GetLoweredName;
        if (Checks.CHECKS) {
            Checks.check(prog);
        }
        return JNI.callPPPI(prog, name_expression, lowered_name, __functionAddress);
    }

    @NativeType(value="nvrtcResult")
    public static int nvrtcGetLoweredName(@NativeType(value="nvrtcProgram") long prog, @NativeType(value="char const * const") ByteBuffer name_expression, @NativeType(value="char const **") PointerBuffer lowered_name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name_expression);
            Checks.check(lowered_name, 1);
        }
        return org.lwjgl.cuda.NVRTC.nnvrtcGetLoweredName(prog, MemoryUtil.memAddress(name_expression), MemoryUtil.memAddress(lowered_name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="nvrtcResult")
    public static int nvrtcGetLoweredName(@NativeType(value="nvrtcProgram") long prog, @NativeType(value="char const * const") CharSequence name_expression, @NativeType(value="char const **") PointerBuffer lowered_name) {
        if (Checks.CHECKS) {
            Checks.check(lowered_name, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(name_expression, true);
            long name_expressionEncoded = stack.getPointerAddress();
            int n = org.lwjgl.cuda.NVRTC.nnvrtcGetLoweredName(prog, name_expressionEncoded, MemoryUtil.memAddress(lowered_name));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    static /* synthetic */ SharedLibrary access$000() {
        return NVRTC;
    }

    public static final class Functions {
        public static final long GetErrorString = APIUtil.apiGetFunctionAddress(org.lwjgl.cuda.NVRTC.access$000(), "nvrtcGetErrorString");
        public static final long Version = APIUtil.apiGetFunctionAddress(org.lwjgl.cuda.NVRTC.access$000(), "nvrtcVersion");
        public static final long GetNumSupportedArchs = org.lwjgl.cuda.NVRTC.access$000().getFunctionAddress("nvrtcGetNumSupportedArchs");
        public static final long GetSupportedArchs = org.lwjgl.cuda.NVRTC.access$000().getFunctionAddress("nvrtcGetSupportedArchs");
        public static final long CreateProgram = APIUtil.apiGetFunctionAddress(org.lwjgl.cuda.NVRTC.access$000(), "nvrtcCreateProgram");
        public static final long DestroyProgram = APIUtil.apiGetFunctionAddress(org.lwjgl.cuda.NVRTC.access$000(), "nvrtcDestroyProgram");
        public static final long CompileProgram = APIUtil.apiGetFunctionAddress(org.lwjgl.cuda.NVRTC.access$000(), "nvrtcCompileProgram");
        public static final long GetPTXSize = APIUtil.apiGetFunctionAddress(org.lwjgl.cuda.NVRTC.access$000(), "nvrtcGetPTXSize");
        public static final long GetPTX = APIUtil.apiGetFunctionAddress(org.lwjgl.cuda.NVRTC.access$000(), "nvrtcGetPTX");
        public static final long GetCUBINSize = org.lwjgl.cuda.NVRTC.access$000().getFunctionAddress("nvrtcGetCUBINSize");
        public static final long GetCUBIN = org.lwjgl.cuda.NVRTC.access$000().getFunctionAddress("nvrtcGetCUBIN");
        public static final long GetNVVMSize = org.lwjgl.cuda.NVRTC.access$000().getFunctionAddress("nvrtcGetNVVMSize");
        public static final long GetNVVM = org.lwjgl.cuda.NVRTC.access$000().getFunctionAddress("nvrtcGetNVVM");
        public static final long GetProgramLogSize = APIUtil.apiGetFunctionAddress(org.lwjgl.cuda.NVRTC.access$000(), "nvrtcGetProgramLogSize");
        public static final long GetProgramLog = APIUtil.apiGetFunctionAddress(org.lwjgl.cuda.NVRTC.access$000(), "nvrtcGetProgramLog");
        public static final long AddNameExpression = APIUtil.apiGetFunctionAddress(org.lwjgl.cuda.NVRTC.access$000(), "nvrtcAddNameExpression");
        public static final long GetLoweredName = APIUtil.apiGetFunctionAddress(org.lwjgl.cuda.NVRTC.access$000(), "nvrtcGetLoweredName");

        private Functions() {
        }
    }
}

