/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUuuid
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BYTES;

    public CUuuid(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CUuuid.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char[16]")
    public ByteBuffer bytes() {
        return CUuuid.nbytes(this.address());
    }

    @NativeType(value="char[16]")
    public String bytesString() {
        return CUuuid.nbytesString(this.address());
    }

    public static CUuuid malloc() {
        return CUuuid.wrap(CUuuid.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static CUuuid calloc() {
        return CUuuid.wrap(CUuuid.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static CUuuid create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return CUuuid.wrap(CUuuid.class, MemoryUtil.memAddress(container), container);
    }

    public static CUuuid create(long address) {
        return CUuuid.wrap(CUuuid.class, address);
    }

    @Nullable
    public static CUuuid createSafe(long address) {
        return address == 0L ? null : CUuuid.wrap(CUuuid.class, address);
    }

    public static Buffer malloc(int capacity) {
        return CUuuid.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(CUuuid.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return CUuuid.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUuuid.__create(capacity, SIZEOF);
        return CUuuid.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return CUuuid.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : CUuuid.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static CUuuid mallocStack() {
        return CUuuid.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CUuuid callocStack() {
        return CUuuid.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CUuuid mallocStack(MemoryStack stack) {
        return CUuuid.malloc(stack);
    }

    @Deprecated
    public static CUuuid callocStack(MemoryStack stack) {
        return CUuuid.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CUuuid.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CUuuid.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CUuuid.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CUuuid.calloc(capacity, stack);
    }

    public static CUuuid malloc(MemoryStack stack) {
        return CUuuid.wrap(CUuuid.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CUuuid calloc(MemoryStack stack) {
        return CUuuid.wrap(CUuuid.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return CUuuid.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return CUuuid.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nbytes(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)BYTES, 16);
    }

    public static String nbytesString(long struct) {
        return MemoryUtil.memASCII(struct + (long)BYTES);
    }

    static {
        Struct.Layout layout = CUuuid.__struct(CUuuid.__array(1, 16));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BYTES = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<CUuuid, Buffer>
    implements NativeResource {
        private static final CUuuid ELEMENT_FACTORY = CUuuid.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected CUuuid getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char[16]")
        public ByteBuffer bytes() {
            return CUuuid.nbytes(this.address());
        }

        @NativeType(value="char[16]")
        public String bytesString() {
            return CUuuid.nbytesString(this.address());
        }
    }
}

