/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUmemPoolPtrExportData
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int RESERVED;

    public CUmemPoolPtrExportData(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CUmemPoolPtrExportData.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned char[64]")
    public ByteBuffer reserved() {
        return CUmemPoolPtrExportData.nreserved(this.address());
    }

    @NativeType(value="unsigned char")
    public byte reserved(int index) {
        return CUmemPoolPtrExportData.nreserved(this.address(), index);
    }

    public CUmemPoolPtrExportData reserved(@NativeType(value="unsigned char[64]") ByteBuffer value) {
        CUmemPoolPtrExportData.nreserved(this.address(), value);
        return this;
    }

    public CUmemPoolPtrExportData reserved(int index, @NativeType(value="unsigned char") byte value) {
        CUmemPoolPtrExportData.nreserved(this.address(), index, value);
        return this;
    }

    public CUmemPoolPtrExportData set(CUmemPoolPtrExportData src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static CUmemPoolPtrExportData malloc() {
        return CUmemPoolPtrExportData.wrap(CUmemPoolPtrExportData.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static CUmemPoolPtrExportData calloc() {
        return CUmemPoolPtrExportData.wrap(CUmemPoolPtrExportData.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static CUmemPoolPtrExportData create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return CUmemPoolPtrExportData.wrap(CUmemPoolPtrExportData.class, MemoryUtil.memAddress(container), container);
    }

    public static CUmemPoolPtrExportData create(long address) {
        return CUmemPoolPtrExportData.wrap(CUmemPoolPtrExportData.class, address);
    }

    @Nullable
    public static CUmemPoolPtrExportData createSafe(long address) {
        return address == 0L ? null : CUmemPoolPtrExportData.wrap(CUmemPoolPtrExportData.class, address);
    }

    public static Buffer malloc(int capacity) {
        return CUmemPoolPtrExportData.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(CUmemPoolPtrExportData.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return CUmemPoolPtrExportData.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUmemPoolPtrExportData.__create(capacity, SIZEOF);
        return CUmemPoolPtrExportData.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return CUmemPoolPtrExportData.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : CUmemPoolPtrExportData.wrap(Buffer.class, address, capacity);
    }

    public static CUmemPoolPtrExportData malloc(MemoryStack stack) {
        return CUmemPoolPtrExportData.wrap(CUmemPoolPtrExportData.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CUmemPoolPtrExportData calloc(MemoryStack stack) {
        return CUmemPoolPtrExportData.wrap(CUmemPoolPtrExportData.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return CUmemPoolPtrExportData.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return CUmemPoolPtrExportData.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nreserved(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)RESERVED, 64);
    }

    public static byte nreserved(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)RESERVED + Checks.check(index, 64) * 1L);
    }

    public static void nreserved(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 64);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)RESERVED, value.remaining() * 1);
    }

    public static void nreserved(long struct, int index, byte value) {
        UNSAFE.putByte(null, struct + (long)RESERVED + Checks.check(index, 64) * 1L, value);
    }

    static {
        Struct.Layout layout = CUmemPoolPtrExportData.__struct(CUmemPoolPtrExportData.__array(1, 64));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        RESERVED = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<CUmemPoolPtrExportData, Buffer>
    implements NativeResource {
        private static final CUmemPoolPtrExportData ELEMENT_FACTORY = CUmemPoolPtrExportData.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected CUmemPoolPtrExportData getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned char[64]")
        public ByteBuffer reserved() {
            return CUmemPoolPtrExportData.nreserved(this.address());
        }

        @NativeType(value="unsigned char")
        public byte reserved(int index) {
            return CUmemPoolPtrExportData.nreserved(this.address(), index);
        }

        public Buffer reserved(@NativeType(value="unsigned char[64]") ByteBuffer value) {
            CUmemPoolPtrExportData.nreserved(this.address(), value);
            return this;
        }

        public Buffer reserved(int index, @NativeType(value="unsigned char") byte value) {
            CUmemPoolPtrExportData.nreserved(this.address(), index, value);
            return this;
        }
    }
}

