/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.cuda.CUmemLocation;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUmemPoolProps
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ALLOCTYPE;
    public static final int HANDLETYPES;
    public static final int LOCATION;
    public static final int WIN32SECURITYATTRIBUTES;
    public static final int RESERVED;

    public CUmemPoolProps(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CUmemPoolProps.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="CUmemAllocationType")
    public int allocType() {
        return CUmemPoolProps.nallocType(this.address());
    }

    @NativeType(value="CUmemAllocationHandleType")
    public int handleTypes() {
        return CUmemPoolProps.nhandleTypes(this.address());
    }

    public CUmemLocation location() {
        return CUmemPoolProps.nlocation(this.address());
    }

    @NativeType(value="void *")
    public long win32SecurityAttributes() {
        return CUmemPoolProps.nwin32SecurityAttributes(this.address());
    }

    @NativeType(value="unsigned char[64]")
    public ByteBuffer reserved() {
        return CUmemPoolProps.nreserved(this.address());
    }

    @NativeType(value="unsigned char")
    public byte reserved(int index) {
        return CUmemPoolProps.nreserved(this.address(), index);
    }

    public CUmemPoolProps allocType(@NativeType(value="CUmemAllocationType") int value) {
        CUmemPoolProps.nallocType(this.address(), value);
        return this;
    }

    public CUmemPoolProps handleTypes(@NativeType(value="CUmemAllocationHandleType") int value) {
        CUmemPoolProps.nhandleTypes(this.address(), value);
        return this;
    }

    public CUmemPoolProps location(CUmemLocation value) {
        CUmemPoolProps.nlocation(this.address(), value);
        return this;
    }

    public CUmemPoolProps location(Consumer<CUmemLocation> consumer) {
        consumer.accept(this.location());
        return this;
    }

    public CUmemPoolProps win32SecurityAttributes(@NativeType(value="void *") long value) {
        CUmemPoolProps.nwin32SecurityAttributes(this.address(), value);
        return this;
    }

    public CUmemPoolProps reserved(@NativeType(value="unsigned char[64]") ByteBuffer value) {
        CUmemPoolProps.nreserved(this.address(), value);
        return this;
    }

    public CUmemPoolProps reserved(int index, @NativeType(value="unsigned char") byte value) {
        CUmemPoolProps.nreserved(this.address(), index, value);
        return this;
    }

    public CUmemPoolProps set(int allocType, int handleTypes, CUmemLocation location, long win32SecurityAttributes, ByteBuffer reserved) {
        this.allocType(allocType);
        this.handleTypes(handleTypes);
        this.location(location);
        this.win32SecurityAttributes(win32SecurityAttributes);
        this.reserved(reserved);
        return this;
    }

    public CUmemPoolProps set(CUmemPoolProps src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static CUmemPoolProps malloc() {
        return CUmemPoolProps.wrap(CUmemPoolProps.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static CUmemPoolProps calloc() {
        return CUmemPoolProps.wrap(CUmemPoolProps.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static CUmemPoolProps create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return CUmemPoolProps.wrap(CUmemPoolProps.class, MemoryUtil.memAddress(container), container);
    }

    public static CUmemPoolProps create(long address) {
        return CUmemPoolProps.wrap(CUmemPoolProps.class, address);
    }

    @Nullable
    public static CUmemPoolProps createSafe(long address) {
        return address == 0L ? null : CUmemPoolProps.wrap(CUmemPoolProps.class, address);
    }

    public static Buffer malloc(int capacity) {
        return CUmemPoolProps.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(CUmemPoolProps.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return CUmemPoolProps.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUmemPoolProps.__create(capacity, SIZEOF);
        return CUmemPoolProps.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return CUmemPoolProps.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : CUmemPoolProps.wrap(Buffer.class, address, capacity);
    }

    public static CUmemPoolProps malloc(MemoryStack stack) {
        return CUmemPoolProps.wrap(CUmemPoolProps.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CUmemPoolProps calloc(MemoryStack stack) {
        return CUmemPoolProps.wrap(CUmemPoolProps.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return CUmemPoolProps.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return CUmemPoolProps.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nallocType(long struct) {
        return UNSAFE.getInt(null, struct + (long)ALLOCTYPE);
    }

    public static int nhandleTypes(long struct) {
        return UNSAFE.getInt(null, struct + (long)HANDLETYPES);
    }

    public static CUmemLocation nlocation(long struct) {
        return CUmemLocation.create(struct + (long)LOCATION);
    }

    public static long nwin32SecurityAttributes(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)WIN32SECURITYATTRIBUTES);
    }

    public static ByteBuffer nreserved(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)RESERVED, 64);
    }

    public static byte nreserved(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)RESERVED + Checks.check(index, 64) * 1L);
    }

    public static void nallocType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ALLOCTYPE, value);
    }

    public static void nhandleTypes(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)HANDLETYPES, value);
    }

    public static void nlocation(long struct, CUmemLocation value) {
        MemoryUtil.memCopy(value.address(), struct + (long)LOCATION, CUmemLocation.SIZEOF);
    }

    public static void nwin32SecurityAttributes(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)WIN32SECURITYATTRIBUTES, value);
    }

    public static void nreserved(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 64);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)RESERVED, value.remaining() * 1);
    }

    public static void nreserved(long struct, int index, byte value) {
        UNSAFE.putByte(null, struct + (long)RESERVED + Checks.check(index, 64) * 1L, value);
    }

    static {
        Struct.Layout layout = CUmemPoolProps.__struct(CUmemPoolProps.__member(4), CUmemPoolProps.__member(4), CUmemPoolProps.__member(CUmemLocation.SIZEOF, CUmemLocation.ALIGNOF), CUmemPoolProps.__member(POINTER_SIZE), CUmemPoolProps.__array(1, 64));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ALLOCTYPE = layout.offsetof(0);
        HANDLETYPES = layout.offsetof(1);
        LOCATION = layout.offsetof(2);
        WIN32SECURITYATTRIBUTES = layout.offsetof(3);
        RESERVED = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<CUmemPoolProps, Buffer>
    implements NativeResource {
        private static final CUmemPoolProps ELEMENT_FACTORY = CUmemPoolProps.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected CUmemPoolProps getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="CUmemAllocationType")
        public int allocType() {
            return CUmemPoolProps.nallocType(this.address());
        }

        @NativeType(value="CUmemAllocationHandleType")
        public int handleTypes() {
            return CUmemPoolProps.nhandleTypes(this.address());
        }

        public CUmemLocation location() {
            return CUmemPoolProps.nlocation(this.address());
        }

        @NativeType(value="void *")
        public long win32SecurityAttributes() {
            return CUmemPoolProps.nwin32SecurityAttributes(this.address());
        }

        @NativeType(value="unsigned char[64]")
        public ByteBuffer reserved() {
            return CUmemPoolProps.nreserved(this.address());
        }

        @NativeType(value="unsigned char")
        public byte reserved(int index) {
            return CUmemPoolProps.nreserved(this.address(), index);
        }

        public Buffer allocType(@NativeType(value="CUmemAllocationType") int value) {
            CUmemPoolProps.nallocType(this.address(), value);
            return this;
        }

        public Buffer handleTypes(@NativeType(value="CUmemAllocationHandleType") int value) {
            CUmemPoolProps.nhandleTypes(this.address(), value);
            return this;
        }

        public Buffer location(CUmemLocation value) {
            CUmemPoolProps.nlocation(this.address(), value);
            return this;
        }

        public Buffer location(Consumer<CUmemLocation> consumer) {
            consumer.accept(this.location());
            return this;
        }

        public Buffer win32SecurityAttributes(@NativeType(value="void *") long value) {
            CUmemPoolProps.nwin32SecurityAttributes(this.address(), value);
            return this;
        }

        public Buffer reserved(@NativeType(value="unsigned char[64]") ByteBuffer value) {
            CUmemPoolProps.nreserved(this.address(), value);
            return this;
        }

        public Buffer reserved(int index, @NativeType(value="unsigned char") byte value) {
            CUmemPoolProps.nreserved(this.address(), index, value);
            return this;
        }
    }
}

