/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.cuda.CUmemLocation;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUmemAccessDesc
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LOCATION;
    public static final int FLAGS;

    public CUmemAccessDesc(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CUmemAccessDesc.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public CUmemLocation location() {
        return CUmemAccessDesc.nlocation(this.address());
    }

    @NativeType(value="CUmemAccess_flags")
    public int flags() {
        return CUmemAccessDesc.nflags(this.address());
    }

    public CUmemAccessDesc location(CUmemLocation value) {
        CUmemAccessDesc.nlocation(this.address(), value);
        return this;
    }

    public CUmemAccessDesc location(Consumer<CUmemLocation> consumer) {
        consumer.accept(this.location());
        return this;
    }

    public CUmemAccessDesc flags(@NativeType(value="CUmemAccess_flags") int value) {
        CUmemAccessDesc.nflags(this.address(), value);
        return this;
    }

    public CUmemAccessDesc set(CUmemLocation location, int flags) {
        this.location(location);
        this.flags(flags);
        return this;
    }

    public CUmemAccessDesc set(CUmemAccessDesc src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static CUmemAccessDesc malloc() {
        return CUmemAccessDesc.wrap(CUmemAccessDesc.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static CUmemAccessDesc calloc() {
        return CUmemAccessDesc.wrap(CUmemAccessDesc.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static CUmemAccessDesc create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return CUmemAccessDesc.wrap(CUmemAccessDesc.class, MemoryUtil.memAddress(container), container);
    }

    public static CUmemAccessDesc create(long address) {
        return CUmemAccessDesc.wrap(CUmemAccessDesc.class, address);
    }

    @Nullable
    public static CUmemAccessDesc createSafe(long address) {
        return address == 0L ? null : CUmemAccessDesc.wrap(CUmemAccessDesc.class, address);
    }

    public static Buffer malloc(int capacity) {
        return CUmemAccessDesc.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(CUmemAccessDesc.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return CUmemAccessDesc.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUmemAccessDesc.__create(capacity, SIZEOF);
        return CUmemAccessDesc.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return CUmemAccessDesc.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : CUmemAccessDesc.wrap(Buffer.class, address, capacity);
    }

    public static CUmemAccessDesc malloc(MemoryStack stack) {
        return CUmemAccessDesc.wrap(CUmemAccessDesc.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CUmemAccessDesc calloc(MemoryStack stack) {
        return CUmemAccessDesc.wrap(CUmemAccessDesc.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return CUmemAccessDesc.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return CUmemAccessDesc.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static CUmemLocation nlocation(long struct) {
        return CUmemLocation.create(struct + (long)LOCATION);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static void nlocation(long struct, CUmemLocation value) {
        MemoryUtil.memCopy(value.address(), struct + (long)LOCATION, CUmemLocation.SIZEOF);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    static {
        Struct.Layout layout = CUmemAccessDesc.__struct(CUmemAccessDesc.__member(CUmemLocation.SIZEOF, CUmemLocation.ALIGNOF), CUmemAccessDesc.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LOCATION = layout.offsetof(0);
        FLAGS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CUmemAccessDesc, Buffer>
    implements NativeResource {
        private static final CUmemAccessDesc ELEMENT_FACTORY = CUmemAccessDesc.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected CUmemAccessDesc getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public CUmemLocation location() {
            return CUmemAccessDesc.nlocation(this.address());
        }

        @NativeType(value="CUmemAccess_flags")
        public int flags() {
            return CUmemAccessDesc.nflags(this.address());
        }

        public Buffer location(CUmemLocation value) {
            CUmemAccessDesc.nlocation(this.address(), value);
            return this;
        }

        public Buffer location(Consumer<CUmemLocation> consumer) {
            consumer.accept(this.location());
            return this;
        }

        public Buffer flags(@NativeType(value="CUmemAccess_flags") int value) {
            CUmemAccessDesc.nflags(this.address(), value);
            return this;
        }
    }
}

