/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.cuda.CUaccessPolicyWindow;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUkernelNodeAttrValue
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ACCESSPOLICYWINDOW;
    public static final int COOPERATIVE;

    public CUkernelNodeAttrValue(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CUkernelNodeAttrValue.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public CUaccessPolicyWindow accessPolicyWindow() {
        return CUkernelNodeAttrValue.naccessPolicyWindow(this.address());
    }

    public int cooperative() {
        return CUkernelNodeAttrValue.ncooperative(this.address());
    }

    public CUkernelNodeAttrValue accessPolicyWindow(CUaccessPolicyWindow value) {
        CUkernelNodeAttrValue.naccessPolicyWindow(this.address(), value);
        return this;
    }

    public CUkernelNodeAttrValue accessPolicyWindow(Consumer<CUaccessPolicyWindow> consumer) {
        consumer.accept(this.accessPolicyWindow());
        return this;
    }

    public CUkernelNodeAttrValue cooperative(int value) {
        CUkernelNodeAttrValue.ncooperative(this.address(), value);
        return this;
    }

    public CUkernelNodeAttrValue set(CUkernelNodeAttrValue src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static CUkernelNodeAttrValue malloc() {
        return CUkernelNodeAttrValue.wrap(CUkernelNodeAttrValue.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static CUkernelNodeAttrValue calloc() {
        return CUkernelNodeAttrValue.wrap(CUkernelNodeAttrValue.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static CUkernelNodeAttrValue create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return CUkernelNodeAttrValue.wrap(CUkernelNodeAttrValue.class, MemoryUtil.memAddress(container), container);
    }

    public static CUkernelNodeAttrValue create(long address) {
        return CUkernelNodeAttrValue.wrap(CUkernelNodeAttrValue.class, address);
    }

    @Nullable
    public static CUkernelNodeAttrValue createSafe(long address) {
        return address == 0L ? null : CUkernelNodeAttrValue.wrap(CUkernelNodeAttrValue.class, address);
    }

    public static Buffer malloc(int capacity) {
        return CUkernelNodeAttrValue.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(CUkernelNodeAttrValue.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return CUkernelNodeAttrValue.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUkernelNodeAttrValue.__create(capacity, SIZEOF);
        return CUkernelNodeAttrValue.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return CUkernelNodeAttrValue.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : CUkernelNodeAttrValue.wrap(Buffer.class, address, capacity);
    }

    public static CUkernelNodeAttrValue malloc(MemoryStack stack) {
        return CUkernelNodeAttrValue.wrap(CUkernelNodeAttrValue.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CUkernelNodeAttrValue calloc(MemoryStack stack) {
        return CUkernelNodeAttrValue.wrap(CUkernelNodeAttrValue.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return CUkernelNodeAttrValue.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return CUkernelNodeAttrValue.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static CUaccessPolicyWindow naccessPolicyWindow(long struct) {
        return CUaccessPolicyWindow.create(struct + (long)ACCESSPOLICYWINDOW);
    }

    public static int ncooperative(long struct) {
        return UNSAFE.getInt(null, struct + (long)COOPERATIVE);
    }

    public static void naccessPolicyWindow(long struct, CUaccessPolicyWindow value) {
        MemoryUtil.memCopy(value.address(), struct + (long)ACCESSPOLICYWINDOW, CUaccessPolicyWindow.SIZEOF);
    }

    public static void ncooperative(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)COOPERATIVE, value);
    }

    static {
        Struct.Layout layout = CUkernelNodeAttrValue.__union(CUkernelNodeAttrValue.__member(CUaccessPolicyWindow.SIZEOF, CUaccessPolicyWindow.ALIGNOF), CUkernelNodeAttrValue.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ACCESSPOLICYWINDOW = layout.offsetof(0);
        COOPERATIVE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CUkernelNodeAttrValue, Buffer>
    implements NativeResource {
        private static final CUkernelNodeAttrValue ELEMENT_FACTORY = CUkernelNodeAttrValue.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected CUkernelNodeAttrValue getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public CUaccessPolicyWindow accessPolicyWindow() {
            return CUkernelNodeAttrValue.naccessPolicyWindow(this.address());
        }

        public int cooperative() {
            return CUkernelNodeAttrValue.ncooperative(this.address());
        }

        public Buffer accessPolicyWindow(CUaccessPolicyWindow value) {
            CUkernelNodeAttrValue.naccessPolicyWindow(this.address(), value);
            return this;
        }

        public Buffer accessPolicyWindow(Consumer<CUaccessPolicyWindow> consumer) {
            consumer.accept(this.accessPolicyWindow());
            return this;
        }

        public Buffer cooperative(int value) {
            CUkernelNodeAttrValue.ncooperative(this.address(), value);
            return this;
        }
    }
}

