/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUDA_MEMCPY3D_PEER
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SRCXINBYTES;
    public static final int SRCY;
    public static final int SRCZ;
    public static final int SRCLOD;
    public static final int SRCMEMORYTYPE;
    public static final int SRCHOST;
    public static final int SRCDEVICE;
    public static final int SRCARRAY;
    public static final int SRCCONTEXT;
    public static final int SRCPITCH;
    public static final int SRCHEIGHT;
    public static final int DSTXINBYTES;
    public static final int DSTY;
    public static final int DSTZ;
    public static final int DSTLOD;
    public static final int DSTMEMORYTYPE;
    public static final int DSTHOST;
    public static final int DSTDEVICE;
    public static final int DSTARRAY;
    public static final int DSTCONTEXT;
    public static final int DSTPITCH;
    public static final int DSTHEIGHT;
    public static final int WIDTHINBYTES;
    public static final int HEIGHT;
    public static final int DEPTH;

    public CUDA_MEMCPY3D_PEER(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CUDA_MEMCPY3D_PEER.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="size_t")
    public long srcXInBytes() {
        return CUDA_MEMCPY3D_PEER.nsrcXInBytes(this.address());
    }

    @NativeType(value="size_t")
    public long srcY() {
        return CUDA_MEMCPY3D_PEER.nsrcY(this.address());
    }

    @NativeType(value="size_t")
    public long srcZ() {
        return CUDA_MEMCPY3D_PEER.nsrcZ(this.address());
    }

    @NativeType(value="size_t")
    public long srcLOD() {
        return CUDA_MEMCPY3D_PEER.nsrcLOD(this.address());
    }

    @NativeType(value="CUmemorytype")
    public int srcMemoryType() {
        return CUDA_MEMCPY3D_PEER.nsrcMemoryType(this.address());
    }

    @Nullable
    @NativeType(value="void const *")
    public ByteBuffer srcHost(int capacity) {
        return CUDA_MEMCPY3D_PEER.nsrcHost(this.address(), capacity);
    }

    @NativeType(value="CUdeviceptr")
    public long srcDevice() {
        return CUDA_MEMCPY3D_PEER.nsrcDevice(this.address());
    }

    @NativeType(value="CUarray")
    public long srcArray() {
        return CUDA_MEMCPY3D_PEER.nsrcArray(this.address());
    }

    @NativeType(value="CUcontext")
    public long srcContext() {
        return CUDA_MEMCPY3D_PEER.nsrcContext(this.address());
    }

    @NativeType(value="size_t")
    public long srcPitch() {
        return CUDA_MEMCPY3D_PEER.nsrcPitch(this.address());
    }

    @NativeType(value="size_t")
    public long srcHeight() {
        return CUDA_MEMCPY3D_PEER.nsrcHeight(this.address());
    }

    @NativeType(value="size_t")
    public long dstXInBytes() {
        return CUDA_MEMCPY3D_PEER.ndstXInBytes(this.address());
    }

    @NativeType(value="size_t")
    public long dstY() {
        return CUDA_MEMCPY3D_PEER.ndstY(this.address());
    }

    @NativeType(value="size_t")
    public long dstZ() {
        return CUDA_MEMCPY3D_PEER.ndstZ(this.address());
    }

    @NativeType(value="size_t")
    public long dstLOD() {
        return CUDA_MEMCPY3D_PEER.ndstLOD(this.address());
    }

    @NativeType(value="CUmemorytype")
    public int dstMemoryType() {
        return CUDA_MEMCPY3D_PEER.ndstMemoryType(this.address());
    }

    @Nullable
    @NativeType(value="void *")
    public ByteBuffer dstHost(int capacity) {
        return CUDA_MEMCPY3D_PEER.ndstHost(this.address(), capacity);
    }

    @NativeType(value="CUdeviceptr")
    public long dstDevice() {
        return CUDA_MEMCPY3D_PEER.ndstDevice(this.address());
    }

    @NativeType(value="CUarray")
    public long dstArray() {
        return CUDA_MEMCPY3D_PEER.ndstArray(this.address());
    }

    @NativeType(value="CUcontext")
    public long dstContext() {
        return CUDA_MEMCPY3D_PEER.ndstContext(this.address());
    }

    @NativeType(value="size_t")
    public long dstPitch() {
        return CUDA_MEMCPY3D_PEER.ndstPitch(this.address());
    }

    @NativeType(value="size_t")
    public long dstHeight() {
        return CUDA_MEMCPY3D_PEER.ndstHeight(this.address());
    }

    @NativeType(value="size_t")
    public long WidthInBytes() {
        return CUDA_MEMCPY3D_PEER.nWidthInBytes(this.address());
    }

    @NativeType(value="size_t")
    public long Height() {
        return CUDA_MEMCPY3D_PEER.nHeight(this.address());
    }

    @NativeType(value="size_t")
    public long Depth() {
        return CUDA_MEMCPY3D_PEER.nDepth(this.address());
    }

    public CUDA_MEMCPY3D_PEER srcXInBytes(@NativeType(value="size_t") long value) {
        CUDA_MEMCPY3D_PEER.nsrcXInBytes(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY3D_PEER srcY(@NativeType(value="size_t") long value) {
        CUDA_MEMCPY3D_PEER.nsrcY(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY3D_PEER srcZ(@NativeType(value="size_t") long value) {
        CUDA_MEMCPY3D_PEER.nsrcZ(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY3D_PEER srcLOD(@NativeType(value="size_t") long value) {
        CUDA_MEMCPY3D_PEER.nsrcLOD(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY3D_PEER srcMemoryType(@NativeType(value="CUmemorytype") int value) {
        CUDA_MEMCPY3D_PEER.nsrcMemoryType(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY3D_PEER srcHost(@Nullable @NativeType(value="void const *") ByteBuffer value) {
        CUDA_MEMCPY3D_PEER.nsrcHost(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY3D_PEER srcDevice(@NativeType(value="CUdeviceptr") long value) {
        CUDA_MEMCPY3D_PEER.nsrcDevice(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY3D_PEER srcArray(@NativeType(value="CUarray") long value) {
        CUDA_MEMCPY3D_PEER.nsrcArray(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY3D_PEER srcContext(@NativeType(value="CUcontext") long value) {
        CUDA_MEMCPY3D_PEER.nsrcContext(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY3D_PEER srcPitch(@NativeType(value="size_t") long value) {
        CUDA_MEMCPY3D_PEER.nsrcPitch(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY3D_PEER srcHeight(@NativeType(value="size_t") long value) {
        CUDA_MEMCPY3D_PEER.nsrcHeight(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY3D_PEER dstXInBytes(@NativeType(value="size_t") long value) {
        CUDA_MEMCPY3D_PEER.ndstXInBytes(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY3D_PEER dstY(@NativeType(value="size_t") long value) {
        CUDA_MEMCPY3D_PEER.ndstY(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY3D_PEER dstZ(@NativeType(value="size_t") long value) {
        CUDA_MEMCPY3D_PEER.ndstZ(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY3D_PEER dstLOD(@NativeType(value="size_t") long value) {
        CUDA_MEMCPY3D_PEER.ndstLOD(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY3D_PEER dstMemoryType(@NativeType(value="CUmemorytype") int value) {
        CUDA_MEMCPY3D_PEER.ndstMemoryType(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY3D_PEER dstHost(@Nullable @NativeType(value="void *") ByteBuffer value) {
        CUDA_MEMCPY3D_PEER.ndstHost(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY3D_PEER dstDevice(@NativeType(value="CUdeviceptr") long value) {
        CUDA_MEMCPY3D_PEER.ndstDevice(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY3D_PEER dstArray(@NativeType(value="CUarray") long value) {
        CUDA_MEMCPY3D_PEER.ndstArray(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY3D_PEER dstContext(@NativeType(value="CUcontext") long value) {
        CUDA_MEMCPY3D_PEER.ndstContext(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY3D_PEER dstPitch(@NativeType(value="size_t") long value) {
        CUDA_MEMCPY3D_PEER.ndstPitch(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY3D_PEER dstHeight(@NativeType(value="size_t") long value) {
        CUDA_MEMCPY3D_PEER.ndstHeight(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY3D_PEER WidthInBytes(@NativeType(value="size_t") long value) {
        CUDA_MEMCPY3D_PEER.nWidthInBytes(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY3D_PEER Height(@NativeType(value="size_t") long value) {
        CUDA_MEMCPY3D_PEER.nHeight(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY3D_PEER Depth(@NativeType(value="size_t") long value) {
        CUDA_MEMCPY3D_PEER.nDepth(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY3D_PEER set(long srcXInBytes, long srcY, long srcZ, long srcLOD, int srcMemoryType, @Nullable ByteBuffer srcHost, long srcDevice, long srcArray, long srcContext, long srcPitch, long srcHeight, long dstXInBytes, long dstY, long dstZ, long dstLOD, int dstMemoryType, @Nullable ByteBuffer dstHost, long dstDevice, long dstArray, long dstContext, long dstPitch, long dstHeight, long WidthInBytes, long Height, long Depth) {
        this.srcXInBytes(srcXInBytes);
        this.srcY(srcY);
        this.srcZ(srcZ);
        this.srcLOD(srcLOD);
        this.srcMemoryType(srcMemoryType);
        this.srcHost(srcHost);
        this.srcDevice(srcDevice);
        this.srcArray(srcArray);
        this.srcContext(srcContext);
        this.srcPitch(srcPitch);
        this.srcHeight(srcHeight);
        this.dstXInBytes(dstXInBytes);
        this.dstY(dstY);
        this.dstZ(dstZ);
        this.dstLOD(dstLOD);
        this.dstMemoryType(dstMemoryType);
        this.dstHost(dstHost);
        this.dstDevice(dstDevice);
        this.dstArray(dstArray);
        this.dstContext(dstContext);
        this.dstPitch(dstPitch);
        this.dstHeight(dstHeight);
        this.WidthInBytes(WidthInBytes);
        this.Height(Height);
        this.Depth(Depth);
        return this;
    }

    public CUDA_MEMCPY3D_PEER set(CUDA_MEMCPY3D_PEER src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static CUDA_MEMCPY3D_PEER malloc() {
        return CUDA_MEMCPY3D_PEER.wrap(CUDA_MEMCPY3D_PEER.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static CUDA_MEMCPY3D_PEER calloc() {
        return CUDA_MEMCPY3D_PEER.wrap(CUDA_MEMCPY3D_PEER.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static CUDA_MEMCPY3D_PEER create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return CUDA_MEMCPY3D_PEER.wrap(CUDA_MEMCPY3D_PEER.class, MemoryUtil.memAddress(container), container);
    }

    public static CUDA_MEMCPY3D_PEER create(long address) {
        return CUDA_MEMCPY3D_PEER.wrap(CUDA_MEMCPY3D_PEER.class, address);
    }

    @Nullable
    public static CUDA_MEMCPY3D_PEER createSafe(long address) {
        return address == 0L ? null : CUDA_MEMCPY3D_PEER.wrap(CUDA_MEMCPY3D_PEER.class, address);
    }

    public static Buffer malloc(int capacity) {
        return CUDA_MEMCPY3D_PEER.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(CUDA_MEMCPY3D_PEER.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return CUDA_MEMCPY3D_PEER.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUDA_MEMCPY3D_PEER.__create(capacity, SIZEOF);
        return CUDA_MEMCPY3D_PEER.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return CUDA_MEMCPY3D_PEER.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : CUDA_MEMCPY3D_PEER.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static CUDA_MEMCPY3D_PEER mallocStack() {
        return CUDA_MEMCPY3D_PEER.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CUDA_MEMCPY3D_PEER callocStack() {
        return CUDA_MEMCPY3D_PEER.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CUDA_MEMCPY3D_PEER mallocStack(MemoryStack stack) {
        return CUDA_MEMCPY3D_PEER.malloc(stack);
    }

    @Deprecated
    public static CUDA_MEMCPY3D_PEER callocStack(MemoryStack stack) {
        return CUDA_MEMCPY3D_PEER.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CUDA_MEMCPY3D_PEER.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CUDA_MEMCPY3D_PEER.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CUDA_MEMCPY3D_PEER.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CUDA_MEMCPY3D_PEER.calloc(capacity, stack);
    }

    public static CUDA_MEMCPY3D_PEER malloc(MemoryStack stack) {
        return CUDA_MEMCPY3D_PEER.wrap(CUDA_MEMCPY3D_PEER.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CUDA_MEMCPY3D_PEER calloc(MemoryStack stack) {
        return CUDA_MEMCPY3D_PEER.wrap(CUDA_MEMCPY3D_PEER.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return CUDA_MEMCPY3D_PEER.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return CUDA_MEMCPY3D_PEER.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nsrcXInBytes(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SRCXINBYTES);
    }

    public static long nsrcY(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SRCY);
    }

    public static long nsrcZ(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SRCZ);
    }

    public static long nsrcLOD(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SRCLOD);
    }

    public static int nsrcMemoryType(long struct) {
        return UNSAFE.getInt(null, struct + (long)SRCMEMORYTYPE);
    }

    @Nullable
    public static ByteBuffer nsrcHost(long struct, int capacity) {
        return MemoryUtil.memByteBufferSafe(MemoryUtil.memGetAddress(struct + (long)SRCHOST), capacity);
    }

    public static long nsrcDevice(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SRCDEVICE);
    }

    public static long nsrcArray(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SRCARRAY);
    }

    public static long nsrcContext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SRCCONTEXT);
    }

    public static long nsrcPitch(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SRCPITCH);
    }

    public static long nsrcHeight(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SRCHEIGHT);
    }

    public static long ndstXInBytes(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)DSTXINBYTES);
    }

    public static long ndstY(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)DSTY);
    }

    public static long ndstZ(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)DSTZ);
    }

    public static long ndstLOD(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)DSTLOD);
    }

    public static int ndstMemoryType(long struct) {
        return UNSAFE.getInt(null, struct + (long)DSTMEMORYTYPE);
    }

    @Nullable
    public static ByteBuffer ndstHost(long struct, int capacity) {
        return MemoryUtil.memByteBufferSafe(MemoryUtil.memGetAddress(struct + (long)DSTHOST), capacity);
    }

    public static long ndstDevice(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)DSTDEVICE);
    }

    public static long ndstArray(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)DSTARRAY);
    }

    public static long ndstContext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)DSTCONTEXT);
    }

    public static long ndstPitch(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)DSTPITCH);
    }

    public static long ndstHeight(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)DSTHEIGHT);
    }

    public static long nWidthInBytes(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)WIDTHINBYTES);
    }

    public static long nHeight(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)HEIGHT);
    }

    public static long nDepth(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)DEPTH);
    }

    public static void nsrcXInBytes(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)SRCXINBYTES, value);
    }

    public static void nsrcY(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)SRCY, value);
    }

    public static void nsrcZ(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)SRCZ, value);
    }

    public static void nsrcLOD(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)SRCLOD, value);
    }

    public static void nsrcMemoryType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SRCMEMORYTYPE, value);
    }

    public static void nsrcHost(long struct, @Nullable ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)SRCHOST, MemoryUtil.memAddressSafe(value));
    }

    public static void nsrcDevice(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)SRCDEVICE, value);
    }

    public static void nsrcArray(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)SRCARRAY, value);
    }

    public static void nsrcContext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)SRCCONTEXT, value);
    }

    public static void nsrcPitch(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)SRCPITCH, value);
    }

    public static void nsrcHeight(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)SRCHEIGHT, value);
    }

    public static void ndstXInBytes(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)DSTXINBYTES, value);
    }

    public static void ndstY(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)DSTY, value);
    }

    public static void ndstZ(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)DSTZ, value);
    }

    public static void ndstLOD(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)DSTLOD, value);
    }

    public static void ndstMemoryType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DSTMEMORYTYPE, value);
    }

    public static void ndstHost(long struct, @Nullable ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)DSTHOST, MemoryUtil.memAddressSafe(value));
    }

    public static void ndstDevice(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)DSTDEVICE, value);
    }

    public static void ndstArray(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)DSTARRAY, value);
    }

    public static void ndstContext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)DSTCONTEXT, value);
    }

    public static void ndstPitch(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)DSTPITCH, value);
    }

    public static void ndstHeight(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)DSTHEIGHT, value);
    }

    public static void nWidthInBytes(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)WIDTHINBYTES, value);
    }

    public static void nHeight(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)HEIGHT, value);
    }

    public static void nDepth(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)DEPTH, value);
    }

    static {
        Struct.Layout layout = CUDA_MEMCPY3D_PEER.__struct(CUDA_MEMCPY3D_PEER.__member(POINTER_SIZE), CUDA_MEMCPY3D_PEER.__member(POINTER_SIZE), CUDA_MEMCPY3D_PEER.__member(POINTER_SIZE), CUDA_MEMCPY3D_PEER.__member(POINTER_SIZE), CUDA_MEMCPY3D_PEER.__member(4), CUDA_MEMCPY3D_PEER.__member(POINTER_SIZE), CUDA_MEMCPY3D_PEER.__member(POINTER_SIZE), CUDA_MEMCPY3D_PEER.__member(POINTER_SIZE), CUDA_MEMCPY3D_PEER.__member(POINTER_SIZE), CUDA_MEMCPY3D_PEER.__member(POINTER_SIZE), CUDA_MEMCPY3D_PEER.__member(POINTER_SIZE), CUDA_MEMCPY3D_PEER.__member(POINTER_SIZE), CUDA_MEMCPY3D_PEER.__member(POINTER_SIZE), CUDA_MEMCPY3D_PEER.__member(POINTER_SIZE), CUDA_MEMCPY3D_PEER.__member(POINTER_SIZE), CUDA_MEMCPY3D_PEER.__member(4), CUDA_MEMCPY3D_PEER.__member(POINTER_SIZE), CUDA_MEMCPY3D_PEER.__member(POINTER_SIZE), CUDA_MEMCPY3D_PEER.__member(POINTER_SIZE), CUDA_MEMCPY3D_PEER.__member(POINTER_SIZE), CUDA_MEMCPY3D_PEER.__member(POINTER_SIZE), CUDA_MEMCPY3D_PEER.__member(POINTER_SIZE), CUDA_MEMCPY3D_PEER.__member(POINTER_SIZE), CUDA_MEMCPY3D_PEER.__member(POINTER_SIZE), CUDA_MEMCPY3D_PEER.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SRCXINBYTES = layout.offsetof(0);
        SRCY = layout.offsetof(1);
        SRCZ = layout.offsetof(2);
        SRCLOD = layout.offsetof(3);
        SRCMEMORYTYPE = layout.offsetof(4);
        SRCHOST = layout.offsetof(5);
        SRCDEVICE = layout.offsetof(6);
        SRCARRAY = layout.offsetof(7);
        SRCCONTEXT = layout.offsetof(8);
        SRCPITCH = layout.offsetof(9);
        SRCHEIGHT = layout.offsetof(10);
        DSTXINBYTES = layout.offsetof(11);
        DSTY = layout.offsetof(12);
        DSTZ = layout.offsetof(13);
        DSTLOD = layout.offsetof(14);
        DSTMEMORYTYPE = layout.offsetof(15);
        DSTHOST = layout.offsetof(16);
        DSTDEVICE = layout.offsetof(17);
        DSTARRAY = layout.offsetof(18);
        DSTCONTEXT = layout.offsetof(19);
        DSTPITCH = layout.offsetof(20);
        DSTHEIGHT = layout.offsetof(21);
        WIDTHINBYTES = layout.offsetof(22);
        HEIGHT = layout.offsetof(23);
        DEPTH = layout.offsetof(24);
    }

    public static class Buffer
    extends StructBuffer<CUDA_MEMCPY3D_PEER, Buffer>
    implements NativeResource {
        private static final CUDA_MEMCPY3D_PEER ELEMENT_FACTORY = CUDA_MEMCPY3D_PEER.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected CUDA_MEMCPY3D_PEER getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="size_t")
        public long srcXInBytes() {
            return CUDA_MEMCPY3D_PEER.nsrcXInBytes(this.address());
        }

        @NativeType(value="size_t")
        public long srcY() {
            return CUDA_MEMCPY3D_PEER.nsrcY(this.address());
        }

        @NativeType(value="size_t")
        public long srcZ() {
            return CUDA_MEMCPY3D_PEER.nsrcZ(this.address());
        }

        @NativeType(value="size_t")
        public long srcLOD() {
            return CUDA_MEMCPY3D_PEER.nsrcLOD(this.address());
        }

        @NativeType(value="CUmemorytype")
        public int srcMemoryType() {
            return CUDA_MEMCPY3D_PEER.nsrcMemoryType(this.address());
        }

        @Nullable
        @NativeType(value="void const *")
        public ByteBuffer srcHost(int capacity) {
            return CUDA_MEMCPY3D_PEER.nsrcHost(this.address(), capacity);
        }

        @NativeType(value="CUdeviceptr")
        public long srcDevice() {
            return CUDA_MEMCPY3D_PEER.nsrcDevice(this.address());
        }

        @NativeType(value="CUarray")
        public long srcArray() {
            return CUDA_MEMCPY3D_PEER.nsrcArray(this.address());
        }

        @NativeType(value="CUcontext")
        public long srcContext() {
            return CUDA_MEMCPY3D_PEER.nsrcContext(this.address());
        }

        @NativeType(value="size_t")
        public long srcPitch() {
            return CUDA_MEMCPY3D_PEER.nsrcPitch(this.address());
        }

        @NativeType(value="size_t")
        public long srcHeight() {
            return CUDA_MEMCPY3D_PEER.nsrcHeight(this.address());
        }

        @NativeType(value="size_t")
        public long dstXInBytes() {
            return CUDA_MEMCPY3D_PEER.ndstXInBytes(this.address());
        }

        @NativeType(value="size_t")
        public long dstY() {
            return CUDA_MEMCPY3D_PEER.ndstY(this.address());
        }

        @NativeType(value="size_t")
        public long dstZ() {
            return CUDA_MEMCPY3D_PEER.ndstZ(this.address());
        }

        @NativeType(value="size_t")
        public long dstLOD() {
            return CUDA_MEMCPY3D_PEER.ndstLOD(this.address());
        }

        @NativeType(value="CUmemorytype")
        public int dstMemoryType() {
            return CUDA_MEMCPY3D_PEER.ndstMemoryType(this.address());
        }

        @Nullable
        @NativeType(value="void *")
        public ByteBuffer dstHost(int capacity) {
            return CUDA_MEMCPY3D_PEER.ndstHost(this.address(), capacity);
        }

        @NativeType(value="CUdeviceptr")
        public long dstDevice() {
            return CUDA_MEMCPY3D_PEER.ndstDevice(this.address());
        }

        @NativeType(value="CUarray")
        public long dstArray() {
            return CUDA_MEMCPY3D_PEER.ndstArray(this.address());
        }

        @NativeType(value="CUcontext")
        public long dstContext() {
            return CUDA_MEMCPY3D_PEER.ndstContext(this.address());
        }

        @NativeType(value="size_t")
        public long dstPitch() {
            return CUDA_MEMCPY3D_PEER.ndstPitch(this.address());
        }

        @NativeType(value="size_t")
        public long dstHeight() {
            return CUDA_MEMCPY3D_PEER.ndstHeight(this.address());
        }

        @NativeType(value="size_t")
        public long WidthInBytes() {
            return CUDA_MEMCPY3D_PEER.nWidthInBytes(this.address());
        }

        @NativeType(value="size_t")
        public long Height() {
            return CUDA_MEMCPY3D_PEER.nHeight(this.address());
        }

        @NativeType(value="size_t")
        public long Depth() {
            return CUDA_MEMCPY3D_PEER.nDepth(this.address());
        }

        public Buffer srcXInBytes(@NativeType(value="size_t") long value) {
            CUDA_MEMCPY3D_PEER.nsrcXInBytes(this.address(), value);
            return this;
        }

        public Buffer srcY(@NativeType(value="size_t") long value) {
            CUDA_MEMCPY3D_PEER.nsrcY(this.address(), value);
            return this;
        }

        public Buffer srcZ(@NativeType(value="size_t") long value) {
            CUDA_MEMCPY3D_PEER.nsrcZ(this.address(), value);
            return this;
        }

        public Buffer srcLOD(@NativeType(value="size_t") long value) {
            CUDA_MEMCPY3D_PEER.nsrcLOD(this.address(), value);
            return this;
        }

        public Buffer srcMemoryType(@NativeType(value="CUmemorytype") int value) {
            CUDA_MEMCPY3D_PEER.nsrcMemoryType(this.address(), value);
            return this;
        }

        public Buffer srcHost(@Nullable @NativeType(value="void const *") ByteBuffer value) {
            CUDA_MEMCPY3D_PEER.nsrcHost(this.address(), value);
            return this;
        }

        public Buffer srcDevice(@NativeType(value="CUdeviceptr") long value) {
            CUDA_MEMCPY3D_PEER.nsrcDevice(this.address(), value);
            return this;
        }

        public Buffer srcArray(@NativeType(value="CUarray") long value) {
            CUDA_MEMCPY3D_PEER.nsrcArray(this.address(), value);
            return this;
        }

        public Buffer srcContext(@NativeType(value="CUcontext") long value) {
            CUDA_MEMCPY3D_PEER.nsrcContext(this.address(), value);
            return this;
        }

        public Buffer srcPitch(@NativeType(value="size_t") long value) {
            CUDA_MEMCPY3D_PEER.nsrcPitch(this.address(), value);
            return this;
        }

        public Buffer srcHeight(@NativeType(value="size_t") long value) {
            CUDA_MEMCPY3D_PEER.nsrcHeight(this.address(), value);
            return this;
        }

        public Buffer dstXInBytes(@NativeType(value="size_t") long value) {
            CUDA_MEMCPY3D_PEER.ndstXInBytes(this.address(), value);
            return this;
        }

        public Buffer dstY(@NativeType(value="size_t") long value) {
            CUDA_MEMCPY3D_PEER.ndstY(this.address(), value);
            return this;
        }

        public Buffer dstZ(@NativeType(value="size_t") long value) {
            CUDA_MEMCPY3D_PEER.ndstZ(this.address(), value);
            return this;
        }

        public Buffer dstLOD(@NativeType(value="size_t") long value) {
            CUDA_MEMCPY3D_PEER.ndstLOD(this.address(), value);
            return this;
        }

        public Buffer dstMemoryType(@NativeType(value="CUmemorytype") int value) {
            CUDA_MEMCPY3D_PEER.ndstMemoryType(this.address(), value);
            return this;
        }

        public Buffer dstHost(@Nullable @NativeType(value="void *") ByteBuffer value) {
            CUDA_MEMCPY3D_PEER.ndstHost(this.address(), value);
            return this;
        }

        public Buffer dstDevice(@NativeType(value="CUdeviceptr") long value) {
            CUDA_MEMCPY3D_PEER.ndstDevice(this.address(), value);
            return this;
        }

        public Buffer dstArray(@NativeType(value="CUarray") long value) {
            CUDA_MEMCPY3D_PEER.ndstArray(this.address(), value);
            return this;
        }

        public Buffer dstContext(@NativeType(value="CUcontext") long value) {
            CUDA_MEMCPY3D_PEER.ndstContext(this.address(), value);
            return this;
        }

        public Buffer dstPitch(@NativeType(value="size_t") long value) {
            CUDA_MEMCPY3D_PEER.ndstPitch(this.address(), value);
            return this;
        }

        public Buffer dstHeight(@NativeType(value="size_t") long value) {
            CUDA_MEMCPY3D_PEER.ndstHeight(this.address(), value);
            return this;
        }

        public Buffer WidthInBytes(@NativeType(value="size_t") long value) {
            CUDA_MEMCPY3D_PEER.nWidthInBytes(this.address(), value);
            return this;
        }

        public Buffer Height(@NativeType(value="size_t") long value) {
            CUDA_MEMCPY3D_PEER.nHeight(this.address(), value);
            return this;
        }

        public Buffer Depth(@NativeType(value="size_t") long value) {
            CUDA_MEMCPY3D_PEER.nDepth(this.address(), value);
            return this;
        }
    }
}

