/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUDA_MEMCPY2D
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SRCXINBYTES;
    public static final int SRCY;
    public static final int SRCMEMORYTYPE;
    public static final int SRCHOST;
    public static final int SRCDEVICE;
    public static final int SRCARRAY;
    public static final int SRCPITCH;
    public static final int DSTXINBYTES;
    public static final int DSTY;
    public static final int DSTMEMORYTYPE;
    public static final int DSTHOST;
    public static final int DSTDEVICE;
    public static final int DSTARRAY;
    public static final int DSTPITCH;
    public static final int WIDTHINBYTES;
    public static final int HEIGHT;

    public CUDA_MEMCPY2D(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CUDA_MEMCPY2D.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="size_t")
    public long srcXInBytes() {
        return CUDA_MEMCPY2D.nsrcXInBytes(this.address());
    }

    @NativeType(value="size_t")
    public long srcY() {
        return CUDA_MEMCPY2D.nsrcY(this.address());
    }

    @NativeType(value="CUmemorytype")
    public int srcMemoryType() {
        return CUDA_MEMCPY2D.nsrcMemoryType(this.address());
    }

    @Nullable
    @NativeType(value="void const *")
    public ByteBuffer srcHost(int capacity) {
        return CUDA_MEMCPY2D.nsrcHost(this.address(), capacity);
    }

    @NativeType(value="CUdeviceptr")
    public long srcDevice() {
        return CUDA_MEMCPY2D.nsrcDevice(this.address());
    }

    @NativeType(value="CUarray")
    public long srcArray() {
        return CUDA_MEMCPY2D.nsrcArray(this.address());
    }

    @NativeType(value="size_t")
    public long srcPitch() {
        return CUDA_MEMCPY2D.nsrcPitch(this.address());
    }

    @NativeType(value="size_t")
    public long dstXInBytes() {
        return CUDA_MEMCPY2D.ndstXInBytes(this.address());
    }

    @NativeType(value="size_t")
    public long dstY() {
        return CUDA_MEMCPY2D.ndstY(this.address());
    }

    @NativeType(value="CUmemorytype")
    public int dstMemoryType() {
        return CUDA_MEMCPY2D.ndstMemoryType(this.address());
    }

    @Nullable
    @NativeType(value="void *")
    public ByteBuffer dstHost(int capacity) {
        return CUDA_MEMCPY2D.ndstHost(this.address(), capacity);
    }

    @NativeType(value="CUdeviceptr")
    public long dstDevice() {
        return CUDA_MEMCPY2D.ndstDevice(this.address());
    }

    @NativeType(value="CUarray")
    public long dstArray() {
        return CUDA_MEMCPY2D.ndstArray(this.address());
    }

    @NativeType(value="size_t")
    public long dstPitch() {
        return CUDA_MEMCPY2D.ndstPitch(this.address());
    }

    @NativeType(value="size_t")
    public long WidthInBytes() {
        return CUDA_MEMCPY2D.nWidthInBytes(this.address());
    }

    @NativeType(value="size_t")
    public long Height() {
        return CUDA_MEMCPY2D.nHeight(this.address());
    }

    public CUDA_MEMCPY2D srcXInBytes(@NativeType(value="size_t") long value) {
        CUDA_MEMCPY2D.nsrcXInBytes(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY2D srcY(@NativeType(value="size_t") long value) {
        CUDA_MEMCPY2D.nsrcY(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY2D srcMemoryType(@NativeType(value="CUmemorytype") int value) {
        CUDA_MEMCPY2D.nsrcMemoryType(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY2D srcHost(@Nullable @NativeType(value="void const *") ByteBuffer value) {
        CUDA_MEMCPY2D.nsrcHost(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY2D srcDevice(@NativeType(value="CUdeviceptr") long value) {
        CUDA_MEMCPY2D.nsrcDevice(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY2D srcArray(@NativeType(value="CUarray") long value) {
        CUDA_MEMCPY2D.nsrcArray(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY2D srcPitch(@NativeType(value="size_t") long value) {
        CUDA_MEMCPY2D.nsrcPitch(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY2D dstXInBytes(@NativeType(value="size_t") long value) {
        CUDA_MEMCPY2D.ndstXInBytes(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY2D dstY(@NativeType(value="size_t") long value) {
        CUDA_MEMCPY2D.ndstY(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY2D dstMemoryType(@NativeType(value="CUmemorytype") int value) {
        CUDA_MEMCPY2D.ndstMemoryType(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY2D dstHost(@Nullable @NativeType(value="void *") ByteBuffer value) {
        CUDA_MEMCPY2D.ndstHost(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY2D dstDevice(@NativeType(value="CUdeviceptr") long value) {
        CUDA_MEMCPY2D.ndstDevice(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY2D dstArray(@NativeType(value="CUarray") long value) {
        CUDA_MEMCPY2D.ndstArray(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY2D dstPitch(@NativeType(value="size_t") long value) {
        CUDA_MEMCPY2D.ndstPitch(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY2D WidthInBytes(@NativeType(value="size_t") long value) {
        CUDA_MEMCPY2D.nWidthInBytes(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY2D Height(@NativeType(value="size_t") long value) {
        CUDA_MEMCPY2D.nHeight(this.address(), value);
        return this;
    }

    public CUDA_MEMCPY2D set(long srcXInBytes, long srcY, int srcMemoryType, @Nullable ByteBuffer srcHost, long srcDevice, long srcArray, long srcPitch, long dstXInBytes, long dstY, int dstMemoryType, @Nullable ByteBuffer dstHost, long dstDevice, long dstArray, long dstPitch, long WidthInBytes, long Height) {
        this.srcXInBytes(srcXInBytes);
        this.srcY(srcY);
        this.srcMemoryType(srcMemoryType);
        this.srcHost(srcHost);
        this.srcDevice(srcDevice);
        this.srcArray(srcArray);
        this.srcPitch(srcPitch);
        this.dstXInBytes(dstXInBytes);
        this.dstY(dstY);
        this.dstMemoryType(dstMemoryType);
        this.dstHost(dstHost);
        this.dstDevice(dstDevice);
        this.dstArray(dstArray);
        this.dstPitch(dstPitch);
        this.WidthInBytes(WidthInBytes);
        this.Height(Height);
        return this;
    }

    public CUDA_MEMCPY2D set(CUDA_MEMCPY2D src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static CUDA_MEMCPY2D malloc() {
        return CUDA_MEMCPY2D.wrap(CUDA_MEMCPY2D.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static CUDA_MEMCPY2D calloc() {
        return CUDA_MEMCPY2D.wrap(CUDA_MEMCPY2D.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static CUDA_MEMCPY2D create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return CUDA_MEMCPY2D.wrap(CUDA_MEMCPY2D.class, MemoryUtil.memAddress(container), container);
    }

    public static CUDA_MEMCPY2D create(long address) {
        return CUDA_MEMCPY2D.wrap(CUDA_MEMCPY2D.class, address);
    }

    @Nullable
    public static CUDA_MEMCPY2D createSafe(long address) {
        return address == 0L ? null : CUDA_MEMCPY2D.wrap(CUDA_MEMCPY2D.class, address);
    }

    public static Buffer malloc(int capacity) {
        return CUDA_MEMCPY2D.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(CUDA_MEMCPY2D.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return CUDA_MEMCPY2D.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUDA_MEMCPY2D.__create(capacity, SIZEOF);
        return CUDA_MEMCPY2D.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return CUDA_MEMCPY2D.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : CUDA_MEMCPY2D.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static CUDA_MEMCPY2D mallocStack() {
        return CUDA_MEMCPY2D.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CUDA_MEMCPY2D callocStack() {
        return CUDA_MEMCPY2D.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CUDA_MEMCPY2D mallocStack(MemoryStack stack) {
        return CUDA_MEMCPY2D.malloc(stack);
    }

    @Deprecated
    public static CUDA_MEMCPY2D callocStack(MemoryStack stack) {
        return CUDA_MEMCPY2D.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CUDA_MEMCPY2D.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CUDA_MEMCPY2D.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CUDA_MEMCPY2D.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CUDA_MEMCPY2D.calloc(capacity, stack);
    }

    public static CUDA_MEMCPY2D malloc(MemoryStack stack) {
        return CUDA_MEMCPY2D.wrap(CUDA_MEMCPY2D.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CUDA_MEMCPY2D calloc(MemoryStack stack) {
        return CUDA_MEMCPY2D.wrap(CUDA_MEMCPY2D.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return CUDA_MEMCPY2D.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return CUDA_MEMCPY2D.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nsrcXInBytes(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SRCXINBYTES);
    }

    public static long nsrcY(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SRCY);
    }

    public static int nsrcMemoryType(long struct) {
        return UNSAFE.getInt(null, struct + (long)SRCMEMORYTYPE);
    }

    @Nullable
    public static ByteBuffer nsrcHost(long struct, int capacity) {
        return MemoryUtil.memByteBufferSafe(MemoryUtil.memGetAddress(struct + (long)SRCHOST), capacity);
    }

    public static long nsrcDevice(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SRCDEVICE);
    }

    public static long nsrcArray(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SRCARRAY);
    }

    public static long nsrcPitch(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SRCPITCH);
    }

    public static long ndstXInBytes(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)DSTXINBYTES);
    }

    public static long ndstY(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)DSTY);
    }

    public static int ndstMemoryType(long struct) {
        return UNSAFE.getInt(null, struct + (long)DSTMEMORYTYPE);
    }

    @Nullable
    public static ByteBuffer ndstHost(long struct, int capacity) {
        return MemoryUtil.memByteBufferSafe(MemoryUtil.memGetAddress(struct + (long)DSTHOST), capacity);
    }

    public static long ndstDevice(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)DSTDEVICE);
    }

    public static long ndstArray(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)DSTARRAY);
    }

    public static long ndstPitch(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)DSTPITCH);
    }

    public static long nWidthInBytes(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)WIDTHINBYTES);
    }

    public static long nHeight(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)HEIGHT);
    }

    public static void nsrcXInBytes(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)SRCXINBYTES, value);
    }

    public static void nsrcY(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)SRCY, value);
    }

    public static void nsrcMemoryType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SRCMEMORYTYPE, value);
    }

    public static void nsrcHost(long struct, @Nullable ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)SRCHOST, MemoryUtil.memAddressSafe(value));
    }

    public static void nsrcDevice(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)SRCDEVICE, value);
    }

    public static void nsrcArray(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)SRCARRAY, value);
    }

    public static void nsrcPitch(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)SRCPITCH, value);
    }

    public static void ndstXInBytes(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)DSTXINBYTES, value);
    }

    public static void ndstY(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)DSTY, value);
    }

    public static void ndstMemoryType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DSTMEMORYTYPE, value);
    }

    public static void ndstHost(long struct, @Nullable ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)DSTHOST, MemoryUtil.memAddressSafe(value));
    }

    public static void ndstDevice(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)DSTDEVICE, value);
    }

    public static void ndstArray(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)DSTARRAY, value);
    }

    public static void ndstPitch(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)DSTPITCH, value);
    }

    public static void nWidthInBytes(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)WIDTHINBYTES, value);
    }

    public static void nHeight(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)HEIGHT, value);
    }

    static {
        Struct.Layout layout = CUDA_MEMCPY2D.__struct(CUDA_MEMCPY2D.__member(POINTER_SIZE), CUDA_MEMCPY2D.__member(POINTER_SIZE), CUDA_MEMCPY2D.__member(4), CUDA_MEMCPY2D.__member(POINTER_SIZE), CUDA_MEMCPY2D.__member(POINTER_SIZE), CUDA_MEMCPY2D.__member(POINTER_SIZE), CUDA_MEMCPY2D.__member(POINTER_SIZE), CUDA_MEMCPY2D.__member(POINTER_SIZE), CUDA_MEMCPY2D.__member(POINTER_SIZE), CUDA_MEMCPY2D.__member(4), CUDA_MEMCPY2D.__member(POINTER_SIZE), CUDA_MEMCPY2D.__member(POINTER_SIZE), CUDA_MEMCPY2D.__member(POINTER_SIZE), CUDA_MEMCPY2D.__member(POINTER_SIZE), CUDA_MEMCPY2D.__member(POINTER_SIZE), CUDA_MEMCPY2D.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SRCXINBYTES = layout.offsetof(0);
        SRCY = layout.offsetof(1);
        SRCMEMORYTYPE = layout.offsetof(2);
        SRCHOST = layout.offsetof(3);
        SRCDEVICE = layout.offsetof(4);
        SRCARRAY = layout.offsetof(5);
        SRCPITCH = layout.offsetof(6);
        DSTXINBYTES = layout.offsetof(7);
        DSTY = layout.offsetof(8);
        DSTMEMORYTYPE = layout.offsetof(9);
        DSTHOST = layout.offsetof(10);
        DSTDEVICE = layout.offsetof(11);
        DSTARRAY = layout.offsetof(12);
        DSTPITCH = layout.offsetof(13);
        WIDTHINBYTES = layout.offsetof(14);
        HEIGHT = layout.offsetof(15);
    }

    public static class Buffer
    extends StructBuffer<CUDA_MEMCPY2D, Buffer>
    implements NativeResource {
        private static final CUDA_MEMCPY2D ELEMENT_FACTORY = CUDA_MEMCPY2D.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected CUDA_MEMCPY2D getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="size_t")
        public long srcXInBytes() {
            return CUDA_MEMCPY2D.nsrcXInBytes(this.address());
        }

        @NativeType(value="size_t")
        public long srcY() {
            return CUDA_MEMCPY2D.nsrcY(this.address());
        }

        @NativeType(value="CUmemorytype")
        public int srcMemoryType() {
            return CUDA_MEMCPY2D.nsrcMemoryType(this.address());
        }

        @Nullable
        @NativeType(value="void const *")
        public ByteBuffer srcHost(int capacity) {
            return CUDA_MEMCPY2D.nsrcHost(this.address(), capacity);
        }

        @NativeType(value="CUdeviceptr")
        public long srcDevice() {
            return CUDA_MEMCPY2D.nsrcDevice(this.address());
        }

        @NativeType(value="CUarray")
        public long srcArray() {
            return CUDA_MEMCPY2D.nsrcArray(this.address());
        }

        @NativeType(value="size_t")
        public long srcPitch() {
            return CUDA_MEMCPY2D.nsrcPitch(this.address());
        }

        @NativeType(value="size_t")
        public long dstXInBytes() {
            return CUDA_MEMCPY2D.ndstXInBytes(this.address());
        }

        @NativeType(value="size_t")
        public long dstY() {
            return CUDA_MEMCPY2D.ndstY(this.address());
        }

        @NativeType(value="CUmemorytype")
        public int dstMemoryType() {
            return CUDA_MEMCPY2D.ndstMemoryType(this.address());
        }

        @Nullable
        @NativeType(value="void *")
        public ByteBuffer dstHost(int capacity) {
            return CUDA_MEMCPY2D.ndstHost(this.address(), capacity);
        }

        @NativeType(value="CUdeviceptr")
        public long dstDevice() {
            return CUDA_MEMCPY2D.ndstDevice(this.address());
        }

        @NativeType(value="CUarray")
        public long dstArray() {
            return CUDA_MEMCPY2D.ndstArray(this.address());
        }

        @NativeType(value="size_t")
        public long dstPitch() {
            return CUDA_MEMCPY2D.ndstPitch(this.address());
        }

        @NativeType(value="size_t")
        public long WidthInBytes() {
            return CUDA_MEMCPY2D.nWidthInBytes(this.address());
        }

        @NativeType(value="size_t")
        public long Height() {
            return CUDA_MEMCPY2D.nHeight(this.address());
        }

        public Buffer srcXInBytes(@NativeType(value="size_t") long value) {
            CUDA_MEMCPY2D.nsrcXInBytes(this.address(), value);
            return this;
        }

        public Buffer srcY(@NativeType(value="size_t") long value) {
            CUDA_MEMCPY2D.nsrcY(this.address(), value);
            return this;
        }

        public Buffer srcMemoryType(@NativeType(value="CUmemorytype") int value) {
            CUDA_MEMCPY2D.nsrcMemoryType(this.address(), value);
            return this;
        }

        public Buffer srcHost(@Nullable @NativeType(value="void const *") ByteBuffer value) {
            CUDA_MEMCPY2D.nsrcHost(this.address(), value);
            return this;
        }

        public Buffer srcDevice(@NativeType(value="CUdeviceptr") long value) {
            CUDA_MEMCPY2D.nsrcDevice(this.address(), value);
            return this;
        }

        public Buffer srcArray(@NativeType(value="CUarray") long value) {
            CUDA_MEMCPY2D.nsrcArray(this.address(), value);
            return this;
        }

        public Buffer srcPitch(@NativeType(value="size_t") long value) {
            CUDA_MEMCPY2D.nsrcPitch(this.address(), value);
            return this;
        }

        public Buffer dstXInBytes(@NativeType(value="size_t") long value) {
            CUDA_MEMCPY2D.ndstXInBytes(this.address(), value);
            return this;
        }

        public Buffer dstY(@NativeType(value="size_t") long value) {
            CUDA_MEMCPY2D.ndstY(this.address(), value);
            return this;
        }

        public Buffer dstMemoryType(@NativeType(value="CUmemorytype") int value) {
            CUDA_MEMCPY2D.ndstMemoryType(this.address(), value);
            return this;
        }

        public Buffer dstHost(@Nullable @NativeType(value="void *") ByteBuffer value) {
            CUDA_MEMCPY2D.ndstHost(this.address(), value);
            return this;
        }

        public Buffer dstDevice(@NativeType(value="CUdeviceptr") long value) {
            CUDA_MEMCPY2D.ndstDevice(this.address(), value);
            return this;
        }

        public Buffer dstArray(@NativeType(value="CUarray") long value) {
            CUDA_MEMCPY2D.ndstArray(this.address(), value);
            return this;
        }

        public Buffer dstPitch(@NativeType(value="size_t") long value) {
            CUDA_MEMCPY2D.ndstPitch(this.address(), value);
            return this;
        }

        public Buffer WidthInBytes(@NativeType(value="size_t") long value) {
            CUDA_MEMCPY2D.nWidthInBytes(this.address(), value);
            return this;
        }

        public Buffer Height(@NativeType(value="size_t") long value) {
            CUDA_MEMCPY2D.nHeight(this.address(), value);
            return this;
        }
    }
}

