/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import org.lwjgl.cuda.CU;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class CUDAProfiler {
    public static final int CU_OUT_KEY_VALUE_PAIR = 0;
    public static final int CU_OUT_CSV = 1;

    protected CUDAProfiler() {
        throw new UnsupportedOperationException();
    }

    public static int ncuProfilerInitialize(long configFile, long outputFile, int outputMode) {
        long __functionAddress = Functions.ProfilerInitialize;
        return JNI.callPPI(configFile, outputFile, outputMode, __functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuProfilerInitialize(@NativeType(value="char const *") ByteBuffer configFile, @NativeType(value="char const *") ByteBuffer outputFile, @NativeType(value="CUoutput_mode") int outputMode) {
        if (Checks.CHECKS) {
            Checks.checkNT1(configFile);
            Checks.checkNT1(outputFile);
        }
        return CUDAProfiler.ncuProfilerInitialize(MemoryUtil.memAddress(configFile), MemoryUtil.memAddress(outputFile), outputMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="CUresult")
    public static int cuProfilerInitialize(@NativeType(value="char const *") CharSequence configFile, @NativeType(value="char const *") CharSequence outputFile, @NativeType(value="CUoutput_mode") int outputMode) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(configFile, true);
            long configFileEncoded = stack.getPointerAddress();
            stack.nASCII(outputFile, true);
            long outputFileEncoded = stack.getPointerAddress();
            int n = CUDAProfiler.ncuProfilerInitialize(configFileEncoded, outputFileEncoded, outputMode);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="CUresult")
    public static int cuProfilerStart() {
        long __functionAddress = Functions.ProfilerStart;
        return JNI.callI(__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuProfilerStop() {
        long __functionAddress = Functions.ProfilerStop;
        return JNI.callI(__functionAddress);
    }

    public static final class Functions {
        public static final long ProfilerInitialize = APIUtil.apiGetFunctionAddress(CU.getLibrary(), "cuProfilerInitialize");
        public static final long ProfilerStart = APIUtil.apiGetFunctionAddress(CU.getLibrary(), "cuProfilerStart");
        public static final long ProfilerStop = APIUtil.apiGetFunctionAddress(CU.getLibrary(), "cuProfilerStop");

        private Functions() {
        }
    }
}

