/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct bgfx_vertex_layout_t")
public class BGFXVertexLayout
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HASH;
    public static final int STRIDE;
    public static final int OFFSET;
    public static final int ATTRIBUTES;

    public BGFXVertexLayout(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), BGFXVertexLayout.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int hash() {
        return BGFXVertexLayout.nhash(this.address());
    }

    @NativeType(value="uint16_t")
    public short stride() {
        return BGFXVertexLayout.nstride(this.address());
    }

    @NativeType(value="uint16_t[BGFX_ATTRIB_COUNT]")
    public ShortBuffer offset() {
        return BGFXVertexLayout.noffset(this.address());
    }

    @NativeType(value="uint16_t")
    public short offset(int index) {
        return BGFXVertexLayout.noffset(this.address(), index);
    }

    @NativeType(value="uint16_t[BGFX_ATTRIB_COUNT]")
    public ShortBuffer attributes() {
        return BGFXVertexLayout.nattributes(this.address());
    }

    @NativeType(value="uint16_t")
    public short attributes(int index) {
        return BGFXVertexLayout.nattributes(this.address(), index);
    }

    public BGFXVertexLayout hash(@NativeType(value="uint32_t") int value) {
        BGFXVertexLayout.nhash(this.address(), value);
        return this;
    }

    public BGFXVertexLayout stride(@NativeType(value="uint16_t") short value) {
        BGFXVertexLayout.nstride(this.address(), value);
        return this;
    }

    public BGFXVertexLayout offset(@NativeType(value="uint16_t[BGFX_ATTRIB_COUNT]") ShortBuffer value) {
        BGFXVertexLayout.noffset(this.address(), value);
        return this;
    }

    public BGFXVertexLayout offset(int index, @NativeType(value="uint16_t") short value) {
        BGFXVertexLayout.noffset(this.address(), index, value);
        return this;
    }

    public BGFXVertexLayout attributes(@NativeType(value="uint16_t[BGFX_ATTRIB_COUNT]") ShortBuffer value) {
        BGFXVertexLayout.nattributes(this.address(), value);
        return this;
    }

    public BGFXVertexLayout attributes(int index, @NativeType(value="uint16_t") short value) {
        BGFXVertexLayout.nattributes(this.address(), index, value);
        return this;
    }

    public BGFXVertexLayout set(int hash, short stride, ShortBuffer offset, ShortBuffer attributes) {
        this.hash(hash);
        this.stride(stride);
        this.offset(offset);
        this.attributes(attributes);
        return this;
    }

    public BGFXVertexLayout set(BGFXVertexLayout src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static BGFXVertexLayout malloc() {
        return BGFXVertexLayout.wrap(BGFXVertexLayout.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static BGFXVertexLayout calloc() {
        return BGFXVertexLayout.wrap(BGFXVertexLayout.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static BGFXVertexLayout create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return BGFXVertexLayout.wrap(BGFXVertexLayout.class, MemoryUtil.memAddress(container), container);
    }

    public static BGFXVertexLayout create(long address) {
        return BGFXVertexLayout.wrap(BGFXVertexLayout.class, address);
    }

    @Nullable
    public static BGFXVertexLayout createSafe(long address) {
        return address == 0L ? null : BGFXVertexLayout.wrap(BGFXVertexLayout.class, address);
    }

    public static Buffer malloc(int capacity) {
        return BGFXVertexLayout.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(BGFXVertexLayout.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return BGFXVertexLayout.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = BGFXVertexLayout.__create(capacity, SIZEOF);
        return BGFXVertexLayout.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return BGFXVertexLayout.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : BGFXVertexLayout.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static BGFXVertexLayout mallocStack() {
        return BGFXVertexLayout.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static BGFXVertexLayout callocStack() {
        return BGFXVertexLayout.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static BGFXVertexLayout mallocStack(MemoryStack stack) {
        return BGFXVertexLayout.malloc(stack);
    }

    @Deprecated
    public static BGFXVertexLayout callocStack(MemoryStack stack) {
        return BGFXVertexLayout.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return BGFXVertexLayout.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return BGFXVertexLayout.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return BGFXVertexLayout.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return BGFXVertexLayout.calloc(capacity, stack);
    }

    public static BGFXVertexLayout malloc(MemoryStack stack) {
        return BGFXVertexLayout.wrap(BGFXVertexLayout.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static BGFXVertexLayout calloc(MemoryStack stack) {
        return BGFXVertexLayout.wrap(BGFXVertexLayout.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return BGFXVertexLayout.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return BGFXVertexLayout.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nhash(long struct) {
        return UNSAFE.getInt(null, struct + (long)HASH);
    }

    public static short nstride(long struct) {
        return UNSAFE.getShort(null, struct + (long)STRIDE);
    }

    public static ShortBuffer noffset(long struct) {
        return MemoryUtil.memShortBuffer(struct + (long)OFFSET, 18);
    }

    public static short noffset(long struct, int index) {
        return UNSAFE.getShort(null, struct + (long)OFFSET + Checks.check(index, 18) * 2L);
    }

    public static ShortBuffer nattributes(long struct) {
        return MemoryUtil.memShortBuffer(struct + (long)ATTRIBUTES, 18);
    }

    public static short nattributes(long struct, int index) {
        return UNSAFE.getShort(null, struct + (long)ATTRIBUTES + Checks.check(index, 18) * 2L);
    }

    public static void nhash(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)HASH, value);
    }

    public static void nstride(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)STRIDE, value);
    }

    public static void noffset(long struct, ShortBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 18);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)OFFSET, value.remaining() * 2);
    }

    public static void noffset(long struct, int index, short value) {
        UNSAFE.putShort(null, struct + (long)OFFSET + Checks.check(index, 18) * 2L, value);
    }

    public static void nattributes(long struct, ShortBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 18);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)ATTRIBUTES, value.remaining() * 2);
    }

    public static void nattributes(long struct, int index, short value) {
        UNSAFE.putShort(null, struct + (long)ATTRIBUTES + Checks.check(index, 18) * 2L, value);
    }

    static {
        Struct.Layout layout = BGFXVertexLayout.__struct(BGFXVertexLayout.__member(4), BGFXVertexLayout.__member(2), BGFXVertexLayout.__array(2, 18), BGFXVertexLayout.__array(2, 18));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        HASH = layout.offsetof(0);
        STRIDE = layout.offsetof(1);
        OFFSET = layout.offsetof(2);
        ATTRIBUTES = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<BGFXVertexLayout, Buffer>
    implements NativeResource {
        private static final BGFXVertexLayout ELEMENT_FACTORY = BGFXVertexLayout.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected BGFXVertexLayout getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int hash() {
            return BGFXVertexLayout.nhash(this.address());
        }

        @NativeType(value="uint16_t")
        public short stride() {
            return BGFXVertexLayout.nstride(this.address());
        }

        @NativeType(value="uint16_t[BGFX_ATTRIB_COUNT]")
        public ShortBuffer offset() {
            return BGFXVertexLayout.noffset(this.address());
        }

        @NativeType(value="uint16_t")
        public short offset(int index) {
            return BGFXVertexLayout.noffset(this.address(), index);
        }

        @NativeType(value="uint16_t[BGFX_ATTRIB_COUNT]")
        public ShortBuffer attributes() {
            return BGFXVertexLayout.nattributes(this.address());
        }

        @NativeType(value="uint16_t")
        public short attributes(int index) {
            return BGFXVertexLayout.nattributes(this.address(), index);
        }

        public Buffer hash(@NativeType(value="uint32_t") int value) {
            BGFXVertexLayout.nhash(this.address(), value);
            return this;
        }

        public Buffer stride(@NativeType(value="uint16_t") short value) {
            BGFXVertexLayout.nstride(this.address(), value);
            return this;
        }

        public Buffer offset(@NativeType(value="uint16_t[BGFX_ATTRIB_COUNT]") ShortBuffer value) {
            BGFXVertexLayout.noffset(this.address(), value);
            return this;
        }

        public Buffer offset(int index, @NativeType(value="uint16_t") short value) {
            BGFXVertexLayout.noffset(this.address(), index, value);
            return this;
        }

        public Buffer attributes(@NativeType(value="uint16_t[BGFX_ATTRIB_COUNT]") ShortBuffer value) {
            BGFXVertexLayout.nattributes(this.address(), value);
            return this;
        }

        public Buffer attributes(int index, @NativeType(value="uint16_t") short value) {
            BGFXVertexLayout.nattributes(this.address(), index, value);
            return this;
        }
    }
}

