/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct bgfx_transform_t")
public class BGFXTransform
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DATA;
    public static final int NUM;

    public BGFXTransform(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), BGFXTransform.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="float *")
    public FloatBuffer data() {
        return BGFXTransform.ndata(this.address());
    }

    @NativeType(value="uint16_t")
    public short num() {
        return BGFXTransform.nnum(this.address());
    }

    public static BGFXTransform malloc() {
        return BGFXTransform.wrap(BGFXTransform.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static BGFXTransform calloc() {
        return BGFXTransform.wrap(BGFXTransform.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static BGFXTransform create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return BGFXTransform.wrap(BGFXTransform.class, MemoryUtil.memAddress(container), container);
    }

    public static BGFXTransform create(long address) {
        return BGFXTransform.wrap(BGFXTransform.class, address);
    }

    @Nullable
    public static BGFXTransform createSafe(long address) {
        return address == 0L ? null : BGFXTransform.wrap(BGFXTransform.class, address);
    }

    public static Buffer malloc(int capacity) {
        return BGFXTransform.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(BGFXTransform.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return BGFXTransform.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = BGFXTransform.__create(capacity, SIZEOF);
        return BGFXTransform.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return BGFXTransform.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : BGFXTransform.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static BGFXTransform mallocStack() {
        return BGFXTransform.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static BGFXTransform callocStack() {
        return BGFXTransform.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static BGFXTransform mallocStack(MemoryStack stack) {
        return BGFXTransform.malloc(stack);
    }

    @Deprecated
    public static BGFXTransform callocStack(MemoryStack stack) {
        return BGFXTransform.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return BGFXTransform.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return BGFXTransform.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return BGFXTransform.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return BGFXTransform.calloc(capacity, stack);
    }

    public static BGFXTransform malloc(MemoryStack stack) {
        return BGFXTransform.wrap(BGFXTransform.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static BGFXTransform calloc(MemoryStack stack) {
        return BGFXTransform.wrap(BGFXTransform.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return BGFXTransform.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return BGFXTransform.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static FloatBuffer ndata(long struct) {
        return MemoryUtil.memFloatBuffer(MemoryUtil.memGetAddress(struct + (long)DATA), Short.toUnsignedInt(BGFXTransform.nnum(struct)) << 4);
    }

    public static short nnum(long struct) {
        return UNSAFE.getShort(null, struct + (long)NUM);
    }

    static {
        Struct.Layout layout = BGFXTransform.__struct(BGFXTransform.__member(POINTER_SIZE), BGFXTransform.__member(2));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DATA = layout.offsetof(0);
        NUM = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<BGFXTransform, Buffer>
    implements NativeResource {
        private static final BGFXTransform ELEMENT_FACTORY = BGFXTransform.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected BGFXTransform getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="float *")
        public FloatBuffer data() {
            return BGFXTransform.ndata(this.address());
        }

        @NativeType(value="uint16_t")
        public short num() {
            return BGFXTransform.nnum(this.address());
        }
    }
}

