/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct bgfx_texture_info_t")
public class BGFXTextureInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FORMAT;
    public static final int STORAGESIZE;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int DEPTH;
    public static final int NUMLAYERS;
    public static final int NUMMIPS;
    public static final int BITSPERPIXEL;
    public static final int CUBEMAP;

    public BGFXTextureInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), BGFXTextureInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="bgfx_texture_format_t")
    public int format() {
        return BGFXTextureInfo.nformat(this.address());
    }

    @NativeType(value="uint32_t")
    public int storageSize() {
        return BGFXTextureInfo.nstorageSize(this.address());
    }

    @NativeType(value="uint16_t")
    public short width() {
        return BGFXTextureInfo.nwidth(this.address());
    }

    @NativeType(value="uint16_t")
    public short height() {
        return BGFXTextureInfo.nheight(this.address());
    }

    @NativeType(value="uint16_t")
    public short depth() {
        return BGFXTextureInfo.ndepth(this.address());
    }

    @NativeType(value="uint16_t")
    public short numLayers() {
        return BGFXTextureInfo.nnumLayers(this.address());
    }

    @NativeType(value="uint8_t")
    public byte numMips() {
        return BGFXTextureInfo.nnumMips(this.address());
    }

    @NativeType(value="uint8_t")
    public byte bitsPerPixel() {
        return BGFXTextureInfo.nbitsPerPixel(this.address());
    }

    @NativeType(value="bool")
    public boolean cubeMap() {
        return BGFXTextureInfo.ncubeMap(this.address());
    }

    public static BGFXTextureInfo malloc() {
        return BGFXTextureInfo.wrap(BGFXTextureInfo.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static BGFXTextureInfo calloc() {
        return BGFXTextureInfo.wrap(BGFXTextureInfo.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static BGFXTextureInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return BGFXTextureInfo.wrap(BGFXTextureInfo.class, MemoryUtil.memAddress(container), container);
    }

    public static BGFXTextureInfo create(long address) {
        return BGFXTextureInfo.wrap(BGFXTextureInfo.class, address);
    }

    @Nullable
    public static BGFXTextureInfo createSafe(long address) {
        return address == 0L ? null : BGFXTextureInfo.wrap(BGFXTextureInfo.class, address);
    }

    public static Buffer malloc(int capacity) {
        return BGFXTextureInfo.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(BGFXTextureInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return BGFXTextureInfo.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = BGFXTextureInfo.__create(capacity, SIZEOF);
        return BGFXTextureInfo.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return BGFXTextureInfo.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : BGFXTextureInfo.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static BGFXTextureInfo mallocStack() {
        return BGFXTextureInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static BGFXTextureInfo callocStack() {
        return BGFXTextureInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static BGFXTextureInfo mallocStack(MemoryStack stack) {
        return BGFXTextureInfo.malloc(stack);
    }

    @Deprecated
    public static BGFXTextureInfo callocStack(MemoryStack stack) {
        return BGFXTextureInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return BGFXTextureInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return BGFXTextureInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return BGFXTextureInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return BGFXTextureInfo.calloc(capacity, stack);
    }

    public static BGFXTextureInfo malloc(MemoryStack stack) {
        return BGFXTextureInfo.wrap(BGFXTextureInfo.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static BGFXTextureInfo calloc(MemoryStack stack) {
        return BGFXTextureInfo.wrap(BGFXTextureInfo.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return BGFXTextureInfo.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return BGFXTextureInfo.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nformat(long struct) {
        return UNSAFE.getInt(null, struct + (long)FORMAT);
    }

    public static int nstorageSize(long struct) {
        return UNSAFE.getInt(null, struct + (long)STORAGESIZE);
    }

    public static short nwidth(long struct) {
        return UNSAFE.getShort(null, struct + (long)WIDTH);
    }

    public static short nheight(long struct) {
        return UNSAFE.getShort(null, struct + (long)HEIGHT);
    }

    public static short ndepth(long struct) {
        return UNSAFE.getShort(null, struct + (long)DEPTH);
    }

    public static short nnumLayers(long struct) {
        return UNSAFE.getShort(null, struct + (long)NUMLAYERS);
    }

    public static byte nnumMips(long struct) {
        return UNSAFE.getByte(null, struct + (long)NUMMIPS);
    }

    public static byte nbitsPerPixel(long struct) {
        return UNSAFE.getByte(null, struct + (long)BITSPERPIXEL);
    }

    public static boolean ncubeMap(long struct) {
        return UNSAFE.getByte(null, struct + (long)CUBEMAP) != 0;
    }

    static {
        Struct.Layout layout = BGFXTextureInfo.__struct(BGFXTextureInfo.__member(4), BGFXTextureInfo.__member(4), BGFXTextureInfo.__member(2), BGFXTextureInfo.__member(2), BGFXTextureInfo.__member(2), BGFXTextureInfo.__member(2), BGFXTextureInfo.__member(1), BGFXTextureInfo.__member(1), BGFXTextureInfo.__member(1));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FORMAT = layout.offsetof(0);
        STORAGESIZE = layout.offsetof(1);
        WIDTH = layout.offsetof(2);
        HEIGHT = layout.offsetof(3);
        DEPTH = layout.offsetof(4);
        NUMLAYERS = layout.offsetof(5);
        NUMMIPS = layout.offsetof(6);
        BITSPERPIXEL = layout.offsetof(7);
        CUBEMAP = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<BGFXTextureInfo, Buffer>
    implements NativeResource {
        private static final BGFXTextureInfo ELEMENT_FACTORY = BGFXTextureInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected BGFXTextureInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="bgfx_texture_format_t")
        public int format() {
            return BGFXTextureInfo.nformat(this.address());
        }

        @NativeType(value="uint32_t")
        public int storageSize() {
            return BGFXTextureInfo.nstorageSize(this.address());
        }

        @NativeType(value="uint16_t")
        public short width() {
            return BGFXTextureInfo.nwidth(this.address());
        }

        @NativeType(value="uint16_t")
        public short height() {
            return BGFXTextureInfo.nheight(this.address());
        }

        @NativeType(value="uint16_t")
        public short depth() {
            return BGFXTextureInfo.ndepth(this.address());
        }

        @NativeType(value="uint16_t")
        public short numLayers() {
            return BGFXTextureInfo.nnumLayers(this.address());
        }

        @NativeType(value="uint8_t")
        public byte numMips() {
            return BGFXTextureInfo.nnumMips(this.address());
        }

        @NativeType(value="uint8_t")
        public byte bitsPerPixel() {
            return BGFXTextureInfo.nbitsPerPixel(this.address());
        }

        @NativeType(value="bool")
        public boolean cubeMap() {
            return BGFXTextureInfo.ncubeMap(this.address());
        }
    }
}

