/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;

@NativeType(value="struct bgfx_resolution_t")
public class BGFXResolution
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FORMAT;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int RESET;
    public static final int NUMBACKBUFFERS;
    public static final int MAXFRAMELATENCY;

    public BGFXResolution(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), BGFXResolution.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="bgfx_texture_format_t")
    public int format() {
        return BGFXResolution.nformat(this.address());
    }

    @NativeType(value="uint32_t")
    public int width() {
        return BGFXResolution.nwidth(this.address());
    }

    @NativeType(value="uint32_t")
    public int height() {
        return BGFXResolution.nheight(this.address());
    }

    @NativeType(value="uint32_t")
    public int reset() {
        return BGFXResolution.nreset(this.address());
    }

    @NativeType(value="uint8_t")
    public byte numBackBuffers() {
        return BGFXResolution.nnumBackBuffers(this.address());
    }

    @NativeType(value="uint8_t")
    public byte maxFrameLatency() {
        return BGFXResolution.nmaxFrameLatency(this.address());
    }

    public BGFXResolution format(@NativeType(value="bgfx_texture_format_t") int value) {
        BGFXResolution.nformat(this.address(), value);
        return this;
    }

    public BGFXResolution width(@NativeType(value="uint32_t") int value) {
        BGFXResolution.nwidth(this.address(), value);
        return this;
    }

    public BGFXResolution height(@NativeType(value="uint32_t") int value) {
        BGFXResolution.nheight(this.address(), value);
        return this;
    }

    public BGFXResolution reset(@NativeType(value="uint32_t") int value) {
        BGFXResolution.nreset(this.address(), value);
        return this;
    }

    public BGFXResolution numBackBuffers(@NativeType(value="uint8_t") byte value) {
        BGFXResolution.nnumBackBuffers(this.address(), value);
        return this;
    }

    public BGFXResolution maxFrameLatency(@NativeType(value="uint8_t") byte value) {
        BGFXResolution.nmaxFrameLatency(this.address(), value);
        return this;
    }

    public BGFXResolution set(int format, int width, int height, int reset, byte numBackBuffers, byte maxFrameLatency) {
        this.format(format);
        this.width(width);
        this.height(height);
        this.reset(reset);
        this.numBackBuffers(numBackBuffers);
        this.maxFrameLatency(maxFrameLatency);
        return this;
    }

    public BGFXResolution set(BGFXResolution src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static BGFXResolution malloc() {
        return BGFXResolution.wrap(BGFXResolution.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static BGFXResolution calloc() {
        return BGFXResolution.wrap(BGFXResolution.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static BGFXResolution create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return BGFXResolution.wrap(BGFXResolution.class, MemoryUtil.memAddress(container), container);
    }

    public static BGFXResolution create(long address) {
        return BGFXResolution.wrap(BGFXResolution.class, address);
    }

    @Nullable
    public static BGFXResolution createSafe(long address) {
        return address == 0L ? null : BGFXResolution.wrap(BGFXResolution.class, address);
    }

    @Deprecated
    public static BGFXResolution mallocStack() {
        return BGFXResolution.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static BGFXResolution callocStack() {
        return BGFXResolution.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static BGFXResolution mallocStack(MemoryStack stack) {
        return BGFXResolution.malloc(stack);
    }

    @Deprecated
    public static BGFXResolution callocStack(MemoryStack stack) {
        return BGFXResolution.calloc(stack);
    }

    public static BGFXResolution malloc(MemoryStack stack) {
        return BGFXResolution.wrap(BGFXResolution.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static BGFXResolution calloc(MemoryStack stack) {
        return BGFXResolution.wrap(BGFXResolution.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static int nformat(long struct) {
        return UNSAFE.getInt(null, struct + (long)FORMAT);
    }

    public static int nwidth(long struct) {
        return UNSAFE.getInt(null, struct + (long)WIDTH);
    }

    public static int nheight(long struct) {
        return UNSAFE.getInt(null, struct + (long)HEIGHT);
    }

    public static int nreset(long struct) {
        return UNSAFE.getInt(null, struct + (long)RESET);
    }

    public static byte nnumBackBuffers(long struct) {
        return UNSAFE.getByte(null, struct + (long)NUMBACKBUFFERS);
    }

    public static byte nmaxFrameLatency(long struct) {
        return UNSAFE.getByte(null, struct + (long)MAXFRAMELATENCY);
    }

    public static void nformat(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FORMAT, value);
    }

    public static void nwidth(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)WIDTH, value);
    }

    public static void nheight(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)HEIGHT, value);
    }

    public static void nreset(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)RESET, value);
    }

    public static void nnumBackBuffers(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)NUMBACKBUFFERS, value);
    }

    public static void nmaxFrameLatency(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)MAXFRAMELATENCY, value);
    }

    static {
        Struct.Layout layout = BGFXResolution.__struct(BGFXResolution.__member(4), BGFXResolution.__member(4), BGFXResolution.__member(4), BGFXResolution.__member(4), BGFXResolution.__member(1), BGFXResolution.__member(1));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FORMAT = layout.offsetof(0);
        WIDTH = layout.offsetof(1);
        HEIGHT = layout.offsetof(2);
        RESET = layout.offsetof(3);
        NUMBACKBUFFERS = layout.offsetof(4);
        MAXFRAMELATENCY = layout.offsetof(5);
    }
}

