/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.bgfx.BGFXCaps;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;

@NativeType(value="struct bgfx_internal_data_t")
public class BGFXInternalData
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CAPS;
    public static final int CONTEXT;

    public BGFXInternalData(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), BGFXInternalData.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="bgfx_caps_t *")
    public BGFXCaps caps() {
        return BGFXInternalData.ncaps(this.address());
    }

    @NativeType(value="void *")
    public long context() {
        return BGFXInternalData.ncontext(this.address());
    }

    public static BGFXInternalData create(long address) {
        return BGFXInternalData.wrap(BGFXInternalData.class, address);
    }

    @Nullable
    public static BGFXInternalData createSafe(long address) {
        return address == 0L ? null : BGFXInternalData.wrap(BGFXInternalData.class, address);
    }

    public static BGFXCaps ncaps(long struct) {
        return BGFXCaps.create(MemoryUtil.memGetAddress(struct + (long)CAPS));
    }

    public static long ncontext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)CONTEXT);
    }

    static {
        Struct.Layout layout = BGFXInternalData.__struct(BGFXInternalData.__member(POINTER_SIZE), BGFXInternalData.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CAPS = layout.offsetof(0);
        CONTEXT = layout.offsetof(1);
    }
}

