/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct bgfx_instance_data_buffer_t")
public class BGFXInstanceDataBuffer
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DATA;
    public static final int SIZE;
    public static final int OFFSET;
    public static final int NUM;
    public static final int STRIDE;
    public static final int HANDLE;

    public BGFXInstanceDataBuffer(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), BGFXInstanceDataBuffer.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint8_t *")
    public ByteBuffer data() {
        return BGFXInstanceDataBuffer.ndata(this.address());
    }

    @NativeType(value="uint32_t")
    public int size() {
        return BGFXInstanceDataBuffer.nsize(this.address());
    }

    @NativeType(value="uint32_t")
    public int offset() {
        return BGFXInstanceDataBuffer.noffset(this.address());
    }

    @NativeType(value="uint32_t")
    public int num() {
        return BGFXInstanceDataBuffer.nnum(this.address());
    }

    @NativeType(value="uint16_t")
    public short stride() {
        return BGFXInstanceDataBuffer.nstride(this.address());
    }

    @NativeType(value="bgfx_vertex_buffer_handle_t")
    public short handle() {
        return BGFXInstanceDataBuffer.nhandle(this.address());
    }

    public BGFXInstanceDataBuffer data(@NativeType(value="uint8_t *") ByteBuffer value) {
        BGFXInstanceDataBuffer.ndata(this.address(), value);
        return this;
    }

    public BGFXInstanceDataBuffer offset(@NativeType(value="uint32_t") int value) {
        BGFXInstanceDataBuffer.noffset(this.address(), value);
        return this;
    }

    public BGFXInstanceDataBuffer num(@NativeType(value="uint32_t") int value) {
        BGFXInstanceDataBuffer.nnum(this.address(), value);
        return this;
    }

    public BGFXInstanceDataBuffer stride(@NativeType(value="uint16_t") short value) {
        BGFXInstanceDataBuffer.nstride(this.address(), value);
        return this;
    }

    public BGFXInstanceDataBuffer handle(@NativeType(value="bgfx_vertex_buffer_handle_t") short value) {
        BGFXInstanceDataBuffer.nhandle(this.address(), value);
        return this;
    }

    public BGFXInstanceDataBuffer set(ByteBuffer data, int offset, int num, short stride, short handle) {
        this.data(data);
        this.offset(offset);
        this.num(num);
        this.stride(stride);
        this.handle(handle);
        return this;
    }

    public BGFXInstanceDataBuffer set(BGFXInstanceDataBuffer src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static BGFXInstanceDataBuffer malloc() {
        return BGFXInstanceDataBuffer.wrap(BGFXInstanceDataBuffer.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static BGFXInstanceDataBuffer calloc() {
        return BGFXInstanceDataBuffer.wrap(BGFXInstanceDataBuffer.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static BGFXInstanceDataBuffer create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return BGFXInstanceDataBuffer.wrap(BGFXInstanceDataBuffer.class, MemoryUtil.memAddress(container), container);
    }

    public static BGFXInstanceDataBuffer create(long address) {
        return BGFXInstanceDataBuffer.wrap(BGFXInstanceDataBuffer.class, address);
    }

    @Nullable
    public static BGFXInstanceDataBuffer createSafe(long address) {
        return address == 0L ? null : BGFXInstanceDataBuffer.wrap(BGFXInstanceDataBuffer.class, address);
    }

    public static Buffer malloc(int capacity) {
        return BGFXInstanceDataBuffer.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(BGFXInstanceDataBuffer.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return BGFXInstanceDataBuffer.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = BGFXInstanceDataBuffer.__create(capacity, SIZEOF);
        return BGFXInstanceDataBuffer.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return BGFXInstanceDataBuffer.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : BGFXInstanceDataBuffer.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static BGFXInstanceDataBuffer mallocStack() {
        return BGFXInstanceDataBuffer.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static BGFXInstanceDataBuffer callocStack() {
        return BGFXInstanceDataBuffer.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static BGFXInstanceDataBuffer mallocStack(MemoryStack stack) {
        return BGFXInstanceDataBuffer.malloc(stack);
    }

    @Deprecated
    public static BGFXInstanceDataBuffer callocStack(MemoryStack stack) {
        return BGFXInstanceDataBuffer.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return BGFXInstanceDataBuffer.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return BGFXInstanceDataBuffer.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return BGFXInstanceDataBuffer.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return BGFXInstanceDataBuffer.calloc(capacity, stack);
    }

    public static BGFXInstanceDataBuffer malloc(MemoryStack stack) {
        return BGFXInstanceDataBuffer.wrap(BGFXInstanceDataBuffer.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static BGFXInstanceDataBuffer calloc(MemoryStack stack) {
        return BGFXInstanceDataBuffer.wrap(BGFXInstanceDataBuffer.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return BGFXInstanceDataBuffer.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return BGFXInstanceDataBuffer.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer ndata(long struct) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)DATA), BGFXInstanceDataBuffer.nsize(struct));
    }

    public static int nsize(long struct) {
        return UNSAFE.getInt(null, struct + (long)SIZE);
    }

    public static int noffset(long struct) {
        return UNSAFE.getInt(null, struct + (long)OFFSET);
    }

    public static int nnum(long struct) {
        return UNSAFE.getInt(null, struct + (long)NUM);
    }

    public static short nstride(long struct) {
        return UNSAFE.getShort(null, struct + (long)STRIDE);
    }

    public static short nhandle(long struct) {
        return UNSAFE.getShort(null, struct + (long)HANDLE);
    }

    public static void ndata(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)DATA, MemoryUtil.memAddress(value));
        BGFXInstanceDataBuffer.nsize(struct, value.remaining());
    }

    public static void nsize(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SIZE, value);
    }

    public static void noffset(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)OFFSET, value);
    }

    public static void nnum(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)NUM, value);
    }

    public static void nstride(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)STRIDE, value);
    }

    public static void nhandle(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)HANDLE, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)DATA));
    }

    static {
        Struct.Layout layout = BGFXInstanceDataBuffer.__struct(BGFXInstanceDataBuffer.__member(POINTER_SIZE), BGFXInstanceDataBuffer.__member(4), BGFXInstanceDataBuffer.__member(4), BGFXInstanceDataBuffer.__member(4), BGFXInstanceDataBuffer.__member(2), BGFXInstanceDataBuffer.__member(2));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DATA = layout.offsetof(0);
        SIZE = layout.offsetof(1);
        OFFSET = layout.offsetof(2);
        NUM = layout.offsetof(3);
        STRIDE = layout.offsetof(4);
        HANDLE = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<BGFXInstanceDataBuffer, Buffer>
    implements NativeResource {
        private static final BGFXInstanceDataBuffer ELEMENT_FACTORY = BGFXInstanceDataBuffer.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected BGFXInstanceDataBuffer getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint8_t *")
        public ByteBuffer data() {
            return BGFXInstanceDataBuffer.ndata(this.address());
        }

        @NativeType(value="uint32_t")
        public int size() {
            return BGFXInstanceDataBuffer.nsize(this.address());
        }

        @NativeType(value="uint32_t")
        public int offset() {
            return BGFXInstanceDataBuffer.noffset(this.address());
        }

        @NativeType(value="uint32_t")
        public int num() {
            return BGFXInstanceDataBuffer.nnum(this.address());
        }

        @NativeType(value="uint16_t")
        public short stride() {
            return BGFXInstanceDataBuffer.nstride(this.address());
        }

        @NativeType(value="bgfx_vertex_buffer_handle_t")
        public short handle() {
            return BGFXInstanceDataBuffer.nhandle(this.address());
        }

        public Buffer data(@NativeType(value="uint8_t *") ByteBuffer value) {
            BGFXInstanceDataBuffer.ndata(this.address(), value);
            return this;
        }

        public Buffer offset(@NativeType(value="uint32_t") int value) {
            BGFXInstanceDataBuffer.noffset(this.address(), value);
            return this;
        }

        public Buffer num(@NativeType(value="uint32_t") int value) {
            BGFXInstanceDataBuffer.nnum(this.address(), value);
            return this;
        }

        public Buffer stride(@NativeType(value="uint16_t") short value) {
            BGFXInstanceDataBuffer.nstride(this.address(), value);
            return this;
        }

        public Buffer handle(@NativeType(value="bgfx_vertex_buffer_handle_t") short value) {
            BGFXInstanceDataBuffer.nhandle(this.address(), value);
            return this;
        }
    }
}

