/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;

@NativeType(value="struct bgfx_init_limits_t")
public class BGFXInitLimits
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MAXENCODERS;
    public static final int MINRESOURCECBSIZE;
    public static final int TRANSIENTVBSIZE;
    public static final int TRANSIENTIBSIZE;

    public BGFXInitLimits(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), BGFXInitLimits.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint16_t")
    public short maxEncoders() {
        return BGFXInitLimits.nmaxEncoders(this.address());
    }

    @NativeType(value="uint32_t")
    public int minResourceCbSize() {
        return BGFXInitLimits.nminResourceCbSize(this.address());
    }

    @NativeType(value="uint32_t")
    public int transientVbSize() {
        return BGFXInitLimits.ntransientVbSize(this.address());
    }

    @NativeType(value="uint32_t")
    public int transientIbSize() {
        return BGFXInitLimits.ntransientIbSize(this.address());
    }

    public BGFXInitLimits maxEncoders(@NativeType(value="uint16_t") short value) {
        BGFXInitLimits.nmaxEncoders(this.address(), value);
        return this;
    }

    public BGFXInitLimits minResourceCbSize(@NativeType(value="uint32_t") int value) {
        BGFXInitLimits.nminResourceCbSize(this.address(), value);
        return this;
    }

    public BGFXInitLimits transientVbSize(@NativeType(value="uint32_t") int value) {
        BGFXInitLimits.ntransientVbSize(this.address(), value);
        return this;
    }

    public BGFXInitLimits transientIbSize(@NativeType(value="uint32_t") int value) {
        BGFXInitLimits.ntransientIbSize(this.address(), value);
        return this;
    }

    public BGFXInitLimits set(short maxEncoders, int minResourceCbSize, int transientVbSize, int transientIbSize) {
        this.maxEncoders(maxEncoders);
        this.minResourceCbSize(minResourceCbSize);
        this.transientVbSize(transientVbSize);
        this.transientIbSize(transientIbSize);
        return this;
    }

    public BGFXInitLimits set(BGFXInitLimits src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static BGFXInitLimits malloc() {
        return BGFXInitLimits.wrap(BGFXInitLimits.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static BGFXInitLimits calloc() {
        return BGFXInitLimits.wrap(BGFXInitLimits.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static BGFXInitLimits create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return BGFXInitLimits.wrap(BGFXInitLimits.class, MemoryUtil.memAddress(container), container);
    }

    public static BGFXInitLimits create(long address) {
        return BGFXInitLimits.wrap(BGFXInitLimits.class, address);
    }

    @Nullable
    public static BGFXInitLimits createSafe(long address) {
        return address == 0L ? null : BGFXInitLimits.wrap(BGFXInitLimits.class, address);
    }

    @Deprecated
    public static BGFXInitLimits mallocStack() {
        return BGFXInitLimits.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static BGFXInitLimits callocStack() {
        return BGFXInitLimits.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static BGFXInitLimits mallocStack(MemoryStack stack) {
        return BGFXInitLimits.malloc(stack);
    }

    @Deprecated
    public static BGFXInitLimits callocStack(MemoryStack stack) {
        return BGFXInitLimits.calloc(stack);
    }

    public static BGFXInitLimits malloc(MemoryStack stack) {
        return BGFXInitLimits.wrap(BGFXInitLimits.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static BGFXInitLimits calloc(MemoryStack stack) {
        return BGFXInitLimits.wrap(BGFXInitLimits.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static short nmaxEncoders(long struct) {
        return UNSAFE.getShort(null, struct + (long)MAXENCODERS);
    }

    public static int nminResourceCbSize(long struct) {
        return UNSAFE.getInt(null, struct + (long)MINRESOURCECBSIZE);
    }

    public static int ntransientVbSize(long struct) {
        return UNSAFE.getInt(null, struct + (long)TRANSIENTVBSIZE);
    }

    public static int ntransientIbSize(long struct) {
        return UNSAFE.getInt(null, struct + (long)TRANSIENTIBSIZE);
    }

    public static void nmaxEncoders(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)MAXENCODERS, value);
    }

    public static void nminResourceCbSize(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MINRESOURCECBSIZE, value);
    }

    public static void ntransientVbSize(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TRANSIENTVBSIZE, value);
    }

    public static void ntransientIbSize(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TRANSIENTIBSIZE, value);
    }

    static {
        Struct.Layout layout = BGFXInitLimits.__struct(BGFXInitLimits.__member(2), BGFXInitLimits.__member(4), BGFXInitLimits.__member(4), BGFXInitLimits.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MAXENCODERS = layout.offsetof(0);
        MINRESOURCECBSIZE = layout.offsetof(1);
        TRANSIENTVBSIZE = layout.offsetof(2);
        TRANSIENTIBSIZE = layout.offsetof(3);
    }
}

