/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct bgfx_attachment_t")
public class BGFXAttachment
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ACCESS;
    public static final int HANDLE;
    public static final int MIP;
    public static final int LAYER;
    public static final int NUMLAYERS;
    public static final int RESOLVE;

    public BGFXAttachment(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), BGFXAttachment.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="bgfx_access_t")
    public int access() {
        return BGFXAttachment.naccess(this.address());
    }

    @NativeType(value="bgfx_texture_handle_t")
    public short handle() {
        return BGFXAttachment.nhandle(this.address());
    }

    @NativeType(value="uint16_t")
    public short mip() {
        return BGFXAttachment.nmip(this.address());
    }

    @NativeType(value="uint16_t")
    public short layer() {
        return BGFXAttachment.nlayer(this.address());
    }

    @NativeType(value="uint16_t")
    public short numLayers() {
        return BGFXAttachment.nnumLayers(this.address());
    }

    @NativeType(value="uint8_t")
    public byte resolve() {
        return BGFXAttachment.nresolve(this.address());
    }

    public BGFXAttachment access(@NativeType(value="bgfx_access_t") int value) {
        BGFXAttachment.naccess(this.address(), value);
        return this;
    }

    public BGFXAttachment handle(@NativeType(value="bgfx_texture_handle_t") short value) {
        BGFXAttachment.nhandle(this.address(), value);
        return this;
    }

    public BGFXAttachment mip(@NativeType(value="uint16_t") short value) {
        BGFXAttachment.nmip(this.address(), value);
        return this;
    }

    public BGFXAttachment layer(@NativeType(value="uint16_t") short value) {
        BGFXAttachment.nlayer(this.address(), value);
        return this;
    }

    public BGFXAttachment numLayers(@NativeType(value="uint16_t") short value) {
        BGFXAttachment.nnumLayers(this.address(), value);
        return this;
    }

    public BGFXAttachment resolve(@NativeType(value="uint8_t") byte value) {
        BGFXAttachment.nresolve(this.address(), value);
        return this;
    }

    public BGFXAttachment set(int access, short handle, short mip, short layer, short numLayers, byte resolve) {
        this.access(access);
        this.handle(handle);
        this.mip(mip);
        this.layer(layer);
        this.numLayers(numLayers);
        this.resolve(resolve);
        return this;
    }

    public BGFXAttachment set(BGFXAttachment src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static BGFXAttachment malloc() {
        return BGFXAttachment.wrap(BGFXAttachment.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static BGFXAttachment calloc() {
        return BGFXAttachment.wrap(BGFXAttachment.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static BGFXAttachment create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return BGFXAttachment.wrap(BGFXAttachment.class, MemoryUtil.memAddress(container), container);
    }

    public static BGFXAttachment create(long address) {
        return BGFXAttachment.wrap(BGFXAttachment.class, address);
    }

    @Nullable
    public static BGFXAttachment createSafe(long address) {
        return address == 0L ? null : BGFXAttachment.wrap(BGFXAttachment.class, address);
    }

    public static Buffer malloc(int capacity) {
        return BGFXAttachment.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(BGFXAttachment.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return BGFXAttachment.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = BGFXAttachment.__create(capacity, SIZEOF);
        return BGFXAttachment.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return BGFXAttachment.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : BGFXAttachment.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static BGFXAttachment mallocStack() {
        return BGFXAttachment.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static BGFXAttachment callocStack() {
        return BGFXAttachment.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static BGFXAttachment mallocStack(MemoryStack stack) {
        return BGFXAttachment.malloc(stack);
    }

    @Deprecated
    public static BGFXAttachment callocStack(MemoryStack stack) {
        return BGFXAttachment.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return BGFXAttachment.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return BGFXAttachment.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return BGFXAttachment.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return BGFXAttachment.calloc(capacity, stack);
    }

    public static BGFXAttachment malloc(MemoryStack stack) {
        return BGFXAttachment.wrap(BGFXAttachment.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static BGFXAttachment calloc(MemoryStack stack) {
        return BGFXAttachment.wrap(BGFXAttachment.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return BGFXAttachment.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return BGFXAttachment.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int naccess(long struct) {
        return UNSAFE.getInt(null, struct + (long)ACCESS);
    }

    public static short nhandle(long struct) {
        return UNSAFE.getShort(null, struct + (long)HANDLE);
    }

    public static short nmip(long struct) {
        return UNSAFE.getShort(null, struct + (long)MIP);
    }

    public static short nlayer(long struct) {
        return UNSAFE.getShort(null, struct + (long)LAYER);
    }

    public static short nnumLayers(long struct) {
        return UNSAFE.getShort(null, struct + (long)NUMLAYERS);
    }

    public static byte nresolve(long struct) {
        return UNSAFE.getByte(null, struct + (long)RESOLVE);
    }

    public static void naccess(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ACCESS, value);
    }

    public static void nhandle(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)HANDLE, value);
    }

    public static void nmip(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)MIP, value);
    }

    public static void nlayer(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)LAYER, value);
    }

    public static void nnumLayers(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)NUMLAYERS, value);
    }

    public static void nresolve(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)RESOLVE, value);
    }

    static {
        Struct.Layout layout = BGFXAttachment.__struct(BGFXAttachment.__member(4), BGFXAttachment.__member(2), BGFXAttachment.__member(2), BGFXAttachment.__member(2), BGFXAttachment.__member(2), BGFXAttachment.__member(1));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ACCESS = layout.offsetof(0);
        HANDLE = layout.offsetof(1);
        MIP = layout.offsetof(2);
        LAYER = layout.offsetof(3);
        NUMLAYERS = layout.offsetof(4);
        RESOLVE = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<BGFXAttachment, Buffer>
    implements NativeResource {
        private static final BGFXAttachment ELEMENT_FACTORY = BGFXAttachment.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected BGFXAttachment getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="bgfx_access_t")
        public int access() {
            return BGFXAttachment.naccess(this.address());
        }

        @NativeType(value="bgfx_texture_handle_t")
        public short handle() {
            return BGFXAttachment.nhandle(this.address());
        }

        @NativeType(value="uint16_t")
        public short mip() {
            return BGFXAttachment.nmip(this.address());
        }

        @NativeType(value="uint16_t")
        public short layer() {
            return BGFXAttachment.nlayer(this.address());
        }

        @NativeType(value="uint16_t")
        public short numLayers() {
            return BGFXAttachment.nnumLayers(this.address());
        }

        @NativeType(value="uint8_t")
        public byte resolve() {
            return BGFXAttachment.nresolve(this.address());
        }

        public Buffer access(@NativeType(value="bgfx_access_t") int value) {
            BGFXAttachment.naccess(this.address(), value);
            return this;
        }

        public Buffer handle(@NativeType(value="bgfx_texture_handle_t") short value) {
            BGFXAttachment.nhandle(this.address(), value);
            return this;
        }

        public Buffer mip(@NativeType(value="uint16_t") short value) {
            BGFXAttachment.nmip(this.address(), value);
            return this;
        }

        public Buffer layer(@NativeType(value="uint16_t") short value) {
            BGFXAttachment.nlayer(this.address(), value);
            return this;
        }

        public Buffer numLayers(@NativeType(value="uint16_t") short value) {
            BGFXAttachment.nnumLayers(this.address(), value);
            return this;
        }

        public Buffer resolve(@NativeType(value="uint8_t") byte value) {
            BGFXAttachment.nresolve(this.address(), value);
            return this;
        }
    }
}

