/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.bgfx.BGFXReallocCallback;
import org.lwjgl.bgfx.BGFXReallocCallbackI;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct bgfx_allocator_vtbl_t")
public class BGFXAllocatorVtbl
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int REALLOC;

    public BGFXAllocatorVtbl(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), BGFXAllocatorVtbl.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void * (*) (bgfx_allocator_interface_t *, void *, size_t, size_t, char *, uint32_t)")
    public BGFXReallocCallback realloc() {
        return BGFXAllocatorVtbl.nrealloc(this.address());
    }

    public BGFXAllocatorVtbl realloc(@NativeType(value="void * (*) (bgfx_allocator_interface_t *, void *, size_t, size_t, char *, uint32_t)") BGFXReallocCallbackI value) {
        BGFXAllocatorVtbl.nrealloc(this.address(), value);
        return this;
    }

    public BGFXAllocatorVtbl set(BGFXAllocatorVtbl src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static BGFXAllocatorVtbl malloc() {
        return BGFXAllocatorVtbl.wrap(BGFXAllocatorVtbl.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static BGFXAllocatorVtbl calloc() {
        return BGFXAllocatorVtbl.wrap(BGFXAllocatorVtbl.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static BGFXAllocatorVtbl create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return BGFXAllocatorVtbl.wrap(BGFXAllocatorVtbl.class, MemoryUtil.memAddress(container), container);
    }

    public static BGFXAllocatorVtbl create(long address) {
        return BGFXAllocatorVtbl.wrap(BGFXAllocatorVtbl.class, address);
    }

    @Nullable
    public static BGFXAllocatorVtbl createSafe(long address) {
        return address == 0L ? null : BGFXAllocatorVtbl.wrap(BGFXAllocatorVtbl.class, address);
    }

    public static Buffer malloc(int capacity) {
        return BGFXAllocatorVtbl.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(BGFXAllocatorVtbl.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return BGFXAllocatorVtbl.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = BGFXAllocatorVtbl.__create(capacity, SIZEOF);
        return BGFXAllocatorVtbl.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return BGFXAllocatorVtbl.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : BGFXAllocatorVtbl.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static BGFXAllocatorVtbl mallocStack() {
        return BGFXAllocatorVtbl.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static BGFXAllocatorVtbl callocStack() {
        return BGFXAllocatorVtbl.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static BGFXAllocatorVtbl mallocStack(MemoryStack stack) {
        return BGFXAllocatorVtbl.malloc(stack);
    }

    @Deprecated
    public static BGFXAllocatorVtbl callocStack(MemoryStack stack) {
        return BGFXAllocatorVtbl.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return BGFXAllocatorVtbl.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return BGFXAllocatorVtbl.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return BGFXAllocatorVtbl.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return BGFXAllocatorVtbl.calloc(capacity, stack);
    }

    public static BGFXAllocatorVtbl malloc(MemoryStack stack) {
        return BGFXAllocatorVtbl.wrap(BGFXAllocatorVtbl.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static BGFXAllocatorVtbl calloc(MemoryStack stack) {
        return BGFXAllocatorVtbl.wrap(BGFXAllocatorVtbl.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return BGFXAllocatorVtbl.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return BGFXAllocatorVtbl.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static BGFXReallocCallback nrealloc(long struct) {
        return BGFXReallocCallback.create(MemoryUtil.memGetAddress(struct + (long)REALLOC));
    }

    public static void nrealloc(long struct, BGFXReallocCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)REALLOC, value.address());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)REALLOC));
    }

    static {
        Struct.Layout layout = BGFXAllocatorVtbl.__struct(BGFXAllocatorVtbl.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        REALLOC = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<BGFXAllocatorVtbl, Buffer>
    implements NativeResource {
        private static final BGFXAllocatorVtbl ELEMENT_FACTORY = BGFXAllocatorVtbl.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected BGFXAllocatorVtbl getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void * (*) (bgfx_allocator_interface_t *, void *, size_t, size_t, char *, uint32_t)")
        public BGFXReallocCallback realloc() {
            return BGFXAllocatorVtbl.nrealloc(this.address());
        }

        public Buffer realloc(@NativeType(value="void * (*) (bgfx_allocator_interface_t *, void *, size_t, size_t, char *, uint32_t)") BGFXReallocCallbackI value) {
            BGFXAllocatorVtbl.nrealloc(this.address(), value);
            return this;
        }
    }
}

