/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.bgfx.BGFXAllocatorVtbl;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;

@NativeType(value="struct bgfx_allocator_interface_t")
public class BGFXAllocatorInterface
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VTBL;

    public BGFXAllocatorInterface(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), BGFXAllocatorInterface.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="bgfx_allocator_vtbl_t const *")
    public BGFXAllocatorVtbl vtbl() {
        return BGFXAllocatorInterface.nvtbl(this.address());
    }

    public BGFXAllocatorInterface vtbl(@NativeType(value="bgfx_allocator_vtbl_t const *") BGFXAllocatorVtbl value) {
        BGFXAllocatorInterface.nvtbl(this.address(), value);
        return this;
    }

    public BGFXAllocatorInterface set(BGFXAllocatorInterface src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static BGFXAllocatorInterface malloc() {
        return BGFXAllocatorInterface.wrap(BGFXAllocatorInterface.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static BGFXAllocatorInterface calloc() {
        return BGFXAllocatorInterface.wrap(BGFXAllocatorInterface.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static BGFXAllocatorInterface create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return BGFXAllocatorInterface.wrap(BGFXAllocatorInterface.class, MemoryUtil.memAddress(container), container);
    }

    public static BGFXAllocatorInterface create(long address) {
        return BGFXAllocatorInterface.wrap(BGFXAllocatorInterface.class, address);
    }

    @Nullable
    public static BGFXAllocatorInterface createSafe(long address) {
        return address == 0L ? null : BGFXAllocatorInterface.wrap(BGFXAllocatorInterface.class, address);
    }

    @Deprecated
    public static BGFXAllocatorInterface mallocStack() {
        return BGFXAllocatorInterface.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static BGFXAllocatorInterface callocStack() {
        return BGFXAllocatorInterface.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static BGFXAllocatorInterface mallocStack(MemoryStack stack) {
        return BGFXAllocatorInterface.malloc(stack);
    }

    @Deprecated
    public static BGFXAllocatorInterface callocStack(MemoryStack stack) {
        return BGFXAllocatorInterface.calloc(stack);
    }

    public static BGFXAllocatorInterface malloc(MemoryStack stack) {
        return BGFXAllocatorInterface.wrap(BGFXAllocatorInterface.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static BGFXAllocatorInterface calloc(MemoryStack stack) {
        return BGFXAllocatorInterface.wrap(BGFXAllocatorInterface.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static BGFXAllocatorVtbl nvtbl(long struct) {
        return BGFXAllocatorVtbl.create(MemoryUtil.memGetAddress(struct + (long)VTBL));
    }

    public static void nvtbl(long struct, BGFXAllocatorVtbl value) {
        MemoryUtil.memPutAddress(struct + (long)VTBL, value.address());
    }

    public static void validate(long struct) {
        long vtbl = MemoryUtil.memGetAddress(struct + (long)VTBL);
        Checks.check(vtbl);
        BGFXAllocatorVtbl.validate(vtbl);
    }

    static {
        Struct.Layout layout = BGFXAllocatorInterface.__struct(BGFXAllocatorInterface.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VTBL = layout.offsetof(0);
    }
}

