/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiMetadataEntry")
public class AIMetaDataEntry
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MTYPE;
    public static final int MDATA;

    public AIMetaDataEntry(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), AIMetaDataEntry.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="aiMetadataType")
    public int mType() {
        return AIMetaDataEntry.nmType(this.address());
    }

    @NativeType(value="void *")
    public ByteBuffer mData(int capacity) {
        return AIMetaDataEntry.nmData(this.address(), capacity);
    }

    public AIMetaDataEntry mType(@NativeType(value="aiMetadataType") int value) {
        AIMetaDataEntry.nmType(this.address(), value);
        return this;
    }

    public AIMetaDataEntry mData(@NativeType(value="void *") ByteBuffer value) {
        AIMetaDataEntry.nmData(this.address(), value);
        return this;
    }

    public AIMetaDataEntry set(int mType, ByteBuffer mData) {
        this.mType(mType);
        this.mData(mData);
        return this;
    }

    public AIMetaDataEntry set(AIMetaDataEntry src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static AIMetaDataEntry malloc() {
        return AIMetaDataEntry.wrap(AIMetaDataEntry.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static AIMetaDataEntry calloc() {
        return AIMetaDataEntry.wrap(AIMetaDataEntry.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static AIMetaDataEntry create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return AIMetaDataEntry.wrap(AIMetaDataEntry.class, MemoryUtil.memAddress(container), container);
    }

    public static AIMetaDataEntry create(long address) {
        return AIMetaDataEntry.wrap(AIMetaDataEntry.class, address);
    }

    @Nullable
    public static AIMetaDataEntry createSafe(long address) {
        return address == 0L ? null : AIMetaDataEntry.wrap(AIMetaDataEntry.class, address);
    }

    public static Buffer malloc(int capacity) {
        return AIMetaDataEntry.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(AIMetaDataEntry.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return AIMetaDataEntry.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AIMetaDataEntry.__create(capacity, SIZEOF);
        return AIMetaDataEntry.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return AIMetaDataEntry.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : AIMetaDataEntry.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static AIMetaDataEntry mallocStack() {
        return AIMetaDataEntry.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIMetaDataEntry callocStack() {
        return AIMetaDataEntry.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIMetaDataEntry mallocStack(MemoryStack stack) {
        return AIMetaDataEntry.malloc(stack);
    }

    @Deprecated
    public static AIMetaDataEntry callocStack(MemoryStack stack) {
        return AIMetaDataEntry.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return AIMetaDataEntry.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return AIMetaDataEntry.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIMetaDataEntry.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIMetaDataEntry.calloc(capacity, stack);
    }

    public static AIMetaDataEntry malloc(MemoryStack stack) {
        return AIMetaDataEntry.wrap(AIMetaDataEntry.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIMetaDataEntry calloc(MemoryStack stack) {
        return AIMetaDataEntry.wrap(AIMetaDataEntry.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return AIMetaDataEntry.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return AIMetaDataEntry.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nmType(long struct) {
        return UNSAFE.getInt(null, struct + (long)MTYPE);
    }

    public static ByteBuffer nmData(long struct, int capacity) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)MDATA), capacity);
    }

    public static void nmType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MTYPE, value);
    }

    public static void nmData(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)MDATA, MemoryUtil.memAddress(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)MDATA));
    }

    static {
        Struct.Layout layout = AIMetaDataEntry.__struct(AIMetaDataEntry.__member(4), AIMetaDataEntry.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MTYPE = layout.offsetof(0);
        MDATA = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<AIMetaDataEntry, Buffer>
    implements NativeResource {
        private static final AIMetaDataEntry ELEMENT_FACTORY = AIMetaDataEntry.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected AIMetaDataEntry getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="aiMetadataType")
        public int mType() {
            return AIMetaDataEntry.nmType(this.address());
        }

        @NativeType(value="void *")
        public ByteBuffer mData(int capacity) {
            return AIMetaDataEntry.nmData(this.address(), capacity);
        }

        public Buffer mType(@NativeType(value="aiMetadataType") int value) {
            AIMetaDataEntry.nmType(this.address(), value);
            return this;
        }

        public Buffer mData(@NativeType(value="void *") ByteBuffer value) {
            AIMetaDataEntry.nmData(this.address(), value);
            return this;
        }
    }
}

