/*
 * Decompiled with CFR 0.152.
 */
package fi.autiosaari.caccanen.test;

import fi.autiosaari.caccanen.core.Camera;
import fi.autiosaari.caccanen.core.ILogic;
import fi.autiosaari.caccanen.core.MouseInput;
import fi.autiosaari.caccanen.core.ObjectLoader;
import fi.autiosaari.caccanen.core.WindowManager;
import fi.autiosaari.caccanen.core.entity.Entity;
import fi.autiosaari.caccanen.core.entity.Material;
import fi.autiosaari.caccanen.core.entity.Model;
import fi.autiosaari.caccanen.core.entity.SceneManager;
import fi.autiosaari.caccanen.core.entity.Texture;
import fi.autiosaari.caccanen.core.entity.terrain.BlendMapTerrain;
import fi.autiosaari.caccanen.core.entity.terrain.Terrain;
import fi.autiosaari.caccanen.core.entity.terrain.TerrainTexture;
import fi.autiosaari.caccanen.core.lighting.DirectionalLight;
import fi.autiosaari.caccanen.core.lighting.PointLight;
import fi.autiosaari.caccanen.core.lighting.SpotLight;
import fi.autiosaari.caccanen.core.rendering.RenderManager;
import fi.autiosaari.caccanen.test.Main;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL11;

public class TestGame
implements ILogic {
    private final RenderManager renderer = new RenderManager();
    private final WindowManager window = Main.getWindow();
    private final ObjectLoader loader = new ObjectLoader();
    private Camera camera = new Camera();
    private SceneManager sceneManager;
    Vector3f cameraInc = new Vector3f(0.0f, 0.0f, 0.0f);

    public TestGame() {
        this.sceneManager = new SceneManager(-90.0f);
    }

    @Override
    public void init() throws Exception {
        this.renderer.init();
        Model farjan = this.loader.loadOBJModel("/models/farjan.obj");
        farjan.setTexture(new Texture(this.loader.loadTexture("textures/laiva_mapattu_tekstuuri.png")), 1.0f);
        Model aurink = this.loader.loadOBJModel("/models/farjan.obj");
        aurink.setTexture(new Texture(this.loader.loadTexture("textures/aurinko.png")), 1.0f);
        TerrainTexture backgroundTexture = new TerrainTexture(this.loader.loadTexture("textures/meri.png"));
        TerrainTexture redTexture = new TerrainTexture(this.loader.loadTexture("textures/meri.png"));
        TerrainTexture blueTexture = new TerrainTexture(this.loader.loadTexture("textures/meri.png"));
        TerrainTexture greenTexture = new TerrainTexture(this.loader.loadTexture("textures/meri.png"));
        TerrainTexture blendMap = new TerrainTexture(this.loader.loadTexture("textures/meri.png"));
        BlendMapTerrain blendMapTerrain = new BlendMapTerrain(backgroundTexture, redTexture, greenTexture, blueTexture);
        Terrain terrain = new Terrain(new Vector3f(0.0f, 1.0f, -800.0f), this.loader, new Material(new Vector4f(0.0f, 0.0f, 0.0f, 0.0f), 0.1f), blendMapTerrain, blendMap);
        Terrain terrain2 = new Terrain(new Vector3f(-800.0f, 1.0f, -800.0f), this.loader, new Material(new Vector4f(0.0f, 0.0f, 0.0f, 0.0f), 0.1f), blendMapTerrain, blendMap);
        this.sceneManager.addTerrain(terrain);
        this.sceneManager.addTerrain(terrain2);
        this.camera.setPosition(0.0f, 10.0f, 0.0f);
        Vector3f farjanPos = new Vector3f(-150.0f, -12.0f, -50.0f);
        Vector3f farjanRot = new Vector3f(0.0f, -90.0f, 0.0f);
        int farjanScale = 10;
        this.sceneManager.addEntity(new Entity(farjan, farjanPos, farjanRot, farjanScale));
        Vector3f aurinkpos = new Vector3f(120.0f, 75.0f, -200.0f);
        Vector3f aurinkrot = new Vector3f(0.0f, 90.0f, 0.0f);
        int aurinkscale = 5;
        this.sceneManager.addEntity(new Entity(aurink, aurinkpos, aurinkrot, aurinkscale));
        float lightIntensity = 1.0f;
        Vector3f lightPosition = new Vector3f(-0.5f, -0.5f, -3.2f);
        Vector3f lightColour = new Vector3f(1.0f, 1.0f, 1.0f);
        PointLight pointLight = new PointLight(lightColour, lightPosition, lightIntensity, 0.0f, 0.0f, 1.0f);
        Vector3f coneDir = new Vector3f(0.0f, -50.0f, 0.0f);
        float cutoff = (float)Math.cos(Math.toRadians(140.0));
        lightIntensity = 10.0f;
        SpotLight spotLight = new SpotLight(new PointLight(lightColour, new Vector3f(0.0f, 0.0f, 1.0f), lightIntensity, 0.0f, 0.0f, 1.0f), coneDir, cutoff);
        coneDir = new Vector3f(0.0f, -50.0f, 0.0f);
        cutoff = (float)Math.cos(Math.toRadians(140.0));
        SpotLight spotLight1 = new SpotLight(new SpotLight(new PointLight(lightColour, lightPosition, lightIntensity, 0.0f, 0.0f, 1.0f), coneDir, cutoff));
        lightPosition = new Vector3f(-1.0f, -10.0f, 0.0f);
        lightColour = new Vector3f(1.0f, 1.0f, 1.0f);
        this.sceneManager.setDirectionalLight(new DirectionalLight(lightColour, lightPosition, lightIntensity));
        this.sceneManager.setPointLights(new PointLight[]{pointLight});
        this.sceneManager.setSpotLights(new SpotLight[]{spotLight, spotLight1});
    }

    @Override
    public void input() {
        this.cameraInc.set(0.0f, 0.0f, 0.0f);
        if (this.window.isKeyPressed(87)) {
            this.cameraInc.z = -1.0f;
        }
        if (this.window.isKeyPressed(83)) {
            this.cameraInc.z = 1.0f;
        }
        if (this.window.isKeyPressed(65)) {
            this.cameraInc.x = -1.0f;
        }
        if (this.window.isKeyPressed(68)) {
            this.cameraInc.x = 1.0f;
        }
        if (this.window.isKeyPressed(90)) {
            this.cameraInc.y = -1.0f;
        }
        if (this.window.isKeyPressed(88)) {
            this.cameraInc.y = 1.0f;
        }
    }

    @Override
    public void update(float interval, MouseInput mouseInput) {
        this.camera.movePosition(this.cameraInc.x * 0.2f, this.cameraInc.y * 0.2f, this.cameraInc.z * 0.2f);
        if (!mouseInput.isRightButtonPress()) {
            Vector2f rotVec = mouseInput.getDisplVec();
            this.camera.moveRotation(rotVec.x * 0.2f, rotVec.y * 0.2f, 0.0f);
        }
        float aurinkspeed = 10.0f;
        this.sceneManager.getEntities().get(1).incRotation(0.0f, 10.0f, 0.0f);
        float farjanmovespeed = 0.07f;
        this.sceneManager.getEntities().get(0).incPos(0.07f, 0.0f, 0.0f);
        this.sceneManager.incSpotAngle(0.15f);
        if (this.sceneManager.getSpotAngle() > 4.0f) {
            this.sceneManager.setSpotInc(-1.0f);
        } else if (this.sceneManager.getSpotAngle() <= -4.0f) {
            this.sceneManager.setSpotInc(1.0f);
        }
        double spotAngleRad = Math.toRadians(this.sceneManager.getSpotAngle());
        Vector3f coneDir = this.sceneManager.getSpotLights()[0].getPointLight().getPosition();
        coneDir.x = (float)Math.sin(spotAngleRad);
        coneDir = this.sceneManager.getSpotLights()[1].getPointLight().getPosition();
        coneDir.z = (float)Math.sin(spotAngleRad * 0.15);
        this.sceneManager.incLightAngle(1.1f);
        if (this.sceneManager.getLightAngle() > 90.0f) {
            this.sceneManager.getDirectionalLight().setIntensity(0.0f);
            if (this.sceneManager.getLightAngle() >= 360.0f) {
                this.sceneManager.setLightAngle(-90.0f);
            }
        } else if (this.sceneManager.getLightAngle() <= -80.0f || this.sceneManager.getLightAngle() >= 80.0f) {
            float factor = 1.0f - (Math.abs(this.sceneManager.getLightAngle()) - 80.0f) / 10.0f;
            this.sceneManager.getDirectionalLight().setIntensity(factor);
            this.sceneManager.getDirectionalLight().getColour().y = Math.max(factor, 0.9f);
            this.sceneManager.getDirectionalLight().getColour().z = Math.max(factor, 0.5f);
        } else {
            this.sceneManager.getDirectionalLight().setIntensity(1.0f);
            this.sceneManager.getDirectionalLight().getColour().x = 1.0f;
            this.sceneManager.getDirectionalLight().getColour().y = 1.0f;
            this.sceneManager.getDirectionalLight().getColour().z = 1.0f;
        }
        double angRad = Math.toRadians(this.sceneManager.getLightAngle());
        this.sceneManager.getDirectionalLight().getDirection().x = (float)Math.sin(angRad);
        this.sceneManager.getDirectionalLight().getDirection().y = (float)Math.cos(angRad);
        this.sceneManager.getEntities().forEach(this.renderer::processEntities);
        this.sceneManager.getTerrains().forEach(this.renderer::processTerrain);
    }

    @Override
    public void render() {
        if (this.window.isResized()) {
            GL11.glViewport(0, 0, this.window.getWidth(), this.window.getHeight());
            this.window.setResize(true);
        }
        this.renderer.render(this.camera, this.sceneManager);
    }

    @Override
    public void cleanup() {
        this.renderer.cleanup();
        this.loader.cleanup();
    }
}

