/*
 * Decompiled with CFR 0.152.
 */
package fi.autiosaari.caccanen.core.rendering;

import fi.autiosaari.caccanen.core.Camera;
import fi.autiosaari.caccanen.core.ShaderManager;
import fi.autiosaari.caccanen.core.WindowManager;
import fi.autiosaari.caccanen.core.entity.Entity;
import fi.autiosaari.caccanen.core.entity.SceneManager;
import fi.autiosaari.caccanen.core.entity.terrain.Terrain;
import fi.autiosaari.caccanen.core.lighting.DirectionalLight;
import fi.autiosaari.caccanen.core.lighting.PointLight;
import fi.autiosaari.caccanen.core.lighting.SpotLight;
import fi.autiosaari.caccanen.core.rendering.EntityRenderer;
import fi.autiosaari.caccanen.core.rendering.TerrainRenderer;
import fi.autiosaari.caccanen.core.utils.Consts;
import fi.autiosaari.caccanen.test.Main;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.opengl.GL11;

public class RenderManager {
    private final WindowManager window = Main.getWindow();
    private EntityRenderer entityRenderer;
    private TerrainRenderer terrainRenderer;

    public void init() throws Exception {
        this.entityRenderer = new EntityRenderer();
        this.terrainRenderer = new TerrainRenderer();
        this.entityRenderer.init();
        this.terrainRenderer.init();
    }

    public static void renderLights(PointLight[] pointLights, SpotLight[] spotLights, DirectionalLight directionalLight, ShaderManager shader) {
        int i;
        shader.setUniform("ambientLight", Consts.AMBIENT_LIGHT);
        shader.setUniform("specularPower", 10.0f);
        int numLights = spotLights != null ? spotLights.length : 0;
        for (i = 0; i < numLights; ++i) {
            shader.setUniform("spotLights", spotLights[i], i);
        }
        numLights = pointLights != null ? pointLights.length : 0;
        for (i = 0; i < numLights; ++i) {
            shader.setUniform("pointLights", pointLights[i], i);
        }
        shader.setUniform("directionalLight", directionalLight);
    }

    public void render(Camera camera, SceneManager scene) {
        this.clear();
        this.entityRenderer.render(camera, scene.getPointLights(), scene.getSpotLights(), scene.getDirectionalLight());
        this.terrainRenderer.render(camera, scene.getPointLights(), scene.getSpotLights(), scene.getDirectionalLight());
    }

    public void processEntities(Entity entity) {
        List<Entity> entityList = this.entityRenderer.getEntities().get(entity.getModel());
        if (entityList != null) {
            entityList.add(entity);
        } else {
            this.entityRenderer.getEntities().put(entity.getModel(), new ArrayList<Entity>(List.of(entity)));
        }
    }

    public void processTerrain(Terrain terrain) {
        this.terrainRenderer.getTerrains().add(terrain);
    }

    public void clear() {
        GL11.glClear(16640);
    }

    public void cleanup() {
        this.entityRenderer.cleanup();
        this.terrainRenderer.cleanup();
    }
}

