/*
 * Decompiled with CFR 0.152.
 */
package fi.autiosaari.caccanen.core.rendering;

import fi.autiosaari.caccanen.core.Camera;
import fi.autiosaari.caccanen.core.ShaderManager;
import fi.autiosaari.caccanen.core.entity.Entity;
import fi.autiosaari.caccanen.core.entity.Model;
import fi.autiosaari.caccanen.core.lighting.DirectionalLight;
import fi.autiosaari.caccanen.core.lighting.PointLight;
import fi.autiosaari.caccanen.core.lighting.SpotLight;
import fi.autiosaari.caccanen.core.rendering.IRenderer;
import fi.autiosaari.caccanen.core.rendering.RenderManager;
import fi.autiosaari.caccanen.core.utils.Transformation;
import fi.autiosaari.caccanen.core.utils.Utils;
import fi.autiosaari.caccanen.test.Main;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

public class EntityRenderer
implements IRenderer {
    ShaderManager shader;
    private Map<Model, List<Entity>> entities = new HashMap<Model, List<Entity>>();

    public EntityRenderer() throws Exception {
        this.shader = new ShaderManager();
    }

    @Override
    public void init() throws Exception {
        this.shader.createVertexShader(Utils.loadResource("/shaders/entity_vertex.vs"));
        this.shader.createFragmentShader(Utils.loadResource("/shaders/entity_fragment.fs"));
        this.shader.link();
        this.shader.createUniform("textureSampler");
        this.shader.createUniform("transformationMatrix");
        this.shader.createUniform("projectionMatrix");
        this.shader.createUniform("viewMatrix");
        this.shader.createUniform("ambientLight");
        this.shader.createMaterialUniform("material");
        this.shader.createUniform("specularPower");
        this.shader.createDirectionalLightUniform("directionalLight");
        this.shader.createPointLightListUniform("pointLights", 5);
        this.shader.createSpotLightListUniform("spotLights", 5);
    }

    @Override
    public void render(Camera camera, PointLight[] pointLights, SpotLight[] spotLights, DirectionalLight directionalLight) {
        this.shader.bind();
        this.shader.setUniform("projectionMatrix", Main.getWindow().updateProjectionMatrix());
        RenderManager.renderLights(pointLights, spotLights, directionalLight, this.shader);
        for (Model model : this.entities.keySet()) {
            this.bind(model);
            this.entities.get(model).forEach(entity -> {
                this.prepare(entity, camera);
                GL11.glDrawElements(4, entity.getModel().getVertexCount(), 5125, 0L);
            });
            this.unbind();
        }
        this.entities.clear();
        this.shader.unbind();
    }

    @Override
    public void bind(Model model) {
        GL30.glBindVertexArray(model.getId());
        GL20.glEnableVertexAttribArray(0);
        GL20.glEnableVertexAttribArray(1);
        GL20.glEnableVertexAttribArray(2);
        this.shader.setUniform("material", model.getMaterial());
        GL13.glActiveTexture(33984);
        GL11.glBindTexture(3553, model.getTexture().getId());
    }

    @Override
    public void unbind() {
        GL20.glDisableVertexAttribArray(0);
        GL20.glDisableVertexAttribArray(1);
        GL20.glDisableVertexAttribArray(2);
        GL30.glBindVertexArray(0);
    }

    public void prepare(Object entity, Camera camera) {
        this.shader.setUniform("textureSampler", 0);
        this.shader.setUniform("transformationMatrix", Transformation.createTransformationMatrix((Entity)entity));
        this.shader.setUniform("viewMatrix", Transformation.getViewMatrix(camera));
    }

    @Override
    public void cleanup() {
        this.shader.cleanup();
    }

    public Map<Model, List<Entity>> getEntities() {
        return this.entities;
    }
}

