/*
 * Decompiled with CFR 0.152.
 */
package fi.autiosaari.caccanen.core.entity;

import fi.autiosaari.caccanen.core.entity.Texture;
import fi.autiosaari.caccanen.core.utils.Consts;
import org.joml.Vector4f;

public class Material {
    private Vector4f ambientColour;
    private Vector4f diffuseColour;
    private Vector4f specularColour;
    private float reflectance;
    private Texture texture;

    public Material() {
        this.ambientColour = Consts.DEFAULT_COLOUR;
        this.diffuseColour = Consts.DEFAULT_COLOUR;
        this.specularColour = Consts.DEFAULT_COLOUR;
        this.texture = null;
        this.reflectance = 0.0f;
    }

    public Material(Vector4f colour, float reflectance) {
        this(colour, colour, colour, reflectance, null);
    }

    public Material(Vector4f colour, float reflectance, Texture texture) {
        this(colour, colour, colour, reflectance, texture);
    }

    public Material(Texture texture, float reflectance) {
        this(Consts.DEFAULT_COLOUR, Consts.DEFAULT_COLOUR, Consts.DEFAULT_COLOUR, reflectance, texture);
    }

    public Material(Texture texture) {
        this(Consts.DEFAULT_COLOUR, Consts.DEFAULT_COLOUR, Consts.DEFAULT_COLOUR, 0.0f, texture);
    }

    public Material(Vector4f ambientColour, Vector4f diffusionColour, Vector4f specularColour, float reflectance, Texture texture) {
        this.ambientColour = ambientColour;
        this.diffuseColour = diffusionColour;
        this.specularColour = specularColour;
        this.reflectance = reflectance;
        this.texture = texture;
    }

    public Vector4f getAmbientColour() {
        return this.ambientColour;
    }

    public void setAmbientColour(Vector4f ambientColour) {
        this.ambientColour = ambientColour;
    }

    public Vector4f getDiffuseColour() {
        return this.diffuseColour;
    }

    public void setDiffuseColour(Vector4f diffuseColour) {
        this.diffuseColour = diffuseColour;
    }

    public Vector4f getSpecularColour() {
        return this.specularColour;
    }

    public void setSpecularColour(Vector4f specularColour) {
        this.specularColour = specularColour;
    }

    public float getReflectance() {
        return this.reflectance;
    }

    public void setReflectance(float reflectance) {
        this.reflectance = reflectance;
    }

    public Texture getTexture() {
        return this.texture;
    }

    public void setTexture(Texture texture) {
        this.texture = texture;
    }

    public boolean hasTexture() {
        return this.texture != null;
    }
}

