/*
 * Decompiled with CFR 0.152.
 */
package fi.autiosaari.caccanen.core;

import fi.autiosaari.caccanen.test.Main;
import org.joml.Vector2d;
import org.joml.Vector2f;
import org.lwjgl.glfw.GLFW;

public class MouseInput {
    private final Vector2d previousPos = new Vector2d(-1.0, -1.0);
    private final Vector2d currentPos = new Vector2d(0.0, 0.0);
    private final Vector2f displVec = new Vector2f();
    private boolean inWindow = false;
    private boolean leftButtonPress = false;
    private boolean rightButtonPress = false;

    public void init() {
        GLFW.glfwSetCursorPosCallback(Main.getWindow().getWindowHandle(), (window, xpos, ypos) -> {
            this.currentPos.x = xpos;
            this.currentPos.y = ypos;
        });
        GLFW.glfwSetCursorEnterCallback(Main.getWindow().getWindowHandle(), (window, entered) -> {
            this.inWindow = entered;
        });
        GLFW.glfwSetMouseButtonCallback(Main.getWindow().getWindowHandle(), (window, button, action, mods) -> {
            this.leftButtonPress = button == 0 && action == 1;
            this.rightButtonPress = button == 1 && action == 1;
        });
    }

    public void input() {
        this.displVec.x = 0.0f;
        this.displVec.y = 0.0f;
        if (this.previousPos.x > 0.0 && this.previousPos.y > 0.0 && this.inWindow) {
            boolean rotateY;
            double x = this.currentPos.x - this.previousPos.x;
            double y = this.currentPos.y - this.previousPos.y;
            boolean rotateX = x != 0.0;
            boolean bl = rotateY = y != 0.0;
            if (rotateX) {
                this.displVec.y = (float)x;
            }
            if (rotateY) {
                this.displVec.x = (float)y;
            }
        }
        this.previousPos.x = this.currentPos.x;
        this.previousPos.y = this.currentPos.y;
    }

    public Vector2f getDisplVec() {
        return this.displVec;
    }

    public boolean isLeftButtonPress() {
        return this.leftButtonPress;
    }

    public boolean isRightButtonPress() {
        return this.rightButtonPress;
    }
}

