/*
 * Decompiled with CFR 0.152.
 */
package fi.autiosaari.caccanen.core;

import fi.autiosaari.caccanen.core.ILogic;
import fi.autiosaari.caccanen.core.MouseInput;
import fi.autiosaari.caccanen.core.WindowManager;
import fi.autiosaari.caccanen.test.Main;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;

public class EngineManager {
    public static final long NANOSECOND = 1000000000L;
    public static final float FRAMERATE = 1000.0f;
    private static int fps;
    private static float frameTime;
    private boolean isRunning;
    private WindowManager window;
    private MouseInput mouseInput;
    private GLFWErrorCallback errorCallback;
    private ILogic gameLogic;

    private void init() throws Exception {
        this.errorCallback = GLFWErrorCallback.createPrint(System.err);
        GLFW.glfwSetErrorCallback(this.errorCallback);
        this.window = Main.getWindow();
        this.gameLogic = Main.getGame();
        this.mouseInput = new MouseInput();
        this.window.init();
        this.gameLogic.init();
        this.mouseInput.init();
    }

    public void start() throws Exception {
        this.init();
        if (this.isRunning) {
            return;
        }
        this.run();
    }

    public void run() {
        this.isRunning = true;
        int frames = 0;
        long frameCounter = 0L;
        long lastTime = System.nanoTime();
        double unprocessedTime = 0.0;
        while (this.isRunning) {
            boolean render = false;
            long startTime = System.nanoTime();
            long passedTime = startTime - lastTime;
            lastTime = startTime;
            unprocessedTime += (double)passedTime / 1.0E9;
            frameCounter += passedTime;
            this.input();
            while (unprocessedTime > (double)frameTime) {
                render = true;
                unprocessedTime -= (double)frameTime;
                if (this.window.windowShouldClose()) {
                    this.stop();
                }
                if (frameCounter < 1000000000L) continue;
                EngineManager.setFps(frames);
                this.window.setTitle("Caccanen 0.0.1-SNAPSHOT - OpenGL | FPS: " + EngineManager.getFps());
                frames = 0;
                frameCounter = 0L;
            }
            if (!render) continue;
            this.update(frameTime);
            this.render();
            ++frames;
        }
        this.cleanup();
    }

    public void stop() {
        if (!this.isRunning) {
            return;
        }
        this.isRunning = false;
    }

    public void input() {
        this.mouseInput.input();
        this.gameLogic.input();
    }

    public void render() {
        this.gameLogic.render();
        this.window.update();
    }

    public void update(float interval) {
        this.gameLogic.update(interval, this.mouseInput);
    }

    public void cleanup() {
        this.window.cleanup();
        this.gameLogic.cleanup();
        this.errorCallback.free();
        GLFW.glfwTerminate();
    }

    public static int getFps() {
        return fps;
    }

    public static void setFps(int fps) {
        EngineManager.fps = fps;
    }

    static {
        frameTime = 0.001f;
    }
}

