
// ffmpeg -i batman-party-hard.gif -vsync 0 batman-party-hard-%d.png
function loadPngAnimation(animationObject) {
    animationObject.images = [];
    animationObject.i = void null;
    if (!animationObject.fps) {
        animationObject.fps = 30;
    }

    animationObject.frameDelay = 1.0 / animationObject.fps;

    for (var i = 1; i <= animationObject.frames; i++) {
        var image = new Image();
        image.load(animationObject.prefix + i + ".png");
        animationObject.images.push(image);
    }
}

function playPngAnimation(animation) {
    var timeNow = getSceneTimeFromStart();
    if (animation.animationObject.i === void null) {
        animation.animationObject.i = 0;
        animation.animationObject.startTime = timeNow;
        animation.animationObject.frameStartTime = animation.animationObject.startTime;
    }

    if (Math.abs(timeNow-animation.animationObject.frameStartTime) >= animation.animationObject.frameDelay) {
        animation.animationObject.i = (animation.animationObject.i+1)%animation.animationObject.frames;
        animation.animationObject.frameStartTime = timeNow;
    }

    animation.ref.ptr = animation.animationObject.images[animation.animationObject.i].ptr;
}


var brushcat = {
    prefix: 'brushcat/brushcat-',
    frames: 21,
    fps: 21
};

var bunnycat = {
    prefix: 'bunnycat/bunnycat-',
    frames: 10,
    fps: 10
};

var drinkcat = {
    prefix: 'drinkcat/drinkcat-',
    frames: 9,
    fps: 9
};

var huhcat = {
    prefix: 'huhcat/huhcat-',
    frames: 97,
    fps: 30
};

var keyboardcats = {
    prefix: 'keyboardcats/keyboardcats-',
    frames: 8,
    fps: 17
};

var excitementcat = {
    prefix: 'excitementcat/excitementcat-',
    frames: 15,
    fps: 15
};

var laserpointercat = {
    prefix: 'laserpointercat/laserpointercat-',
    frames: 29,
    fps: 20
};

var pawcat = {
    prefix: 'pawcat/pawcat-',
    frames: 5,
    fps: 8
};

var roombacat = {
    prefix: 'roombacat/roombacat-',
    frames: 39,
    fps: 30
};

var sweepcat = {
    prefix: 'sweepcat/sweepcat-',
    frames: 42,
    fps: 30
};

var catheads = {
    prefix: 'catheads/catheads-',
    frames: 225,
    fps: 30
};

var start      = 0;
var end        = 110;
var duration   = 110;
var layer      = 0;
var font       = "BebasNeue-Regular.ttf";
var bpm = 170;
var beat_in_seconds = 60.0 / bpm;

var gl = new WebGL2RenderingContext(); //enable WebGL 2 partial support

Demo.prototype.init = function()
{
    gl.enable(gl.CULL_FACE);
    
    this.loader.addAnimation([{ 
        "start": start, "duration": duration
        ,"layer": layer
        ,"fbo":{"name":"textFbo","action":"begin","storeDepth":false}
    }]);
    this.loader.addAnimation(
    {
        "start": start, "duration": 40
        ,"layer": layer
        ,"text":{
                "name":"BebasNeue-Regular.ttf"
            ,"string":"{return 'JUMALAUTA';}"
        }
        ,"scale": [{"uniform2d":13.0}]
        ,"position":[
            {"x":getScreenWidth()*0.5,"y":getScreenHeight()*0.5}
        ]
        /*,"shader":{"name":"biasTex.fs", "variable":[
                {"name":"textureBias","value":[0.0]}
        ]}*/
        ,"color":[{"a":0},{"duration":1,"a":255},{"duration":13},{"duration":1,"a":0}]
    });
    this.loader.addAnimation({
        "start": start, "duration": 40
        ,"layer": layer
        ,"text":{
                "name":"BebasNeue-Regular.ttf"
            ,"string":"{return '*.*.*.*.';}"
        }
        ,"scale": [{"uniform2d":13.0}]
        ,"position":[
            {"x":getScreenWidth()*0.5,"y":getScreenHeight()*0.5}
        ]
        /*,"shader":{"name":"biasTex.fs", "variable":[
                {"name":"textureBias","value":[0.0]}
        ]}*/
        ,"color":[{"a":0},{"duration":1+13},{"duration":0.5,"a":255},{"duration":0.5*2},{"duration":0.5,"a":0}]
    });
    this.loader.addAnimation({
        "start": start, "duration": 40
        ,"layer": layer
        ,"text":{
                "name":"BebasNeue-Regular.ttf"
            ,"string":"{return 'A.*.*.*.';}"
        }
        ,"scale": [{"uniform2d":13.0}]
        ,"position":[
            {"x":getScreenWidth()*0.5,"y":getScreenHeight()*0.5}
        ]
        /*,"shader":{"name":"biasTex.fs", "variable":[
                {"name":"textureBias","value":[0.0]}
        ]}*/
        ,"color":[{"a":0},{"duration":1+13+0.5*2},{"duration":0.5,"a":255},{"duration":0.5*2},{"duration":0.5,"a":0}]
    });
    this.loader.addAnimation({
        "start": start, "duration": 40
        ,"layer": layer
        ,"text":{
                "name":"BebasNeue-Regular.ttf"
            ,"string":"{return 'A.C.*.*.';}"
        }
        ,"scale": [{"uniform2d":13.0}]
        ,"position":[
            {"x":getScreenWidth()*0.5,"y":getScreenHeight()*0.5}
        ]
        /*,"shader":{"name":"biasTex.fs", "variable":[
                {"name":"textureBias","value":[0.0]}
        ]}*/
        ,"color":[{"a":0},{"duration":1+13+0.5*4},{"duration":0.5,"a":255},{"duration":0.5*3},{"duration":0.5,"a":0}]
    });
    this.loader.addAnimation({
        "start": start, "duration": 40
        ,"layer": layer
        ,"text":{
                "name":"BebasNeue-Regular.ttf"
            ,"string":"{return 'A.C.A.*.';}"
        }
        ,"scale": [{"uniform2d":13.0}]
        ,"position":[
            {"x":getScreenWidth()*0.5,"y":getScreenHeight()*0.5}
        ]
        /*,"shader":{"name":"biasTex.fs", "variable":[
                {"name":"textureBias","value":[0.0]}
        ]}*/
        ,"color":[{"a":0},{"duration":1+13+0.5*7},{"duration":0.5,"a":255},{"duration":0.5*3},{"duration":0.5,"a":0}]
    });
    this.loader.addAnimation({
        "start": start, "duration": 40
        ,"layer": layer
        ,"text":{
                "name":"BebasNeue-Regular.ttf"
            ,"string":"{return 'A.C.A.B.';}"
        }
        ,"scale": [{"uniform2d":13.0}]
        ,"position":[
            {"x":getScreenWidth()*0.5,"y":getScreenHeight()*0.5}
        ]
        /*,"shader":{"name":"biasTex.fs", "variable":[
                {"name":"textureBias","value":[0.0]}
        ]}*/
        ,"color":[{"a":0},{"duration":1+13+0.5*10},{"duration":0.5,"a":255},{"duration":11-beat_in_seconds},{"duration":beat_in_seconds,"a":0}]
    });

    this.loader.addAnimation({
        "start": start+30, "duration": 40
        ,"layer": layer
        ,"text":{
                "name":"BebasNeue-Regular.ttf"
            ,"string":"{return 'ALL';}"
        }
        ,"scale": [{"uniform2d":13.0}]
        ,"position":[
            {"x":getScreenWidth()*0.5,"y":getScreenHeight()*0.5}
        ]
        ,"color":[{"a":0},{"duration":beat_in_seconds,"a":255},{"duration":beat_in_seconds*3},{"duration":beat_in_seconds,"a":0}]
    });
    this.loader.addAnimation({
        "start": start+30+beat_in_seconds*3, "duration": 40
        ,"layer": layer
        ,"text":{
                "name":"BebasNeue-Regular.ttf"
            ,"string":"{return 'CATS';}"
        }
        ,"scale": [{"uniform2d":13.0}]
        ,"position":[
            {"x":getScreenWidth()*0.5,"y":getScreenHeight()*0.5}
        ]
        ,"color":[{"a":0},{"duration":beat_in_seconds,"a":255},{"duration":beat_in_seconds*3},{"duration":beat_in_seconds,"a":0}]
    });
    this.loader.addAnimation({
        "start": start+30+beat_in_seconds*3, "duration": 40
        ,"layer": layer
        ,"text":{
                "name":"BebasNeue-Regular.ttf"
            ,"string":"{return 'COPS';}"
        }
        ,"scale": [{"uniform2d":13.0}]
        ,"position":[
            {"x":getScreenWidth()*0.5,"y":getScreenHeight()*0.5}
        ]
        ,"color":[{"a":0},{"duration":beat_in_seconds,"a":255},{"duration":beat_in_seconds*0.03},{"duration":0.1,"a":0}]
    });
    this.loader.addAnimation({
        "start": start+30+beat_in_seconds*7, "duration": 40
        ,"layer": layer
        ,"text":{
                "name":"BebasNeue-Regular.ttf"
            ,"string":"{return 'ARE';}"
        }
        ,"scale": [{"uniform2d":13.0}]
        ,"position":[
            {"x":getScreenWidth()*0.5,"y":getScreenHeight()*0.5}
        ]
        ,"color":[{"a":0},{"duration":beat_in_seconds,"a":255},{"duration":beat_in_seconds*3},{"duration":beat_in_seconds,"a":0}]
    });
    this.loader.addAnimation({
        "start": start+30+beat_in_seconds*11, "duration": 40
        ,"layer": layer
        ,"text":{
                "name":"BebasNeue-Regular.ttf"
            ,"string":"{return 'BEAUTIFUL';}"
        }
        ,"scale": [{"uniform2d":13.0}]
        ,"position":[
            {"x":getScreenWidth()*0.5,"y":getScreenHeight()*0.5}
        ]
        ,"color":[{"a":0},{"duration":beat_in_seconds,"a":255},{"duration":beat_in_seconds*3},{"duration":beat_in_seconds,"a":0}]
    });

    this.loader.addAnimation({
        "start": start+60+43, "duration": duration
        ,"layer": layer
        ,"text":{
                "name":"BebasNeue-Regular.ttf"
            ,"string":"{return 'JUMALAUTA';}"
        }
        ,"scale": [{"uniform2d":13.0}]
        ,"position":[
            {"x":getScreenWidth()*0.5,"y":getScreenHeight()*0.5}
        ]
        /*,"shader":{"name":"biasTex.fs", "variable":[
                {"name":"textureBias","value":[0.0]}
        ]}*/
        ,"color":[{"a":0},{"duration":1,"a":255},{"duration":11},{"duration":1,"a":0}]
    });
    this.loader.addAnimation({
        "start": start+60+43, "duration": duration
        ,"layer": layer
        ,"text":{
                "name":"BebasNeue-Regular.ttf"
            ,"string":"{return 'A.C.A.B.';}"
        }
        ,"scale": [{"uniform2d":13.0}]
        ,"position":[
            {"x":getScreenWidth()*0.5,"y":getScreenHeight()*0.5}
        ]
        /*,"shader":{"name":"biasTex.fs", "variable":[
                {"name":"textureBias","value":[0.0]}
        ]}*/
        ,"color":[{"a":0},{"duration":1+11},{"duration":1,"a":255},{"duration":16-beat_in_seconds*2},{"duration":beat_in_seconds,"a":0}]
    });
    
    this.loader.addAnimation({ 
        "start": start, "duration": duration
        ,"layer": layer
        ,"fbo":{"name":"textFbo","action":"unbind"}
    });

    var videos = true;
    if (videos) {
    
        this.loader.addAnimation({
             "start": start, "duration": 30
            ,"layer": layer, "image": {"name":"riot.ogv", "video":{"speed":0.8} }
            ,"scale":[{"uniform2d":4.0}]
            ,"position":[{"x":getScreenWidth()*0.5,"y":getScreenHeight()*0.5}]
            ,"color":[{"a":0},{"duration":5,"a":200},{"duration":25-beat_in_seconds},{"duration":beat_in_seconds,"a":0}]
        });

    }

    
    this.loader.addAnimation ({
        "start": 31+beat_in_seconds*3, "duration": 8, "layer": layer
        ,"image": "background-cat-eyes.png"
        ,"color":[{"a":0},{"duration":beat_in_seconds,"a":200},{"duration":7.5},{"duration":beat_in_seconds,"a":0}]
       /*,"shader":{"name":"colorcycle.fs", "variable":[
             {"name":"shift","value":[0.0]}
       ]}*/
    });

    this.loader.addAnimation({
        "start": 41+beat_in_seconds, "duration":17
       ,"layer": layer, "image": ["_embedded/defaultTransparent.png"]
       ,"shader":{"name":"spiral.fs","variable":[
           {"name":"background","type":"int","value":[3]}
       ]}
       ,"color":[{"a":0},{"duration":beat_in_seconds*3},{"duration":beat_in_seconds,"a":130}]
   });

   this.loader.addAnimation ({
        "start": 38+beat_in_seconds*5, "duration": 8, "layer": layer
        ,"image": "background-cat-half-face.png"
        ,"color":[{"a":0},{"duration":beat_in_seconds,"a":255},{"duration":6.0},{"duration":beat_in_seconds*6,"a":0}]
        ,"position":[{"x":getScreenWidth()*0.2,"y":getScreenHeight()*0.5},{"duration":1,"x":getScreenWidth()*0.5,"y":getScreenHeight()*0.5}]
    });

    this.loader.addAnimation([{
		"start": 35+beat_in_seconds, "duration": 6, "layer": layer,
		"object":"lanka.obj"
		,"camera": "Cam01"
		,"scale":[{"uniform3d":1}]
        ,"angle":[{"degreesX":"{return getSceneTimeFromStart()*20;}","degreesY":"{return getSceneTimeFromStart()*30;}","degreesZ":"{return getSceneTimeFromStart()*40;}"}]
		,"position":[
			{"x":0
			,"y":0
			,"z":"{return -15}"}]
    }]);

    this.loader.addAnimation([{
		"start": 41+beat_in_seconds, "duration": 6-beat_in_seconds, "layer": layer,
		"object":"lanka.obj"
		,"camera": "Cam01"
		,"scale":[{"uniform3d":1}]
        ,"angle":[{"degreesX":"{return getSceneTimeFromStart()*20;}","degreesY":"{return getSceneTimeFromStart()*30;}","degreesZ":"{return getSceneTimeFromStart()*40;}"}]
		,"position":[
			{"x":0
			,"y":0
			,"z":"{return Math.sin(getSceneTimeFromStart()*9)*8-23}"}]
    }]);

    for(var i = 0; i < 120; i++) {
        this.loader.addAnimation ({
            "start": 58.5-i*0.1, "duration": 12, "layer": layer
            ,"image": "cat-face-"+(Math.floor(Math.random()*6)+1)+".png"
            ,"perspective":"3d"
            ,"position":[{"x":Math.random()*8-4,"y":Math.random()*8-4,"z":-10}
            ,{"duration":5,"z":3}]
            //,"position":[{"x":getScreenWidth()*0.5,"y":getScreenHeight()*0.5}]
            ,"color":[{"a":0},{"duration":beat_in_seconds*2,"a":255},{"duration":5},{"duration":beat_in_seconds*2,"a":0}]
            ,"angle":[{"i":i,"degreesZ":"{return Math.sin(getSceneTimeFromStart()*2+animation.i*0.5)*10}"}]
           /*,"shader":{"name":"colorcycle.fs", "variable":[
                 {"name":"shift","value":[0.0]}
           ]}*/
        });
    }

    this.loader.addAnimation ({
        "start": 58, "duration": 13, "layer": layer
        ,"image": "excitementcat/excitementcat-1.png"
        ,"animationObject": excitementcat
        ,"initFunction":"{loadPngAnimation(animation.animationObject);}"
        ,"runFunction":"{playPngAnimation(animation);}"
        ,"scale":[{"uniform2d":6.0}]
        ,"color":[{"a":0},{"duration":beat_in_seconds,"a":255},{"duration":12},{"duration":beat_in_seconds,"a":0}]
       /*,"shader":{"name":"colorcycle.fs", "variable":[
             {"name":"shift","value":[0.0]}
       ]}*/
    });

    this.loader.addAnimation ({
        "start": 58, "duration": 13, "layer": layer
        ,"runFunction":"{gl.blendFunc(gl.SRC_ALPHA, gl.ONE)}"
    });
    for (var i = 0; i < 40; i++) {
        this.loader.addAnimation ({
            "start": 61, "duration": 13, "layer": layer
            ,"image": "laserpoint.png"
            ,"scale":[{"uniform2d":0.2+0.3*(i/40)}]
            ,"position":[{"p":i/30.0,
                "x":"{ return getScreenWidth()*(0.5+0.5*Math.sin(getSceneTimeFromStart()*15+animation.p)); }",
                "y":"{ return getScreenHeight()*(0.5+0.2*Math.cos(getSceneTimeFromStart()*15+animation.p));}"},
                {"duration":2,"p":i/30.0,
                "x":"{ return getScreenWidth()*(0.5+0.3*Math.sin(getSceneTimeFromStart()*15+animation.p)); }",
                "y":"{ return getScreenHeight()*(0.5+0.4*Math.cos(getSceneTimeFromStart()*15+animation.p));}"},
                {"duration":2,"p":i/30.0,
                "x":"{ return getScreenWidth()*(0.5+0.7*Math.cos(getSceneTimeFromStart()*15+animation.p)); }",
                "y":"{ return getScreenHeight()*(0.5+0.4*Math.sin(getSceneTimeFromStart()*15+animation.p));}"},
                {"duration":2,"p":i/30.0,
                "x":"{ return getScreenWidth()*(0.5+0.2*Math.sin(getSceneTimeFromStart()*15+animation.p)); }",
                "y":"{ return getScreenHeight()*(0.5+0.5*Math.cos(getSceneTimeFromStart()*15+animation.p));}"},
            ],
            "color":[{"a":0},{"duration":1,"a":200*(i/40)}]
        });
    }
    this.loader.addAnimation ({
        "start": 58, "duration": 13, "layer": layer
        ,"runFunction":"{gl.blendFunc(gl.SRC_ALPHA, gl.ONE_MINUS_SRC_ALPHA)}"
    });
    

    this.loader.addAnimation ({
        "start": 70, "duration": 11, "layer": layer
        ,"image": "laserpointercat/laserpointercat-1.png"
        ,"animationObject": laserpointercat
        ,"initFunction":"{loadPngAnimation(animation.animationObject);}"
        ,"runFunction":"{playPngAnimation(animation);}"
        ,"scale":[{"uniform2d":8}]
        ,"position":[{"x":getScreenWidth()*0.5,"y":getScreenHeight()*0.5}]
        ,"color":[{"a":0},{"duration":beat_in_seconds,"a":255},{"duration":17.5},{"duration":beat_in_seconds,"a":0}]
       /*,"shader":{"name":"colorcycle.fs", "variable":[
             {"name":"shift","value":[0.0]}
       ]}*/
    });

    this.loader.addAnimation ({
        "start": 80, "duration": 20, "layer": layer
        ,"image": "pawcat/pawcat-1.png"
        ,"animationObject": pawcat
        ,"initFunction":"{loadPngAnimation(animation.animationObject);}"
        ,"runFunction":"{playPngAnimation(animation);}"
        ,"scale":[{"uniform2d":9}]
        ,"position":[{"x":getScreenWidth()*0.5,"y":getScreenHeight()*0.55}]
        ,"color":[{"a":0},{"duration":beat_in_seconds,"a":255},{"duration":18.5},{"duration":beat_in_seconds,"a":0}]
       /*,"shader":{"name":"colorcycle.fs", "variable":[
             {"name":"shift","value":[0.0]}
       ]}*/
    });


    this.loader.addAnimation ({
        "start": 80, "duration": 19, "layer": layer
        ,"runFunction":"{gl.blendFunc(gl.SRC_ALPHA, gl.ONE)}"
    });
    for(var i = 0; i < 14; i++) {
        this.loader.addAnimation ({
            "start": 86.5+beat_in_seconds*3*i, "duration": 3, "layer": layer
            ,"image": "heart.png"
            ,"scale":[{"uniform2d":0.2},{"duration":beat_in_seconds*2,"uniform2d":2}]
            ,"position":[{"x":getScreenWidth()*(0.25),"y":getScreenHeight()*(0.38)}]
            ,"angle":[{"degreesZ":Math.random()*360},{"duration":beat_in_seconds*2,"degreesZ":Math.random()*360}]
            ,"color":[{"a":0},{"duration":beat_in_seconds,"a":200},{"duration":beat_in_seconds,"a":0}]
            ,"shader":{"name":"colorcycle.fs", "variable":[
                {"name":"shift2","value":["{return (1.0+Math.sin(getSceneTimeFromStart()*5))/2.0}"]}
          ]}   
        });
        this.loader.addAnimation ({
            "start": 86.5+beat_in_seconds*3*i+beat_in_seconds, "duration": 3, "layer": layer
            ,"image": "heart.png"
            ,"scale":[{"uniform2d":0.2},{"duration":beat_in_seconds*2,"uniform2d":2}]
            ,"position":[{"x":getScreenWidth()*0.59,"y":getScreenHeight()*0.2}]
            ,"angle":[{"degreesZ":Math.random()*360},{"duration":beat_in_seconds*2,"degreesZ":Math.random()*360}]
            ,"color":[{"a":0},{"duration":beat_in_seconds,"a":200},{"duration":beat_in_seconds,"a":0}]
            ,"shader":{"name":"colorcycle.fs", "variable":[
                {"name":"shift2","value":["{return (1.0+Math.sin(getSceneTimeFromStart()*5))/2.0}"]}
          ]}
   
        });
    }
    this.loader.addAnimation ({
        "start": 80, "duration": 19, "layer": layer
        ,"runFunction":"{gl.blendFunc(gl.SRC_ALPHA, gl.ONE_MINUS_SRC_ALPHA)}"
    });

    this.loader.addAnimation ({
        "start": 98, "duration": 5, "layer": layer
        ,"image": "keyboardcats/keyboardcats-1.png"
        ,"animationObject": keyboardcats
        ,"initFunction":"{loadPngAnimation(animation.animationObject);}"
        ,"runFunction":"{playPngAnimation(animation);}"
        ,"scale":[{"uniform2d":4.5}]
        ,"position":[{"x":getScreenWidth()*0.5,"y":getScreenHeight()*0.55}]
        ,"color":[{"a":0},{"duration":beat_in_seconds,"a":255},{"duration":17.5},{"duration":beat_in_seconds,"a":0}]
       ,"shader":{"name":"colorcycle.fs", "variable":[
             {"name":"shift2","value":["{return (1.0+Math.sin(getSceneTimeFromStart()*5))/2.0}"]}
       ]}
    });

    this.loader.addAnimation ({
        "start": start+60+43, "duration": 20, "layer": layer
        ,"image": "cat-stare.png"
        ,"position":[
            {"x":getScreenWidth()*-0.2,"y":getScreenHeight()*-0.2},
            {"duration":2,"x":getScreenWidth()*0.17,"y":getScreenHeight()*0.07}]

        ,"color":[{"a":0},{"duration":1,"a":255}]
    });

    this.loader.addAnimation({
        "start": start, "duration": end
       ,"layer": layer
       ,"image": ["textFbo.color.fbo"]
   });


   this.loader.addAnimation([{
    "start": start+60+43, "duration": 20,
    "object":"singlecat.obj"
    ,"camera": "Cam01"
    ,"layer": layer
    ,"scale":[{"uniform3d":1}]
    //,"angle":[{"degreesX":"{return getSceneTimeFromStart()*10;}","degreesY":"{return getSceneTimeFromStart()*10;}","degreesZ":"{return getSceneTimeFromStart()*10;}"}]
    ,"angle":[
        {"degreesX":"{return Math.sin(getSceneTimeFromStart()*4)*2-90}","degreesZ":"{return Math.cos(getSceneTimeFromStart()*4)*2-90}"},
        {"duration":6},
        {"duration":4,"degreesX":"{return Math.sin(getSceneTimeFromStart()*4)*2-90}","degreesZ":"{return Math.cos(getSceneTimeFromStart()*4)*2+90}"},
    ]
    ,"position":[
        {"x":0,"y":0,"z":-15},
        {"duration":10},
        {"z":3}]
}]);

   this.loader.addAnimation({
    "start": start, "duration": end
   ,"layer": layer+1
   ,"image": ["_embedded/defaultTransparent.png"]
   ,"shader":{"name":"vignette.fs", "variable":[
       {"name":"fadeStart","value":"{return [0.35];}"} //0.35
      ,{"name":"fadeEnd","value":"{return [1.0];}"} //0.5
 ]}
});

}
