Demo.prototype.sceneFruitsDisco = function () {
    this.setScene('fruitsDisco');

    this.loader.addAnimation([{
 
      "object":{
          "name":"bg/obj_discobg.obj"
        }
        ,"transparent":true
      ,"position":[{
        "x":0,
        "y":0,
        "z":10,
      }]

      ,"color":[{
          "r":1.0,
          "g":1.0,
          "b":1.0
      }]
      ,"scale":[{"uniform3d":()=>26.25}]
      ,"angle":[{             
        "degreesZ":()=>25,
        "degreesY":()=>45,         
      }],
      shader: {
        name: 'multiSceneEffects/colorcycle.fs',
        variable: [
          { name: 'shiftHue', value: [()=>2.5*getSceneTimeFromStart()] },
          { name: 'shiftSaturation', value: [0] },
          { name: 'shiftValue', value: [0] },
          { name: 'centerize', value: [0.0] }
        ]
      }
      
    }]);
    
    this.loader.addAnimation([{
 
      "object":{
          "name":"bg/obj_discofloor.obj"
        }
        ,"transparent":true
      ,"position":[{
        "x":0,
        "y":-2,
        "z":0,
      }]

      ,"color":[{
          "r":1.0,
          "g":1.0,
          "b":1.0
      }]
      ,"scale":[{"uniform3d":()=>26.25}]
      ,"angle":[{             
        "degreesZ":()=>0,
        "degreesY":()=>-90*getSceneTimeFromStart(),         
      }],
      textureProperties: [{},{minFilter: 'NearestMipmapNearestFilter', magFilter: 'NearestFilter'}],
      shader: {
        name: 'multiSceneEffects/uvscroll.fs',
        variable: [
          { name: 'sScrollScale', value: [-1.0] },
          { name: 'fakeTime', value: [() => -.1*getSceneTimeFromStart()] },
          { name: 'kolor', value: [0.9] }
        ]
      }
      
    }]);

      let objects = ["obj_kurk.obj", "obj_banana.obj", "obj_carrot.obj", "obj_myski.obj", "obj_munis.obj"];
      let objectSyncs = ["Kurk", "Bana", "Pork", "Mysk", "Muna"];
      let positions =
      [
        0,0, 1.0043,
        0.955112,0.0,0.310335,
        0.590292,0.0,-0.812467,
        -0.590292,0,-0.812467,
        -0.955112,0,0.310335
  
      ];

  
      this.loader.addAnimation([{
        "id":"rotaPeach26",
        "object": null
        ,"position":[{
          "x":0,
          "y":0,
          "z":0,
        }]
        ,"color":[{
            "r":1.0,
            "g":1.0,
            "b":1.0
        }]
        ,"scale":[{"uniform3d":1.0}]
        ,"angle":[{             
          "degreesY":()=>getSceneTimeFromStart()*45
            
        }]
      }]);

      this.loader.addAnimation([{

        "object":{
            "name":"obj_peach.obj"
          }
        ,"position":[{
          "x":0,
          "y":()=>Sync.get('Veggies:PeachY')-.9,
          "z":0,
        }]
        ,"color":[{
            "r":1.0,
            "g":1.0,
            "b":1.0
        }]
        ,"scale":[{"uniform3d":1.0}]
        ,"angle":[{             
          "degreesY":()=>getSceneTimeFromStart()*45,
          "degreesZ":()=>Math.sin(getSceneTimeFromStart())*25            
        }]
      }]);

        for (let i = 0; i<objects.length;i++)
        {
          let posScaleSyncName = 'VegRot:'+objectSyncs[i]+'PosScale';
          let angleName = 'VegRot:'+objectSyncs[i]+'Angle';
          let ySyncName = 'Veggies:'+objectSyncs[i]+'Y';
          let x = positions[i*3];
          let y = positions[i*3+1];
          let z = positions[i*3+2];
          this.loader.addAnimation([{
            "id":'asdfg'+i,
            "parent":"rotaPeach26",
            "object":{
                "name":objects[i]
              }
            ,"position":[{
              "x":()=>x * Sync.get(posScaleSyncName),
              "y":()=>y * Sync.get(posScaleSyncName)+Sync.get(ySyncName)-.5,
              "z":()=>z * Sync.get(posScaleSyncName),
            }]
            ,"color":[{
                "r":1.0,
                "g":1.0,
                "b":1.0
            }]
            ,"scale":[{"uniform3d":.35}]
            ,"angle":[{             
              "degreesY":()=>getSceneTimeFromStart()*90,              
            }]
          }]);
      }

      //disco ball
      this.loader.addAnimation({
        object: {
          name: 'sceneFruitsDisco/obj_discoball.obj'
        },
        "position":[{
          "x":0,
          "y":2.5,
          "z":0,
        }]
      });


}
