import socket

import time
from math import exp
udp_socket = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)


def decay_uvs(intensity):

    array = [1,0,97,108,101,102,0]    

    for i in range(24,28):
            array = array + [1,i,0,int(255*intensity),int(255*intensity),int(255*intensity)]

    return bytearray(array)


def decay_light(lights,color,intensity):

    array = [1,0,97,108,101,102,0]    

    for i in range(28):
        if i in lights:
            array = array + [1,i,0,int(color[0]*intensity),int(color[1]*intensity),int(color[2]*intensity)]
        else:
            array = array + [1,i,0,0,0,0]

    return bytearray(array)


def rotating_light(t,rot_light_list,lightcolor,bgcolor):

    array = [1,0,97,108,101,102,0]    


    for i in range(24):    
        for j in rot_light_list:
            if int(j[0] + t*j[1]) % 24 == i:
                array = array + [1,i,0,min(int(lightcolor[0]),255),min(int(lightcolor[1]),255),min(int(lightcolor[2]),255)]
                break
            else:
                array = array + [1,i,0,min(int(bgcolor[0]),255),min(int(bgcolor[1]),255),min(int(bgcolor[2]),255)]

    return bytearray(array)


def all_black():
    return decay_light([],[0,0,0],0.0)

if __name__ == "__main__": 

    t0 = time.time()

    t = t0
    while(t-t0 < 10):  
       t = time.time()
       udp_socket.sendto(rotating_light(t-t0,[(1,-5),(1,5)],[255,0,0],[0,0,50]),('valot.instanssi',9909))
