#version 330 core

in vec2 texCoord;
out vec4 fragColor;
uniform sampler2D texture0;
uniform vec4 color = vec4(1,1,1,1);

uniform float time = 1.0;
uniform float fade = 0.08;
uniform float effectType = 0.0;

void main()
{
	float t = time * 0.2;
	vec2 coord=texCoord.xy;
	//coord.x += sin(time)*0.2;
	//coord.y += cos(time*0.8)*0.2;
	float x = (-1.0+2.0*coord.x);
	float y = (-1.0+2.0*coord.y);
	if (effectType == 1) {
		x += t*100;
		y += t*100;
	}

	float u = sqrt(x*x + y*y);
	float v = atan(y, x);

	if (effectType != 2) {
		coord.x = cos(v+t)/u+sin(t)*0.2+t;
	}
	coord.y = sin(v+t)/u+cos(t)*0.2+t;
	vec4 uv = texture(texture0, mod(coord + t*0.8,vec2(1.0,1.0)));
	fragColor = vec4(uv.r,uv.g,uv.b,uv.a-fade/u) * color;
}
