lmpr:          EQU  &FA
hmpr:          EQU  &FB
vmpr:          EQU  &FC
rom0_off:      EQU  %00100000
mode_4:        EQU  %01100000

sines:	EQU &8800
unrolledPlasma: EQU &9000

	autoexec
	ORG	&8000
	DUMP &8000

start:
	di

	IN   A,(vmpr)
	AND  %00011111
	OR   rom0_off
	OUT  (lmpr),A
;	OR   mode_4
;	OUT (vmpr),A


	ld hl,pals
	ld bc,16*256 + 248	; 16 = number of colors

	ld d,0
	ld e,b
	dec e
	add hl,de
	otdr


	ld hl,256
	ld sp,hl

; Thanks to baze for this, got it from sizecoding discord in z80.
	ld bc,sines
singen:
	rrc c
	sbc a,a
	xor h
	ld (bc),a
	add hl,sp
	push hl		; sp-=2
	rlc c
	inc c
	jr nz,singen



ld ixh,1

genUnrolls:
	ld hl,unrolledPlasma
	ld ixl,128
	ld de,sines
	gen64:
		ld (hl),&77		; ld (hl),a
		inc hl
		ld (hl),&2c		; inc l
		inc hl

		ld a,(de)

		ld b,ixh
		duplex1:
			inc e
			inc e
		dec b
		jr nz,duplex1

		ex de,hl
		sub (hl)
		ex de,hl

		ld b,ixh
		duplex2:
			sra a
		dec b
		jr nz,duplex2

		or a
		jr z,noDiff

		add a,2
		cp 5
		jr nc,noDiff

		ld bc,codes
		add a,c
		ld c,a		; assumes code will be within 256 byte area
		ld a,(bc)
		ld (hl),a
		inc hl
	noDiff:

	dec ixl
	jr nz,gen64

	ld (hl),&c9			; ret



; enable sound
ld a,&1c
ld d,1
call setSoundReg

mainloop:

;xor a
;out (254),a

waitVsync:
	in a,(249)
	and 8
jr nz,waitVsync

;ld a,7
;out (254),a


	ld a,(nframe)
	ld b,a

	;ld h,0	; l = ?
	ld hl,0

	ld d,sines/256
	ld c,94
	plasmY:
        ld a,c
		add a,b
		add a

        ld e,a
		ld a,(de)
		add a,c

        ld e,2

		call unrolledPlasma

		ld l,0
		inc h

    dec c
    jr nz,plasmY


	ld hl,(nframe)
	inc hl
	ld (nframe),hl

	;inc h
	; enable channel
	ld a,h
	and 7
	or a
	jr z,notUnset
	ld d,a
	ld a,&14
	call setSoundReg
notUnset:
	; volume
	ld a,117
	xor l
	ld d,a
	and 7
	call setSoundReg

	; tone
	;ld a,111;221
	ld a,l
	and h
	ld d,a
	and 3
	add &08
	inc a
	call setSoundReg

	; octave
	;ld d,%00000100
	ld a,78
	inc a
	and h
	xor l
	and 3
	ld a,&10
	call setSoundReg



	ld a,l
	or a
	jr nz,mainloop

	ld a,h
	;srl a
	and 7
	ld hl,plasmType
	ld d,0
	ld e,a
	add hl,de
	ld a,(hl)
	ld ixh,a
	jp genUnrolls

jr mainloop


; function(511) = a
; value(255) = d
setSoundReg:
	ld bc,511
	out (c),a

	ld bc,255
	ld a,d
	out (c),a
	ret

;sub a,e	-	&93
;dec a		-	&3d
;inc a		-	&3c
;add a,e	-	&83

plasmType:
db 1,2,4,16,1,8,0,3

nframe:
dw 256

codes:
db &93,&3d,0,&3c,&83

pals:
db 0,19,53,55
db 80,82,116,118
db 118,116,82,80
db 55,53,19
