import time,ugfx,stm,pyb,os,buttons

imgs = [None]
pals = [None]
dir="apps/hexwab~2048/"

code = open(dir+"code").read()

def mmap(file):
    print(file)
    @micropython.asm_thumb
    def findblk(r0,r1,r2):
        data(2,0xf500,0x7000,0xf1b0,0x6f01,0xd208,0x2300,0x58c4,0x58cd)
        data(2,0x42ac,0xd1f5,0x3304,0x4293,0xd1f8,0xe000,0x2000)
    for i in range(2):
        buf=bytearray(open(file,"rb").read())
        ret=findblk(1<<27,buf,len(buf))
        if ret:
            return ret
        assert(not i,file)
        open("tmp","w").write(buf)
        os.unlink(file)
        os.rename("tmp",file)

@micropython.asm_thumb
def call(r0,r1,r2):
     data(2,0x3201,0x4790)
     
def blit(x,y,n):
    ugfx.stream_start(x,y,54,54)
    if mode==0: call(img0[n]+64,img0[n],code)
    if mode==1: call(imgs[n][fnum[n]],pals[n][fnum[n]],code)
    if mode==2: call(img0[0]+64,img0[0],code)
    ugfx.stream_stop()

NIMG = 11

frames = [
    None,
    [200,20],
    [7,7,7,7,7,7,7,7,7], #wobb
    [5,5,5,5], # googl
    [7,7,7,7,7,7], # pizz
    [7,7], # cap
    [4,4,4,4,4,4,4,4,4], # rainb
    [8,8], #big
    [8,8], # whiteblue
    [6,6,6],
    [6,6,6,6,6,6],
    [5,5,5,5,5],
];

#frames = [
#    None, [1],[1],[1],[1],[1],[1],[1],[1],[1],[1],[1]
#];
fcount = [0] * (NIMG+1)
fnum = [0] * (NIMG+1)

for i in range(1,NIMG+1):
    it,pt = [],[]
    for j in range(len(frames[i])):
        #print("open i1%x%x" % (i,j))
        im = mmap(dir+("i1%x%x" % (i,j)))
        print("OK")
        it.append(im+64)
        pt.append(im)
    imgs.append(it)
    pals.append(pt)

img0 = [ mmap(dir+"i200") ]
for i in range(1,NIMG+1):
    im = mmap(dir+("i0%x0" % i))
    img0.append(im)

grid = [0]*16
score = 0
hi = 0
try:
    hi = int(open(dir+"hi").read())
except:
    pass

INC = 59
SIZE = 54
X = [5+(i>>2)*INC for i in range(16)]
Y = [5+(i&3)*INC for i in range(16)]
XO = [0,0,1,-1]
YO = [1,-1,0,0]
DIST = 59
STEP = 6
R = INC - SIZE
P = [
    [0,SIZE,SIZE,STEP], # U
    [0,-STEP,SIZE,STEP], # D
    [SIZE,0,STEP,SIZE], # R
    [-STEP,0,STEP,SIZE], # L 
]

Q = [
    [0,SIZE,SIZE,R], # U
    [0,-R,SIZE,R], # D
    [SIZE,0,R,SIZE], # R
    [-R,0,R,SIZE], # L 
]

def move(dir):
    moved = False
    while 1:
        moves = step(dir,True)
        if not len(moves):
            break
        moved = True
        for s in range(DIST,0,-STEP):
            for m in moves:
                xx=X[m]+XO[dir]*s
                yy=Y[m]+YO[dir]*s
                sq = moves[m] # grid[m]&15
                blit(xx,yy, sq)
                pp = P[dir]
                if s!=DIST: ugfx.area(xx+pp[0],yy+pp[1],pp[2],pp[3],SQ[mode])
        for m in moves:
            ugfx.area(X[m]+[0,0,SIZE,-R][dir],Y[m]+[SIZE,-R,0,0][dir],[SIZE,SIZE,R,R][dir],[R,R,SIZE,SIZE][dir],BORDER[mode])
            ugfx.area(X[m]+[0,0,SIZE+R,-R-4][dir],Y[m]+[SIZE+R,-R-4,0,0][dir],[SIZE,SIZE,4,4][dir],[4,4,SIZE,SIZE][dir],SQ[mode])
        for m in moves:
            blit(X[m], Y[m], grid[m]&15)
    for i in range(16): grid[i] &= 15

    if moved:
        sp = spawn()
        #print ("spawning %d at square %d" % (grid[sp], sp))

def step(dir,really):
    global won
    start = [0,3,0,12][dir]
    x = [4,4,1,1][dir]
    y = [1,-1,4,-4][dir]
    moves = {}
    for i in range(4):
        last = -1
        oo = -1
        for j in range(4):
            o = start+i*x+j*y
            if grid[o]:
                if not last:
                    if not really: return True
                    moves[oo] = grid[oo] = grid[o] # move
                    grid[o] = 0
                elif grid[o]==last and not last & 16:
                    if not really: return True
                    moves[oo] = grid[oo]
                    if moves[oo]==11: won=True
                    grid[oo] += 17 # merge
                    grid[o] = 0
                    sc(2<<moves[oo])
            oo = o
            last = grid[oo]
    if not really: return False
    return moves

def spawn():
    while True:
        sq = pyb.rng()&15
        if not grid[sq]:
            break
    grid[sq] = 1 if pyb.rng()%10 else 2 #1+(pyb.rng()%10)
    blit(X[sq], Y[sq], grid[sq])
    return sq

def sc(n):
    global score,hi
    score += n
    scw.text(str(score))
    if score>hi:
        hi = score
        hiw.text(str(hi))

BORDER = [0xbd74,0xf6bd,0]
SQ = [0xce16,0xffff,0]
BG = [0xffdd,0xff3f,0]
SC = [0xbd74,0xf81f,0]

def vsync():
    while not tear.value():
        pyb.wfi()
    while tear.value():
        pyb.wfi()

def redraw():
    sty.set_background(SC[mode])
    ugfx.area(241,0,79,240,BG[mode])
    ugfx.display_image(243,10,dir+["logo0","logo2","1x1"][mode]+".gif")
    ugfx.area(250,80,61,40,SC[mode])
    ugfx.display_image(260,86,dir+["score0","score1","1x1"][mode]+".gif")
    ugfx.area(250,132,61,40,SC[mode])
    ugfx.display_image(266,138,dir+["score3","score2","1x1"][mode]+".gif")
    ugfx.set_default_font(ugfx.FONT_SMALL)
    scw.text(str(score))
    hiw.text(str(hi))
    ugfx.text(248,190,"A: Mode", 0)
    ugfx.text(248,206,"B: Restart", 0)
    ugfx.area(0,0,241,240,BORDER[mode])
    for i in range(16):
        if grid[i]: blit(X[i], Y[i], grid[i])
        else: ugfx.area(X[i],Y[i],54,54,SQ[mode])
    
stm.mem8[0xa0000005]=0 # DATAST
ugfx.init()
ugfx.enable_tear()
tear = pyb.Pin("TEAR", pyb.Pin.IN)
sty = ugfx.Style()
sty.set_enabled([-1,-1,-1,-1])
ugfx.set_default_font(ugfx.FONT_MEDIUM)
scw = ugfx.Label(250,100,61,16,'',justification=ugfx.Label.CENTER,style=sty)
hiw = ugfx.Label(250,152,61,16,'',justification=ugfx.Label.CENTER,style=sty)
mode = 0
nmodes = 3
while True:
    grid = [0]*16
    score = 0
    restart = False
    spawn()
    spawn()
    frame = 0
    gameover = 0
    moved = True
    redraw()
    won = 0
    while True:
        if won or not (step(0,0) or step(1,0) or step(2,0) or step(3,0)):
            gameover += 1
            if gameover == 100:
                break
        if restart: break
        but = 0
        for i in range(4):
            b = buttons.is_pressed("JOY_"+["UP","DOWN","LEFT","RIGHT"][i])
            but += b
            if b and not moved:
                move(i)
                moved = True
        for i in range(2):
            b = buttons.is_pressed("BTN_"+["A","B"][i])
            but += b
            if b and not moved:
                if i==0:
                    mode = (mode+1)%nmodes
                    redraw()
                    moved = True
                else: restart = True
        if moved and but==0:
            moved = False
        vsync()
        frame += 1
        for i in range(1,NIMG+1):
            if not fcount[i]:
                fnum[i] = (fnum[i]+1) % len(frames[i])
                fcount[i] = frames[i] [fnum[i]]
                for j in range(16):
                    if grid[j]==i:
                        blit(X[j], Y[j], i)
            else:
                fcount[i] -= 1
        # if not (frame % 50):
        #     bg = [0xcfff,0xd7bf,0xdf7f,0xe73f,0xeeff,0xf6bf,0xfe7f,0xfebe,0xfefd,
        #       0xff3c,0xff7b,0xffba,0xfff9,0xf7fa,0xeffb,0xe7fc,0xdffd,0xd7fe][int(frame/50)%18]
        #     ugfx.area(241,0,79,240,bg)
        #     scw.visible(0)
        #     scw.visible(1)

    hif=open(dir+"hi","w")
    hif.write(str(hi))
    hif.flush()
    os.sync()
    if not restart:
        ugfx.display_image(0,0,dir+[["gameover","gog2"],["won","dogerar8"]][won][mode]+".gif")
        while not buttons.is_pressed("BTN_B"):
            pyb.wfi()
