; SUPERSTARS - 512byte intro by Abaddon
; music:ern0 code:TomCat

RESX EQU 320
SCREEN EQU 0A000H

; MIDI base note
B EQU 28
; base address for indexes
A EQU BP-RESX

ORG 256
 DW 127                 ; constant 127 -> amplitude for sinus table
 DW 3C00H               ; constant 1/128 -> calculating PI/128 for sinus table

 FNINIT
 MOV AL,3FH
 MOV DX,331H
 OUT DX,AL

 MOV AL,13H
 INT 10H
 XCHG AL,AH
 CWD
 MOV BP,text
 MOV BL,16
 INT 10H

 MOV BX,SCREEN
 MOV ES,BX
 MOV AL,113;108
sinus:
  FLDPI                 ; PI
  FMUL DWORD [SI]       ; PI/128
  FIMUL WORD [DI]       ; counter*PI/128
  FSIN                  ; SIN(counter*PI/128)
  FIMUL WORD [SI]       ; 127*SIN(counter*PI/128)
  FISTP WORD [BX+SI]    ; -
  INC BX
  OUT 40H,AL
 DEC BYTE [DI]          ; loop 256x
 JNZ sinus              ; BX = sinus table

 MOV BP,RESX
 SUB SI,BP
 FLD DWORD [A+pi90]     ; ar
 FLDZ                   ; a ar

forf:
 HLT

next:
 DB 0B1H;MOV CL,1
self_mod1:
 DB 1
 LOOP no_zak

 PUSHA
 MOV DX,330H
 MOV SI,ES
 CMP DI,diff_end+2
 JB no_reset

 MOV DI,diff
reset_chord:
 MOV DWORD [SI],1000000H*(37+B)+10000H*(33+B)+100H*(30+B)+(33+12+B)
si_bug:
 MOV BYTE [A+si_bug-4],10
tweak_solo:
 ROL WORD [A+self_mod4],1

no_reset:
 DB 0B1H;MOV CL,3
self_mod2:
 DB 3
 INC CX
play_notes:
 MOV AL,90H
 OUT DX,AL
 OUTSB
 MOV AL,7FH
 OUT DX,AL
 LOOP play_notes

 XOR BYTE [A+self_mod2],3
 JNZ solo_only

calc_chord_diff:
 DEC SI
 DEC SI
 MOV AX,[DI]
 SUB [SI],AX
 DEC SI
 SCASW
 DEC BYTE [SI]

solo_only:
 ADD WORD [A+self_mod3],33393
 DB 0B8H;MOV AX,0
self_mod3:
 DW 0
 DB 0A9H;TEST AX,4
self_mod4:
 DW 4
 MOV AL,[SI+2]
 JNZ rnd1
 MOV AL,[SI+1]
 ADD AL,12
rnd1:
 MOV [SI-1],AL

 POP AX
 PUSH DI
 POPA
 MOV CL,24

no_zak:
 MOV [A+self_mod1],CL

 SUB AX,AX
 PUSHA

 MOV DI,RESX*20
stars:
  PUSHA
  CWD
  LEA    AX,[DI-RESX*20]
  DIV    BP
  MOV    AH,DL
  SHR    DX,5
  ADD    BL,DL
  MOV    DL,AL
  SHR    DL,5
  ADD    BL,DL
  ADD    BL,DL
  AND    AX,257*31
  SUB    AL,16
  SUB    AH,16
  XCHG   DX,AX

  MOV BP,2
  MOV CL,4
fors:
   MOV AL,[BX]
   IMUL DL
   ADD BL,64
   XCHG SI,AX
   MOV AL,[BX]
   IMUL DH
   ADD AX,SI
   SUB BL,64+51
   CMP AX,666
   JG nexts
   MOV AL,0B4H-72;*2
  LOOP fors

c225:;DD 2.25
 JMP putpixel
pi90:;DD 0.10966227
 DB 10H,40H
 DB 0E0H,3DH
pi135:
 DD 0.07310818

nexts:
  DEC BP
  JNZ fors
  MOV AL,0B3H-72;*2

putpixel:
  STOSB
  POPA
  INC DI
 CMP DI,RESX*180
 JNE stars

 MOV CL,22
fori:
 CMP SI,RESX*8
 JNE .1
  MOV SI,BP
.1:

 DEC SI
 JS nexti

  PUSH SI

forj:
  CMP [ES:SI],CH
  JZ nextj

   PUSH 10
   MOV BX,SP
   POP DI
   PUSHA                ; AX,CX,DX,BX,SP,BP,SI,DI

   FILD WORD [BX-2]     ; i a ar
   FIADD WORD [BX]      ; i+j a ar
   FMUL ST0,ST2         ; (i+j)*ar a ar
   FADD ST0,ST0         ; (i+j)*ar*2 a ar
   FADD ST0,ST1         ; a+(i+j)*ar*2 a ar
   FSIN                 ; ay a ar

   FILD WORD [BX-2]     ; i ay a ar
   FIADD WORD [BX]      ; i+j ay a ar
   FIADD WORD [BX]      ; i+j*2 ay a ar
   FIADD WORD [BX]      ; i+j*3 ay a ar
   FMUL ST0,ST3         ; (i+j*3)*ar ay a ar
   FADD ST0,ST2         ; a+(i+j*3)*ar ay a ar
   FCOS                 ; ax ay a ar

   MOV BX,SP
   FILD WORD [BX]       ; 10 ax ay a ar
   FMUL ST1,ST0         ; 10 10*ax ay a ar
   FMUL ST0,ST2         ; 10*ay 10*ax ay a ar

   FISTP WORD [BX]      ; 10*ax ay a ar
   IMUL AX,12           ; 12*j
   SUB AX,[BX]          ; y=12*j+10*ay

   FISTP WORD [BX]      ; ay a ar
   IMUL DI,CX,16        ; 16*i
   ADD DI,DX            ; 16*i+2*px
   SAR DI,1             ; x=8*i+px
   ADD DI,[BX]          ; 8*i+px+10*ax

   FMUL DWORD [A+c225]  ; 2.25*ay a ar
   FISTP WORD [BX]      ; a ar
   MOV CL,5
   ADD CX,[BX]

   IMUL BP
   ADD AX,RESX*52+66
   ADD DI,AX

   MOV AL,31
   AND AX,SI
   ADD AL,64
   MOV BX,CX
forp:
    PUSHA
    REP STOSB
    POPA
    ADD DI,BP
   DEC BX
   JNZ forp

   POPA

nextj:
  ADD SI,BP
  INC AX
  AND AL,7
  JNZ forj

  POP SI

nexti:

 DEC CX
 JNS fori

 POPA

 FSUB DWORD [A+pi135]
 SUB DX,3
 JNS nextf
  FADD ST0,ST1          ; a+=ar
  MOV DX,6
  INC SI
  CMP SI,BP
  JNE .1
   MOV SI,RESX*8
.1:
  CMP SI,RESX*9
  JNE .2
  SUB SI,SI
.2:

nextf:
 DEC BL

 MOV AH,1
 INT 16H
 JZ forf

;MOV AL,3
;INT 10H
;MOV AL,0
;OUT 40H,AL
;OUT 40H,AL
;FUCOMPP
RETN

diff:
 DB 1,0
 DB 0,0
 DB 2,2
 DB 0,0
 DB 0,2
 DB 0,0
 DB 1,1
diff_end:

text:
 DB "SAD YEAR 2STARS PASSED AWAY INTRO DEDICA"
 DB "TED TO INNOCENT&AVANTAGE WE MISS YOU!   "
