// problems:
// * line renderer assumes scale x/y/z to be identical, having x at -1 makes stuff disappear?
// * depthsteam
//   - mirror only works for selfie mode - need test scene with all combinations
//   - also support fake floor mirror?
//   - support proper mesh rendering
//   - support raymarching from surface?


- globals
  Global
    t = FramePosFromMidi(3, 16) / 60
    sf = H(t-1) // deactivate filters at start
    tRMSpinningDisk = FramePosFromMidi(3, 26) / 60
    aRMSpinningDisk = filter(FrameIntensityFromMidi(3, 26), 0.5) 
    tRMRetroFractal = FramePosFromMidi(3, 18) / 60
    aRMRetroFractal = filter(FrameIntensityFromMidi(3, 18), 0.5) 
    tRMRetroDots = FramePosFromMidi(3, 24) / 60
    aRMRetroDots = filter(FrameIntensityFromMidi(3, 24), 0.5)
    tRMWater = FramePosFromMidi(3, 20) / 60
    aRMWater = filter(FrameIntensityFromMidi(3, 20), 0.5)
    tRMTransTorus = FramePosFromMidi(3, 22) / 60
    aRMTransTorus = filter(FrameIntensityFromMidi(3, 22), 0.5)
//    Pulse = pow(1 - ((2 * t) % 1),8)
    Pulse = 1.4 * impact(time - NoteOnTimestampFromMidi(1, 37), 0.04, 0.5, 3)
    ColorH = 0.65
    ColorS = 0.9
    ColorV = 13
    ColorVMirror = 3
    D_PointSize = 2.0
    D_DOFEnable = true
    D_DOFMaxBlur = 0.2
    D_DOFSharpRadius = 5
    D_DOFUseTargetPoint = true    
    ccGlitch = IntensityFromMidiCC(1,14)
    ccFractalLoop = filter(IntensityFromMidiCC(1,15), 1, 0, 1)
    ccMainY = filter(IntensityFromMidiCC(1,16), 0.3) // emerge from water
    ccMainZ = filter(IntensityFromMidiCC(1,19), 0.3) 
    noteOnSmooth = 0.3 // linearstep(0.01, 1, IntensityFromMidiCC(1,17))
    ccFloorScroll = filter(IntensityFromMidiCC(1,18), 0.3, 0, 1)
    ccFloorScroll2 =  filter(IntensityFromMidiCC(1,87), 0.3, 0, 1) // 87
    ccFractalBeatAmount = filter(IntensityFromMidiCC(1,84), 0.8)
    ccDotsAnim =      filter(IntensityFromMidiCC(1,85), 0.1) * 2 -1
    ccOrbit =         filter(IntensityFromMidiCC(1,86), 1.7*sf, 0, 1)
    ccOrbitTilt =     filter(IntensityFromMidiCC(1,88), 1.5*sf, 0)
    ccDolly =     filter(IntensityFromMidiCC(1,89), 1)
    ccFOV =     filter(IntensityFromMidiCC(1,90), 1)
    ccParticlesSolo =     filter(IntensityFromMidiCC(1,91), 1)
    ccCamY =     filter(IntensityFromMidiCC(1,92), 1)
//  ccDanceTimeWarp =     filter(IntensityFromMidiCC(1,93), 0.3)    
//  ccDanceColor =     filter(IntensityFromMidiCC(1,94 ), 0.3)   
//  ccDanceTimeOffset =     filter(IntensityFromMidiCC(1,95), 0.3) 
    ccDanceCameras =    2 * (IntensityFromMidiCC(1,96) - 0.5)  
    ccDollyPulse =  IntensityFromMidiCC(1,97)  
    ccGoldPulse =  IntensityFromMidiCC(1,98)
    ccDotPhase =  filter(IntensityFromMidiCC(1,99), 0.3, 0, 1)   
    ccWater =  filter(IntensityFromMidiCC(1,100), 1)   
    ccDanceEnv = filter(IntensityFromMidiCC(1,101), 1) 
    ccFractalAmount = filter(IntensityFromMidiCC(1,102), 0.7) 
    ccExposure = filter(IntensityFromMidiCC(1,103), 1*sf) 
    ccMainRot = filter(IntensityFromMidiCC(1,104), 1.6, 0, 1) 
    ccRetroMetalEnv = filter(IntensityFromMidiCC(1,105), 1) 
    ccFractalBeatTime = filter(IntensityFromMidiCC(1,106), 0.5, 0, 1) 
    nnSingbox = filter(IntensityFromMidi(1,36), 0.3)
    eps = 0.0001  

- cam_base
  CameraControl ; Resource = "presets/cam_base.kv"  
    TiltOrbit = 0             
- cam_orbit_fractal
  CameraControl ; Resource = "presets/cam_orbit_fractal.kv"                  ; Amount = aRMRetroFractal
- cam_water
  CameraControl ; Resource = "presets/cam_water.kv"                          ; Amount = aRMWater
- cam_fractaltoruses_floorcontact
  CameraControl ; Resource = "presets/cam_fractaltoruses_floorcontact.kv"    ; Amount = aRMTransTorus
- cam_fractaltoruses_floorcontact2
  CameraControl ; Resource = "presets/cam_fractaltoruses_floorcontact2.kv"   ; Amount = aRMTransTorus * linearstep(0, 12, tRMTransTorus)
- cam_fractaltoruses_floorcontact3
  CameraControl ; Resource = "presets/cam_fractaltoruses_floorcontact3.kv"   ; Amount = aRMTransTorus * smootherstep(6, 20, tRMTransTorus)
- cam_dancegroup_close
  CameraControl ; Resource = "presets/cam_dancegroup_close.kv"               ; Amount = smoothstep(eps,1-eps,filter(linearstep(0,1, ccDanceCameras), 0.5))
- cam_dancegroup_lineup
  CameraControl ; Resource = "presets/cam_dancegroup_lineup.kv"              ; Amount = smoothstep(eps,1-eps,filter(linearstep(0,1,0-ccDanceCameras), 0.5))
- cam_override
  CameraControl ; Resource = "presets/cam_override.kv"   
    FXAmount =   1.0
    FXExposure = ccExposure * 2 - 1
    FXGlitch = 6.0 * pow(ccGlitch, 2)
    Orbit =     360 * (ccOrbit-0.5)
    TiltOrbit = 180 * (ccOrbitTilt-0.5)
    Dolly = 10 * (ccDolly-0.5) + Pulse * ccDollyPulse
    FOV = 1 + 1.95 * (ccFOV-0.5)
    Y = 3  * (ccCamY-0.5)

- env_default
  EnvironmentPreset ; Resource = "presets/env_default.kv"                    ; Amount = 1
- env_clean_retrometal
  EnvironmentPreset ; Resource = "presets/env_clean_retrometal.kv"           ; Amount = 1
- env_clean_singbox
  EnvironmentPreset ; Resource = "presets/env_clean_singbox.kv"              ; Amount = FrameIntensityFromMidi(2, 18)
- env_retrometal
  EnvironmentPreset ; Resource = "presets/env_retrometal.kv"                 ; Amount = max(aRMRetroFractal, ccRetroMetalEnv)
- env_retrometal_dots
  EnvironmentPreset ; Resource = "presets/env_retrometal_dots.kv"            ; Amount = min(1-nnSingbox, aRMRetroFractal * smootherstep(5, 9, tRMRetroFractal))
    GridWarp = 0
    GridWarpOffsetU = 0
    GridWarpOffsetV = 0
- env_glass_water
  EnvironmentPreset ; Resource = "presets/env_glass_water.kv"                ; Amount = min(1.0, ccWater + aRMWater)
- env_dance
  EnvironmentPreset ; Resource = "presets/env_dance.kv"                      ; Amount = ccDanceEnv
- env_darkblue_trans
  EnvironmentPreset ; Resource = "presets/env_darkblue_trans.kv"             ; Amount = filter(sign(IntensityFromMidi(1, 39)), noteOnSmooth) + aRMTransTorus
- env_darkblue_trans_gold
  EnvironmentPreset ; Resource = "presets/env_darkblue_trans_gold.kv"        ; Amount = ccGoldPulse
- env_retrometal_dots_trans
  EnvironmentPreset ; Resource = "presets/env_retrometal_dots_trans.kv"      ; Amount = aRMRetroDots * smoothstep(3,8,tRMRetroDots)
    GridWarp = 0
    GridWarpOffsetU = 0
    GridWarpOffsetV = 0
- env_override
  EnvironmentPreset ; Resource = "presets/env_override.kv"                   ; Amount = 1
    PlaneOffsetU = ccFloorScroll2
    PlaneOffsetV = ccFloorScroll + 0.125 
    GridWarp = ccDotsAnim
    GridWarpOffsetU = ccDotPhase
    GridWarpOffsetV = ccDotPhase


- rm_master
  RayMarchControl ; Resource = "presets/rm_master.kv"                    
  - rm_base
    RayMarchControl ; Resource = "presets/rm_base.kv"                    
  - rm_ball
    RayMarchControl ; Resource = "presets/rm_ball.kv"                        ; Amount = filter(sign(IntensityFromMidi(1, 48)), noteOnSmooth)
  - rm_quaternion_classic
    RayMarchControl ; Resource = "presets/rm_quaternion_classic.kv"          ; Amount = aRMRetroFractal + aRMRetroDots
      FractalBeatAmount = 0.0
  - rm_quaternion_classic_ball
    RayMarchControl ; Resource = "presets/rm_quaternion_classic_ball.kv"     ; Amount = aRMRetroDots * (1-ccFractalAmount)
      FractalBeatAmount = 0.0
  - rm_quaternion_classic2
    RayMarchControl ; Resource = "presets/rm_quaternion_classic2.kv"         ; Amount = aRMRetroFractal * smootherstep(16, 32, tRMRetroFractal)
      FractalBeatAmount = 0.0
  - rm_fractaltoruses_water
    RayMarchControl ; Resource = "presets/rm_fractaltoruses_water.kv"        ; Amount = aRMWater
      FractalBeatAmount = 0.0
      FractalAmount = 1 - ccMainY / 2
//      FractalTime1 = ccFractalLoop + 0.008 * sin(filter(tRMWater,0.3) * pi * 4) * smoothstep(20,28,tRMWater)
  - rm_fractaltoruses_floorcontact
    RayMarchControl ; Resource = "presets/rm_fractaltoruses_floorcontact.kv" ; Amount = aRMTransTorus
  - rm_override
    RayMarchControl ; Resource = "presets/rm_override.kv"
      // FractalBeatTime = (FramePosFromMidi(3, 16) / 60)+0.12
      FractalBeatTime = ccFractalBeatTime
      FractalBeatAmount = 0.5 * ccFractalBeatAmount
      DisplaceShift = 0.3 * (FramePosFromMidi(3, 16) / 60)
      MainObjRot = vec3(0, ccMainRot * pi * 2, 0)
//      MainObj = vec4(1,2,3,0)
      MainObj = vec4(0,-1.5*ccMainY,ccMainZ*4-2,0)
      FractalTime1 = ccFractalLoop + 0.008 * sin(filter(tRMWater,0.3) * pi * 4) * smoothstep(20,28,tRMWater)


- LOGO  
  ShaderRect ; Material = "teadrinker-logo-anim" ; SizeInScene = 1
    UseMainCamera = false
    Matrix = MatrixFromTRS(0,0,0, 90,0,0, 1.4)
    Intensity = FrameIntensityFromMidi(3, 28) 
    Aspect = 1
    _Size = 0.125
    _LocalTime = FramePosFromMidi(3, 28) / 90
    _Color = hsvColor(ColorH, ColorS, ColorV, 1)
    RenderQueue = 3006


- particles_solo
  Particles ; Resource = "presets/particles_solo.kv"
    Matrix = MatrixFromTRS(0,1.5,0, 0,0,0, 1)
    Intensity = smoothstep(0, 0.5, ccParticlesSolo)
    Size = localDefault + smoothstep(0.5, 1, ccParticlesSolo)
//    Color = hsvColor()
//    Size = 2
//    SizeV = 0.9
//    Intensity = 1
//    LifeDuration = 4
//    Flow = 0.2
//    EmitterSize = vec3(7,2.5,7)
//    Direction = vec3(-1,0,0)
//    RenderStyle = 32
//    Tail = 40
//    Velocity = 3
//    VelocityV = 2/3
//    Spread = 0.0


//- cam override
//  CameraControl
//    Priority = 999
//    Amount = 1
//    _Dolly =       6 * filter(IntensityFromMidiCC(1, 20)-0.5, 1.5) 
//    _X =           6 * filter(IntensityFromMidiCC(1, 21)-0.5, 1.5) 
//    _Z =           6 * filter(IntensityFromMidiCC(1, 22)-0.5, 1.5) 
//    _Y =           6 * filter(IntensityFromMidiCC(1, 30)-0.5, 1.5)
//    _FOV =   35 + 50 * filter(IntensityFromMidiCC(1, 23)-0.5, 1.5) 
//    _Orbit =     360 * filter(IntensityFromMidiCC(1, 27)-0.5, 1.6)
//    _TiltOrbit = 180 * filter(IntensityFromMidiCC(1, 26)-0.5, 1.5)
//    _Roll =       45 * filter(IntensityFromMidiCC(1, 25)-0.5, 1.5)
//    _VRScale =    2
//    BlendDefault = 0

//    FXAmount =   1.0
//    FXGlitch = 6.0 * pow(ccGlitch, 2)

//    FXGlitchBlend = 1.0
//    FXAmountBlend =   1.0

// - deck_chair 
//  MeshStack ; Resource = "deck_chair.obj"


