#type vertex
#version 330 core
layout (location = 0) in vec2 aPos;
layout (location = 1) in vec2 aTexCoords;

out vec2 TexCoords;

void main()
{
    TexCoords = aTexCoords;
    gl_Position = vec4(aPos.x, aPos.y, 0.0, 1.0); 
}

#type fragment
#version 330 core
out vec4 FragColor;

in vec2 TexCoords;


uniform sampler2D screenTexture;
uniform sampler2D noiseTexture;
uniform float value;
uniform float contribution;
uniform vec2 offset;
uniform float speed;
uniform vec4 adjust;

uniform float fTime;

void main(void)
   {
   vec2 noise = texture( noiseTexture,TexCoords+fTime*0.01*speed).xy;
   noise += texture( noiseTexture,TexCoords*vec2(-2.0,2.0)+fTime*0.02*speed).xy;  
   noise += texture( noiseTexture,TexCoords*vec2(0.5,-0.5)+fTime*0.04*speed).xy;   

   noise = (noise-offset)*value;
 
   vec4 col = texture( screenTexture,TexCoords+noise);
   FragColor = col*texture( screenTexture,TexCoords)*contribution*adjust;
   //FragColor = texture( noiseTexture,TexCoords);
}