#type vertex
#version 330 core
layout (location = 0) in vec3 aPos;
layout (location = 1) in vec3 aNormal;
layout (location = 2) in vec2 aTexCoords;

flat out vec4 PolyColor;

uniform mat4 projection;
uniform mat4 view;
uniform mat4 model;
uniform mat4 MVP;

//uniform bool inverse_normals;
uniform vec4 objectColor;
uniform vec3 lightPosition;
uniform vec3 lightColor;
uniform sampler2D texture_diffuse1;
uniform vec3 viewPos;

uniform float ambientObjectStrenght; // Recommended 0.01

void main()
{
    vec3 objectPosition = vec3(model * vec4(aPos, 1.0));   
    
    vec3 normal = aNormal;//normalize(aNormal);

    // ambient
    vec3 ambient = ambientObjectStrenght * objectColor.rgb;
    // lighting
    vec3 lighting = vec3(0.0);
    // diffuse
    vec3 lightDir = normalize(lightPosition - objectPosition);
    float diff = max(dot(lightDir, normal), 0.0);
    vec3 diffuse = lightColor * diff * objectColor.rgb;      
    vec3 result = diffuse;        
    // attenuation (use quadratic as we have gamma correction)
    //float distance = length(objectPosition - lightPosition);
    //result *= 1.0 / (distance * distance);
    lighting = result;

    PolyColor = vec4(ambient + lighting, 1.0);
   
    gl_Position = MVP * vec4(aPos, 1.0);
}

#type fragment
#version 330 core
out vec4 FragColor;
flat in vec4 PolyColor;

void main()
{
FragColor = PolyColor;
}