#type vertex
#version 330 core
layout (location = 0) in vec3 aPos;
layout (location = 1) in vec3 aNormal;
layout (location = 2) in vec2 aTexCoords;

out VS_OUT {
vec3 FragPos;
vec3 Normal;
vec2 TexCoords;
} vs_out;

uniform mat4 model;
uniform mat4 view;
uniform mat4 projection;

void main()
{
vs_out.FragPos = vec3(model * vec4(aPos, 1.0)); // aPos;
vs_out.TexCoords = aTexCoords;
vs_out.Normal = vec3(model * vec4(aNormal, 1.0));

gl_Position = projection * view * model * vec4(aPos, 1.0);
}

#type fragment
#version 330 core
out vec4 FragColor;

in VS_OUT {
vec3 FragPos;
vec3 Normal;
vec2 TexCoords;
} fs_in;

uniform vec3 lightPos;
uniform vec3 lightCol;

uniform vec3 viewPos;
uniform float ambientStrenght; // Recommended 0.1

uniform sampler2D texture_diffuse1;

void main()
{    
//vec3 objectColor = texture(texture_diffuse1, fs_in.TexCoords).rgb;
vec3 objectColor = vec3(1,0.2,0.2);

// ambient
vec3 ambient = ambientStrenght * objectColor;

// diffuse
vec3 norm = normalize(fs_in.Normal);
vec3 lightDir = normalize(lightPos - fs_in.FragPos);
float diff = max(dot(norm, lightDir), 0.0);
vec3 diffuse = diff * lightCol;

vec3 result = (ambient + diffuse) * objectColor;
FragColor = vec4(result, 1.0);
}